/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.field.ProcOrdConf2Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.link.ProcOrdConf2Link;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.selectable.ProcOrdConf2Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Process Order Confirmation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProcOrdConf2Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProcOrdConf2 extends VdmEntity<ProcOrdConf2>
{

    /**
     * Selector for all available fields of ProcOrdConf2.
     *
     */
    public final static ProcOrdConf2Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationGroup</b>
     * </p>
     *
     * @return Collective ID of Order Confirmations
     */
    @Key
    @SerializedName( "ConfirmationGroup" )
    @JsonProperty( "ConfirmationGroup" )
    @Nullable
    @ODataField( odataName = "ConfirmationGroup" )
    private String confirmationGroup;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationGroup</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> CONFIRMATION_GROUP =
        new ProcOrdConf2Field<String>("ConfirmationGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationCount</b>
     * </p>
     *
     * @return Identifier of Single Order Confirmation
     */
    @Key
    @SerializedName( "ConfirmationCount" )
    @JsonProperty( "ConfirmationCount" )
    @Nullable
    @ODataField( odataName = "ConfirmationCount" )
    private String confirmationCount;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationCount</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> CONFIRMATION_COUNT =
        new ProcOrdConf2Field<String>("ConfirmationCount");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Manufacturing Order ID
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> ORDER_ID = new ProcOrdConf2Field<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderOperation</b>
     * </p>
     *
     * @return Manufacturing Order Operation
     */
    @SerializedName( "OrderOperation" )
    @JsonProperty( "OrderOperation" )
    @Nullable
    @ODataField( odataName = "OrderOperation" )
    private String orderOperation;
    /**
     * Use with available fluent helpers to apply the <b>OrderOperation</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> ORDER_OPERATION = new ProcOrdConf2Field<String>("OrderOperation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderSuboperation</b>
     * </p>
     *
     * @return Manufacturing Order Suboperation
     */
    @SerializedName( "OrderSuboperation" )
    @JsonProperty( "OrderSuboperation" )
    @Nullable
    @ODataField( odataName = "OrderSuboperation" )
    private String orderSuboperation;
    /**
     * Use with available fluent helpers to apply the <b>OrderSuboperation</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> ORDER_SUBOPERATION =
        new ProcOrdConf2Field<String>("OrderSuboperation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderType</b>
     * </p>
     *
     * @return Manufacturing Order Type
     */
    @SerializedName( "OrderType" )
    @JsonProperty( "OrderType" )
    @Nullable
    @ODataField( odataName = "OrderType" )
    private String orderType;
    /**
     * Use with available fluent helpers to apply the <b>OrderType</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> ORDER_TYPE = new ProcOrdConf2Field<String>("OrderType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OrderOperationInternalID</b>
     * </p>
     *
     * @return Internal Identifier of an Operation or Activity
     */
    @SerializedName( "OrderOperationInternalID" )
    @JsonProperty( "OrderOperationInternalID" )
    @Nullable
    @ODataField( odataName = "OrderOperationInternalID" )
    private String orderOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>OrderOperationInternalID</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> ORDER_OPERATION_INTERNAL_ID =
        new ProcOrdConf2Field<String>("OrderOperationInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationText</b>
     * </p>
     *
     * @return Confirmation Text
     */
    @SerializedName( "ConfirmationText" )
    @JsonProperty( "ConfirmationText" )
    @Nullable
    @ODataField( odataName = "ConfirmationText" )
    private String confirmationText;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationText</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> CONFIRMATION_TEXT = new ProcOrdConf2Field<String>("ConfirmationText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> LANGUAGE = new ProcOrdConf2Field<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number for Order
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> MATERIAL = new ProcOrdConf2Field<String>("Material");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPlannedTotalQty</b>
     * </p>
     *
     * @return Manufacturing Order Planned Total Quantity
     */
    @SerializedName( "OrderPlannedTotalQty" )
    @JsonProperty( "OrderPlannedTotalQty" )
    @Nullable
    @ODataField( odataName = "OrderPlannedTotalQty" )
    private BigDecimal orderPlannedTotalQty;
    /**
     * Use with available fluent helpers to apply the <b>OrderPlannedTotalQty</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<BigDecimal> ORDER_PLANNED_TOTAL_QTY =
        new ProcOrdConf2Field<BigDecimal>("OrderPlannedTotalQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductionUnit</b>
     * </p>
     *
     * @return Production Unit of Measure
     */
    @SerializedName( "ProductionUnit" )
    @JsonProperty( "ProductionUnit" )
    @Nullable
    @ODataField( odataName = "ProductionUnit" )
    private String productionUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProductionUnit</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> PRODUCTION_UNIT = new ProcOrdConf2Field<String>("ProductionUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinalConfirmationType</b>
     * </p>
     *
     * @return Final Confirmation Type
     */
    @SerializedName( "FinalConfirmationType" )
    @JsonProperty( "FinalConfirmationType" )
    @Nullable
    @ODataField( odataName = "FinalConfirmationType" )
    private String finalConfirmationType;
    /**
     * Use with available fluent helpers to apply the <b>FinalConfirmationType</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> FINAL_CONFIRMATION_TYPE =
        new ProcOrdConf2Field<String>("FinalConfirmationType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsFinalConfirmation</b>
     * </p>
     *
     * @return Activation of Final Confirmation
     */
    @SerializedName( "IsFinalConfirmation" )
    @JsonProperty( "IsFinalConfirmation" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsFinalConfirmation" )
    private Boolean isFinalConfirmation;
    /**
     * Use with available fluent helpers to apply the <b>IsFinalConfirmation</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<Boolean> IS_FINAL_CONFIRMATION =
        new ProcOrdConf2Field<Boolean>("IsFinalConfirmation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OpenReservationsIsCleared</b>
     * </p>
     *
     * @return Clear Open Reservations
     */
    @SerializedName( "OpenReservationsIsCleared" )
    @JsonProperty( "OpenReservationsIsCleared" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "OpenReservationsIsCleared" )
    private Boolean openReservationsIsCleared;
    /**
     * Use with available fluent helpers to apply the <b>OpenReservationsIsCleared</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<Boolean> OPEN_RESERVATIONS_IS_CLEARED =
        new ProcOrdConf2Field<Boolean>("OpenReservationsIsCleared");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversed</b>
     * </p>
     *
     * @return Indicator: Document was reversed
     */
    @SerializedName( "IsReversed" )
    @JsonProperty( "IsReversed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsReversed" )
    private Boolean isReversed;
    /**
     * Use with available fluent helpers to apply the <b>IsReversed</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<Boolean> IS_REVERSED = new ProcOrdConf2Field<Boolean>("IsReversed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversal</b>
     * </p>
     *
     * @return Confirmation record is a Cancellation
     */
    @SerializedName( "IsReversal" )
    @JsonProperty( "IsReversal" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsReversal" )
    private Boolean isReversal;
    /**
     * Use with available fluent helpers to apply the <b>IsReversal</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<Boolean> IS_REVERSAL = new ProcOrdConf2Field<Boolean>("IsReversal");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>APIConfHasNoGoodsMovements</b>
     * </p>
     *
     * @return Confirmation: No Goods Movement via API
     */
    @SerializedName( "APIConfHasNoGoodsMovements" )
    @JsonProperty( "APIConfHasNoGoodsMovements" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "APIConfHasNoGoodsMovements" )
    private Boolean aPIConfHasNoGoodsMovements;
    /**
     * Use with available fluent helpers to apply the <b>APIConfHasNoGoodsMovements</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<Boolean> API_CONF_HAS_NO_GOODS_MOVEMENTS =
        new ProcOrdConf2Field<Boolean>("APIConfHasNoGoodsMovements");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderConfirmationRecordType</b>
     * </p>
     *
     * @return Record Type for Confirmation
     */
    @SerializedName( "OrderConfirmationRecordType" )
    @JsonProperty( "OrderConfirmationRecordType" )
    @Nullable
    @ODataField( odataName = "OrderConfirmationRecordType" )
    private String orderConfirmationRecordType;
    /**
     * Use with available fluent helpers to apply the <b>OrderConfirmationRecordType</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> ORDER_CONFIRMATION_RECORD_TYPE =
        new ProcOrdConf2Field<String>("OrderConfirmationRecordType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationEntryDate</b>
     * </p>
     *
     * @return Entry Date of Confirmation
     */
    @SerializedName( "ConfirmationEntryDate" )
    @JsonProperty( "ConfirmationEntryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmationEntryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmationEntryDate;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationEntryDate</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalDateTime> CONFIRMATION_ENTRY_DATE =
        new ProcOrdConf2Field<LocalDateTime>("ConfirmationEntryDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationEntryTime</b>
     * </p>
     *
     * @return Confirmation Entry Time
     */
    @SerializedName( "ConfirmationEntryTime" )
    @JsonProperty( "ConfirmationEntryTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmationEntryTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmationEntryTime;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationEntryTime</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalTime> CONFIRMATION_ENTRY_TIME =
        new ProcOrdConf2Field<LocalTime>("ConfirmationEntryTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EnteredByUser</b>
     * </p>
     *
     * @return User who Entered the Confirmation
     */
    @SerializedName( "EnteredByUser" )
    @JsonProperty( "EnteredByUser" )
    @Nullable
    @ODataField( odataName = "EnteredByUser" )
    private String enteredByUser;
    /**
     * Use with available fluent helpers to apply the <b>EnteredByUser</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> ENTERED_BY_USER = new ProcOrdConf2Field<String>("EnteredByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Date of Last Change
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalDateTime> LAST_CHANGE_DATE =
        new ProcOrdConf2Field<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> LAST_CHANGED_BY_USER =
        new ProcOrdConf2Field<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationExternalEntryDate</b>
     * </p>
     *
     * @return External date of entry for confirmation
     */
    @SerializedName( "ConfirmationExternalEntryDate" )
    @JsonProperty( "ConfirmationExternalEntryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmationExternalEntryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmationExternalEntryDate;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationExternalEntryDate</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalDateTime> CONFIRMATION_EXTERNAL_ENTRY_DATE =
        new ProcOrdConf2Field<LocalDateTime>("ConfirmationExternalEntryDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationExternalEntryTime</b>
     * </p>
     *
     * @return External time of entry for confirmation
     */
    @SerializedName( "ConfirmationExternalEntryTime" )
    @JsonProperty( "ConfirmationExternalEntryTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmationExternalEntryTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmationExternalEntryTime;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationExternalEntryTime</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalTime> CONFIRMATION_EXTERNAL_ENTRY_TIME =
        new ProcOrdConf2Field<LocalTime>("ConfirmationExternalEntryTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EnteredByExternalUser</b>
     * </p>
     *
     * @return External creator of confirmation
     */
    @SerializedName( "EnteredByExternalUser" )
    @JsonProperty( "EnteredByExternalUser" )
    @Nullable
    @ODataField( odataName = "EnteredByExternalUser" )
    private String enteredByExternalUser;
    /**
     * Use with available fluent helpers to apply the <b>EnteredByExternalUser</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> ENTERED_BY_EXTERNAL_USER =
        new ProcOrdConf2Field<String>("EnteredByExternalUser");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExternalSystemConfirmation</b>
     * </p>
     *
     * @return External Key for Confirmation (for example, from PDC System)
     */
    @SerializedName( "ExternalSystemConfirmation" )
    @JsonProperty( "ExternalSystemConfirmation" )
    @Nullable
    @ODataField( odataName = "ExternalSystemConfirmation" )
    private UUID externalSystemConfirmation;
    /**
     * Use with available fluent helpers to apply the <b>ExternalSystemConfirmation</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<UUID> EXTERNAL_SYSTEM_CONFIRMATION =
        new ProcOrdConf2Field<UUID>("ExternalSystemConfirmation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> PLANT = new ProcOrdConf2Field<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Object Type of the Resource
     */
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> WORK_CENTER_TYPE_CODE =
        new ProcOrdConf2Field<String>("WorkCenterTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> WORK_CENTER = new ProcOrdConf2Field<String>("WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShiftGrouping</b>
     * </p>
     *
     * @return Grouping for Shift Definitions and Shift Sequences
     */
    @SerializedName( "ShiftGrouping" )
    @JsonProperty( "ShiftGrouping" )
    @Nullable
    @ODataField( odataName = "ShiftGrouping" )
    private String shiftGrouping;
    /**
     * Use with available fluent helpers to apply the <b>ShiftGrouping</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> SHIFT_GROUPING = new ProcOrdConf2Field<String>("ShiftGrouping");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftDefinition</b>
     * </p>
     *
     * @return Shift Definition
     */
    @SerializedName( "ShiftDefinition" )
    @JsonProperty( "ShiftDefinition" )
    @Nullable
    @ODataField( odataName = "ShiftDefinition" )
    private String shiftDefinition;
    /**
     * Use with available fluent helpers to apply the <b>ShiftDefinition</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> SHIFT_DEFINITION = new ProcOrdConf2Field<String>("ShiftDefinition");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "Personnel" )
    @JsonProperty( "Personnel" )
    @Nullable
    @ODataField( odataName = "Personnel" )
    private String personnel;
    /**
     * Use with available fluent helpers to apply the <b>Personnel</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> PERSONNEL = new ProcOrdConf2Field<String>("Personnel");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TimeRecording</b>
     * </p>
     *
     * @return Time Recording ID
     */
    @SerializedName( "TimeRecording" )
    @JsonProperty( "TimeRecording" )
    @Nullable
    @ODataField( odataName = "TimeRecording" )
    private String timeRecording;
    /**
     * Use with available fluent helpers to apply the <b>TimeRecording</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> TIME_RECORDING = new ProcOrdConf2Field<String>("TimeRecording");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EmployeeWageType</b>
     * </p>
     *
     * @return Employee Wage Type
     */
    @SerializedName( "EmployeeWageType" )
    @JsonProperty( "EmployeeWageType" )
    @Nullable
    @ODataField( odataName = "EmployeeWageType" )
    private String employeeWageType;
    /**
     * Use with available fluent helpers to apply the <b>EmployeeWageType</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> EMPLOYEE_WAGE_TYPE =
        new ProcOrdConf2Field<String>("EmployeeWageType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmployeeWageGroup</b>
     * </p>
     *
     * @return Employee Wage Group
     */
    @SerializedName( "EmployeeWageGroup" )
    @JsonProperty( "EmployeeWageGroup" )
    @Nullable
    @ODataField( odataName = "EmployeeWageGroup" )
    private String employeeWageGroup;
    /**
     * Use with available fluent helpers to apply the <b>EmployeeWageGroup</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> EMPLOYEE_WAGE_GROUP =
        new ProcOrdConf2Field<String>("EmployeeWageGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BreakDurationUnit</b>
     * </p>
     *
     * @return Unit for a Break Time
     */
    @SerializedName( "BreakDurationUnit" )
    @JsonProperty( "BreakDurationUnit" )
    @Nullable
    @ODataField( odataName = "BreakDurationUnit" )
    private String breakDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>BreakDurationUnit</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> BREAK_DURATION_UNIT =
        new ProcOrdConf2Field<String>("BreakDurationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BreakDurationUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "BreakDurationUnitISOCode" )
    @JsonProperty( "BreakDurationUnitISOCode" )
    @Nullable
    @ODataField( odataName = "BreakDurationUnitISOCode" )
    private String breakDurationUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>BreakDurationUnitISOCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> BREAK_DURATION_UNIT_ISO_CODE =
        new ProcOrdConf2Field<String>("BreakDurationUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BreakDurationUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "BreakDurationUnitSAPCode" )
    @JsonProperty( "BreakDurationUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "BreakDurationUnitSAPCode" )
    private String breakDurationUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>BreakDurationUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> BREAK_DURATION_UNIT_SAP_CODE =
        new ProcOrdConf2Field<String>("BreakDurationUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedBreakDuration</b>
     * </p>
     *
     * @return Confirmed Break Time
     */
    @SerializedName( "ConfirmedBreakDuration" )
    @JsonProperty( "ConfirmedBreakDuration" )
    @Nullable
    @ODataField( odataName = "ConfirmedBreakDuration" )
    private BigDecimal confirmedBreakDuration;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedBreakDuration</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<BigDecimal> CONFIRMED_BREAK_DURATION =
        new ProcOrdConf2Field<BigDecimal>("ConfirmedBreakDuration");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EmployeeSuitability</b>
     * </p>
     *
     * @return Employee Suitability
     */
    @SerializedName( "EmployeeSuitability" )
    @JsonProperty( "EmployeeSuitability" )
    @Nullable
    @ODataField( odataName = "EmployeeSuitability" )
    private String employeeSuitability;
    /**
     * Use with available fluent helpers to apply the <b>EmployeeSuitability</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> EMPLOYEE_SUITABILITY =
        new ProcOrdConf2Field<String>("EmployeeSuitability");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfEmployees</b>
     * </p>
     *
     * @return Number of Employees
     */
    @SerializedName( "NumberOfEmployees" )
    @JsonProperty( "NumberOfEmployees" )
    @Nullable
    @ODataField( odataName = "NumberOfEmployees" )
    private BigDecimal numberOfEmployees;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfEmployees</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<BigDecimal> NUMBER_OF_EMPLOYEES =
        new ProcOrdConf2Field<BigDecimal>("NumberOfEmployees");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalDateTime> POSTING_DATE =
        new ProcOrdConf2Field<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedExecutionStartDate</b>
     * </p>
     *
     * @return Confirmed Start Date of Execution
     */
    @SerializedName( "ConfirmedExecutionStartDate" )
    @JsonProperty( "ConfirmedExecutionStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedExecutionStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmedExecutionStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedExecutionStartDate</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalDateTime> CONFIRMED_EXECUTION_START_DATE =
        new ProcOrdConf2Field<LocalDateTime>("ConfirmedExecutionStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedExecutionStartTime</b>
     * </p>
     *
     * @return Confirmed Start Time of Execution
     */
    @SerializedName( "ConfirmedExecutionStartTime" )
    @JsonProperty( "ConfirmedExecutionStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedExecutionStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmedExecutionStartTime;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedExecutionStartTime</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalTime> CONFIRMED_EXECUTION_START_TIME =
        new ProcOrdConf2Field<LocalTime>("ConfirmedExecutionStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedSetupEndDate</b>
     * </p>
     *
     * @return Confirmed End Date of Setup
     */
    @SerializedName( "ConfirmedSetupEndDate" )
    @JsonProperty( "ConfirmedSetupEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedSetupEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmedSetupEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedSetupEndDate</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalDateTime> CONFIRMED_SETUP_END_DATE =
        new ProcOrdConf2Field<LocalDateTime>("ConfirmedSetupEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedSetupEndTime</b>
     * </p>
     *
     * @return Confirmed End Time of Setup
     */
    @SerializedName( "ConfirmedSetupEndTime" )
    @JsonProperty( "ConfirmedSetupEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedSetupEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmedSetupEndTime;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedSetupEndTime</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalTime> CONFIRMED_SETUP_END_TIME =
        new ProcOrdConf2Field<LocalTime>("ConfirmedSetupEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProcessingStartDate</b>
     * </p>
     *
     * @return Confirmed Start Date of Processing
     */
    @SerializedName( "ConfirmedProcessingStartDate" )
    @JsonProperty( "ConfirmedProcessingStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedProcessingStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmedProcessingStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedProcessingStartDate</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalDateTime> CONFIRMED_PROCESSING_START_DATE =
        new ProcOrdConf2Field<LocalDateTime>("ConfirmedProcessingStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProcessingStartTime</b>
     * </p>
     *
     * @return Confirmed Start Time of Processing
     */
    @SerializedName( "ConfirmedProcessingStartTime" )
    @JsonProperty( "ConfirmedProcessingStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedProcessingStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmedProcessingStartTime;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedProcessingStartTime</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalTime> CONFIRMED_PROCESSING_START_TIME =
        new ProcOrdConf2Field<LocalTime>("ConfirmedProcessingStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProcessingEndDate</b>
     * </p>
     *
     * @return Confirmed End Date of Processing
     */
    @SerializedName( "ConfirmedProcessingEndDate" )
    @JsonProperty( "ConfirmedProcessingEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedProcessingEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmedProcessingEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedProcessingEndDate</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalDateTime> CONFIRMED_PROCESSING_END_DATE =
        new ProcOrdConf2Field<LocalDateTime>("ConfirmedProcessingEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProcessingEndTime</b>
     * </p>
     *
     * @return Confirmed End Time of Processing
     */
    @SerializedName( "ConfirmedProcessingEndTime" )
    @JsonProperty( "ConfirmedProcessingEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedProcessingEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmedProcessingEndTime;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedProcessingEndTime</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalTime> CONFIRMED_PROCESSING_END_TIME =
        new ProcOrdConf2Field<LocalTime>("ConfirmedProcessingEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedTeardownStartDate</b>
     * </p>
     *
     * @return Confirmed Start Date of Teardown
     */
    @SerializedName( "ConfirmedTeardownStartDate" )
    @JsonProperty( "ConfirmedTeardownStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedTeardownStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmedTeardownStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedTeardownStartDate</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalDateTime> CONFIRMED_TEARDOWN_START_DATE =
        new ProcOrdConf2Field<LocalDateTime>("ConfirmedTeardownStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedTeardownStartTime</b>
     * </p>
     *
     * @return Confirmed Start Time of Teardown
     */
    @SerializedName( "ConfirmedTeardownStartTime" )
    @JsonProperty( "ConfirmedTeardownStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedTeardownStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmedTeardownStartTime;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedTeardownStartTime</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalTime> CONFIRMED_TEARDOWN_START_TIME =
        new ProcOrdConf2Field<LocalTime>("ConfirmedTeardownStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedExecutionEndDate</b>
     * </p>
     *
     * @return Confirmed End Date of Execution
     */
    @SerializedName( "ConfirmedExecutionEndDate" )
    @JsonProperty( "ConfirmedExecutionEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedExecutionEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmedExecutionEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedExecutionEndDate</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalDateTime> CONFIRMED_EXECUTION_END_DATE =
        new ProcOrdConf2Field<LocalDateTime>("ConfirmedExecutionEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedExecutionEndTime</b>
     * </p>
     *
     * @return Confirmed End Time of Execution
     */
    @SerializedName( "ConfirmedExecutionEndTime" )
    @JsonProperty( "ConfirmedExecutionEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedExecutionEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmedExecutionEndTime;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedExecutionEndTime</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<LocalTime> CONFIRMED_EXECUTION_END_TIME =
        new ProcOrdConf2Field<LocalTime>("ConfirmedExecutionEndTime");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationUnit</b>
     * </p>
     *
     * @return Confirmation Unit of Measure
     */
    @SerializedName( "ConfirmationUnit" )
    @JsonProperty( "ConfirmationUnit" )
    @Nullable
    @ODataField( odataName = "ConfirmationUnit" )
    private String confirmationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationUnit</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> CONFIRMATION_UNIT = new ProcOrdConf2Field<String>("ConfirmationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "ConfirmationUnitISOCode" )
    @JsonProperty( "ConfirmationUnitISOCode" )
    @Nullable
    @ODataField( odataName = "ConfirmationUnitISOCode" )
    private String confirmationUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationUnitISOCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> CONFIRMATION_UNIT_ISO_CODE =
        new ProcOrdConf2Field<String>("ConfirmationUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "ConfirmationUnitSAPCode" )
    @JsonProperty( "ConfirmationUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "ConfirmationUnitSAPCode" )
    private String confirmationUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> CONFIRMATION_UNIT_SAP_CODE =
        new ProcOrdConf2Field<String>("ConfirmationUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationYieldQuantity</b>
     * </p>
     *
     * @return Yield to be Confirmed
     */
    @SerializedName( "ConfirmationYieldQuantity" )
    @JsonProperty( "ConfirmationYieldQuantity" )
    @Nullable
    @ODataField( odataName = "ConfirmationYieldQuantity" )
    private BigDecimal confirmationYieldQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationYieldQuantity</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<BigDecimal> CONFIRMATION_YIELD_QUANTITY =
        new ProcOrdConf2Field<BigDecimal>("ConfirmationYieldQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationScrapQuantity</b>
     * </p>
     *
     * @return Scrap to Be Confirmed
     */
    @SerializedName( "ConfirmationScrapQuantity" )
    @JsonProperty( "ConfirmationScrapQuantity" )
    @Nullable
    @ODataField( odataName = "ConfirmationScrapQuantity" )
    private BigDecimal confirmationScrapQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationScrapQuantity</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<BigDecimal> CONFIRMATION_SCRAP_QUANTITY =
        new ProcOrdConf2Field<BigDecimal>("ConfirmationScrapQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>VarianceReasonCode</b>
     * </p>
     *
     * @return Reason for Variance
     */
    @SerializedName( "VarianceReasonCode" )
    @JsonProperty( "VarianceReasonCode" )
    @Nullable
    @ODataField( odataName = "VarianceReasonCode" )
    private String varianceReasonCode;
    /**
     * Use with available fluent helpers to apply the <b>VarianceReasonCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> VARIANCE_REASON_CODE =
        new ProcOrdConf2Field<String>("VarianceReasonCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpWorkQuantityUnit1</b>
     * </p>
     *
     * @return Unit of Measure for Confirmed Work Quantity 1
     */
    @SerializedName( "OpWorkQuantityUnit1" )
    @JsonProperty( "OpWorkQuantityUnit1" )
    @Nullable
    @ODataField( odataName = "OpWorkQuantityUnit1" )
    private String opWorkQuantityUnit1;
    /**
     * Use with available fluent helpers to apply the <b>OpWorkQuantityUnit1</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> OP_WORK_QUANTITY_UNIT1 =
        new ProcOrdConf2Field<String>("OpWorkQuantityUnit1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit1ISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "WorkQuantityUnit1ISOCode" )
    @JsonProperty( "WorkQuantityUnit1ISOCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit1ISOCode" )
    private String workQuantityUnit1ISOCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkQuantityUnit1ISOCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> WORK_QUANTITY_UNIT1_I_S_O_CODE =
        new ProcOrdConf2Field<String>("WorkQuantityUnit1ISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit1SAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "WorkQuantityUnit1SAPCode" )
    @JsonProperty( "WorkQuantityUnit1SAPCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit1SAPCode" )
    private String workQuantityUnit1SAPCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkQuantityUnit1SAPCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> WORK_QUANTITY_UNIT1_S_A_P_CODE =
        new ProcOrdConf2Field<String>("WorkQuantityUnit1SAPCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpConfirmedWorkQuantity1</b>
     * </p>
     *
     * @return Already Confirmed Work Quantity (Activity) 1
     */
    @SerializedName( "OpConfirmedWorkQuantity1" )
    @JsonProperty( "OpConfirmedWorkQuantity1" )
    @Nullable
    @ODataField( odataName = "OpConfirmedWorkQuantity1" )
    private BigDecimal opConfirmedWorkQuantity1;
    /**
     * Use with available fluent helpers to apply the <b>OpConfirmedWorkQuantity1</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<BigDecimal> OP_CONFIRMED_WORK_QUANTITY1 =
        new ProcOrdConf2Field<BigDecimal>("OpConfirmedWorkQuantity1");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherOpWorkQuantity1IsExpd</b>
     * </p>
     *
     * @return Indicator: No Remaining Work Quantity 1 is Expected
     */
    @SerializedName( "NoFurtherOpWorkQuantity1IsExpd" )
    @JsonProperty( "NoFurtherOpWorkQuantity1IsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherOpWorkQuantity1IsExpd" )
    private Boolean noFurtherOpWorkQuantity1IsExpd;
    /**
     * Use with available fluent helpers to apply the <b>NoFurtherOpWorkQuantity1IsExpd</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<Boolean> NO_FURTHER_OP_WORK_QUANTITY1_IS_EXPD =
        new ProcOrdConf2Field<Boolean>("NoFurtherOpWorkQuantity1IsExpd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpWorkQuantityUnit2</b>
     * </p>
     *
     * @return Unit of Measure for Confirmed Work Quantity 2
     */
    @SerializedName( "OpWorkQuantityUnit2" )
    @JsonProperty( "OpWorkQuantityUnit2" )
    @Nullable
    @ODataField( odataName = "OpWorkQuantityUnit2" )
    private String opWorkQuantityUnit2;
    /**
     * Use with available fluent helpers to apply the <b>OpWorkQuantityUnit2</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> OP_WORK_QUANTITY_UNIT2 =
        new ProcOrdConf2Field<String>("OpWorkQuantityUnit2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit2ISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "WorkQuantityUnit2ISOCode" )
    @JsonProperty( "WorkQuantityUnit2ISOCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit2ISOCode" )
    private String workQuantityUnit2ISOCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkQuantityUnit2ISOCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> WORK_QUANTITY_UNIT2_I_S_O_CODE =
        new ProcOrdConf2Field<String>("WorkQuantityUnit2ISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit2SAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "WorkQuantityUnit2SAPCode" )
    @JsonProperty( "WorkQuantityUnit2SAPCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit2SAPCode" )
    private String workQuantityUnit2SAPCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkQuantityUnit2SAPCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> WORK_QUANTITY_UNIT2_S_A_P_CODE =
        new ProcOrdConf2Field<String>("WorkQuantityUnit2SAPCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpConfirmedWorkQuantity2</b>
     * </p>
     *
     * @return Already Confirmed Work Quantity (Activity) 2
     */
    @SerializedName( "OpConfirmedWorkQuantity2" )
    @JsonProperty( "OpConfirmedWorkQuantity2" )
    @Nullable
    @ODataField( odataName = "OpConfirmedWorkQuantity2" )
    private BigDecimal opConfirmedWorkQuantity2;
    /**
     * Use with available fluent helpers to apply the <b>OpConfirmedWorkQuantity2</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<BigDecimal> OP_CONFIRMED_WORK_QUANTITY2 =
        new ProcOrdConf2Field<BigDecimal>("OpConfirmedWorkQuantity2");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherOpWorkQuantity2IsExpd</b>
     * </p>
     *
     * @return Indicator: No Remaining Work Quantity 2 is Expected
     */
    @SerializedName( "NoFurtherOpWorkQuantity2IsExpd" )
    @JsonProperty( "NoFurtherOpWorkQuantity2IsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherOpWorkQuantity2IsExpd" )
    private Boolean noFurtherOpWorkQuantity2IsExpd;
    /**
     * Use with available fluent helpers to apply the <b>NoFurtherOpWorkQuantity2IsExpd</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<Boolean> NO_FURTHER_OP_WORK_QUANTITY2_IS_EXPD =
        new ProcOrdConf2Field<Boolean>("NoFurtherOpWorkQuantity2IsExpd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpWorkQuantityUnit3</b>
     * </p>
     *
     * @return Unit of Measure for Confirmed Work Quantity 3
     */
    @SerializedName( "OpWorkQuantityUnit3" )
    @JsonProperty( "OpWorkQuantityUnit3" )
    @Nullable
    @ODataField( odataName = "OpWorkQuantityUnit3" )
    private String opWorkQuantityUnit3;
    /**
     * Use with available fluent helpers to apply the <b>OpWorkQuantityUnit3</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> OP_WORK_QUANTITY_UNIT3 =
        new ProcOrdConf2Field<String>("OpWorkQuantityUnit3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit3ISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "WorkQuantityUnit3ISOCode" )
    @JsonProperty( "WorkQuantityUnit3ISOCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit3ISOCode" )
    private String workQuantityUnit3ISOCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkQuantityUnit3ISOCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> WORK_QUANTITY_UNIT3_I_S_O_CODE =
        new ProcOrdConf2Field<String>("WorkQuantityUnit3ISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit3SAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "WorkQuantityUnit3SAPCode" )
    @JsonProperty( "WorkQuantityUnit3SAPCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit3SAPCode" )
    private String workQuantityUnit3SAPCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkQuantityUnit3SAPCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> WORK_QUANTITY_UNIT3_S_A_P_CODE =
        new ProcOrdConf2Field<String>("WorkQuantityUnit3SAPCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpConfirmedWorkQuantity3</b>
     * </p>
     *
     * @return Already Confirmed Work Quantity (Activity) 3
     */
    @SerializedName( "OpConfirmedWorkQuantity3" )
    @JsonProperty( "OpConfirmedWorkQuantity3" )
    @Nullable
    @ODataField( odataName = "OpConfirmedWorkQuantity3" )
    private BigDecimal opConfirmedWorkQuantity3;
    /**
     * Use with available fluent helpers to apply the <b>OpConfirmedWorkQuantity3</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<BigDecimal> OP_CONFIRMED_WORK_QUANTITY3 =
        new ProcOrdConf2Field<BigDecimal>("OpConfirmedWorkQuantity3");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherOpWorkQuantity3IsExpd</b>
     * </p>
     *
     * @return Indicator: No Remaining Work Quantity 3 is Expected
     */
    @SerializedName( "NoFurtherOpWorkQuantity3IsExpd" )
    @JsonProperty( "NoFurtherOpWorkQuantity3IsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherOpWorkQuantity3IsExpd" )
    private Boolean noFurtherOpWorkQuantity3IsExpd;
    /**
     * Use with available fluent helpers to apply the <b>NoFurtherOpWorkQuantity3IsExpd</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<Boolean> NO_FURTHER_OP_WORK_QUANTITY3_IS_EXPD =
        new ProcOrdConf2Field<Boolean>("NoFurtherOpWorkQuantity3IsExpd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpWorkQuantityUnit4</b>
     * </p>
     *
     * @return Unit of Measure for Confirmed Work Quantity 4
     */
    @SerializedName( "OpWorkQuantityUnit4" )
    @JsonProperty( "OpWorkQuantityUnit4" )
    @Nullable
    @ODataField( odataName = "OpWorkQuantityUnit4" )
    private String opWorkQuantityUnit4;
    /**
     * Use with available fluent helpers to apply the <b>OpWorkQuantityUnit4</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> OP_WORK_QUANTITY_UNIT4 =
        new ProcOrdConf2Field<String>("OpWorkQuantityUnit4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit4ISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "WorkQuantityUnit4ISOCode" )
    @JsonProperty( "WorkQuantityUnit4ISOCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit4ISOCode" )
    private String workQuantityUnit4ISOCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkQuantityUnit4ISOCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> WORK_QUANTITY_UNIT4_I_S_O_CODE =
        new ProcOrdConf2Field<String>("WorkQuantityUnit4ISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit4SAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "WorkQuantityUnit4SAPCode" )
    @JsonProperty( "WorkQuantityUnit4SAPCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit4SAPCode" )
    private String workQuantityUnit4SAPCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkQuantityUnit4SAPCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> WORK_QUANTITY_UNIT4_S_A_P_CODE =
        new ProcOrdConf2Field<String>("WorkQuantityUnit4SAPCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpConfirmedWorkQuantity4</b>
     * </p>
     *
     * @return Already Confirmed Work Quantity (Activity) 4
     */
    @SerializedName( "OpConfirmedWorkQuantity4" )
    @JsonProperty( "OpConfirmedWorkQuantity4" )
    @Nullable
    @ODataField( odataName = "OpConfirmedWorkQuantity4" )
    private BigDecimal opConfirmedWorkQuantity4;
    /**
     * Use with available fluent helpers to apply the <b>OpConfirmedWorkQuantity4</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<BigDecimal> OP_CONFIRMED_WORK_QUANTITY4 =
        new ProcOrdConf2Field<BigDecimal>("OpConfirmedWorkQuantity4");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherOpWorkQuantity4IsExpd</b>
     * </p>
     *
     * @return Indicator: No Remaining Work Quantity 4 is Expected
     */
    @SerializedName( "NoFurtherOpWorkQuantity4IsExpd" )
    @JsonProperty( "NoFurtherOpWorkQuantity4IsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherOpWorkQuantity4IsExpd" )
    private Boolean noFurtherOpWorkQuantity4IsExpd;
    /**
     * Use with available fluent helpers to apply the <b>NoFurtherOpWorkQuantity4IsExpd</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<Boolean> NO_FURTHER_OP_WORK_QUANTITY4_IS_EXPD =
        new ProcOrdConf2Field<Boolean>("NoFurtherOpWorkQuantity4IsExpd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpWorkQuantityUnit5</b>
     * </p>
     *
     * @return Unit of Measure for Confirmed Work Quantity 5
     */
    @SerializedName( "OpWorkQuantityUnit5" )
    @JsonProperty( "OpWorkQuantityUnit5" )
    @Nullable
    @ODataField( odataName = "OpWorkQuantityUnit5" )
    private String opWorkQuantityUnit5;
    /**
     * Use with available fluent helpers to apply the <b>OpWorkQuantityUnit5</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> OP_WORK_QUANTITY_UNIT5 =
        new ProcOrdConf2Field<String>("OpWorkQuantityUnit5");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit5ISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "WorkQuantityUnit5ISOCode" )
    @JsonProperty( "WorkQuantityUnit5ISOCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit5ISOCode" )
    private String workQuantityUnit5ISOCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkQuantityUnit5ISOCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> WORK_QUANTITY_UNIT5_I_S_O_CODE =
        new ProcOrdConf2Field<String>("WorkQuantityUnit5ISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit5SAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "WorkQuantityUnit5SAPCode" )
    @JsonProperty( "WorkQuantityUnit5SAPCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit5SAPCode" )
    private String workQuantityUnit5SAPCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkQuantityUnit5SAPCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> WORK_QUANTITY_UNIT5_S_A_P_CODE =
        new ProcOrdConf2Field<String>("WorkQuantityUnit5SAPCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpConfirmedWorkQuantity5</b>
     * </p>
     *
     * @return Already Confirmed Work Quantity (Activity) 5
     */
    @SerializedName( "OpConfirmedWorkQuantity5" )
    @JsonProperty( "OpConfirmedWorkQuantity5" )
    @Nullable
    @ODataField( odataName = "OpConfirmedWorkQuantity5" )
    private BigDecimal opConfirmedWorkQuantity5;
    /**
     * Use with available fluent helpers to apply the <b>OpConfirmedWorkQuantity5</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<BigDecimal> OP_CONFIRMED_WORK_QUANTITY5 =
        new ProcOrdConf2Field<BigDecimal>("OpConfirmedWorkQuantity5");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherOpWorkQuantity5IsExpd</b>
     * </p>
     *
     * @return Indicator: No Remaining Work Quantity 5 is Expected
     */
    @SerializedName( "NoFurtherOpWorkQuantity5IsExpd" )
    @JsonProperty( "NoFurtherOpWorkQuantity5IsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherOpWorkQuantity5IsExpd" )
    private Boolean noFurtherOpWorkQuantity5IsExpd;
    /**
     * Use with available fluent helpers to apply the <b>NoFurtherOpWorkQuantity5IsExpd</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<Boolean> NO_FURTHER_OP_WORK_QUANTITY5_IS_EXPD =
        new ProcOrdConf2Field<Boolean>("NoFurtherOpWorkQuantity5IsExpd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpWorkQuantityUnit6</b>
     * </p>
     *
     * @return Unit of Measure for Confirmed Work Quantity 6
     */
    @SerializedName( "OpWorkQuantityUnit6" )
    @JsonProperty( "OpWorkQuantityUnit6" )
    @Nullable
    @ODataField( odataName = "OpWorkQuantityUnit6" )
    private String opWorkQuantityUnit6;
    /**
     * Use with available fluent helpers to apply the <b>OpWorkQuantityUnit6</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> OP_WORK_QUANTITY_UNIT6 =
        new ProcOrdConf2Field<String>("OpWorkQuantityUnit6");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit6ISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "WorkQuantityUnit6ISOCode" )
    @JsonProperty( "WorkQuantityUnit6ISOCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit6ISOCode" )
    private String workQuantityUnit6ISOCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkQuantityUnit6ISOCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> WORK_QUANTITY_UNIT6_I_S_O_CODE =
        new ProcOrdConf2Field<String>("WorkQuantityUnit6ISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit6SAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "WorkQuantityUnit6SAPCode" )
    @JsonProperty( "WorkQuantityUnit6SAPCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit6SAPCode" )
    private String workQuantityUnit6SAPCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkQuantityUnit6SAPCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> WORK_QUANTITY_UNIT6_S_A_P_CODE =
        new ProcOrdConf2Field<String>("WorkQuantityUnit6SAPCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpConfirmedWorkQuantity6</b>
     * </p>
     *
     * @return Already Confirmed Work Quantity (Activity) 6
     */
    @SerializedName( "OpConfirmedWorkQuantity6" )
    @JsonProperty( "OpConfirmedWorkQuantity6" )
    @Nullable
    @ODataField( odataName = "OpConfirmedWorkQuantity6" )
    private BigDecimal opConfirmedWorkQuantity6;
    /**
     * Use with available fluent helpers to apply the <b>OpConfirmedWorkQuantity6</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<BigDecimal> OP_CONFIRMED_WORK_QUANTITY6 =
        new ProcOrdConf2Field<BigDecimal>("OpConfirmedWorkQuantity6");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherOpWorkQuantity6IsExpd</b>
     * </p>
     *
     * @return Indicator: No Remaining Work Quantity 6 is Expected
     */
    @SerializedName( "NoFurtherOpWorkQuantity6IsExpd" )
    @JsonProperty( "NoFurtherOpWorkQuantity6IsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherOpWorkQuantity6IsExpd" )
    private Boolean noFurtherOpWorkQuantity6IsExpd;
    /**
     * Use with available fluent helpers to apply the <b>NoFurtherOpWorkQuantity6IsExpd</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<Boolean> NO_FURTHER_OP_WORK_QUANTITY6_IS_EXPD =
        new ProcOrdConf2Field<Boolean>("NoFurtherOpWorkQuantity6IsExpd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcessEntryUnit</b>
     * </p>
     *
     * @return Unit of Measure for Business Process Quantity
     */
    @SerializedName( "BusinessProcessEntryUnit" )
    @JsonProperty( "BusinessProcessEntryUnit" )
    @Nullable
    @ODataField( odataName = "BusinessProcessEntryUnit" )
    private String businessProcessEntryUnit;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcessEntryUnit</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> BUSINESS_PROCESS_ENTRY_UNIT =
        new ProcOrdConf2Field<String>("BusinessProcessEntryUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusProcessEntrUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "BusProcessEntrUnitISOCode" )
    @JsonProperty( "BusProcessEntrUnitISOCode" )
    @Nullable
    @ODataField( odataName = "BusProcessEntrUnitISOCode" )
    private String busProcessEntrUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>BusProcessEntrUnitISOCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> BUS_PROCESS_ENTR_UNIT_ISO_CODE =
        new ProcOrdConf2Field<String>("BusProcessEntrUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusProcessEntryUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "BusProcessEntryUnitSAPCode" )
    @JsonProperty( "BusProcessEntryUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "BusProcessEntryUnitSAPCode" )
    private String busProcessEntryUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>BusProcessEntryUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<String> BUS_PROCESS_ENTRY_UNIT_SAP_CODE =
        new ProcOrdConf2Field<String>("BusProcessEntryUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcessConfirmedQty</b>
     * </p>
     *
     * @return Current Quantity for Business Process
     */
    @SerializedName( "BusinessProcessConfirmedQty" )
    @JsonProperty( "BusinessProcessConfirmedQty" )
    @Nullable
    @ODataField( odataName = "BusinessProcessConfirmedQty" )
    private BigDecimal businessProcessConfirmedQty;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcessConfirmedQty</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<BigDecimal> BUSINESS_PROCESS_CONFIRMED_QTY =
        new ProcOrdConf2Field<BigDecimal>("BusinessProcessConfirmedQty");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherBusinessProcQtyIsExpd</b>
     * </p>
     *
     * @return No Remaining Quantity Expected for Business Process
     */
    @SerializedName( "NoFurtherBusinessProcQtyIsExpd" )
    @JsonProperty( "NoFurtherBusinessProcQtyIsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherBusinessProcQtyIsExpd" )
    private Boolean noFurtherBusinessProcQtyIsExpd;
    /**
     * Use with available fluent helpers to apply the <b>NoFurtherBusinessProcQtyIsExpd</b> field to query operations.
     *
     */
    public final static ProcOrdConf2Field<Boolean> NO_FURTHER_BUSINESS_PROC_QTY_IS_EXPD =
        new ProcOrdConf2Field<Boolean>("NoFurtherBusinessProcQtyIsExpd");
    /**
     * Navigation property <b>to_ProcOrdConfMatlDocItm</b> for <b>ProcOrdConf2</b> to multiple
     * <b>ProcOrdConfMatlDocItm</b>.
     *
     */
    @SerializedName( "to_ProcOrdConfMatlDocItm" )
    @JsonProperty( "to_ProcOrdConfMatlDocItm" )
    @ODataField( odataName = "to_ProcOrdConfMatlDocItm" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProcOrdConfMatlDocItm> toProcOrdConfMatlDocItm;
    /**
     * Use with available fluent helpers to apply the <b>to_ProcOrdConfMatlDocItm</b> navigation property to query
     * operations.
     *
     */
    public final static ProcOrdConf2Link<ProcOrdConfMatlDocItm> TO_PROC_ORD_CONF_MATL_DOC_ITM =
        new ProcOrdConf2Link<ProcOrdConfMatlDocItm>("to_ProcOrdConfMatlDocItm");

    @Nonnull
    @Override
    public Class<ProcOrdConf2> getType()
    {
        return ProcOrdConf2.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationGroup</b>
     * </p>
     *
     * @param confirmationGroup
     *            Collective ID of Order Confirmations
     */
    public void setConfirmationGroup( @Nullable final String confirmationGroup )
    {
        rememberChangedField("ConfirmationGroup", this.confirmationGroup);
        this.confirmationGroup = confirmationGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationCount</b>
     * </p>
     *
     * @param confirmationCount
     *            Identifier of Single Order Confirmation
     */
    public void setConfirmationCount( @Nullable final String confirmationCount )
    {
        rememberChangedField("ConfirmationCount", this.confirmationCount);
        this.confirmationCount = confirmationCount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Manufacturing Order ID
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderOperation</b>
     * </p>
     *
     * @param orderOperation
     *            Manufacturing Order Operation
     */
    public void setOrderOperation( @Nullable final String orderOperation )
    {
        rememberChangedField("OrderOperation", this.orderOperation);
        this.orderOperation = orderOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderSuboperation</b>
     * </p>
     *
     * @param orderSuboperation
     *            Manufacturing Order Suboperation
     */
    public void setOrderSuboperation( @Nullable final String orderSuboperation )
    {
        rememberChangedField("OrderSuboperation", this.orderSuboperation);
        this.orderSuboperation = orderSuboperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderType</b>
     * </p>
     *
     * @param orderType
     *            Manufacturing Order Type
     */
    public void setOrderType( @Nullable final String orderType )
    {
        rememberChangedField("OrderType", this.orderType);
        this.orderType = orderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OrderOperationInternalID</b>
     * </p>
     *
     * @param orderOperationInternalID
     *            Internal Identifier of an Operation or Activity
     */
    public void setOrderOperationInternalID( @Nullable final String orderOperationInternalID )
    {
        rememberChangedField("OrderOperationInternalID", this.orderOperationInternalID);
        this.orderOperationInternalID = orderOperationInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationText</b>
     * </p>
     *
     * @param confirmationText
     *            Confirmation Text
     */
    public void setConfirmationText( @Nullable final String confirmationText )
    {
        rememberChangedField("ConfirmationText", this.confirmationText);
        this.confirmationText = confirmationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number for Order
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPlannedTotalQty</b>
     * </p>
     *
     * @param orderPlannedTotalQty
     *            Manufacturing Order Planned Total Quantity
     */
    public void setOrderPlannedTotalQty( @Nullable final BigDecimal orderPlannedTotalQty )
    {
        rememberChangedField("OrderPlannedTotalQty", this.orderPlannedTotalQty);
        this.orderPlannedTotalQty = orderPlannedTotalQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductionUnit</b>
     * </p>
     *
     * @param productionUnit
     *            Production Unit of Measure
     */
    public void setProductionUnit( @Nullable final String productionUnit )
    {
        rememberChangedField("ProductionUnit", this.productionUnit);
        this.productionUnit = productionUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinalConfirmationType</b>
     * </p>
     *
     * @param finalConfirmationType
     *            Final Confirmation Type
     */
    public void setFinalConfirmationType( @Nullable final String finalConfirmationType )
    {
        rememberChangedField("FinalConfirmationType", this.finalConfirmationType);
        this.finalConfirmationType = finalConfirmationType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsFinalConfirmation</b>
     * </p>
     *
     * @param isFinalConfirmation
     *            Activation of Final Confirmation
     */
    public void setIsFinalConfirmation( @Nullable final Boolean isFinalConfirmation )
    {
        rememberChangedField("IsFinalConfirmation", this.isFinalConfirmation);
        this.isFinalConfirmation = isFinalConfirmation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OpenReservationsIsCleared</b>
     * </p>
     *
     * @param openReservationsIsCleared
     *            Clear Open Reservations
     */
    public void setOpenReservationsIsCleared( @Nullable final Boolean openReservationsIsCleared )
    {
        rememberChangedField("OpenReservationsIsCleared", this.openReservationsIsCleared);
        this.openReservationsIsCleared = openReservationsIsCleared;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversed</b>
     * </p>
     *
     * @param isReversed
     *            Indicator: Document was reversed
     */
    public void setIsReversed( @Nullable final Boolean isReversed )
    {
        rememberChangedField("IsReversed", this.isReversed);
        this.isReversed = isReversed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversal</b>
     * </p>
     *
     * @param isReversal
     *            Confirmation record is a Cancellation
     */
    public void setIsReversal( @Nullable final Boolean isReversal )
    {
        rememberChangedField("IsReversal", this.isReversal);
        this.isReversal = isReversal;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>APIConfHasNoGoodsMovements</b>
     * </p>
     *
     * @param aPIConfHasNoGoodsMovements
     *            Confirmation: No Goods Movement via API
     */
    public void setAPIConfHasNoGoodsMovements( @Nullable final Boolean aPIConfHasNoGoodsMovements )
    {
        rememberChangedField("APIConfHasNoGoodsMovements", this.aPIConfHasNoGoodsMovements);
        this.aPIConfHasNoGoodsMovements = aPIConfHasNoGoodsMovements;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderConfirmationRecordType</b>
     * </p>
     *
     * @param orderConfirmationRecordType
     *            Record Type for Confirmation
     */
    public void setOrderConfirmationRecordType( @Nullable final String orderConfirmationRecordType )
    {
        rememberChangedField("OrderConfirmationRecordType", this.orderConfirmationRecordType);
        this.orderConfirmationRecordType = orderConfirmationRecordType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationEntryDate</b>
     * </p>
     *
     * @param confirmationEntryDate
     *            Entry Date of Confirmation
     */
    public void setConfirmationEntryDate( @Nullable final LocalDateTime confirmationEntryDate )
    {
        rememberChangedField("ConfirmationEntryDate", this.confirmationEntryDate);
        this.confirmationEntryDate = confirmationEntryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationEntryTime</b>
     * </p>
     *
     * @param confirmationEntryTime
     *            Confirmation Entry Time
     */
    public void setConfirmationEntryTime( @Nullable final LocalTime confirmationEntryTime )
    {
        rememberChangedField("ConfirmationEntryTime", this.confirmationEntryTime);
        this.confirmationEntryTime = confirmationEntryTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EnteredByUser</b>
     * </p>
     *
     * @param enteredByUser
     *            User who Entered the Confirmation
     */
    public void setEnteredByUser( @Nullable final String enteredByUser )
    {
        rememberChangedField("EnteredByUser", this.enteredByUser);
        this.enteredByUser = enteredByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Date of Last Change
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationExternalEntryDate</b>
     * </p>
     *
     * @param confirmationExternalEntryDate
     *            External date of entry for confirmation
     */
    public void setConfirmationExternalEntryDate( @Nullable final LocalDateTime confirmationExternalEntryDate )
    {
        rememberChangedField("ConfirmationExternalEntryDate", this.confirmationExternalEntryDate);
        this.confirmationExternalEntryDate = confirmationExternalEntryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationExternalEntryTime</b>
     * </p>
     *
     * @param confirmationExternalEntryTime
     *            External time of entry for confirmation
     */
    public void setConfirmationExternalEntryTime( @Nullable final LocalTime confirmationExternalEntryTime )
    {
        rememberChangedField("ConfirmationExternalEntryTime", this.confirmationExternalEntryTime);
        this.confirmationExternalEntryTime = confirmationExternalEntryTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EnteredByExternalUser</b>
     * </p>
     *
     * @param enteredByExternalUser
     *            External creator of confirmation
     */
    public void setEnteredByExternalUser( @Nullable final String enteredByExternalUser )
    {
        rememberChangedField("EnteredByExternalUser", this.enteredByExternalUser);
        this.enteredByExternalUser = enteredByExternalUser;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExternalSystemConfirmation</b>
     * </p>
     *
     * @param externalSystemConfirmation
     *            External Key for Confirmation (for example, from PDC System)
     */
    public void setExternalSystemConfirmation( @Nullable final UUID externalSystemConfirmation )
    {
        rememberChangedField("ExternalSystemConfirmation", this.externalSystemConfirmation);
        this.externalSystemConfirmation = externalSystemConfirmation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Object Type of the Resource
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShiftGrouping</b>
     * </p>
     *
     * @param shiftGrouping
     *            Grouping for Shift Definitions and Shift Sequences
     */
    public void setShiftGrouping( @Nullable final String shiftGrouping )
    {
        rememberChangedField("ShiftGrouping", this.shiftGrouping);
        this.shiftGrouping = shiftGrouping;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftDefinition</b>
     * </p>
     *
     * @param shiftDefinition
     *            Shift Definition
     */
    public void setShiftDefinition( @Nullable final String shiftDefinition )
    {
        rememberChangedField("ShiftDefinition", this.shiftDefinition);
        this.shiftDefinition = shiftDefinition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @param personnel
     *            Personnel Number
     */
    public void setPersonnel( @Nullable final String personnel )
    {
        rememberChangedField("Personnel", this.personnel);
        this.personnel = personnel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TimeRecording</b>
     * </p>
     *
     * @param timeRecording
     *            Time Recording ID
     */
    public void setTimeRecording( @Nullable final String timeRecording )
    {
        rememberChangedField("TimeRecording", this.timeRecording);
        this.timeRecording = timeRecording;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EmployeeWageType</b>
     * </p>
     *
     * @param employeeWageType
     *            Employee Wage Type
     */
    public void setEmployeeWageType( @Nullable final String employeeWageType )
    {
        rememberChangedField("EmployeeWageType", this.employeeWageType);
        this.employeeWageType = employeeWageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmployeeWageGroup</b>
     * </p>
     *
     * @param employeeWageGroup
     *            Employee Wage Group
     */
    public void setEmployeeWageGroup( @Nullable final String employeeWageGroup )
    {
        rememberChangedField("EmployeeWageGroup", this.employeeWageGroup);
        this.employeeWageGroup = employeeWageGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BreakDurationUnit</b>
     * </p>
     *
     * @param breakDurationUnit
     *            Unit for a Break Time
     */
    public void setBreakDurationUnit( @Nullable final String breakDurationUnit )
    {
        rememberChangedField("BreakDurationUnit", this.breakDurationUnit);
        this.breakDurationUnit = breakDurationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BreakDurationUnitISOCode</b>
     * </p>
     *
     * @param breakDurationUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setBreakDurationUnitISOCode( @Nullable final String breakDurationUnitISOCode )
    {
        rememberChangedField("BreakDurationUnitISOCode", this.breakDurationUnitISOCode);
        this.breakDurationUnitISOCode = breakDurationUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BreakDurationUnitSAPCode</b>
     * </p>
     *
     * @param breakDurationUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setBreakDurationUnitSAPCode( @Nullable final String breakDurationUnitSAPCode )
    {
        rememberChangedField("BreakDurationUnitSAPCode", this.breakDurationUnitSAPCode);
        this.breakDurationUnitSAPCode = breakDurationUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedBreakDuration</b>
     * </p>
     *
     * @param confirmedBreakDuration
     *            Confirmed Break Time
     */
    public void setConfirmedBreakDuration( @Nullable final BigDecimal confirmedBreakDuration )
    {
        rememberChangedField("ConfirmedBreakDuration", this.confirmedBreakDuration);
        this.confirmedBreakDuration = confirmedBreakDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EmployeeSuitability</b>
     * </p>
     *
     * @param employeeSuitability
     *            Employee Suitability
     */
    public void setEmployeeSuitability( @Nullable final String employeeSuitability )
    {
        rememberChangedField("EmployeeSuitability", this.employeeSuitability);
        this.employeeSuitability = employeeSuitability;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfEmployees</b>
     * </p>
     *
     * @param numberOfEmployees
     *            Number of Employees
     */
    public void setNumberOfEmployees( @Nullable final BigDecimal numberOfEmployees )
    {
        rememberChangedField("NumberOfEmployees", this.numberOfEmployees);
        this.numberOfEmployees = numberOfEmployees;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedExecutionStartDate</b>
     * </p>
     *
     * @param confirmedExecutionStartDate
     *            Confirmed Start Date of Execution
     */
    public void setConfirmedExecutionStartDate( @Nullable final LocalDateTime confirmedExecutionStartDate )
    {
        rememberChangedField("ConfirmedExecutionStartDate", this.confirmedExecutionStartDate);
        this.confirmedExecutionStartDate = confirmedExecutionStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedExecutionStartTime</b>
     * </p>
     *
     * @param confirmedExecutionStartTime
     *            Confirmed Start Time of Execution
     */
    public void setConfirmedExecutionStartTime( @Nullable final LocalTime confirmedExecutionStartTime )
    {
        rememberChangedField("ConfirmedExecutionStartTime", this.confirmedExecutionStartTime);
        this.confirmedExecutionStartTime = confirmedExecutionStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedSetupEndDate</b>
     * </p>
     *
     * @param confirmedSetupEndDate
     *            Confirmed End Date of Setup
     */
    public void setConfirmedSetupEndDate( @Nullable final LocalDateTime confirmedSetupEndDate )
    {
        rememberChangedField("ConfirmedSetupEndDate", this.confirmedSetupEndDate);
        this.confirmedSetupEndDate = confirmedSetupEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedSetupEndTime</b>
     * </p>
     *
     * @param confirmedSetupEndTime
     *            Confirmed End Time of Setup
     */
    public void setConfirmedSetupEndTime( @Nullable final LocalTime confirmedSetupEndTime )
    {
        rememberChangedField("ConfirmedSetupEndTime", this.confirmedSetupEndTime);
        this.confirmedSetupEndTime = confirmedSetupEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProcessingStartDate</b>
     * </p>
     *
     * @param confirmedProcessingStartDate
     *            Confirmed Start Date of Processing
     */
    public void setConfirmedProcessingStartDate( @Nullable final LocalDateTime confirmedProcessingStartDate )
    {
        rememberChangedField("ConfirmedProcessingStartDate", this.confirmedProcessingStartDate);
        this.confirmedProcessingStartDate = confirmedProcessingStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProcessingStartTime</b>
     * </p>
     *
     * @param confirmedProcessingStartTime
     *            Confirmed Start Time of Processing
     */
    public void setConfirmedProcessingStartTime( @Nullable final LocalTime confirmedProcessingStartTime )
    {
        rememberChangedField("ConfirmedProcessingStartTime", this.confirmedProcessingStartTime);
        this.confirmedProcessingStartTime = confirmedProcessingStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProcessingEndDate</b>
     * </p>
     *
     * @param confirmedProcessingEndDate
     *            Confirmed End Date of Processing
     */
    public void setConfirmedProcessingEndDate( @Nullable final LocalDateTime confirmedProcessingEndDate )
    {
        rememberChangedField("ConfirmedProcessingEndDate", this.confirmedProcessingEndDate);
        this.confirmedProcessingEndDate = confirmedProcessingEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProcessingEndTime</b>
     * </p>
     *
     * @param confirmedProcessingEndTime
     *            Confirmed End Time of Processing
     */
    public void setConfirmedProcessingEndTime( @Nullable final LocalTime confirmedProcessingEndTime )
    {
        rememberChangedField("ConfirmedProcessingEndTime", this.confirmedProcessingEndTime);
        this.confirmedProcessingEndTime = confirmedProcessingEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedTeardownStartDate</b>
     * </p>
     *
     * @param confirmedTeardownStartDate
     *            Confirmed Start Date of Teardown
     */
    public void setConfirmedTeardownStartDate( @Nullable final LocalDateTime confirmedTeardownStartDate )
    {
        rememberChangedField("ConfirmedTeardownStartDate", this.confirmedTeardownStartDate);
        this.confirmedTeardownStartDate = confirmedTeardownStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedTeardownStartTime</b>
     * </p>
     *
     * @param confirmedTeardownStartTime
     *            Confirmed Start Time of Teardown
     */
    public void setConfirmedTeardownStartTime( @Nullable final LocalTime confirmedTeardownStartTime )
    {
        rememberChangedField("ConfirmedTeardownStartTime", this.confirmedTeardownStartTime);
        this.confirmedTeardownStartTime = confirmedTeardownStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedExecutionEndDate</b>
     * </p>
     *
     * @param confirmedExecutionEndDate
     *            Confirmed End Date of Execution
     */
    public void setConfirmedExecutionEndDate( @Nullable final LocalDateTime confirmedExecutionEndDate )
    {
        rememberChangedField("ConfirmedExecutionEndDate", this.confirmedExecutionEndDate);
        this.confirmedExecutionEndDate = confirmedExecutionEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedExecutionEndTime</b>
     * </p>
     *
     * @param confirmedExecutionEndTime
     *            Confirmed End Time of Execution
     */
    public void setConfirmedExecutionEndTime( @Nullable final LocalTime confirmedExecutionEndTime )
    {
        rememberChangedField("ConfirmedExecutionEndTime", this.confirmedExecutionEndTime);
        this.confirmedExecutionEndTime = confirmedExecutionEndTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationUnit</b>
     * </p>
     *
     * @param confirmationUnit
     *            Confirmation Unit of Measure
     */
    public void setConfirmationUnit( @Nullable final String confirmationUnit )
    {
        rememberChangedField("ConfirmationUnit", this.confirmationUnit);
        this.confirmationUnit = confirmationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationUnitISOCode</b>
     * </p>
     *
     * @param confirmationUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setConfirmationUnitISOCode( @Nullable final String confirmationUnitISOCode )
    {
        rememberChangedField("ConfirmationUnitISOCode", this.confirmationUnitISOCode);
        this.confirmationUnitISOCode = confirmationUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationUnitSAPCode</b>
     * </p>
     *
     * @param confirmationUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setConfirmationUnitSAPCode( @Nullable final String confirmationUnitSAPCode )
    {
        rememberChangedField("ConfirmationUnitSAPCode", this.confirmationUnitSAPCode);
        this.confirmationUnitSAPCode = confirmationUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationYieldQuantity</b>
     * </p>
     *
     * @param confirmationYieldQuantity
     *            Yield to be Confirmed
     */
    public void setConfirmationYieldQuantity( @Nullable final BigDecimal confirmationYieldQuantity )
    {
        rememberChangedField("ConfirmationYieldQuantity", this.confirmationYieldQuantity);
        this.confirmationYieldQuantity = confirmationYieldQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationScrapQuantity</b>
     * </p>
     *
     * @param confirmationScrapQuantity
     *            Scrap to Be Confirmed
     */
    public void setConfirmationScrapQuantity( @Nullable final BigDecimal confirmationScrapQuantity )
    {
        rememberChangedField("ConfirmationScrapQuantity", this.confirmationScrapQuantity);
        this.confirmationScrapQuantity = confirmationScrapQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>VarianceReasonCode</b>
     * </p>
     *
     * @param varianceReasonCode
     *            Reason for Variance
     */
    public void setVarianceReasonCode( @Nullable final String varianceReasonCode )
    {
        rememberChangedField("VarianceReasonCode", this.varianceReasonCode);
        this.varianceReasonCode = varianceReasonCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpWorkQuantityUnit1</b>
     * </p>
     *
     * @param opWorkQuantityUnit1
     *            Unit of Measure for Confirmed Work Quantity 1
     */
    public void setOpWorkQuantityUnit1( @Nullable final String opWorkQuantityUnit1 )
    {
        rememberChangedField("OpWorkQuantityUnit1", this.opWorkQuantityUnit1);
        this.opWorkQuantityUnit1 = opWorkQuantityUnit1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit1ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit1ISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setWorkQuantityUnit1ISOCode( @Nullable final String workQuantityUnit1ISOCode )
    {
        rememberChangedField("WorkQuantityUnit1ISOCode", this.workQuantityUnit1ISOCode);
        this.workQuantityUnit1ISOCode = workQuantityUnit1ISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit1SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit1SAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setWorkQuantityUnit1SAPCode( @Nullable final String workQuantityUnit1SAPCode )
    {
        rememberChangedField("WorkQuantityUnit1SAPCode", this.workQuantityUnit1SAPCode);
        this.workQuantityUnit1SAPCode = workQuantityUnit1SAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpConfirmedWorkQuantity1</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity1
     *            Already Confirmed Work Quantity (Activity) 1
     */
    public void setOpConfirmedWorkQuantity1( @Nullable final BigDecimal opConfirmedWorkQuantity1 )
    {
        rememberChangedField("OpConfirmedWorkQuantity1", this.opConfirmedWorkQuantity1);
        this.opConfirmedWorkQuantity1 = opConfirmedWorkQuantity1;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherOpWorkQuantity1IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity1IsExpd
     *            Indicator: No Remaining Work Quantity 1 is Expected
     */
    public void setNoFurtherOpWorkQuantity1IsExpd( @Nullable final Boolean noFurtherOpWorkQuantity1IsExpd )
    {
        rememberChangedField("NoFurtherOpWorkQuantity1IsExpd", this.noFurtherOpWorkQuantity1IsExpd);
        this.noFurtherOpWorkQuantity1IsExpd = noFurtherOpWorkQuantity1IsExpd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpWorkQuantityUnit2</b>
     * </p>
     *
     * @param opWorkQuantityUnit2
     *            Unit of Measure for Confirmed Work Quantity 2
     */
    public void setOpWorkQuantityUnit2( @Nullable final String opWorkQuantityUnit2 )
    {
        rememberChangedField("OpWorkQuantityUnit2", this.opWorkQuantityUnit2);
        this.opWorkQuantityUnit2 = opWorkQuantityUnit2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit2ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit2ISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setWorkQuantityUnit2ISOCode( @Nullable final String workQuantityUnit2ISOCode )
    {
        rememberChangedField("WorkQuantityUnit2ISOCode", this.workQuantityUnit2ISOCode);
        this.workQuantityUnit2ISOCode = workQuantityUnit2ISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit2SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit2SAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setWorkQuantityUnit2SAPCode( @Nullable final String workQuantityUnit2SAPCode )
    {
        rememberChangedField("WorkQuantityUnit2SAPCode", this.workQuantityUnit2SAPCode);
        this.workQuantityUnit2SAPCode = workQuantityUnit2SAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpConfirmedWorkQuantity2</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity2
     *            Already Confirmed Work Quantity (Activity) 2
     */
    public void setOpConfirmedWorkQuantity2( @Nullable final BigDecimal opConfirmedWorkQuantity2 )
    {
        rememberChangedField("OpConfirmedWorkQuantity2", this.opConfirmedWorkQuantity2);
        this.opConfirmedWorkQuantity2 = opConfirmedWorkQuantity2;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherOpWorkQuantity2IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity2IsExpd
     *            Indicator: No Remaining Work Quantity 2 is Expected
     */
    public void setNoFurtherOpWorkQuantity2IsExpd( @Nullable final Boolean noFurtherOpWorkQuantity2IsExpd )
    {
        rememberChangedField("NoFurtherOpWorkQuantity2IsExpd", this.noFurtherOpWorkQuantity2IsExpd);
        this.noFurtherOpWorkQuantity2IsExpd = noFurtherOpWorkQuantity2IsExpd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpWorkQuantityUnit3</b>
     * </p>
     *
     * @param opWorkQuantityUnit3
     *            Unit of Measure for Confirmed Work Quantity 3
     */
    public void setOpWorkQuantityUnit3( @Nullable final String opWorkQuantityUnit3 )
    {
        rememberChangedField("OpWorkQuantityUnit3", this.opWorkQuantityUnit3);
        this.opWorkQuantityUnit3 = opWorkQuantityUnit3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit3ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit3ISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setWorkQuantityUnit3ISOCode( @Nullable final String workQuantityUnit3ISOCode )
    {
        rememberChangedField("WorkQuantityUnit3ISOCode", this.workQuantityUnit3ISOCode);
        this.workQuantityUnit3ISOCode = workQuantityUnit3ISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit3SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit3SAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setWorkQuantityUnit3SAPCode( @Nullable final String workQuantityUnit3SAPCode )
    {
        rememberChangedField("WorkQuantityUnit3SAPCode", this.workQuantityUnit3SAPCode);
        this.workQuantityUnit3SAPCode = workQuantityUnit3SAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpConfirmedWorkQuantity3</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity3
     *            Already Confirmed Work Quantity (Activity) 3
     */
    public void setOpConfirmedWorkQuantity3( @Nullable final BigDecimal opConfirmedWorkQuantity3 )
    {
        rememberChangedField("OpConfirmedWorkQuantity3", this.opConfirmedWorkQuantity3);
        this.opConfirmedWorkQuantity3 = opConfirmedWorkQuantity3;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherOpWorkQuantity3IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity3IsExpd
     *            Indicator: No Remaining Work Quantity 3 is Expected
     */
    public void setNoFurtherOpWorkQuantity3IsExpd( @Nullable final Boolean noFurtherOpWorkQuantity3IsExpd )
    {
        rememberChangedField("NoFurtherOpWorkQuantity3IsExpd", this.noFurtherOpWorkQuantity3IsExpd);
        this.noFurtherOpWorkQuantity3IsExpd = noFurtherOpWorkQuantity3IsExpd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpWorkQuantityUnit4</b>
     * </p>
     *
     * @param opWorkQuantityUnit4
     *            Unit of Measure for Confirmed Work Quantity 4
     */
    public void setOpWorkQuantityUnit4( @Nullable final String opWorkQuantityUnit4 )
    {
        rememberChangedField("OpWorkQuantityUnit4", this.opWorkQuantityUnit4);
        this.opWorkQuantityUnit4 = opWorkQuantityUnit4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit4ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit4ISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setWorkQuantityUnit4ISOCode( @Nullable final String workQuantityUnit4ISOCode )
    {
        rememberChangedField("WorkQuantityUnit4ISOCode", this.workQuantityUnit4ISOCode);
        this.workQuantityUnit4ISOCode = workQuantityUnit4ISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit4SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit4SAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setWorkQuantityUnit4SAPCode( @Nullable final String workQuantityUnit4SAPCode )
    {
        rememberChangedField("WorkQuantityUnit4SAPCode", this.workQuantityUnit4SAPCode);
        this.workQuantityUnit4SAPCode = workQuantityUnit4SAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpConfirmedWorkQuantity4</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity4
     *            Already Confirmed Work Quantity (Activity) 4
     */
    public void setOpConfirmedWorkQuantity4( @Nullable final BigDecimal opConfirmedWorkQuantity4 )
    {
        rememberChangedField("OpConfirmedWorkQuantity4", this.opConfirmedWorkQuantity4);
        this.opConfirmedWorkQuantity4 = opConfirmedWorkQuantity4;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherOpWorkQuantity4IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity4IsExpd
     *            Indicator: No Remaining Work Quantity 4 is Expected
     */
    public void setNoFurtherOpWorkQuantity4IsExpd( @Nullable final Boolean noFurtherOpWorkQuantity4IsExpd )
    {
        rememberChangedField("NoFurtherOpWorkQuantity4IsExpd", this.noFurtherOpWorkQuantity4IsExpd);
        this.noFurtherOpWorkQuantity4IsExpd = noFurtherOpWorkQuantity4IsExpd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpWorkQuantityUnit5</b>
     * </p>
     *
     * @param opWorkQuantityUnit5
     *            Unit of Measure for Confirmed Work Quantity 5
     */
    public void setOpWorkQuantityUnit5( @Nullable final String opWorkQuantityUnit5 )
    {
        rememberChangedField("OpWorkQuantityUnit5", this.opWorkQuantityUnit5);
        this.opWorkQuantityUnit5 = opWorkQuantityUnit5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit5ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit5ISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setWorkQuantityUnit5ISOCode( @Nullable final String workQuantityUnit5ISOCode )
    {
        rememberChangedField("WorkQuantityUnit5ISOCode", this.workQuantityUnit5ISOCode);
        this.workQuantityUnit5ISOCode = workQuantityUnit5ISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit5SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit5SAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setWorkQuantityUnit5SAPCode( @Nullable final String workQuantityUnit5SAPCode )
    {
        rememberChangedField("WorkQuantityUnit5SAPCode", this.workQuantityUnit5SAPCode);
        this.workQuantityUnit5SAPCode = workQuantityUnit5SAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpConfirmedWorkQuantity5</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity5
     *            Already Confirmed Work Quantity (Activity) 5
     */
    public void setOpConfirmedWorkQuantity5( @Nullable final BigDecimal opConfirmedWorkQuantity5 )
    {
        rememberChangedField("OpConfirmedWorkQuantity5", this.opConfirmedWorkQuantity5);
        this.opConfirmedWorkQuantity5 = opConfirmedWorkQuantity5;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherOpWorkQuantity5IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity5IsExpd
     *            Indicator: No Remaining Work Quantity 5 is Expected
     */
    public void setNoFurtherOpWorkQuantity5IsExpd( @Nullable final Boolean noFurtherOpWorkQuantity5IsExpd )
    {
        rememberChangedField("NoFurtherOpWorkQuantity5IsExpd", this.noFurtherOpWorkQuantity5IsExpd);
        this.noFurtherOpWorkQuantity5IsExpd = noFurtherOpWorkQuantity5IsExpd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpWorkQuantityUnit6</b>
     * </p>
     *
     * @param opWorkQuantityUnit6
     *            Unit of Measure for Confirmed Work Quantity 6
     */
    public void setOpWorkQuantityUnit6( @Nullable final String opWorkQuantityUnit6 )
    {
        rememberChangedField("OpWorkQuantityUnit6", this.opWorkQuantityUnit6);
        this.opWorkQuantityUnit6 = opWorkQuantityUnit6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit6ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit6ISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setWorkQuantityUnit6ISOCode( @Nullable final String workQuantityUnit6ISOCode )
    {
        rememberChangedField("WorkQuantityUnit6ISOCode", this.workQuantityUnit6ISOCode);
        this.workQuantityUnit6ISOCode = workQuantityUnit6ISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkQuantityUnit6SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit6SAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setWorkQuantityUnit6SAPCode( @Nullable final String workQuantityUnit6SAPCode )
    {
        rememberChangedField("WorkQuantityUnit6SAPCode", this.workQuantityUnit6SAPCode);
        this.workQuantityUnit6SAPCode = workQuantityUnit6SAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpConfirmedWorkQuantity6</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity6
     *            Already Confirmed Work Quantity (Activity) 6
     */
    public void setOpConfirmedWorkQuantity6( @Nullable final BigDecimal opConfirmedWorkQuantity6 )
    {
        rememberChangedField("OpConfirmedWorkQuantity6", this.opConfirmedWorkQuantity6);
        this.opConfirmedWorkQuantity6 = opConfirmedWorkQuantity6;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherOpWorkQuantity6IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity6IsExpd
     *            Indicator: No Remaining Work Quantity 6 is Expected
     */
    public void setNoFurtherOpWorkQuantity6IsExpd( @Nullable final Boolean noFurtherOpWorkQuantity6IsExpd )
    {
        rememberChangedField("NoFurtherOpWorkQuantity6IsExpd", this.noFurtherOpWorkQuantity6IsExpd);
        this.noFurtherOpWorkQuantity6IsExpd = noFurtherOpWorkQuantity6IsExpd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcessEntryUnit</b>
     * </p>
     *
     * @param businessProcessEntryUnit
     *            Unit of Measure for Business Process Quantity
     */
    public void setBusinessProcessEntryUnit( @Nullable final String businessProcessEntryUnit )
    {
        rememberChangedField("BusinessProcessEntryUnit", this.businessProcessEntryUnit);
        this.businessProcessEntryUnit = businessProcessEntryUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusProcessEntrUnitISOCode</b>
     * </p>
     *
     * @param busProcessEntrUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setBusProcessEntrUnitISOCode( @Nullable final String busProcessEntrUnitISOCode )
    {
        rememberChangedField("BusProcessEntrUnitISOCode", this.busProcessEntrUnitISOCode);
        this.busProcessEntrUnitISOCode = busProcessEntrUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusProcessEntryUnitSAPCode</b>
     * </p>
     *
     * @param busProcessEntryUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setBusProcessEntryUnitSAPCode( @Nullable final String busProcessEntryUnitSAPCode )
    {
        rememberChangedField("BusProcessEntryUnitSAPCode", this.busProcessEntryUnitSAPCode);
        this.busProcessEntryUnitSAPCode = busProcessEntryUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcessConfirmedQty</b>
     * </p>
     *
     * @param businessProcessConfirmedQty
     *            Current Quantity for Business Process
     */
    public void setBusinessProcessConfirmedQty( @Nullable final BigDecimal businessProcessConfirmedQty )
    {
        rememberChangedField("BusinessProcessConfirmedQty", this.businessProcessConfirmedQty);
        this.businessProcessConfirmedQty = businessProcessConfirmedQty;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherBusinessProcQtyIsExpd</b>
     * </p>
     *
     * @param noFurtherBusinessProcQtyIsExpd
     *            No Remaining Quantity Expected for Business Process
     */
    public void setNoFurtherBusinessProcQtyIsExpd( @Nullable final Boolean noFurtherBusinessProcQtyIsExpd )
    {
        rememberChangedField("NoFurtherBusinessProcQtyIsExpd", this.noFurtherBusinessProcQtyIsExpd);
        this.noFurtherBusinessProcQtyIsExpd = noFurtherBusinessProcQtyIsExpd;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProcOrdConf2";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConfirmationGroup", getConfirmationGroup());
        result.put("ConfirmationCount", getConfirmationCount());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConfirmationGroup", getConfirmationGroup());
        values.put("ConfirmationCount", getConfirmationCount());
        values.put("OrderID", getOrderID());
        values.put("OrderOperation", getOrderOperation());
        values.put("OrderSuboperation", getOrderSuboperation());
        values.put("OrderType", getOrderType());
        values.put("OrderOperationInternalID", getOrderOperationInternalID());
        values.put("ConfirmationText", getConfirmationText());
        values.put("Language", getLanguage());
        values.put("Material", getMaterial());
        values.put("OrderPlannedTotalQty", getOrderPlannedTotalQty());
        values.put("ProductionUnit", getProductionUnit());
        values.put("FinalConfirmationType", getFinalConfirmationType());
        values.put("IsFinalConfirmation", getIsFinalConfirmation());
        values.put("OpenReservationsIsCleared", getOpenReservationsIsCleared());
        values.put("IsReversed", getIsReversed());
        values.put("IsReversal", getIsReversal());
        values.put("APIConfHasNoGoodsMovements", getAPIConfHasNoGoodsMovements());
        values.put("OrderConfirmationRecordType", getOrderConfirmationRecordType());
        values.put("ConfirmationEntryDate", getConfirmationEntryDate());
        values.put("ConfirmationEntryTime", getConfirmationEntryTime());
        values.put("EnteredByUser", getEnteredByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ConfirmationExternalEntryDate", getConfirmationExternalEntryDate());
        values.put("ConfirmationExternalEntryTime", getConfirmationExternalEntryTime());
        values.put("EnteredByExternalUser", getEnteredByExternalUser());
        values.put("ExternalSystemConfirmation", getExternalSystemConfirmation());
        values.put("Plant", getPlant());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("WorkCenter", getWorkCenter());
        values.put("ShiftGrouping", getShiftGrouping());
        values.put("ShiftDefinition", getShiftDefinition());
        values.put("Personnel", getPersonnel());
        values.put("TimeRecording", getTimeRecording());
        values.put("EmployeeWageType", getEmployeeWageType());
        values.put("EmployeeWageGroup", getEmployeeWageGroup());
        values.put("BreakDurationUnit", getBreakDurationUnit());
        values.put("BreakDurationUnitISOCode", getBreakDurationUnitISOCode());
        values.put("BreakDurationUnitSAPCode", getBreakDurationUnitSAPCode());
        values.put("ConfirmedBreakDuration", getConfirmedBreakDuration());
        values.put("EmployeeSuitability", getEmployeeSuitability());
        values.put("NumberOfEmployees", getNumberOfEmployees());
        values.put("PostingDate", getPostingDate());
        values.put("ConfirmedExecutionStartDate", getConfirmedExecutionStartDate());
        values.put("ConfirmedExecutionStartTime", getConfirmedExecutionStartTime());
        values.put("ConfirmedSetupEndDate", getConfirmedSetupEndDate());
        values.put("ConfirmedSetupEndTime", getConfirmedSetupEndTime());
        values.put("ConfirmedProcessingStartDate", getConfirmedProcessingStartDate());
        values.put("ConfirmedProcessingStartTime", getConfirmedProcessingStartTime());
        values.put("ConfirmedProcessingEndDate", getConfirmedProcessingEndDate());
        values.put("ConfirmedProcessingEndTime", getConfirmedProcessingEndTime());
        values.put("ConfirmedTeardownStartDate", getConfirmedTeardownStartDate());
        values.put("ConfirmedTeardownStartTime", getConfirmedTeardownStartTime());
        values.put("ConfirmedExecutionEndDate", getConfirmedExecutionEndDate());
        values.put("ConfirmedExecutionEndTime", getConfirmedExecutionEndTime());
        values.put("ConfirmationUnit", getConfirmationUnit());
        values.put("ConfirmationUnitISOCode", getConfirmationUnitISOCode());
        values.put("ConfirmationUnitSAPCode", getConfirmationUnitSAPCode());
        values.put("ConfirmationYieldQuantity", getConfirmationYieldQuantity());
        values.put("ConfirmationScrapQuantity", getConfirmationScrapQuantity());
        values.put("VarianceReasonCode", getVarianceReasonCode());
        values.put("OpWorkQuantityUnit1", getOpWorkQuantityUnit1());
        values.put("WorkQuantityUnit1ISOCode", getWorkQuantityUnit1ISOCode());
        values.put("WorkQuantityUnit1SAPCode", getWorkQuantityUnit1SAPCode());
        values.put("OpConfirmedWorkQuantity1", getOpConfirmedWorkQuantity1());
        values.put("NoFurtherOpWorkQuantity1IsExpd", getNoFurtherOpWorkQuantity1IsExpd());
        values.put("OpWorkQuantityUnit2", getOpWorkQuantityUnit2());
        values.put("WorkQuantityUnit2ISOCode", getWorkQuantityUnit2ISOCode());
        values.put("WorkQuantityUnit2SAPCode", getWorkQuantityUnit2SAPCode());
        values.put("OpConfirmedWorkQuantity2", getOpConfirmedWorkQuantity2());
        values.put("NoFurtherOpWorkQuantity2IsExpd", getNoFurtherOpWorkQuantity2IsExpd());
        values.put("OpWorkQuantityUnit3", getOpWorkQuantityUnit3());
        values.put("WorkQuantityUnit3ISOCode", getWorkQuantityUnit3ISOCode());
        values.put("WorkQuantityUnit3SAPCode", getWorkQuantityUnit3SAPCode());
        values.put("OpConfirmedWorkQuantity3", getOpConfirmedWorkQuantity3());
        values.put("NoFurtherOpWorkQuantity3IsExpd", getNoFurtherOpWorkQuantity3IsExpd());
        values.put("OpWorkQuantityUnit4", getOpWorkQuantityUnit4());
        values.put("WorkQuantityUnit4ISOCode", getWorkQuantityUnit4ISOCode());
        values.put("WorkQuantityUnit4SAPCode", getWorkQuantityUnit4SAPCode());
        values.put("OpConfirmedWorkQuantity4", getOpConfirmedWorkQuantity4());
        values.put("NoFurtherOpWorkQuantity4IsExpd", getNoFurtherOpWorkQuantity4IsExpd());
        values.put("OpWorkQuantityUnit5", getOpWorkQuantityUnit5());
        values.put("WorkQuantityUnit5ISOCode", getWorkQuantityUnit5ISOCode());
        values.put("WorkQuantityUnit5SAPCode", getWorkQuantityUnit5SAPCode());
        values.put("OpConfirmedWorkQuantity5", getOpConfirmedWorkQuantity5());
        values.put("NoFurtherOpWorkQuantity5IsExpd", getNoFurtherOpWorkQuantity5IsExpd());
        values.put("OpWorkQuantityUnit6", getOpWorkQuantityUnit6());
        values.put("WorkQuantityUnit6ISOCode", getWorkQuantityUnit6ISOCode());
        values.put("WorkQuantityUnit6SAPCode", getWorkQuantityUnit6SAPCode());
        values.put("OpConfirmedWorkQuantity6", getOpConfirmedWorkQuantity6());
        values.put("NoFurtherOpWorkQuantity6IsExpd", getNoFurtherOpWorkQuantity6IsExpd());
        values.put("BusinessProcessEntryUnit", getBusinessProcessEntryUnit());
        values.put("BusProcessEntrUnitISOCode", getBusProcessEntrUnitISOCode());
        values.put("BusProcessEntryUnitSAPCode", getBusProcessEntryUnitSAPCode());
        values.put("BusinessProcessConfirmedQty", getBusinessProcessConfirmedQty());
        values.put("NoFurtherBusinessProcQtyIsExpd", getNoFurtherBusinessProcQtyIsExpd());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConfirmationGroup") ) {
                final Object value = values.remove("ConfirmationGroup");
                if( (value == null) || (!value.equals(getConfirmationGroup())) ) {
                    setConfirmationGroup(((String) value));
                }
            }
            if( values.containsKey("ConfirmationCount") ) {
                final Object value = values.remove("ConfirmationCount");
                if( (value == null) || (!value.equals(getConfirmationCount())) ) {
                    setConfirmationCount(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("OrderOperation") ) {
                final Object value = values.remove("OrderOperation");
                if( (value == null) || (!value.equals(getOrderOperation())) ) {
                    setOrderOperation(((String) value));
                }
            }
            if( values.containsKey("OrderSuboperation") ) {
                final Object value = values.remove("OrderSuboperation");
                if( (value == null) || (!value.equals(getOrderSuboperation())) ) {
                    setOrderSuboperation(((String) value));
                }
            }
            if( values.containsKey("OrderType") ) {
                final Object value = values.remove("OrderType");
                if( (value == null) || (!value.equals(getOrderType())) ) {
                    setOrderType(((String) value));
                }
            }
            if( values.containsKey("OrderOperationInternalID") ) {
                final Object value = values.remove("OrderOperationInternalID");
                if( (value == null) || (!value.equals(getOrderOperationInternalID())) ) {
                    setOrderOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("ConfirmationText") ) {
                final Object value = values.remove("ConfirmationText");
                if( (value == null) || (!value.equals(getConfirmationText())) ) {
                    setConfirmationText(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("OrderPlannedTotalQty") ) {
                final Object value = values.remove("OrderPlannedTotalQty");
                if( (value == null) || (!value.equals(getOrderPlannedTotalQty())) ) {
                    setOrderPlannedTotalQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductionUnit") ) {
                final Object value = values.remove("ProductionUnit");
                if( (value == null) || (!value.equals(getProductionUnit())) ) {
                    setProductionUnit(((String) value));
                }
            }
            if( values.containsKey("FinalConfirmationType") ) {
                final Object value = values.remove("FinalConfirmationType");
                if( (value == null) || (!value.equals(getFinalConfirmationType())) ) {
                    setFinalConfirmationType(((String) value));
                }
            }
            if( values.containsKey("IsFinalConfirmation") ) {
                final Object value = values.remove("IsFinalConfirmation");
                if( (value == null) || (!value.equals(getIsFinalConfirmation())) ) {
                    setIsFinalConfirmation(((Boolean) value));
                }
            }
            if( values.containsKey("OpenReservationsIsCleared") ) {
                final Object value = values.remove("OpenReservationsIsCleared");
                if( (value == null) || (!value.equals(getOpenReservationsIsCleared())) ) {
                    setOpenReservationsIsCleared(((Boolean) value));
                }
            }
            if( values.containsKey("IsReversed") ) {
                final Object value = values.remove("IsReversed");
                if( (value == null) || (!value.equals(getIsReversed())) ) {
                    setIsReversed(((Boolean) value));
                }
            }
            if( values.containsKey("IsReversal") ) {
                final Object value = values.remove("IsReversal");
                if( (value == null) || (!value.equals(getIsReversal())) ) {
                    setIsReversal(((Boolean) value));
                }
            }
            if( values.containsKey("APIConfHasNoGoodsMovements") ) {
                final Object value = values.remove("APIConfHasNoGoodsMovements");
                if( (value == null) || (!value.equals(getAPIConfHasNoGoodsMovements())) ) {
                    setAPIConfHasNoGoodsMovements(((Boolean) value));
                }
            }
            if( values.containsKey("OrderConfirmationRecordType") ) {
                final Object value = values.remove("OrderConfirmationRecordType");
                if( (value == null) || (!value.equals(getOrderConfirmationRecordType())) ) {
                    setOrderConfirmationRecordType(((String) value));
                }
            }
            if( values.containsKey("ConfirmationEntryDate") ) {
                final Object value = values.remove("ConfirmationEntryDate");
                if( (value == null) || (!value.equals(getConfirmationEntryDate())) ) {
                    setConfirmationEntryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmationEntryTime") ) {
                final Object value = values.remove("ConfirmationEntryTime");
                if( (value == null) || (!value.equals(getConfirmationEntryTime())) ) {
                    setConfirmationEntryTime(((LocalTime) value));
                }
            }
            if( values.containsKey("EnteredByUser") ) {
                final Object value = values.remove("EnteredByUser");
                if( (value == null) || (!value.equals(getEnteredByUser())) ) {
                    setEnteredByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ConfirmationExternalEntryDate") ) {
                final Object value = values.remove("ConfirmationExternalEntryDate");
                if( (value == null) || (!value.equals(getConfirmationExternalEntryDate())) ) {
                    setConfirmationExternalEntryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmationExternalEntryTime") ) {
                final Object value = values.remove("ConfirmationExternalEntryTime");
                if( (value == null) || (!value.equals(getConfirmationExternalEntryTime())) ) {
                    setConfirmationExternalEntryTime(((LocalTime) value));
                }
            }
            if( values.containsKey("EnteredByExternalUser") ) {
                final Object value = values.remove("EnteredByExternalUser");
                if( (value == null) || (!value.equals(getEnteredByExternalUser())) ) {
                    setEnteredByExternalUser(((String) value));
                }
            }
            if( values.containsKey("ExternalSystemConfirmation") ) {
                final Object value = values.remove("ExternalSystemConfirmation");
                if( (value == null) || (!value.equals(getExternalSystemConfirmation())) ) {
                    setExternalSystemConfirmation(((UUID) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("ShiftGrouping") ) {
                final Object value = values.remove("ShiftGrouping");
                if( (value == null) || (!value.equals(getShiftGrouping())) ) {
                    setShiftGrouping(((String) value));
                }
            }
            if( values.containsKey("ShiftDefinition") ) {
                final Object value = values.remove("ShiftDefinition");
                if( (value == null) || (!value.equals(getShiftDefinition())) ) {
                    setShiftDefinition(((String) value));
                }
            }
            if( values.containsKey("Personnel") ) {
                final Object value = values.remove("Personnel");
                if( (value == null) || (!value.equals(getPersonnel())) ) {
                    setPersonnel(((String) value));
                }
            }
            if( values.containsKey("TimeRecording") ) {
                final Object value = values.remove("TimeRecording");
                if( (value == null) || (!value.equals(getTimeRecording())) ) {
                    setTimeRecording(((String) value));
                }
            }
            if( values.containsKey("EmployeeWageType") ) {
                final Object value = values.remove("EmployeeWageType");
                if( (value == null) || (!value.equals(getEmployeeWageType())) ) {
                    setEmployeeWageType(((String) value));
                }
            }
            if( values.containsKey("EmployeeWageGroup") ) {
                final Object value = values.remove("EmployeeWageGroup");
                if( (value == null) || (!value.equals(getEmployeeWageGroup())) ) {
                    setEmployeeWageGroup(((String) value));
                }
            }
            if( values.containsKey("BreakDurationUnit") ) {
                final Object value = values.remove("BreakDurationUnit");
                if( (value == null) || (!value.equals(getBreakDurationUnit())) ) {
                    setBreakDurationUnit(((String) value));
                }
            }
            if( values.containsKey("BreakDurationUnitISOCode") ) {
                final Object value = values.remove("BreakDurationUnitISOCode");
                if( (value == null) || (!value.equals(getBreakDurationUnitISOCode())) ) {
                    setBreakDurationUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("BreakDurationUnitSAPCode") ) {
                final Object value = values.remove("BreakDurationUnitSAPCode");
                if( (value == null) || (!value.equals(getBreakDurationUnitSAPCode())) ) {
                    setBreakDurationUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("ConfirmedBreakDuration") ) {
                final Object value = values.remove("ConfirmedBreakDuration");
                if( (value == null) || (!value.equals(getConfirmedBreakDuration())) ) {
                    setConfirmedBreakDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("EmployeeSuitability") ) {
                final Object value = values.remove("EmployeeSuitability");
                if( (value == null) || (!value.equals(getEmployeeSuitability())) ) {
                    setEmployeeSuitability(((String) value));
                }
            }
            if( values.containsKey("NumberOfEmployees") ) {
                final Object value = values.remove("NumberOfEmployees");
                if( (value == null) || (!value.equals(getNumberOfEmployees())) ) {
                    setNumberOfEmployees(((BigDecimal) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedExecutionStartDate") ) {
                final Object value = values.remove("ConfirmedExecutionStartDate");
                if( (value == null) || (!value.equals(getConfirmedExecutionStartDate())) ) {
                    setConfirmedExecutionStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedExecutionStartTime") ) {
                final Object value = values.remove("ConfirmedExecutionStartTime");
                if( (value == null) || (!value.equals(getConfirmedExecutionStartTime())) ) {
                    setConfirmedExecutionStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ConfirmedSetupEndDate") ) {
                final Object value = values.remove("ConfirmedSetupEndDate");
                if( (value == null) || (!value.equals(getConfirmedSetupEndDate())) ) {
                    setConfirmedSetupEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedSetupEndTime") ) {
                final Object value = values.remove("ConfirmedSetupEndTime");
                if( (value == null) || (!value.equals(getConfirmedSetupEndTime())) ) {
                    setConfirmedSetupEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ConfirmedProcessingStartDate") ) {
                final Object value = values.remove("ConfirmedProcessingStartDate");
                if( (value == null) || (!value.equals(getConfirmedProcessingStartDate())) ) {
                    setConfirmedProcessingStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedProcessingStartTime") ) {
                final Object value = values.remove("ConfirmedProcessingStartTime");
                if( (value == null) || (!value.equals(getConfirmedProcessingStartTime())) ) {
                    setConfirmedProcessingStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ConfirmedProcessingEndDate") ) {
                final Object value = values.remove("ConfirmedProcessingEndDate");
                if( (value == null) || (!value.equals(getConfirmedProcessingEndDate())) ) {
                    setConfirmedProcessingEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedProcessingEndTime") ) {
                final Object value = values.remove("ConfirmedProcessingEndTime");
                if( (value == null) || (!value.equals(getConfirmedProcessingEndTime())) ) {
                    setConfirmedProcessingEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ConfirmedTeardownStartDate") ) {
                final Object value = values.remove("ConfirmedTeardownStartDate");
                if( (value == null) || (!value.equals(getConfirmedTeardownStartDate())) ) {
                    setConfirmedTeardownStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedTeardownStartTime") ) {
                final Object value = values.remove("ConfirmedTeardownStartTime");
                if( (value == null) || (!value.equals(getConfirmedTeardownStartTime())) ) {
                    setConfirmedTeardownStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ConfirmedExecutionEndDate") ) {
                final Object value = values.remove("ConfirmedExecutionEndDate");
                if( (value == null) || (!value.equals(getConfirmedExecutionEndDate())) ) {
                    setConfirmedExecutionEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedExecutionEndTime") ) {
                final Object value = values.remove("ConfirmedExecutionEndTime");
                if( (value == null) || (!value.equals(getConfirmedExecutionEndTime())) ) {
                    setConfirmedExecutionEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ConfirmationUnit") ) {
                final Object value = values.remove("ConfirmationUnit");
                if( (value == null) || (!value.equals(getConfirmationUnit())) ) {
                    setConfirmationUnit(((String) value));
                }
            }
            if( values.containsKey("ConfirmationUnitISOCode") ) {
                final Object value = values.remove("ConfirmationUnitISOCode");
                if( (value == null) || (!value.equals(getConfirmationUnitISOCode())) ) {
                    setConfirmationUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("ConfirmationUnitSAPCode") ) {
                final Object value = values.remove("ConfirmationUnitSAPCode");
                if( (value == null) || (!value.equals(getConfirmationUnitSAPCode())) ) {
                    setConfirmationUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("ConfirmationYieldQuantity") ) {
                final Object value = values.remove("ConfirmationYieldQuantity");
                if( (value == null) || (!value.equals(getConfirmationYieldQuantity())) ) {
                    setConfirmationYieldQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConfirmationScrapQuantity") ) {
                final Object value = values.remove("ConfirmationScrapQuantity");
                if( (value == null) || (!value.equals(getConfirmationScrapQuantity())) ) {
                    setConfirmationScrapQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("VarianceReasonCode") ) {
                final Object value = values.remove("VarianceReasonCode");
                if( (value == null) || (!value.equals(getVarianceReasonCode())) ) {
                    setVarianceReasonCode(((String) value));
                }
            }
            if( values.containsKey("OpWorkQuantityUnit1") ) {
                final Object value = values.remove("OpWorkQuantityUnit1");
                if( (value == null) || (!value.equals(getOpWorkQuantityUnit1())) ) {
                    setOpWorkQuantityUnit1(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit1ISOCode") ) {
                final Object value = values.remove("WorkQuantityUnit1ISOCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit1ISOCode())) ) {
                    setWorkQuantityUnit1ISOCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit1SAPCode") ) {
                final Object value = values.remove("WorkQuantityUnit1SAPCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit1SAPCode())) ) {
                    setWorkQuantityUnit1SAPCode(((String) value));
                }
            }
            if( values.containsKey("OpConfirmedWorkQuantity1") ) {
                final Object value = values.remove("OpConfirmedWorkQuantity1");
                if( (value == null) || (!value.equals(getOpConfirmedWorkQuantity1())) ) {
                    setOpConfirmedWorkQuantity1(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoFurtherOpWorkQuantity1IsExpd") ) {
                final Object value = values.remove("NoFurtherOpWorkQuantity1IsExpd");
                if( (value == null) || (!value.equals(getNoFurtherOpWorkQuantity1IsExpd())) ) {
                    setNoFurtherOpWorkQuantity1IsExpd(((Boolean) value));
                }
            }
            if( values.containsKey("OpWorkQuantityUnit2") ) {
                final Object value = values.remove("OpWorkQuantityUnit2");
                if( (value == null) || (!value.equals(getOpWorkQuantityUnit2())) ) {
                    setOpWorkQuantityUnit2(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit2ISOCode") ) {
                final Object value = values.remove("WorkQuantityUnit2ISOCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit2ISOCode())) ) {
                    setWorkQuantityUnit2ISOCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit2SAPCode") ) {
                final Object value = values.remove("WorkQuantityUnit2SAPCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit2SAPCode())) ) {
                    setWorkQuantityUnit2SAPCode(((String) value));
                }
            }
            if( values.containsKey("OpConfirmedWorkQuantity2") ) {
                final Object value = values.remove("OpConfirmedWorkQuantity2");
                if( (value == null) || (!value.equals(getOpConfirmedWorkQuantity2())) ) {
                    setOpConfirmedWorkQuantity2(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoFurtherOpWorkQuantity2IsExpd") ) {
                final Object value = values.remove("NoFurtherOpWorkQuantity2IsExpd");
                if( (value == null) || (!value.equals(getNoFurtherOpWorkQuantity2IsExpd())) ) {
                    setNoFurtherOpWorkQuantity2IsExpd(((Boolean) value));
                }
            }
            if( values.containsKey("OpWorkQuantityUnit3") ) {
                final Object value = values.remove("OpWorkQuantityUnit3");
                if( (value == null) || (!value.equals(getOpWorkQuantityUnit3())) ) {
                    setOpWorkQuantityUnit3(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit3ISOCode") ) {
                final Object value = values.remove("WorkQuantityUnit3ISOCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit3ISOCode())) ) {
                    setWorkQuantityUnit3ISOCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit3SAPCode") ) {
                final Object value = values.remove("WorkQuantityUnit3SAPCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit3SAPCode())) ) {
                    setWorkQuantityUnit3SAPCode(((String) value));
                }
            }
            if( values.containsKey("OpConfirmedWorkQuantity3") ) {
                final Object value = values.remove("OpConfirmedWorkQuantity3");
                if( (value == null) || (!value.equals(getOpConfirmedWorkQuantity3())) ) {
                    setOpConfirmedWorkQuantity3(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoFurtherOpWorkQuantity3IsExpd") ) {
                final Object value = values.remove("NoFurtherOpWorkQuantity3IsExpd");
                if( (value == null) || (!value.equals(getNoFurtherOpWorkQuantity3IsExpd())) ) {
                    setNoFurtherOpWorkQuantity3IsExpd(((Boolean) value));
                }
            }
            if( values.containsKey("OpWorkQuantityUnit4") ) {
                final Object value = values.remove("OpWorkQuantityUnit4");
                if( (value == null) || (!value.equals(getOpWorkQuantityUnit4())) ) {
                    setOpWorkQuantityUnit4(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit4ISOCode") ) {
                final Object value = values.remove("WorkQuantityUnit4ISOCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit4ISOCode())) ) {
                    setWorkQuantityUnit4ISOCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit4SAPCode") ) {
                final Object value = values.remove("WorkQuantityUnit4SAPCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit4SAPCode())) ) {
                    setWorkQuantityUnit4SAPCode(((String) value));
                }
            }
            if( values.containsKey("OpConfirmedWorkQuantity4") ) {
                final Object value = values.remove("OpConfirmedWorkQuantity4");
                if( (value == null) || (!value.equals(getOpConfirmedWorkQuantity4())) ) {
                    setOpConfirmedWorkQuantity4(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoFurtherOpWorkQuantity4IsExpd") ) {
                final Object value = values.remove("NoFurtherOpWorkQuantity4IsExpd");
                if( (value == null) || (!value.equals(getNoFurtherOpWorkQuantity4IsExpd())) ) {
                    setNoFurtherOpWorkQuantity4IsExpd(((Boolean) value));
                }
            }
            if( values.containsKey("OpWorkQuantityUnit5") ) {
                final Object value = values.remove("OpWorkQuantityUnit5");
                if( (value == null) || (!value.equals(getOpWorkQuantityUnit5())) ) {
                    setOpWorkQuantityUnit5(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit5ISOCode") ) {
                final Object value = values.remove("WorkQuantityUnit5ISOCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit5ISOCode())) ) {
                    setWorkQuantityUnit5ISOCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit5SAPCode") ) {
                final Object value = values.remove("WorkQuantityUnit5SAPCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit5SAPCode())) ) {
                    setWorkQuantityUnit5SAPCode(((String) value));
                }
            }
            if( values.containsKey("OpConfirmedWorkQuantity5") ) {
                final Object value = values.remove("OpConfirmedWorkQuantity5");
                if( (value == null) || (!value.equals(getOpConfirmedWorkQuantity5())) ) {
                    setOpConfirmedWorkQuantity5(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoFurtherOpWorkQuantity5IsExpd") ) {
                final Object value = values.remove("NoFurtherOpWorkQuantity5IsExpd");
                if( (value == null) || (!value.equals(getNoFurtherOpWorkQuantity5IsExpd())) ) {
                    setNoFurtherOpWorkQuantity5IsExpd(((Boolean) value));
                }
            }
            if( values.containsKey("OpWorkQuantityUnit6") ) {
                final Object value = values.remove("OpWorkQuantityUnit6");
                if( (value == null) || (!value.equals(getOpWorkQuantityUnit6())) ) {
                    setOpWorkQuantityUnit6(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit6ISOCode") ) {
                final Object value = values.remove("WorkQuantityUnit6ISOCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit6ISOCode())) ) {
                    setWorkQuantityUnit6ISOCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit6SAPCode") ) {
                final Object value = values.remove("WorkQuantityUnit6SAPCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit6SAPCode())) ) {
                    setWorkQuantityUnit6SAPCode(((String) value));
                }
            }
            if( values.containsKey("OpConfirmedWorkQuantity6") ) {
                final Object value = values.remove("OpConfirmedWorkQuantity6");
                if( (value == null) || (!value.equals(getOpConfirmedWorkQuantity6())) ) {
                    setOpConfirmedWorkQuantity6(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoFurtherOpWorkQuantity6IsExpd") ) {
                final Object value = values.remove("NoFurtherOpWorkQuantity6IsExpd");
                if( (value == null) || (!value.equals(getNoFurtherOpWorkQuantity6IsExpd())) ) {
                    setNoFurtherOpWorkQuantity6IsExpd(((Boolean) value));
                }
            }
            if( values.containsKey("BusinessProcessEntryUnit") ) {
                final Object value = values.remove("BusinessProcessEntryUnit");
                if( (value == null) || (!value.equals(getBusinessProcessEntryUnit())) ) {
                    setBusinessProcessEntryUnit(((String) value));
                }
            }
            if( values.containsKey("BusProcessEntrUnitISOCode") ) {
                final Object value = values.remove("BusProcessEntrUnitISOCode");
                if( (value == null) || (!value.equals(getBusProcessEntrUnitISOCode())) ) {
                    setBusProcessEntrUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("BusProcessEntryUnitSAPCode") ) {
                final Object value = values.remove("BusProcessEntryUnitSAPCode");
                if( (value == null) || (!value.equals(getBusProcessEntryUnitSAPCode())) ) {
                    setBusProcessEntryUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("BusinessProcessConfirmedQty") ) {
                final Object value = values.remove("BusinessProcessConfirmedQty");
                if( (value == null) || (!value.equals(getBusinessProcessConfirmedQty())) ) {
                    setBusinessProcessConfirmedQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoFurtherBusinessProcQtyIsExpd") ) {
                final Object value = values.remove("NoFurtherBusinessProcQtyIsExpd");
                if( (value == null) || (!value.equals(getNoFurtherBusinessProcQtyIsExpd())) ) {
                    setNoFurtherBusinessProcQtyIsExpd(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProcOrdConfMatlDocItm") ) {
                final Object value = (values).remove("to_ProcOrdConfMatlDocItm");
                if( value instanceof Iterable ) {
                    if( toProcOrdConfMatlDocItm == null ) {
                        toProcOrdConfMatlDocItm = Lists.newArrayList();
                    } else {
                        toProcOrdConfMatlDocItm = Lists.newArrayList(toProcOrdConfMatlDocItm);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProcOrdConfMatlDocItm entity;
                        if( toProcOrdConfMatlDocItm.size() > i ) {
                            entity = toProcOrdConfMatlDocItm.get(i);
                        } else {
                            entity = new ProcOrdConfMatlDocItm();
                            toProcOrdConfMatlDocItm.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProcOrdConf2Field<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProcOrdConf2Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProcOrdConf2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProcOrdConf2Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderConfirmationV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProcOrdConfMatlDocItm != null ) {
            (values).put("to_ProcOrdConfMatlDocItm", toProcOrdConfMatlDocItm);
        }
        return values;
    }

    /**
     * Fetches the <b>ProcOrdConfMatlDocItm</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProcOrdConfMatlDocItm</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProcOrdConfMatlDocItm</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProcOrdConfMatlDocItm> fetchProcOrdConfMatlDocItm()
    {
        return fetchFieldAsList("to_ProcOrdConfMatlDocItm", ProcOrdConfMatlDocItm.class);
    }

    /**
     * Retrieval of associated <b>ProcOrdConfMatlDocItm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProcOrdConfMatlDocItm</b>.
     * <p>
     * If the navigation property <b>to_ProcOrdConfMatlDocItm</b> of a queried <b>ProcOrdConf2</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProcOrdConfMatlDocItm</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProcOrdConfMatlDocItm> getProcOrdConfMatlDocItmOrFetch()
    {
        if( toProcOrdConfMatlDocItm == null ) {
            toProcOrdConfMatlDocItm = fetchProcOrdConfMatlDocItm();
        }
        return toProcOrdConfMatlDocItm;
    }

    /**
     * Retrieval of associated <b>ProcOrdConfMatlDocItm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProcOrdConfMatlDocItm</b>.
     * <p>
     * If the navigation property for an entity <b>ProcOrdConf2</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProcOrdConfMatlDocItm</b> is already loaded, the result
     *         will contain the <b>ProcOrdConfMatlDocItm</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProcOrdConfMatlDocItm>> getProcOrdConfMatlDocItmIfPresent()
    {
        return Option.of(toProcOrdConfMatlDocItm);
    }

    /**
     * Overwrites the list of associated <b>ProcOrdConfMatlDocItm</b> entities for the loaded navigation property
     * <b>to_ProcOrdConfMatlDocItm</b>.
     * <p>
     * If the navigation property <b>to_ProcOrdConfMatlDocItm</b> of a queried <b>ProcOrdConf2</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProcOrdConfMatlDocItm</b> entities.
     */
    public void setProcOrdConfMatlDocItm( @Nonnull final List<ProcOrdConfMatlDocItm> value )
    {
        if( toProcOrdConfMatlDocItm == null ) {
            toProcOrdConfMatlDocItm = Lists.newArrayList();
        }
        toProcOrdConfMatlDocItm.clear();
        toProcOrdConfMatlDocItm.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProcOrdConfMatlDocItm</b> entities. This corresponds to the OData
     * navigation property <b>to_ProcOrdConfMatlDocItm</b>.
     * <p>
     * If the navigation property <b>to_ProcOrdConfMatlDocItm</b> of a queried <b>ProcOrdConf2</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProcOrdConfMatlDocItm</b> entities.
     */
    public void addProcOrdConfMatlDocItm( ProcOrdConfMatlDocItm... entity )
    {
        if( toProcOrdConfMatlDocItm == null ) {
            toProcOrdConfMatlDocItm = Lists.newArrayList();
        }
        toProcOrdConfMatlDocItm.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProcOrdConf2 instances.
     *
     */
    public final static class ProcOrdConf2Builder
    {

        private List<ProcOrdConfMatlDocItm> toProcOrdConfMatlDocItm = Lists.newArrayList();

        private ProcOrdConf2.ProcOrdConf2Builder toProcOrdConfMatlDocItm( final List<ProcOrdConfMatlDocItm> value )
        {
            toProcOrdConfMatlDocItm.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProcOrdConfMatlDocItm</b> for <b>ProcOrdConf2</b> to multiple
         * <b>ProcOrdConfMatlDocItm</b>.
         *
         * @param value
         *            The ProcOrdConfMatlDocItms to build this ProcOrdConf2 with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProcOrdConf2.ProcOrdConf2Builder procOrdConfMatlDocItm( ProcOrdConfMatlDocItm... value )
        {
            return toProcOrdConfMatlDocItm(Lists.newArrayList(value));
        }

    }

}
