/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.selectable.ProcOrdConf2Selectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2 ProcOrdConf2}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class ProcOrdConf2ByKeyFluentHelper
    extends
    FluentHelperByKey<ProcOrdConf2ByKeyFluentHelper, ProcOrdConf2, ProcOrdConf2Selectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2 ProcOrdConf2}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProcOrdConf2}
     * @param confirmationCount
     *            Identifier of Single Order Confirmation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProcOrdConf2}
     * @param confirmationGroup
     *            Collective ID of Order Confirmations
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public ProcOrdConf2ByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String confirmationGroup,
        final String confirmationCount )
    {
        super(servicePath, entityCollection);
        this.key.put("ConfirmationGroup", confirmationGroup);
        this.key.put("ConfirmationCount", confirmationCount);
    }

    @Override
    @Nonnull
    protected Class<ProcOrdConf2> getEntityClass()
    {
        return ProcOrdConf2.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
