/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.selectable.ProcOrderConfBatchCharcSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc
 * ProcOrderConfBatchCharc} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class ProcOrderConfBatchCharcByKeyFluentHelper
    extends
    FluentHelperByKey<ProcOrderConfBatchCharcByKeyFluentHelper, ProcOrderConfBatchCharc, ProcOrderConfBatchCharcSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc
     * ProcOrderConfBatchCharc} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param materialDocument
     *            Number of Material Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProcOrderConfBatchCharc}
     * @param confirmationCount
     *            Identifier of Single Order Confirmation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param materialDocumentItem
     *            Material Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProcOrderConfBatchCharc}
     * @param plant
     *            Plant of a Batch
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param materialDocumentYear
     *            Material Document Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param batch
     *            Batch Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param confirmationGroup
     *            Collective ID of Order Confirmations
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public ProcOrderConfBatchCharcByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String confirmationGroup,
        final String confirmationCount,
        final String materialDocument,
        final String materialDocumentItem,
        final String materialDocumentYear,
        final String plant,
        final String material,
        final String batch,
        final String charcInternalID )
    {
        super(servicePath, entityCollection);
        this.key.put("ConfirmationGroup", confirmationGroup);
        this.key.put("ConfirmationCount", confirmationCount);
        this.key.put("MaterialDocument", materialDocument);
        this.key.put("MaterialDocumentItem", materialDocumentItem);
        this.key.put("MaterialDocumentYear", materialDocumentYear);
        this.key.put("Plant", plant);
        this.key.put("Material", material);
        this.key.put("Batch", batch);
        this.key.put("CharcInternalID", charcInternalID);
    }

    @Override
    @Nonnull
    protected Class<ProcOrderConfBatchCharc> getEntityClass()
    {
        return ProcOrderConfBatchCharc.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
