/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ProcessOrderConfirmationV2ServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderConfirmationV2Service
 * ProcessOrderConfirmationV2Service}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultProcessOrderConfirmationV2ServiceBatch
    extends
    BatchFluentHelperBasic<ProcessOrderConfirmationV2ServiceBatch, ProcessOrderConfirmationV2ServiceBatchChangeSet>
    implements
    ProcessOrderConfirmationV2ServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderConfirmationV2Service service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultProcessOrderConfirmationV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProcessOrderConfirmationV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderConfirmationV2Service service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderConfirmationV2Service.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultProcessOrderConfirmationV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProcessOrderConfirmationV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderConfirmationV2Service service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultProcessOrderConfirmationV2ServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProcessOrderConfirmationV2ServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultProcessOrderConfirmationV2ServiceBatchChangeSet(this, service);
    }

}
