/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItm;

/**
 * Implementation of the {@link ProcessOrderConfirmationV2ServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderConfirmationV2Service
 * ProcessOrderConfirmationV2Service}.
 *
 */
public class DefaultProcessOrderConfirmationV2ServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProcessOrderConfirmationV2ServiceBatch, ProcessOrderConfirmationV2ServiceBatchChangeSet>
    implements
    ProcessOrderConfirmationV2ServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderConfirmationV2Service service;

    @SuppressWarnings( "deprecation" )
    DefaultProcessOrderConfirmationV2ServiceBatchChangeSet(
        @Nonnull final DefaultProcessOrderConfirmationV2ServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderConfirmationV2Service service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProcessOrderConfirmationV2ServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProcessOrderConfirmationV2ServiceBatchChangeSet createProcOrdConf2(
        @Nonnull final ProcOrdConf2 procOrdConf2 )
    {
        return addRequestCreate(service::createProcOrdConf2, procOrdConf2);
    }

    @Nonnull
    @Override
    public ProcessOrderConfirmationV2ServiceBatchChangeSet createProcOrdConfMatlDocItm(
        @Nonnull final ProcOrdConfMatlDocItm procOrdConfMatlDocItm )
    {
        return addRequestCreate(service::createProcOrdConfMatlDocItm, procOrdConfMatlDocItm);
    }

}
