/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItm;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderConfirmationV2Service
 * ProcessOrderConfirmationV2Service}.
 *
 */
public interface ProcessOrderConfirmationV2ServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ProcessOrderConfirmationV2ServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ProcessOrderConfirmationV2ServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2
     * ProcOrdConf2} entity and save it to the S/4HANA system.
     *
     * @param procOrdConf2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2
     *            ProcOrdConf2} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProcessOrderConfirmationV2ServiceBatchChangeSet createProcOrdConf2( @Nonnull final ProcOrdConf2 procOrdConf2 );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItm
     * ProcOrdConfMatlDocItm} entity and save it to the S/4HANA system.
     *
     * @param procOrdConfMatlDocItm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItm
     *            ProcOrdConfMatlDocItm} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProcessOrderConfirmationV2ServiceBatchChangeSet
        createProcOrdConfMatlDocItm( @Nonnull final ProcOrdConfMatlDocItm procOrdConfMatlDocItm );

}
