/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2 ProcOrdConf2}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.field.ProcOrdConf2Field
 * ProcOrdConf2Field} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.link.ProcOrdConf2Link
 * ProcOrdConf2Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMATION_GROUP
 * CONFIRMATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMATION_COUNT
 * CONFIRMATION_COUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#ORDER_OPERATION
 * ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#ORDER_SUBOPERATION
 * ORDER_SUBOPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#ORDER_TYPE
 * ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#ORDER_OPERATION_INTERNAL_ID
 * ORDER_OPERATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMATION_TEXT
 * CONFIRMATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#ORDER_PLANNED_TOTAL_QTY
 * ORDER_PLANNED_TOTAL_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#PRODUCTION_UNIT
 * PRODUCTION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#FINAL_CONFIRMATION_TYPE
 * FINAL_CONFIRMATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#IS_FINAL_CONFIRMATION
 * IS_FINAL_CONFIRMATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#OPEN_RESERVATIONS_IS_CLEARED
 * OPEN_RESERVATIONS_IS_CLEARED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#IS_REVERSED
 * IS_REVERSED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#IS_REVERSAL
 * IS_REVERSAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#API_CONF_HAS_NO_GOODS_MOVEMENTS
 * API_CONF_HAS_NO_GOODS_MOVEMENTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#ORDER_CONFIRMATION_RECORD_TYPE
 * ORDER_CONFIRMATION_RECORD_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMATION_ENTRY_DATE
 * CONFIRMATION_ENTRY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMATION_ENTRY_TIME
 * CONFIRMATION_ENTRY_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#ENTERED_BY_USER
 * ENTERED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMATION_EXTERNAL_ENTRY_DATE
 * CONFIRMATION_EXTERNAL_ENTRY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMATION_EXTERNAL_ENTRY_TIME
 * CONFIRMATION_EXTERNAL_ENTRY_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#ENTERED_BY_EXTERNAL_USER
 * ENTERED_BY_EXTERNAL_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#EXTERNAL_SYSTEM_CONFIRMATION
 * EXTERNAL_SYSTEM_CONFIRMATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#WORK_CENTER_TYPE_CODE
 * WORK_CENTER_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#SHIFT_GROUPING
 * SHIFT_GROUPING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#SHIFT_DEFINITION
 * SHIFT_DEFINITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#TIME_RECORDING
 * TIME_RECORDING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#EMPLOYEE_WAGE_TYPE
 * EMPLOYEE_WAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#EMPLOYEE_WAGE_GROUP
 * EMPLOYEE_WAGE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#BREAK_DURATION_UNIT
 * BREAK_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#BREAK_DURATION_UNIT_ISO_CODE
 * BREAK_DURATION_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#BREAK_DURATION_UNIT_SAP_CODE
 * BREAK_DURATION_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMED_BREAK_DURATION
 * CONFIRMED_BREAK_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#EMPLOYEE_SUITABILITY
 * EMPLOYEE_SUITABILITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#NUMBER_OF_EMPLOYEES
 * NUMBER_OF_EMPLOYEES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMED_EXECUTION_START_DATE
 * CONFIRMED_EXECUTION_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMED_EXECUTION_START_TIME
 * CONFIRMED_EXECUTION_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMED_SETUP_END_DATE
 * CONFIRMED_SETUP_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMED_SETUP_END_TIME
 * CONFIRMED_SETUP_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMED_PROCESSING_START_DATE
 * CONFIRMED_PROCESSING_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMED_PROCESSING_START_TIME
 * CONFIRMED_PROCESSING_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMED_PROCESSING_END_DATE
 * CONFIRMED_PROCESSING_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMED_PROCESSING_END_TIME
 * CONFIRMED_PROCESSING_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMED_TEARDOWN_START_DATE
 * CONFIRMED_TEARDOWN_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMED_TEARDOWN_START_TIME
 * CONFIRMED_TEARDOWN_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMED_EXECUTION_END_DATE
 * CONFIRMED_EXECUTION_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMED_EXECUTION_END_TIME
 * CONFIRMED_EXECUTION_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMATION_UNIT
 * CONFIRMATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMATION_UNIT_ISO_CODE
 * CONFIRMATION_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMATION_UNIT_SAP_CODE
 * CONFIRMATION_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMATION_YIELD_QUANTITY
 * CONFIRMATION_YIELD_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#CONFIRMATION_SCRAP_QUANTITY
 * CONFIRMATION_SCRAP_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#VARIANCE_REASON_CODE
 * VARIANCE_REASON_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#OP_WORK_QUANTITY_UNIT1
 * OP_WORK_QUANTITY_UNIT1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#WORK_QUANTITY_UNIT1_I_S_O_CODE
 * WORK_QUANTITY_UNIT1_I_S_O_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#WORK_QUANTITY_UNIT1_S_A_P_CODE
 * WORK_QUANTITY_UNIT1_S_A_P_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#OP_CONFIRMED_WORK_QUANTITY1
 * OP_CONFIRMED_WORK_QUANTITY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#NO_FURTHER_OP_WORK_QUANTITY1_IS_EXPD
 * NO_FURTHER_OP_WORK_QUANTITY1_IS_EXPD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#OP_WORK_QUANTITY_UNIT2
 * OP_WORK_QUANTITY_UNIT2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#WORK_QUANTITY_UNIT2_I_S_O_CODE
 * WORK_QUANTITY_UNIT2_I_S_O_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#WORK_QUANTITY_UNIT2_S_A_P_CODE
 * WORK_QUANTITY_UNIT2_S_A_P_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#OP_CONFIRMED_WORK_QUANTITY2
 * OP_CONFIRMED_WORK_QUANTITY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#NO_FURTHER_OP_WORK_QUANTITY2_IS_EXPD
 * NO_FURTHER_OP_WORK_QUANTITY2_IS_EXPD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#OP_WORK_QUANTITY_UNIT3
 * OP_WORK_QUANTITY_UNIT3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#WORK_QUANTITY_UNIT3_I_S_O_CODE
 * WORK_QUANTITY_UNIT3_I_S_O_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#WORK_QUANTITY_UNIT3_S_A_P_CODE
 * WORK_QUANTITY_UNIT3_S_A_P_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#OP_CONFIRMED_WORK_QUANTITY3
 * OP_CONFIRMED_WORK_QUANTITY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#NO_FURTHER_OP_WORK_QUANTITY3_IS_EXPD
 * NO_FURTHER_OP_WORK_QUANTITY3_IS_EXPD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#OP_WORK_QUANTITY_UNIT4
 * OP_WORK_QUANTITY_UNIT4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#WORK_QUANTITY_UNIT4_I_S_O_CODE
 * WORK_QUANTITY_UNIT4_I_S_O_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#WORK_QUANTITY_UNIT4_S_A_P_CODE
 * WORK_QUANTITY_UNIT4_S_A_P_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#OP_CONFIRMED_WORK_QUANTITY4
 * OP_CONFIRMED_WORK_QUANTITY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#NO_FURTHER_OP_WORK_QUANTITY4_IS_EXPD
 * NO_FURTHER_OP_WORK_QUANTITY4_IS_EXPD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#OP_WORK_QUANTITY_UNIT5
 * OP_WORK_QUANTITY_UNIT5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#WORK_QUANTITY_UNIT5_I_S_O_CODE
 * WORK_QUANTITY_UNIT5_I_S_O_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#WORK_QUANTITY_UNIT5_S_A_P_CODE
 * WORK_QUANTITY_UNIT5_S_A_P_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#OP_CONFIRMED_WORK_QUANTITY5
 * OP_CONFIRMED_WORK_QUANTITY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#NO_FURTHER_OP_WORK_QUANTITY5_IS_EXPD
 * NO_FURTHER_OP_WORK_QUANTITY5_IS_EXPD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#OP_WORK_QUANTITY_UNIT6
 * OP_WORK_QUANTITY_UNIT6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#WORK_QUANTITY_UNIT6_I_S_O_CODE
 * WORK_QUANTITY_UNIT6_I_S_O_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#WORK_QUANTITY_UNIT6_S_A_P_CODE
 * WORK_QUANTITY_UNIT6_S_A_P_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#OP_CONFIRMED_WORK_QUANTITY6
 * OP_CONFIRMED_WORK_QUANTITY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#NO_FURTHER_OP_WORK_QUANTITY6_IS_EXPD
 * NO_FURTHER_OP_WORK_QUANTITY6_IS_EXPD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#BUSINESS_PROCESS_ENTRY_UNIT
 * BUSINESS_PROCESS_ENTRY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#BUS_PROCESS_ENTR_UNIT_ISO_CODE
 * BUS_PROCESS_ENTR_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#BUS_PROCESS_ENTRY_UNIT_SAP_CODE
 * BUS_PROCESS_ENTRY_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#BUSINESS_PROCESS_CONFIRMED_QTY
 * BUSINESS_PROCESS_CONFIRMED_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#NO_FURTHER_BUSINESS_PROC_QTY_IS_EXPD
 * NO_FURTHER_BUSINESS_PROC_QTY_IS_EXPD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2#TO_PROC_ORD_CONF_MATL_DOC_ITM
 * TO_PROC_ORD_CONF_MATL_DOC_ITM}</li>
 * </ul>
 *
 */
public interface ProcOrdConf2Selectable extends EntitySelectable<ProcOrdConf2>
{

}
