/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc
 * ProcOrderConfBatchCharc}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.field.ProcOrderConfBatchCharcField
 * ProcOrderConfBatchCharcField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.link.ProcOrderConfBatchCharcLink
 * ProcOrderConfBatchCharcLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc#CONFIRMATION_GROUP
 * CONFIRMATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc#CONFIRMATION_COUNT
 * CONFIRMATION_COUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc#MATERIAL_DOCUMENT
 * MATERIAL_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc#MATERIAL_DOCUMENT_ITEM
 * MATERIAL_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc#MATERIAL_DOCUMENT_YEAR
 * MATERIAL_DOCUMENT_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc#BATCH
 * BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc#CHARC_INTERNAL_ID
 * CHARC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc#CHARACTERISTIC
 * CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharc#CHARC_VALUE
 * CHARC_VALUE}</li>
 * </ul>
 *
 */
public interface ProcOrderConfBatchCharcSelectable extends EntitySelectable<ProcOrderConfBatchCharc>
{

}
