/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>FunctionMessage</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FunctionMessage extends VdmComplex<FunctionMessage>
{

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageType</b>
     * </p>
     *
     * @param systemMessageType
     *
     * @return Message Type
     */
    @SerializedName( "SystemMessageType" )
    @JsonProperty( "SystemMessageType" )
    @Nullable
    @ODataField( odataName = "SystemMessageType" )
    private String systemMessageType;
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageIdentification</b>
     * </p>
     *
     * @param systemMessageIdentification
     *
     * @return Message Class
     */
    @SerializedName( "SystemMessageIdentification" )
    @JsonProperty( "SystemMessageIdentification" )
    @Nullable
    @ODataField( odataName = "SystemMessageIdentification" )
    private String systemMessageIdentification;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageNumber</b>
     * </p>
     *
     * @param systemMessageNumber
     *
     * @return Message Number
     */
    @SerializedName( "SystemMessageNumber" )
    @JsonProperty( "SystemMessageNumber" )
    @Nullable
    @ODataField( odataName = "SystemMessageNumber" )
    private String systemMessageNumber;
    /**
     * Constraints: Not nullable, Maximum length: 220
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageLongText</b>
     * </p>
     *
     * @param systemMessageLongText
     *
     * @return Message Text
     */
    @SerializedName( "SystemMessageLongText" )
    @JsonProperty( "SystemMessageLongText" )
    @Nullable
    @ODataField( odataName = "SystemMessageLongText" )
    private String systemMessageLongText;
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageVariable1</b>
     * </p>
     *
     * @param systemMessageVariable1
     *
     * @return Message Variable
     */
    @SerializedName( "SystemMessageVariable1" )
    @JsonProperty( "SystemMessageVariable1" )
    @Nullable
    @ODataField( odataName = "SystemMessageVariable1" )
    private String systemMessageVariable1;
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageVariable2</b>
     * </p>
     *
     * @param systemMessageVariable2
     *
     * @return Message Variable
     */
    @SerializedName( "SystemMessageVariable2" )
    @JsonProperty( "SystemMessageVariable2" )
    @Nullable
    @ODataField( odataName = "SystemMessageVariable2" )
    private String systemMessageVariable2;
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageVariable3</b>
     * </p>
     *
     * @param systemMessageVariable3
     *
     * @return Message Variable
     */
    @SerializedName( "SystemMessageVariable3" )
    @JsonProperty( "SystemMessageVariable3" )
    @Nullable
    @ODataField( odataName = "SystemMessageVariable3" )
    private String systemMessageVariable3;
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageVariable4</b>
     * </p>
     *
     * @param systemMessageVariable4
     *
     * @return Message Variable
     */
    @SerializedName( "SystemMessageVariable4" )
    @JsonProperty( "SystemMessageVariable4" )
    @Nullable
    @ODataField( odataName = "SystemMessageVariable4" )
    private String systemMessageVariable4;

    @Nonnull
    @Override
    public Class<FunctionMessage> getType()
    {
        return FunctionMessage.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SystemMessageType", getSystemMessageType());
        values.put("SystemMessageIdentification", getSystemMessageIdentification());
        values.put("SystemMessageNumber", getSystemMessageNumber());
        values.put("SystemMessageLongText", getSystemMessageLongText());
        values.put("SystemMessageVariable1", getSystemMessageVariable1());
        values.put("SystemMessageVariable2", getSystemMessageVariable2());
        values.put("SystemMessageVariable3", getSystemMessageVariable3());
        values.put("SystemMessageVariable4", getSystemMessageVariable4());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SystemMessageType") ) {
                final Object value = values.remove("SystemMessageType");
                if( (value == null) || (!value.equals(getSystemMessageType())) ) {
                    setSystemMessageType(((String) value));
                }
            }
            if( values.containsKey("SystemMessageIdentification") ) {
                final Object value = values.remove("SystemMessageIdentification");
                if( (value == null) || (!value.equals(getSystemMessageIdentification())) ) {
                    setSystemMessageIdentification(((String) value));
                }
            }
            if( values.containsKey("SystemMessageNumber") ) {
                final Object value = values.remove("SystemMessageNumber");
                if( (value == null) || (!value.equals(getSystemMessageNumber())) ) {
                    setSystemMessageNumber(((String) value));
                }
            }
            if( values.containsKey("SystemMessageLongText") ) {
                final Object value = values.remove("SystemMessageLongText");
                if( (value == null) || (!value.equals(getSystemMessageLongText())) ) {
                    setSystemMessageLongText(((String) value));
                }
            }
            if( values.containsKey("SystemMessageVariable1") ) {
                final Object value = values.remove("SystemMessageVariable1");
                if( (value == null) || (!value.equals(getSystemMessageVariable1())) ) {
                    setSystemMessageVariable1(((String) value));
                }
            }
            if( values.containsKey("SystemMessageVariable2") ) {
                final Object value = values.remove("SystemMessageVariable2");
                if( (value == null) || (!value.equals(getSystemMessageVariable2())) ) {
                    setSystemMessageVariable2(((String) value));
                }
            }
            if( values.containsKey("SystemMessageVariable3") ) {
                final Object value = values.remove("SystemMessageVariable3");
                if( (value == null) || (!value.equals(getSystemMessageVariable3())) ) {
                    setSystemMessageVariable3(((String) value));
                }
            }
            if( values.containsKey("SystemMessageVariable4") ) {
                final Object value = values.remove("SystemMessageVariable4");
                if( (value == null) || (!value.equals(getSystemMessageVariable4())) ) {
                    setSystemMessageVariable4(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageType</b>
     * </p>
     *
     * @param systemMessageType
     *            Message Type
     */
    public void setSystemMessageType( @Nullable final String systemMessageType )
    {
        rememberChangedField("SystemMessageType", this.systemMessageType);
        this.systemMessageType = systemMessageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageIdentification</b>
     * </p>
     *
     * @param systemMessageIdentification
     *            Message Class
     */
    public void setSystemMessageIdentification( @Nullable final String systemMessageIdentification )
    {
        rememberChangedField("SystemMessageIdentification", this.systemMessageIdentification);
        this.systemMessageIdentification = systemMessageIdentification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageNumber</b>
     * </p>
     *
     * @param systemMessageNumber
     *            Message Number
     */
    public void setSystemMessageNumber( @Nullable final String systemMessageNumber )
    {
        rememberChangedField("SystemMessageNumber", this.systemMessageNumber);
        this.systemMessageNumber = systemMessageNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 220
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageLongText</b>
     * </p>
     *
     * @param systemMessageLongText
     *            Message Text
     */
    public void setSystemMessageLongText( @Nullable final String systemMessageLongText )
    {
        rememberChangedField("SystemMessageLongText", this.systemMessageLongText);
        this.systemMessageLongText = systemMessageLongText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageVariable1</b>
     * </p>
     *
     * @param systemMessageVariable1
     *            Message Variable
     */
    public void setSystemMessageVariable1( @Nullable final String systemMessageVariable1 )
    {
        rememberChangedField("SystemMessageVariable1", this.systemMessageVariable1);
        this.systemMessageVariable1 = systemMessageVariable1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageVariable2</b>
     * </p>
     *
     * @param systemMessageVariable2
     *            Message Variable
     */
    public void setSystemMessageVariable2( @Nullable final String systemMessageVariable2 )
    {
        rememberChangedField("SystemMessageVariable2", this.systemMessageVariable2);
        this.systemMessageVariable2 = systemMessageVariable2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageVariable3</b>
     * </p>
     *
     * @param systemMessageVariable3
     *            Message Variable
     */
    public void setSystemMessageVariable3( @Nullable final String systemMessageVariable3 )
    {
        rememberChangedField("SystemMessageVariable3", this.systemMessageVariable3);
        this.systemMessageVariable3 = systemMessageVariable3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>SystemMessageVariable4</b>
     * </p>
     *
     * @param systemMessageVariable4
     *            Message Variable
     */
    public void setSystemMessageVariable4( @Nullable final String systemMessageVariable4 )
    {
        rememberChangedField("SystemMessageVariable4", this.systemMessageVariable4);
        this.systemMessageVariable4 = systemMessageVariable4;
    }

}
