/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.selectable.ProcessOrderItem_2Selectable;

/**
 * Fluent helper to fetch multiple
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderItem_2 ProcessOrderItem_2}
 * entities. This fluent helper allows methods which modify the underlying query to be called before executing the query
 * itself.
 *
 */
public class ProcessOrderItem_2FluentHelper
    extends
    FluentHelperRead<ProcessOrderItem_2FluentHelper, ProcessOrderItem_2, ProcessOrderItem_2Selectable>
{

    /**
     * Creates a fluent helper using the specified service path and entity collection to send the read requests.
     *
     * @param entityCollection
     *            The entity collection to direct the requests to.
     * @param servicePath
     *            The service path to direct the read requests to.
     */
    public ProcessOrderItem_2FluentHelper( @Nonnull final String servicePath, @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
    }

    @Override
    @Nonnull
    protected Class<ProcessOrderItem_2> getEntityClass()
    {
        return ProcessOrderItem_2.class;
    }

}
