/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.field.ProcessOrderProdnRsceTools_2Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.selectable.ProcessOrderProdnRsceTools_2Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Process Order Production Resources Tools
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProcessOrderProdnRsceTools_2Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProcessOrderProdnRsceTools_2 extends VdmEntity<ProcessOrderProdnRsceTools_2>
{

    /**
     * Selector for all available fields of ProcessOrderProdnRsceTools_2.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @return Order Internal ID
     */
    @Key
    @SerializedName( "OrderInternalBillOfOperations" )
    @JsonProperty( "OrderInternalBillOfOperations" )
    @Nullable
    @ODataField( odataName = "OrderInternalBillOfOperations" )
    private String orderInternalBillOfOperations;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalBillOfOperations</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> ORDER_INTERNAL_BILL_OF_OPERATIONS =
        new ProcessOrderProdnRsceTools_2Field<String>("OrderInternalBillOfOperations");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderOpProdnRsceToolIntID</b>
     * </p>
     *
     * @return Item Counter for Production Resources/Tools
     */
    @Key
    @SerializedName( "MfgOrderOpProdnRsceToolIntID" )
    @JsonProperty( "MfgOrderOpProdnRsceToolIntID" )
    @Nullable
    @ODataField( odataName = "MfgOrderOpProdnRsceToolIntID" )
    private String mfgOrderOpProdnRsceToolIntID;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderOpProdnRsceToolIntID</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> MFG_ORDER_OP_PRODN_RSCE_TOOL_INT_ID =
        new ProcessOrderProdnRsceTools_2Field<String>("MfgOrderOpProdnRsceToolIntID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceTool</b>
     * </p>
     *
     * @return Production Resource/Tool Number
     */
    @SerializedName( "ProductionResourceTool" )
    @JsonProperty( "ProductionResourceTool" )
    @Nullable
    @ODataField( odataName = "ProductionResourceTool" )
    private String productionResourceTool;
    /**
     * Use with available fluent helpers to apply the <b>ProductionResourceTool</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRODUCTION_RESOURCE_TOOL =
        new ProcessOrderProdnRsceTools_2Field<String>("ProductionResourceTool");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategory</b>
     * </p>
     *
     * @return Production Resources/Tools Category
     */
    @SerializedName( "ProdnRsceToolCategory" )
    @JsonProperty( "ProdnRsceToolCategory" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolCategory" )
    private String prodnRsceToolCategory;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolCategory</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRODN_RSCE_TOOL_CATEGORY =
        new ProcessOrderProdnRsceTools_2Field<String>("ProdnRsceToolCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategoryName</b>
     * </p>
     *
     * @return Language-dependent description of the PRT category
     */
    @SerializedName( "ProdnRsceToolCategoryName" )
    @JsonProperty( "ProdnRsceToolCategoryName" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolCategoryName" )
    private String prodnRsceToolCategoryName;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolCategoryName</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRODN_RSCE_TOOL_CATEGORY_NAME =
        new ProcessOrderProdnRsceTools_2Field<String>("ProdnRsceToolCategoryName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolControlProfile</b>
     * </p>
     *
     * @return Control Profile for Management of Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolControlProfile" )
    @JsonProperty( "ProdnRsceToolControlProfile" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolControlProfile" )
    private String prodnRsceToolControlProfile;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolControlProfile</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRODN_RSCE_TOOL_CONTROL_PROFILE =
        new ProcessOrderProdnRsceTools_2Field<String>("ProdnRsceToolControlProfile");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolPlant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "ProdnRsceToolPlant" )
    @JsonProperty( "ProdnRsceToolPlant" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolPlant" )
    private String prodnRsceToolPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolPlant</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRODN_RSCE_TOOL_PLANT =
        new ProcessOrderProdnRsceTools_2Field<String>("ProdnRsceToolPlant");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OrderOperationInternalID</b>
     * </p>
     *
     * @return Internal Identifier of an Operation or Activity
     */
    @SerializedName( "OrderOperationInternalID" )
    @JsonProperty( "OrderOperationInternalID" )
    @Nullable
    @ODataField( odataName = "OrderOperationInternalID" )
    private String orderOperationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>OrderOperationInternalID</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> ORDER_OPERATION_INTERNAL_ID =
        new ProcessOrderProdnRsceTools_2Field<String>("OrderOperationInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Process Order
     */
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> MANUFACTURING_ORDER =
        new ProcessOrderProdnRsceTools_2Field<String>("ManufacturingOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @return Operation or Phase Number
     */
    @SerializedName( "ManufacturingOrderOperation" )
    @JsonProperty( "ManufacturingOrderOperation" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderOperation" )
    private String manufacturingOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderOperation</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> MANUFACTURING_ORDER_OPERATION =
        new ProcessOrderProdnRsceTools_2Field<String>("ManufacturingOrderOperation");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @return Manufacturing Order Category
     */
    @SerializedName( "ManufacturingOrderCategory" )
    @JsonProperty( "ManufacturingOrderCategory" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderCategory" )
    private String manufacturingOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderCategory</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> MANUFACTURING_ORDER_CATEGORY =
        new ProcessOrderProdnRsceTools_2Field<String>("ManufacturingOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @return Manufacturing Order Type
     */
    @SerializedName( "ManufacturingOrderType" )
    @JsonProperty( "ManufacturingOrderType" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderType" )
    private String manufacturingOrderType;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderType</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> MANUFACTURING_ORDER_TYPE =
        new ProcessOrderProdnRsceTools_2Field<String>("ManufacturingOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @return Production Plant
     */
    @SerializedName( "ProductionPlant" )
    @JsonProperty( "ProductionPlant" )
    @Nullable
    @ODataField( odataName = "ProductionPlant" )
    private String productionPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPlant</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRODUCTION_PLANT =
        new ProcessOrderProdnRsceTools_2Field<String>("ProductionPlant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsType</b>
     * </p>
     *
     * @return Task List Type
     */
    @SerializedName( "BillOfOperationsType" )
    @JsonProperty( "BillOfOperationsType" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsType" )
    private String billOfOperationsType;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsType</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> BILL_OF_OPERATIONS_TYPE =
        new ProcessOrderProdnRsceTools_2Field<String>("BillOfOperationsType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @SerializedName( "BillOfOperationsGroup" )
    @JsonProperty( "BillOfOperationsGroup" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsGroup" )
    private String billOfOperationsGroup;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsGroup</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> BILL_OF_OPERATIONS_GROUP =
        new ProcessOrderProdnRsceTools_2Field<String>("BillOfOperationsGroup");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageStartDate</b>
     * </p>
     *
     * @return Earliest Scheduled Start Date for PRT Usage
     */
    @SerializedName( "EarliestSchedldUsageStartDate" )
    @JsonProperty( "EarliestSchedldUsageStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EarliestSchedldUsageStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime earliestSchedldUsageStartDate;
    /**
     * Use with available fluent helpers to apply the <b>EarliestSchedldUsageStartDate</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<LocalDateTime> EARLIEST_SCHEDLD_USAGE_START_DATE =
        new ProcessOrderProdnRsceTools_2Field<LocalDateTime>("EarliestSchedldUsageStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageStartTime</b>
     * </p>
     *
     * @return Earliest Scheduled Start Time for PRT Usage
     */
    @SerializedName( "EarliestSchedldUsageStartTime" )
    @JsonProperty( "EarliestSchedldUsageStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "EarliestSchedldUsageStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime earliestSchedldUsageStartTime;
    /**
     * Use with available fluent helpers to apply the <b>EarliestSchedldUsageStartTime</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<LocalTime> EARLIEST_SCHEDLD_USAGE_START_TIME =
        new ProcessOrderProdnRsceTools_2Field<LocalTime>("EarliestSchedldUsageStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageEndDate</b>
     * </p>
     *
     * @return Earliest Scheduled End Date of PRT Usage
     */
    @SerializedName( "EarliestSchedldUsageEndDate" )
    @JsonProperty( "EarliestSchedldUsageEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EarliestSchedldUsageEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime earliestSchedldUsageEndDate;
    /**
     * Use with available fluent helpers to apply the <b>EarliestSchedldUsageEndDate</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<LocalDateTime> EARLIEST_SCHEDLD_USAGE_END_DATE =
        new ProcessOrderProdnRsceTools_2Field<LocalDateTime>("EarliestSchedldUsageEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageEndTime</b>
     * </p>
     *
     * @return Earliest Scheduled End Time of PRT Usage
     */
    @SerializedName( "EarliestSchedldUsageEndTime" )
    @JsonProperty( "EarliestSchedldUsageEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "EarliestSchedldUsageEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime earliestSchedldUsageEndTime;
    /**
     * Use with available fluent helpers to apply the <b>EarliestSchedldUsageEndTime</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<LocalTime> EARLIEST_SCHEDLD_USAGE_END_TIME =
        new ProcessOrderProdnRsceTools_2Field<LocalTime>("EarliestSchedldUsageEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageStartDate</b>
     * </p>
     *
     * @return Latest Scheduled Start Date for PRT Usage
     */
    @SerializedName( "LatestSchedldUsageStartDate" )
    @JsonProperty( "LatestSchedldUsageStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LatestSchedldUsageStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime latestSchedldUsageStartDate;
    /**
     * Use with available fluent helpers to apply the <b>LatestSchedldUsageStartDate</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<LocalDateTime> LATEST_SCHEDLD_USAGE_START_DATE =
        new ProcessOrderProdnRsceTools_2Field<LocalDateTime>("LatestSchedldUsageStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageStartTime</b>
     * </p>
     *
     * @return Latest Scheduled Start Time for PRT Usage
     */
    @SerializedName( "LatestSchedldUsageStartTime" )
    @JsonProperty( "LatestSchedldUsageStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LatestSchedldUsageStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime latestSchedldUsageStartTime;
    /**
     * Use with available fluent helpers to apply the <b>LatestSchedldUsageStartTime</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<LocalTime> LATEST_SCHEDLD_USAGE_START_TIME =
        new ProcessOrderProdnRsceTools_2Field<LocalTime>("LatestSchedldUsageStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageEndDate</b>
     * </p>
     *
     * @return Latest Scheduled End Date for PRT Usage
     */
    @SerializedName( "LatestSchedldUsageEndDate" )
    @JsonProperty( "LatestSchedldUsageEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LatestSchedldUsageEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime latestSchedldUsageEndDate;
    /**
     * Use with available fluent helpers to apply the <b>LatestSchedldUsageEndDate</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<LocalDateTime> LATEST_SCHEDLD_USAGE_END_DATE =
        new ProcessOrderProdnRsceTools_2Field<LocalDateTime>("LatestSchedldUsageEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageEndTime</b>
     * </p>
     *
     * @return Latest Scheduled End Time for PRT Usage
     */
    @SerializedName( "LatestSchedldUsageEndTime" )
    @JsonProperty( "LatestSchedldUsageEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LatestSchedldUsageEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime latestSchedldUsageEndTime;
    /**
     * Use with available fluent helpers to apply the <b>LatestSchedldUsageEndTime</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<LocalTime> LATEST_SCHEDLD_USAGE_END_TIME =
        new ProcessOrderProdnRsceTools_2Field<LocalTime>("LatestSchedldUsageEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualUsageStartDate</b>
     * </p>
     *
     * @return Actual start date of PRT usage
     */
    @SerializedName( "ActualUsageStartDate" )
    @JsonProperty( "ActualUsageStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ActualUsageStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime actualUsageStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ActualUsageStartDate</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<LocalDateTime> ACTUAL_USAGE_START_DATE =
        new ProcessOrderProdnRsceTools_2Field<LocalDateTime>("ActualUsageStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualUsageStartTime</b>
     * </p>
     *
     * @return Actual start time of PRT usage
     */
    @SerializedName( "ActualUsageStartTime" )
    @JsonProperty( "ActualUsageStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ActualUsageStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime actualUsageStartTime;
    /**
     * Use with available fluent helpers to apply the <b>ActualUsageStartTime</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<LocalTime> ACTUAL_USAGE_START_TIME =
        new ProcessOrderProdnRsceTools_2Field<LocalTime>("ActualUsageStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualUsageEndDate</b>
     * </p>
     *
     * @return Actual end date of PRT usage
     */
    @SerializedName( "ActualUsageEndDate" )
    @JsonProperty( "ActualUsageEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ActualUsageEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime actualUsageEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ActualUsageEndDate</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<LocalDateTime> ACTUAL_USAGE_END_DATE =
        new ProcessOrderProdnRsceTools_2Field<LocalDateTime>("ActualUsageEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualUsageEndTime</b>
     * </p>
     *
     * @return Actual end time of PRT usage
     */
    @SerializedName( "ActualUsageEndTime" )
    @JsonProperty( "ActualUsageEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ActualUsageEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime actualUsageEndTime;
    /**
     * Use with available fluent helpers to apply the <b>ActualUsageEndTime</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<LocalTime> ACTUAL_USAGE_END_TIME =
        new ProcessOrderProdnRsceTools_2Field<LocalTime>("ActualUsageEndTime");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageDurnUnit</b>
     * </p>
     *
     * @return Unit for Duration of PRT Usage
     */
    @SerializedName( "ProdnRsceToolUsageDurnUnit" )
    @JsonProperty( "ProdnRsceToolUsageDurnUnit" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolUsageDurnUnit" )
    private String prodnRsceToolUsageDurnUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolUsageDurnUnit</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRODN_RSCE_TOOL_USAGE_DURN_UNIT =
        new ProcessOrderProdnRsceTools_2Field<String>("ProdnRsceToolUsageDurnUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageDuration</b>
     * </p>
     *
     * @return Duration of PRT Usage
     */
    @SerializedName( "ProdnRsceToolUsageDuration" )
    @JsonProperty( "ProdnRsceToolUsageDuration" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolUsageDuration" )
    private Double prodnRsceToolUsageDuration;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolUsageDuration</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<Double> PRODN_RSCE_TOOL_USAGE_DURATION =
        new ProcessOrderProdnRsceTools_2Field<Double>("ProdnRsceToolUsageDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PRTUsageDurationUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "PRTUsageDurationUnitISOCode" )
    @JsonProperty( "PRTUsageDurationUnitISOCode" )
    @Nullable
    @ODataField( odataName = "PRTUsageDurationUnitISOCode" )
    private String pRTUsageDurationUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>PRTUsageDurationUnitISOCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRT_USAGE_DURATION_UNIT_ISO_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("PRTUsageDurationUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PRTUsageDurationUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "PRTUsageDurationUnitSAPCode" )
    @JsonProperty( "PRTUsageDurationUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "PRTUsageDurationUnitSAPCode" )
    private String pRTUsageDurationUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>PRTUsageDurationUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRT_USAGE_DURATION_UNIT_SAP_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("PRTUsageDurationUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolTotQtyCalcFormula</b>
     * </p>
     *
     * @return Formula for Calculating the Total Quantity of PRT
     */
    @SerializedName( "ProdnRsceToolTotQtyCalcFormula" )
    @JsonProperty( "ProdnRsceToolTotQtyCalcFormula" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolTotQtyCalcFormula" )
    private String prodnRsceToolTotQtyCalcFormula;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolTotQtyCalcFormula</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRODN_RSCE_TOOL_TOT_QTY_CALC_FORMULA =
        new ProcessOrderProdnRsceTools_2Field<String>("ProdnRsceToolTotQtyCalcFormula");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQtyCalcFmla</b>
     * </p>
     *
     * @return Formula for Calculating the Total Usage Value of PRT
     */
    @SerializedName( "ProdnRsceToolUsageQtyCalcFmla" )
    @JsonProperty( "ProdnRsceToolUsageQtyCalcFmla" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolUsageQtyCalcFmla" )
    private String prodnRsceToolUsageQtyCalcFmla;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolUsageQtyCalcFmla</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRODN_RSCE_TOOL_USAGE_QTY_CALC_FMLA =
        new ProcessOrderProdnRsceTools_2Field<String>("ProdnRsceToolUsageQtyCalcFmla");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStdWorkQtyUnit</b>
     * </p>
     *
     * @return Unit for Quantity of Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolStdWorkQtyUnit" )
    @JsonProperty( "ProdnRsceToolStdWorkQtyUnit" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolStdWorkQtyUnit" )
    private String prodnRsceToolStdWorkQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolStdWorkQtyUnit</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRODN_RSCE_TOOL_STD_WORK_QTY_UNIT =
        new ProcessOrderProdnRsceTools_2Field<String>("ProdnRsceToolStdWorkQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStandardWorkQty</b>
     * </p>
     *
     * @return Standard Value for Quantity of Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolStandardWorkQty" )
    @JsonProperty( "ProdnRsceToolStandardWorkQty" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolStandardWorkQty" )
    private BigDecimal prodnRsceToolStandardWorkQty;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolStandardWorkQty</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<BigDecimal> PRODN_RSCE_TOOL_STANDARD_WORK_QTY =
        new ProcessOrderProdnRsceTools_2Field<BigDecimal>("ProdnRsceToolStandardWorkQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PRTStdWorkQtyUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "PRTStdWorkQtyUnitISOCode" )
    @JsonProperty( "PRTStdWorkQtyUnitISOCode" )
    @Nullable
    @ODataField( odataName = "PRTStdWorkQtyUnitISOCode" )
    private String pRTStdWorkQtyUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>PRTStdWorkQtyUnitISOCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRT_STD_WORK_QTY_UNIT_ISO_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("PRTStdWorkQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PRTStdWorkQtyUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "PRTStdWorkQtyUnitSAPCode" )
    @JsonProperty( "PRTStdWorkQtyUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "PRTStdWorkQtyUnitSAPCode" )
    private String pRTStdWorkQtyUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>PRTStdWorkQtyUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRT_STD_WORK_QTY_UNIT_SAP_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("PRTStdWorkQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedProdnRsceToolQtyUnit</b>
     * </p>
     *
     * @return Unit for Total Planned Quantity of Production Resource/Tool
     */
    @SerializedName( "PlannedProdnRsceToolQtyUnit" )
    @JsonProperty( "PlannedProdnRsceToolQtyUnit" )
    @Nullable
    @ODataField( odataName = "PlannedProdnRsceToolQtyUnit" )
    private String plannedProdnRsceToolQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>PlannedProdnRsceToolQtyUnit</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PLANNED_PRODN_RSCE_TOOL_QTY_UNIT =
        new ProcessOrderProdnRsceTools_2Field<String>("PlannedProdnRsceToolQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedTotalProdnRsceToolQty</b>
     * </p>
     *
     * @return Total Planned Quantity of Production Resource/Tool
     */
    @SerializedName( "PlannedTotalProdnRsceToolQty" )
    @JsonProperty( "PlannedTotalProdnRsceToolQty" )
    @Nullable
    @ODataField( odataName = "PlannedTotalProdnRsceToolQty" )
    private BigDecimal plannedTotalProdnRsceToolQty;
    /**
     * Use with available fluent helpers to apply the <b>PlannedTotalProdnRsceToolQty</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<BigDecimal> PLANNED_TOTAL_PRODN_RSCE_TOOL_QTY =
        new ProcessOrderProdnRsceTools_2Field<BigDecimal>("PlannedTotalProdnRsceToolQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPRTQtyUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "PlannedPRTQtyUnitISOCode" )
    @JsonProperty( "PlannedPRTQtyUnitISOCode" )
    @Nullable
    @ODataField( odataName = "PlannedPRTQtyUnitISOCode" )
    private String plannedPRTQtyUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>PlannedPRTQtyUnitISOCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PLANNED_PRT_QTY_UNIT_ISO_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("PlannedPRTQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPRTQtyUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "PlannedPRTQtyUnitSAPCode" )
    @JsonProperty( "PlannedPRTQtyUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "PlannedPRTQtyUnitSAPCode" )
    private String plannedPRTQtyUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>PlannedPRTQtyUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PLANNED_PRT_QTY_UNIT_SAP_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("PlannedPRTQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProdnRsceToolQtyUnit</b>
     * </p>
     *
     * @return Unit for Actual Quantity of Production Resource/Tool
     */
    @SerializedName( "ConfirmedProdnRsceToolQtyUnit" )
    @JsonProperty( "ConfirmedProdnRsceToolQtyUnit" )
    @Nullable
    @ODataField( odataName = "ConfirmedProdnRsceToolQtyUnit" )
    private String confirmedProdnRsceToolQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedProdnRsceToolQtyUnit</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> CONFIRMED_PRODN_RSCE_TOOL_QTY_UNIT =
        new ProcessOrderProdnRsceTools_2Field<String>("ConfirmedProdnRsceToolQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProdnRsceToolQty</b>
     * </p>
     *
     * @return Actual Quantity of Production Resource/Tool
     */
    @SerializedName( "ConfirmedProdnRsceToolQty" )
    @JsonProperty( "ConfirmedProdnRsceToolQty" )
    @Nullable
    @ODataField( odataName = "ConfirmedProdnRsceToolQty" )
    private BigDecimal confirmedProdnRsceToolQty;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedProdnRsceToolQty</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<BigDecimal> CONFIRMED_PRODN_RSCE_TOOL_QTY =
        new ProcessOrderProdnRsceTools_2Field<BigDecimal>("ConfirmedProdnRsceToolQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedPRTQtyUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "ConfirmedPRTQtyUnitISOCode" )
    @JsonProperty( "ConfirmedPRTQtyUnitISOCode" )
    @Nullable
    @ODataField( odataName = "ConfirmedPRTQtyUnitISOCode" )
    private String confirmedPRTQtyUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedPRTQtyUnitISOCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> CONFIRMED_PRT_QTY_UNIT_ISO_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("ConfirmedPRTQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedPRTQtyUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "ConfirmedPRTQtyUnitSAPCode" )
    @JsonProperty( "ConfirmedPRTQtyUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "ConfirmedPRTQtyUnitSAPCode" )
    private String confirmedPRTQtyUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedPRTQtyUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> CONFIRMED_PRT_QTY_UNIT_SAP_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("ConfirmedPRTQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantityUnit</b>
     * </p>
     *
     * @return Usage Value Unit of the Production Resource/Tool
     */
    @SerializedName( "ProdnRsceToolUsageQuantityUnit" )
    @JsonProperty( "ProdnRsceToolUsageQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolUsageQuantityUnit" )
    private String prodnRsceToolUsageQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolUsageQuantityUnit</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRODN_RSCE_TOOL_USAGE_QUANTITY_UNIT =
        new ProcessOrderProdnRsceTools_2Field<String>("ProdnRsceToolUsageQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantity</b>
     * </p>
     *
     * @return Standard Usage Value for Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolUsageQuantity" )
    @JsonProperty( "ProdnRsceToolUsageQuantity" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolUsageQuantity" )
    private BigDecimal prodnRsceToolUsageQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolUsageQuantity</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<BigDecimal> PRODN_RSCE_TOOL_USAGE_QUANTITY =
        new ProcessOrderProdnRsceTools_2Field<BigDecimal>("ProdnRsceToolUsageQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PRTUsageQtyUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "PRTUsageQtyUnitISOCode" )
    @JsonProperty( "PRTUsageQtyUnitISOCode" )
    @Nullable
    @ODataField( odataName = "PRTUsageQtyUnitISOCode" )
    private String pRTUsageQtyUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>PRTUsageQtyUnitISOCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRT_USAGE_QTY_UNIT_ISO_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("PRTUsageQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PRTUsageQtyUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "PRTUsageQtyUnitSAPCode" )
    @JsonProperty( "PRTUsageQtyUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "PRTUsageQtyUnitSAPCode" )
    private String pRTUsageQtyUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>PRTUsageQtyUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRT_USAGE_QTY_UNIT_SAP_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("PRTUsageQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlndProdnRsceToolUsageQtyUnit</b>
     * </p>
     *
     * @return Unit for Planned Usage Quantity of Production Resource/Tool
     */
    @SerializedName( "PlndProdnRsceToolUsageQtyUnit" )
    @JsonProperty( "PlndProdnRsceToolUsageQtyUnit" )
    @Nullable
    @ODataField( odataName = "PlndProdnRsceToolUsageQtyUnit" )
    private String plndProdnRsceToolUsageQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>PlndProdnRsceToolUsageQtyUnit</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PLND_PRODN_RSCE_TOOL_USAGE_QTY_UNIT =
        new ProcessOrderProdnRsceTools_2Field<String>("PlndProdnRsceToolUsageQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedProdnRsceToolUsageQty</b>
     * </p>
     *
     * @return Total Planned Usage Value of Production Resource/Tool
     */
    @SerializedName( "PlannedProdnRsceToolUsageQty" )
    @JsonProperty( "PlannedProdnRsceToolUsageQty" )
    @Nullable
    @ODataField( odataName = "PlannedProdnRsceToolUsageQty" )
    private BigDecimal plannedProdnRsceToolUsageQty;
    /**
     * Use with available fluent helpers to apply the <b>PlannedProdnRsceToolUsageQty</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<BigDecimal> PLANNED_PRODN_RSCE_TOOL_USAGE_QTY =
        new ProcessOrderProdnRsceTools_2Field<BigDecimal>("PlannedProdnRsceToolUsageQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPRTUsageQtyUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "PlannedPRTUsageQtyUnitISOCode" )
    @JsonProperty( "PlannedPRTUsageQtyUnitISOCode" )
    @Nullable
    @ODataField( odataName = "PlannedPRTUsageQtyUnitISOCode" )
    private String plannedPRTUsageQtyUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>PlannedPRTUsageQtyUnitISOCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PLANNED_PRT_USAGE_QTY_UNIT_ISO_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("PlannedPRTUsageQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPRTUsageQtyUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "PlannedPRTUsageQtyUnitSAPCode" )
    @JsonProperty( "PlannedPRTUsageQtyUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "PlannedPRTUsageQtyUnitSAPCode" )
    private String plannedPRTUsageQtyUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>PlannedPRTUsageQtyUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PLANNED_PRT_USAGE_QTY_UNIT_SAP_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("PlannedPRTUsageQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdProdnRsceToolUsageQtyUnit</b>
     * </p>
     *
     * @return Unit for Actual Usage Quantity of Production Resource/Tool
     */
    @SerializedName( "ConfdProdnRsceToolUsageQtyUnit" )
    @JsonProperty( "ConfdProdnRsceToolUsageQtyUnit" )
    @Nullable
    @ODataField( odataName = "ConfdProdnRsceToolUsageQtyUnit" )
    private String confdProdnRsceToolUsageQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConfdProdnRsceToolUsageQtyUnit</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> CONFD_PRODN_RSCE_TOOL_USAGE_QTY_UNIT =
        new ProcessOrderProdnRsceTools_2Field<String>("ConfdProdnRsceToolUsageQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProdnRsceToolUsageQty</b>
     * </p>
     *
     * @return Actual Usage Value for Production Resource/Tool
     */
    @SerializedName( "ConfirmedProdnRsceToolUsageQty" )
    @JsonProperty( "ConfirmedProdnRsceToolUsageQty" )
    @Nullable
    @ODataField( odataName = "ConfirmedProdnRsceToolUsageQty" )
    private BigDecimal confirmedProdnRsceToolUsageQty;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedProdnRsceToolUsageQty</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<BigDecimal> CONFIRMED_PRODN_RSCE_TOOL_USAGE_QTY =
        new ProcessOrderProdnRsceTools_2Field<BigDecimal>("ConfirmedProdnRsceToolUsageQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdPRTUsageQtyUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "ConfdPRTUsageQtyUnitISOCode" )
    @JsonProperty( "ConfdPRTUsageQtyUnitISOCode" )
    @Nullable
    @ODataField( odataName = "ConfdPRTUsageQtyUnitISOCode" )
    private String confdPRTUsageQtyUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>ConfdPRTUsageQtyUnitISOCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> CONFD_PRT_USAGE_QTY_UNIT_ISO_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("ConfdPRTUsageQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdPRTUsageQtyUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "ConfdPRTUsageQtyUnitSAPCode" )
    @JsonProperty( "ConfdPRTUsageQtyUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "ConfdPRTUsageQtyUnitSAPCode" )
    private String confdPRTUsageQtyUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>ConfdPRTUsageQtyUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> CONFD_PRT_USAGE_QTY_UNIT_SAP_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("ConfdPRTUsageQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolBaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure for Production Resources/Tools
     */
    @SerializedName( "ProdnRsceToolBaseUnit" )
    @JsonProperty( "ProdnRsceToolBaseUnit" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolBaseUnit" )
    private String prodnRsceToolBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolBaseUnit</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRODN_RSCE_TOOL_BASE_UNIT =
        new ProcessOrderProdnRsceTools_2Field<String>("ProdnRsceToolBaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolBaseUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "ProdnRsceToolBaseUnitISOCode" )
    @JsonProperty( "ProdnRsceToolBaseUnitISOCode" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolBaseUnitISOCode" )
    private String prodnRsceToolBaseUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolBaseUnitISOCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRODN_RSCE_TOOL_BASE_UNIT_ISO_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("ProdnRsceToolBaseUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolBaseUnitSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "ProdnRsceToolBaseUnitSAPCode" )
    @JsonProperty( "ProdnRsceToolBaseUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "ProdnRsceToolBaseUnitSAPCode" )
    private String prodnRsceToolBaseUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>ProdnRsceToolBaseUnitSAPCode</b> field to query operations.
     *
     */
    public final static ProcessOrderProdnRsceTools_2Field<String> PRODN_RSCE_TOOL_BASE_UNIT_SAP_CODE =
        new ProcessOrderProdnRsceTools_2Field<String>("ProdnRsceToolBaseUnitSAPCode");

    @Nonnull
    @Override
    public Class<ProcessOrderProdnRsceTools_2> getType()
    {
        return ProcessOrderProdnRsceTools_2.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     */
    public void setOrderInternalBillOfOperations( @Nullable final String orderInternalBillOfOperations )
    {
        rememberChangedField("OrderInternalBillOfOperations", this.orderInternalBillOfOperations);
        this.orderInternalBillOfOperations = orderInternalBillOfOperations;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderOpProdnRsceToolIntID</b>
     * </p>
     *
     * @param mfgOrderOpProdnRsceToolIntID
     *            Item Counter for Production Resources/Tools
     */
    public void setMfgOrderOpProdnRsceToolIntID( @Nullable final String mfgOrderOpProdnRsceToolIntID )
    {
        rememberChangedField("MfgOrderOpProdnRsceToolIntID", this.mfgOrderOpProdnRsceToolIntID);
        this.mfgOrderOpProdnRsceToolIntID = mfgOrderOpProdnRsceToolIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductionResourceTool</b>
     * </p>
     *
     * @param productionResourceTool
     *            Production Resource/Tool Number
     */
    public void setProductionResourceTool( @Nullable final String productionResourceTool )
    {
        rememberChangedField("ProductionResourceTool", this.productionResourceTool);
        this.productionResourceTool = productionResourceTool;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategory</b>
     * </p>
     *
     * @param prodnRsceToolCategory
     *            Production Resources/Tools Category
     */
    public void setProdnRsceToolCategory( @Nullable final String prodnRsceToolCategory )
    {
        rememberChangedField("ProdnRsceToolCategory", this.prodnRsceToolCategory);
        this.prodnRsceToolCategory = prodnRsceToolCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolCategoryName</b>
     * </p>
     *
     * @param prodnRsceToolCategoryName
     *            Language-dependent description of the PRT category
     */
    public void setProdnRsceToolCategoryName( @Nullable final String prodnRsceToolCategoryName )
    {
        rememberChangedField("ProdnRsceToolCategoryName", this.prodnRsceToolCategoryName);
        this.prodnRsceToolCategoryName = prodnRsceToolCategoryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolControlProfile</b>
     * </p>
     *
     * @param prodnRsceToolControlProfile
     *            Control Profile for Management of Production Resources/Tools
     */
    public void setProdnRsceToolControlProfile( @Nullable final String prodnRsceToolControlProfile )
    {
        rememberChangedField("ProdnRsceToolControlProfile", this.prodnRsceToolControlProfile);
        this.prodnRsceToolControlProfile = prodnRsceToolControlProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolPlant</b>
     * </p>
     *
     * @param prodnRsceToolPlant
     *            Plant
     */
    public void setProdnRsceToolPlant( @Nullable final String prodnRsceToolPlant )
    {
        rememberChangedField("ProdnRsceToolPlant", this.prodnRsceToolPlant);
        this.prodnRsceToolPlant = prodnRsceToolPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OrderOperationInternalID</b>
     * </p>
     *
     * @param orderOperationInternalID
     *            Internal Identifier of an Operation or Activity
     */
    public void setOrderOperationInternalID( @Nullable final String orderOperationInternalID )
    {
        rememberChangedField("OrderOperationInternalID", this.orderOperationInternalID);
        this.orderOperationInternalID = orderOperationInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Process Order
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @param manufacturingOrderOperation
     *            Operation or Phase Number
     */
    public void setManufacturingOrderOperation( @Nullable final String manufacturingOrderOperation )
    {
        rememberChangedField("ManufacturingOrderOperation", this.manufacturingOrderOperation);
        this.manufacturingOrderOperation = manufacturingOrderOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @param manufacturingOrderCategory
     *            Manufacturing Order Category
     */
    public void setManufacturingOrderCategory( @Nullable final String manufacturingOrderCategory )
    {
        rememberChangedField("ManufacturingOrderCategory", this.manufacturingOrderCategory);
        this.manufacturingOrderCategory = manufacturingOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @param manufacturingOrderType
     *            Manufacturing Order Type
     */
    public void setManufacturingOrderType( @Nullable final String manufacturingOrderType )
    {
        rememberChangedField("ManufacturingOrderType", this.manufacturingOrderType);
        this.manufacturingOrderType = manufacturingOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @param productionPlant
     *            Production Plant
     */
    public void setProductionPlant( @Nullable final String productionPlant )
    {
        rememberChangedField("ProductionPlant", this.productionPlant);
        this.productionPlant = productionPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsType</b>
     * </p>
     *
     * @param billOfOperationsType
     *            Task List Type
     */
    public void setBillOfOperationsType( @Nullable final String billOfOperationsType )
    {
        rememberChangedField("BillOfOperationsType", this.billOfOperationsType);
        this.billOfOperationsType = billOfOperationsType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsGroup</b>
     * </p>
     *
     * @param billOfOperationsGroup
     *            Key for Task List Group
     */
    public void setBillOfOperationsGroup( @Nullable final String billOfOperationsGroup )
    {
        rememberChangedField("BillOfOperationsGroup", this.billOfOperationsGroup);
        this.billOfOperationsGroup = billOfOperationsGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageStartDate</b>
     * </p>
     *
     * @param earliestSchedldUsageStartDate
     *            Earliest Scheduled Start Date for PRT Usage
     */
    public void setEarliestSchedldUsageStartDate( @Nullable final LocalDateTime earliestSchedldUsageStartDate )
    {
        rememberChangedField("EarliestSchedldUsageStartDate", this.earliestSchedldUsageStartDate);
        this.earliestSchedldUsageStartDate = earliestSchedldUsageStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageStartTime</b>
     * </p>
     *
     * @param earliestSchedldUsageStartTime
     *            Earliest Scheduled Start Time for PRT Usage
     */
    public void setEarliestSchedldUsageStartTime( @Nullable final LocalTime earliestSchedldUsageStartTime )
    {
        rememberChangedField("EarliestSchedldUsageStartTime", this.earliestSchedldUsageStartTime);
        this.earliestSchedldUsageStartTime = earliestSchedldUsageStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageEndDate</b>
     * </p>
     *
     * @param earliestSchedldUsageEndDate
     *            Earliest Scheduled End Date of PRT Usage
     */
    public void setEarliestSchedldUsageEndDate( @Nullable final LocalDateTime earliestSchedldUsageEndDate )
    {
        rememberChangedField("EarliestSchedldUsageEndDate", this.earliestSchedldUsageEndDate);
        this.earliestSchedldUsageEndDate = earliestSchedldUsageEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EarliestSchedldUsageEndTime</b>
     * </p>
     *
     * @param earliestSchedldUsageEndTime
     *            Earliest Scheduled End Time of PRT Usage
     */
    public void setEarliestSchedldUsageEndTime( @Nullable final LocalTime earliestSchedldUsageEndTime )
    {
        rememberChangedField("EarliestSchedldUsageEndTime", this.earliestSchedldUsageEndTime);
        this.earliestSchedldUsageEndTime = earliestSchedldUsageEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageStartDate</b>
     * </p>
     *
     * @param latestSchedldUsageStartDate
     *            Latest Scheduled Start Date for PRT Usage
     */
    public void setLatestSchedldUsageStartDate( @Nullable final LocalDateTime latestSchedldUsageStartDate )
    {
        rememberChangedField("LatestSchedldUsageStartDate", this.latestSchedldUsageStartDate);
        this.latestSchedldUsageStartDate = latestSchedldUsageStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageStartTime</b>
     * </p>
     *
     * @param latestSchedldUsageStartTime
     *            Latest Scheduled Start Time for PRT Usage
     */
    public void setLatestSchedldUsageStartTime( @Nullable final LocalTime latestSchedldUsageStartTime )
    {
        rememberChangedField("LatestSchedldUsageStartTime", this.latestSchedldUsageStartTime);
        this.latestSchedldUsageStartTime = latestSchedldUsageStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageEndDate</b>
     * </p>
     *
     * @param latestSchedldUsageEndDate
     *            Latest Scheduled End Date for PRT Usage
     */
    public void setLatestSchedldUsageEndDate( @Nullable final LocalDateTime latestSchedldUsageEndDate )
    {
        rememberChangedField("LatestSchedldUsageEndDate", this.latestSchedldUsageEndDate);
        this.latestSchedldUsageEndDate = latestSchedldUsageEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldUsageEndTime</b>
     * </p>
     *
     * @param latestSchedldUsageEndTime
     *            Latest Scheduled End Time for PRT Usage
     */
    public void setLatestSchedldUsageEndTime( @Nullable final LocalTime latestSchedldUsageEndTime )
    {
        rememberChangedField("LatestSchedldUsageEndTime", this.latestSchedldUsageEndTime);
        this.latestSchedldUsageEndTime = latestSchedldUsageEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualUsageStartDate</b>
     * </p>
     *
     * @param actualUsageStartDate
     *            Actual start date of PRT usage
     */
    public void setActualUsageStartDate( @Nullable final LocalDateTime actualUsageStartDate )
    {
        rememberChangedField("ActualUsageStartDate", this.actualUsageStartDate);
        this.actualUsageStartDate = actualUsageStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualUsageStartTime</b>
     * </p>
     *
     * @param actualUsageStartTime
     *            Actual start time of PRT usage
     */
    public void setActualUsageStartTime( @Nullable final LocalTime actualUsageStartTime )
    {
        rememberChangedField("ActualUsageStartTime", this.actualUsageStartTime);
        this.actualUsageStartTime = actualUsageStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualUsageEndDate</b>
     * </p>
     *
     * @param actualUsageEndDate
     *            Actual end date of PRT usage
     */
    public void setActualUsageEndDate( @Nullable final LocalDateTime actualUsageEndDate )
    {
        rememberChangedField("ActualUsageEndDate", this.actualUsageEndDate);
        this.actualUsageEndDate = actualUsageEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualUsageEndTime</b>
     * </p>
     *
     * @param actualUsageEndTime
     *            Actual end time of PRT usage
     */
    public void setActualUsageEndTime( @Nullable final LocalTime actualUsageEndTime )
    {
        rememberChangedField("ActualUsageEndTime", this.actualUsageEndTime);
        this.actualUsageEndTime = actualUsageEndTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageDurnUnit</b>
     * </p>
     *
     * @param prodnRsceToolUsageDurnUnit
     *            Unit for Duration of PRT Usage
     */
    public void setProdnRsceToolUsageDurnUnit( @Nullable final String prodnRsceToolUsageDurnUnit )
    {
        rememberChangedField("ProdnRsceToolUsageDurnUnit", this.prodnRsceToolUsageDurnUnit);
        this.prodnRsceToolUsageDurnUnit = prodnRsceToolUsageDurnUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageDuration</b>
     * </p>
     *
     * @param prodnRsceToolUsageDuration
     *            Duration of PRT Usage
     */
    public void setProdnRsceToolUsageDuration( @Nullable final Double prodnRsceToolUsageDuration )
    {
        rememberChangedField("ProdnRsceToolUsageDuration", this.prodnRsceToolUsageDuration);
        this.prodnRsceToolUsageDuration = prodnRsceToolUsageDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PRTUsageDurationUnitISOCode</b>
     * </p>
     *
     * @param pRTUsageDurationUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setPRTUsageDurationUnitISOCode( @Nullable final String pRTUsageDurationUnitISOCode )
    {
        rememberChangedField("PRTUsageDurationUnitISOCode", this.pRTUsageDurationUnitISOCode);
        this.pRTUsageDurationUnitISOCode = pRTUsageDurationUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PRTUsageDurationUnitSAPCode</b>
     * </p>
     *
     * @param pRTUsageDurationUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setPRTUsageDurationUnitSAPCode( @Nullable final String pRTUsageDurationUnitSAPCode )
    {
        rememberChangedField("PRTUsageDurationUnitSAPCode", this.pRTUsageDurationUnitSAPCode);
        this.pRTUsageDurationUnitSAPCode = pRTUsageDurationUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolTotQtyCalcFormula</b>
     * </p>
     *
     * @param prodnRsceToolTotQtyCalcFormula
     *            Formula for Calculating the Total Quantity of PRT
     */
    public void setProdnRsceToolTotQtyCalcFormula( @Nullable final String prodnRsceToolTotQtyCalcFormula )
    {
        rememberChangedField("ProdnRsceToolTotQtyCalcFormula", this.prodnRsceToolTotQtyCalcFormula);
        this.prodnRsceToolTotQtyCalcFormula = prodnRsceToolTotQtyCalcFormula;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQtyCalcFmla</b>
     * </p>
     *
     * @param prodnRsceToolUsageQtyCalcFmla
     *            Formula for Calculating the Total Usage Value of PRT
     */
    public void setProdnRsceToolUsageQtyCalcFmla( @Nullable final String prodnRsceToolUsageQtyCalcFmla )
    {
        rememberChangedField("ProdnRsceToolUsageQtyCalcFmla", this.prodnRsceToolUsageQtyCalcFmla);
        this.prodnRsceToolUsageQtyCalcFmla = prodnRsceToolUsageQtyCalcFmla;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStdWorkQtyUnit</b>
     * </p>
     *
     * @param prodnRsceToolStdWorkQtyUnit
     *            Unit for Quantity of Production Resources/Tools
     */
    public void setProdnRsceToolStdWorkQtyUnit( @Nullable final String prodnRsceToolStdWorkQtyUnit )
    {
        rememberChangedField("ProdnRsceToolStdWorkQtyUnit", this.prodnRsceToolStdWorkQtyUnit);
        this.prodnRsceToolStdWorkQtyUnit = prodnRsceToolStdWorkQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolStandardWorkQty</b>
     * </p>
     *
     * @param prodnRsceToolStandardWorkQty
     *            Standard Value for Quantity of Production Resources/Tools
     */
    public void setProdnRsceToolStandardWorkQty( @Nullable final BigDecimal prodnRsceToolStandardWorkQty )
    {
        rememberChangedField("ProdnRsceToolStandardWorkQty", this.prodnRsceToolStandardWorkQty);
        this.prodnRsceToolStandardWorkQty = prodnRsceToolStandardWorkQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PRTStdWorkQtyUnitISOCode</b>
     * </p>
     *
     * @param pRTStdWorkQtyUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setPRTStdWorkQtyUnitISOCode( @Nullable final String pRTStdWorkQtyUnitISOCode )
    {
        rememberChangedField("PRTStdWorkQtyUnitISOCode", this.pRTStdWorkQtyUnitISOCode);
        this.pRTStdWorkQtyUnitISOCode = pRTStdWorkQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PRTStdWorkQtyUnitSAPCode</b>
     * </p>
     *
     * @param pRTStdWorkQtyUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setPRTStdWorkQtyUnitSAPCode( @Nullable final String pRTStdWorkQtyUnitSAPCode )
    {
        rememberChangedField("PRTStdWorkQtyUnitSAPCode", this.pRTStdWorkQtyUnitSAPCode);
        this.pRTStdWorkQtyUnitSAPCode = pRTStdWorkQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedProdnRsceToolQtyUnit</b>
     * </p>
     *
     * @param plannedProdnRsceToolQtyUnit
     *            Unit for Total Planned Quantity of Production Resource/Tool
     */
    public void setPlannedProdnRsceToolQtyUnit( @Nullable final String plannedProdnRsceToolQtyUnit )
    {
        rememberChangedField("PlannedProdnRsceToolQtyUnit", this.plannedProdnRsceToolQtyUnit);
        this.plannedProdnRsceToolQtyUnit = plannedProdnRsceToolQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedTotalProdnRsceToolQty</b>
     * </p>
     *
     * @param plannedTotalProdnRsceToolQty
     *            Total Planned Quantity of Production Resource/Tool
     */
    public void setPlannedTotalProdnRsceToolQty( @Nullable final BigDecimal plannedTotalProdnRsceToolQty )
    {
        rememberChangedField("PlannedTotalProdnRsceToolQty", this.plannedTotalProdnRsceToolQty);
        this.plannedTotalProdnRsceToolQty = plannedTotalProdnRsceToolQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPRTQtyUnitISOCode</b>
     * </p>
     *
     * @param plannedPRTQtyUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setPlannedPRTQtyUnitISOCode( @Nullable final String plannedPRTQtyUnitISOCode )
    {
        rememberChangedField("PlannedPRTQtyUnitISOCode", this.plannedPRTQtyUnitISOCode);
        this.plannedPRTQtyUnitISOCode = plannedPRTQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPRTQtyUnitSAPCode</b>
     * </p>
     *
     * @param plannedPRTQtyUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setPlannedPRTQtyUnitSAPCode( @Nullable final String plannedPRTQtyUnitSAPCode )
    {
        rememberChangedField("PlannedPRTQtyUnitSAPCode", this.plannedPRTQtyUnitSAPCode);
        this.plannedPRTQtyUnitSAPCode = plannedPRTQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProdnRsceToolQtyUnit</b>
     * </p>
     *
     * @param confirmedProdnRsceToolQtyUnit
     *            Unit for Actual Quantity of Production Resource/Tool
     */
    public void setConfirmedProdnRsceToolQtyUnit( @Nullable final String confirmedProdnRsceToolQtyUnit )
    {
        rememberChangedField("ConfirmedProdnRsceToolQtyUnit", this.confirmedProdnRsceToolQtyUnit);
        this.confirmedProdnRsceToolQtyUnit = confirmedProdnRsceToolQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProdnRsceToolQty</b>
     * </p>
     *
     * @param confirmedProdnRsceToolQty
     *            Actual Quantity of Production Resource/Tool
     */
    public void setConfirmedProdnRsceToolQty( @Nullable final BigDecimal confirmedProdnRsceToolQty )
    {
        rememberChangedField("ConfirmedProdnRsceToolQty", this.confirmedProdnRsceToolQty);
        this.confirmedProdnRsceToolQty = confirmedProdnRsceToolQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedPRTQtyUnitISOCode</b>
     * </p>
     *
     * @param confirmedPRTQtyUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setConfirmedPRTQtyUnitISOCode( @Nullable final String confirmedPRTQtyUnitISOCode )
    {
        rememberChangedField("ConfirmedPRTQtyUnitISOCode", this.confirmedPRTQtyUnitISOCode);
        this.confirmedPRTQtyUnitISOCode = confirmedPRTQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedPRTQtyUnitSAPCode</b>
     * </p>
     *
     * @param confirmedPRTQtyUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setConfirmedPRTQtyUnitSAPCode( @Nullable final String confirmedPRTQtyUnitSAPCode )
    {
        rememberChangedField("ConfirmedPRTQtyUnitSAPCode", this.confirmedPRTQtyUnitSAPCode);
        this.confirmedPRTQtyUnitSAPCode = confirmedPRTQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantityUnit</b>
     * </p>
     *
     * @param prodnRsceToolUsageQuantityUnit
     *            Usage Value Unit of the Production Resource/Tool
     */
    public void setProdnRsceToolUsageQuantityUnit( @Nullable final String prodnRsceToolUsageQuantityUnit )
    {
        rememberChangedField("ProdnRsceToolUsageQuantityUnit", this.prodnRsceToolUsageQuantityUnit);
        this.prodnRsceToolUsageQuantityUnit = prodnRsceToolUsageQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolUsageQuantity</b>
     * </p>
     *
     * @param prodnRsceToolUsageQuantity
     *            Standard Usage Value for Production Resources/Tools
     */
    public void setProdnRsceToolUsageQuantity( @Nullable final BigDecimal prodnRsceToolUsageQuantity )
    {
        rememberChangedField("ProdnRsceToolUsageQuantity", this.prodnRsceToolUsageQuantity);
        this.prodnRsceToolUsageQuantity = prodnRsceToolUsageQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PRTUsageQtyUnitISOCode</b>
     * </p>
     *
     * @param pRTUsageQtyUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setPRTUsageQtyUnitISOCode( @Nullable final String pRTUsageQtyUnitISOCode )
    {
        rememberChangedField("PRTUsageQtyUnitISOCode", this.pRTUsageQtyUnitISOCode);
        this.pRTUsageQtyUnitISOCode = pRTUsageQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PRTUsageQtyUnitSAPCode</b>
     * </p>
     *
     * @param pRTUsageQtyUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setPRTUsageQtyUnitSAPCode( @Nullable final String pRTUsageQtyUnitSAPCode )
    {
        rememberChangedField("PRTUsageQtyUnitSAPCode", this.pRTUsageQtyUnitSAPCode);
        this.pRTUsageQtyUnitSAPCode = pRTUsageQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlndProdnRsceToolUsageQtyUnit</b>
     * </p>
     *
     * @param plndProdnRsceToolUsageQtyUnit
     *            Unit for Planned Usage Quantity of Production Resource/Tool
     */
    public void setPlndProdnRsceToolUsageQtyUnit( @Nullable final String plndProdnRsceToolUsageQtyUnit )
    {
        rememberChangedField("PlndProdnRsceToolUsageQtyUnit", this.plndProdnRsceToolUsageQtyUnit);
        this.plndProdnRsceToolUsageQtyUnit = plndProdnRsceToolUsageQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedProdnRsceToolUsageQty</b>
     * </p>
     *
     * @param plannedProdnRsceToolUsageQty
     *            Total Planned Usage Value of Production Resource/Tool
     */
    public void setPlannedProdnRsceToolUsageQty( @Nullable final BigDecimal plannedProdnRsceToolUsageQty )
    {
        rememberChangedField("PlannedProdnRsceToolUsageQty", this.plannedProdnRsceToolUsageQty);
        this.plannedProdnRsceToolUsageQty = plannedProdnRsceToolUsageQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPRTUsageQtyUnitISOCode</b>
     * </p>
     *
     * @param plannedPRTUsageQtyUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setPlannedPRTUsageQtyUnitISOCode( @Nullable final String plannedPRTUsageQtyUnitISOCode )
    {
        rememberChangedField("PlannedPRTUsageQtyUnitISOCode", this.plannedPRTUsageQtyUnitISOCode);
        this.plannedPRTUsageQtyUnitISOCode = plannedPRTUsageQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedPRTUsageQtyUnitSAPCode</b>
     * </p>
     *
     * @param plannedPRTUsageQtyUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setPlannedPRTUsageQtyUnitSAPCode( @Nullable final String plannedPRTUsageQtyUnitSAPCode )
    {
        rememberChangedField("PlannedPRTUsageQtyUnitSAPCode", this.plannedPRTUsageQtyUnitSAPCode);
        this.plannedPRTUsageQtyUnitSAPCode = plannedPRTUsageQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdProdnRsceToolUsageQtyUnit</b>
     * </p>
     *
     * @param confdProdnRsceToolUsageQtyUnit
     *            Unit for Actual Usage Quantity of Production Resource/Tool
     */
    public void setConfdProdnRsceToolUsageQtyUnit( @Nullable final String confdProdnRsceToolUsageQtyUnit )
    {
        rememberChangedField("ConfdProdnRsceToolUsageQtyUnit", this.confdProdnRsceToolUsageQtyUnit);
        this.confdProdnRsceToolUsageQtyUnit = confdProdnRsceToolUsageQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedProdnRsceToolUsageQty</b>
     * </p>
     *
     * @param confirmedProdnRsceToolUsageQty
     *            Actual Usage Value for Production Resource/Tool
     */
    public void setConfirmedProdnRsceToolUsageQty( @Nullable final BigDecimal confirmedProdnRsceToolUsageQty )
    {
        rememberChangedField("ConfirmedProdnRsceToolUsageQty", this.confirmedProdnRsceToolUsageQty);
        this.confirmedProdnRsceToolUsageQty = confirmedProdnRsceToolUsageQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdPRTUsageQtyUnitISOCode</b>
     * </p>
     *
     * @param confdPRTUsageQtyUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setConfdPRTUsageQtyUnitISOCode( @Nullable final String confdPRTUsageQtyUnitISOCode )
    {
        rememberChangedField("ConfdPRTUsageQtyUnitISOCode", this.confdPRTUsageQtyUnitISOCode);
        this.confdPRTUsageQtyUnitISOCode = confdPRTUsageQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdPRTUsageQtyUnitSAPCode</b>
     * </p>
     *
     * @param confdPRTUsageQtyUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setConfdPRTUsageQtyUnitSAPCode( @Nullable final String confdPRTUsageQtyUnitSAPCode )
    {
        rememberChangedField("ConfdPRTUsageQtyUnitSAPCode", this.confdPRTUsageQtyUnitSAPCode);
        this.confdPRTUsageQtyUnitSAPCode = confdPRTUsageQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolBaseUnit</b>
     * </p>
     *
     * @param prodnRsceToolBaseUnit
     *            Base Unit of Measure for Production Resources/Tools
     */
    public void setProdnRsceToolBaseUnit( @Nullable final String prodnRsceToolBaseUnit )
    {
        rememberChangedField("ProdnRsceToolBaseUnit", this.prodnRsceToolBaseUnit);
        this.prodnRsceToolBaseUnit = prodnRsceToolBaseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolBaseUnitISOCode</b>
     * </p>
     *
     * @param prodnRsceToolBaseUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setProdnRsceToolBaseUnitISOCode( @Nullable final String prodnRsceToolBaseUnitISOCode )
    {
        rememberChangedField("ProdnRsceToolBaseUnitISOCode", this.prodnRsceToolBaseUnitISOCode);
        this.prodnRsceToolBaseUnitISOCode = prodnRsceToolBaseUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdnRsceToolBaseUnitSAPCode</b>
     * </p>
     *
     * @param prodnRsceToolBaseUnitSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setProdnRsceToolBaseUnitSAPCode( @Nullable final String prodnRsceToolBaseUnitSAPCode )
    {
        rememberChangedField("ProdnRsceToolBaseUnitSAPCode", this.prodnRsceToolBaseUnitSAPCode);
        this.prodnRsceToolBaseUnitSAPCode = prodnRsceToolBaseUnitSAPCode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProcessOrderProdnRsceTools_2";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        result.put("MfgOrderOpProdnRsceToolIntID", getMfgOrderOpProdnRsceToolIntID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        values.put("MfgOrderOpProdnRsceToolIntID", getMfgOrderOpProdnRsceToolIntID());
        values.put("ProductionResourceTool", getProductionResourceTool());
        values.put("ProdnRsceToolCategory", getProdnRsceToolCategory());
        values.put("ProdnRsceToolCategoryName", getProdnRsceToolCategoryName());
        values.put("ProdnRsceToolControlProfile", getProdnRsceToolControlProfile());
        values.put("ProdnRsceToolPlant", getProdnRsceToolPlant());
        values.put("OrderOperationInternalID", getOrderOperationInternalID());
        values.put("ManufacturingOrder", getManufacturingOrder());
        values.put("ManufacturingOrderOperation", getManufacturingOrderOperation());
        values.put("ManufacturingOrderCategory", getManufacturingOrderCategory());
        values.put("ManufacturingOrderType", getManufacturingOrderType());
        values.put("ProductionPlant", getProductionPlant());
        values.put("BillOfOperationsType", getBillOfOperationsType());
        values.put("BillOfOperationsGroup", getBillOfOperationsGroup());
        values.put("EarliestSchedldUsageStartDate", getEarliestSchedldUsageStartDate());
        values.put("EarliestSchedldUsageStartTime", getEarliestSchedldUsageStartTime());
        values.put("EarliestSchedldUsageEndDate", getEarliestSchedldUsageEndDate());
        values.put("EarliestSchedldUsageEndTime", getEarliestSchedldUsageEndTime());
        values.put("LatestSchedldUsageStartDate", getLatestSchedldUsageStartDate());
        values.put("LatestSchedldUsageStartTime", getLatestSchedldUsageStartTime());
        values.put("LatestSchedldUsageEndDate", getLatestSchedldUsageEndDate());
        values.put("LatestSchedldUsageEndTime", getLatestSchedldUsageEndTime());
        values.put("ActualUsageStartDate", getActualUsageStartDate());
        values.put("ActualUsageStartTime", getActualUsageStartTime());
        values.put("ActualUsageEndDate", getActualUsageEndDate());
        values.put("ActualUsageEndTime", getActualUsageEndTime());
        values.put("ProdnRsceToolUsageDurnUnit", getProdnRsceToolUsageDurnUnit());
        values.put("ProdnRsceToolUsageDuration", getProdnRsceToolUsageDuration());
        values.put("PRTUsageDurationUnitISOCode", getPRTUsageDurationUnitISOCode());
        values.put("PRTUsageDurationUnitSAPCode", getPRTUsageDurationUnitSAPCode());
        values.put("ProdnRsceToolTotQtyCalcFormula", getProdnRsceToolTotQtyCalcFormula());
        values.put("ProdnRsceToolUsageQtyCalcFmla", getProdnRsceToolUsageQtyCalcFmla());
        values.put("ProdnRsceToolStdWorkQtyUnit", getProdnRsceToolStdWorkQtyUnit());
        values.put("ProdnRsceToolStandardWorkQty", getProdnRsceToolStandardWorkQty());
        values.put("PRTStdWorkQtyUnitISOCode", getPRTStdWorkQtyUnitISOCode());
        values.put("PRTStdWorkQtyUnitSAPCode", getPRTStdWorkQtyUnitSAPCode());
        values.put("PlannedProdnRsceToolQtyUnit", getPlannedProdnRsceToolQtyUnit());
        values.put("PlannedTotalProdnRsceToolQty", getPlannedTotalProdnRsceToolQty());
        values.put("PlannedPRTQtyUnitISOCode", getPlannedPRTQtyUnitISOCode());
        values.put("PlannedPRTQtyUnitSAPCode", getPlannedPRTQtyUnitSAPCode());
        values.put("ConfirmedProdnRsceToolQtyUnit", getConfirmedProdnRsceToolQtyUnit());
        values.put("ConfirmedProdnRsceToolQty", getConfirmedProdnRsceToolQty());
        values.put("ConfirmedPRTQtyUnitISOCode", getConfirmedPRTQtyUnitISOCode());
        values.put("ConfirmedPRTQtyUnitSAPCode", getConfirmedPRTQtyUnitSAPCode());
        values.put("ProdnRsceToolUsageQuantityUnit", getProdnRsceToolUsageQuantityUnit());
        values.put("ProdnRsceToolUsageQuantity", getProdnRsceToolUsageQuantity());
        values.put("PRTUsageQtyUnitISOCode", getPRTUsageQtyUnitISOCode());
        values.put("PRTUsageQtyUnitSAPCode", getPRTUsageQtyUnitSAPCode());
        values.put("PlndProdnRsceToolUsageQtyUnit", getPlndProdnRsceToolUsageQtyUnit());
        values.put("PlannedProdnRsceToolUsageQty", getPlannedProdnRsceToolUsageQty());
        values.put("PlannedPRTUsageQtyUnitISOCode", getPlannedPRTUsageQtyUnitISOCode());
        values.put("PlannedPRTUsageQtyUnitSAPCode", getPlannedPRTUsageQtyUnitSAPCode());
        values.put("ConfdProdnRsceToolUsageQtyUnit", getConfdProdnRsceToolUsageQtyUnit());
        values.put("ConfirmedProdnRsceToolUsageQty", getConfirmedProdnRsceToolUsageQty());
        values.put("ConfdPRTUsageQtyUnitISOCode", getConfdPRTUsageQtyUnitISOCode());
        values.put("ConfdPRTUsageQtyUnitSAPCode", getConfdPRTUsageQtyUnitSAPCode());
        values.put("ProdnRsceToolBaseUnit", getProdnRsceToolBaseUnit());
        values.put("ProdnRsceToolBaseUnitISOCode", getProdnRsceToolBaseUnitISOCode());
        values.put("ProdnRsceToolBaseUnitSAPCode", getProdnRsceToolBaseUnitSAPCode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("OrderInternalBillOfOperations") ) {
                final Object value = values.remove("OrderInternalBillOfOperations");
                if( (value == null) || (!value.equals(getOrderInternalBillOfOperations())) ) {
                    setOrderInternalBillOfOperations(((String) value));
                }
            }
            if( values.containsKey("MfgOrderOpProdnRsceToolIntID") ) {
                final Object value = values.remove("MfgOrderOpProdnRsceToolIntID");
                if( (value == null) || (!value.equals(getMfgOrderOpProdnRsceToolIntID())) ) {
                    setMfgOrderOpProdnRsceToolIntID(((String) value));
                }
            }
            if( values.containsKey("ProductionResourceTool") ) {
                final Object value = values.remove("ProductionResourceTool");
                if( (value == null) || (!value.equals(getProductionResourceTool())) ) {
                    setProductionResourceTool(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolCategory") ) {
                final Object value = values.remove("ProdnRsceToolCategory");
                if( (value == null) || (!value.equals(getProdnRsceToolCategory())) ) {
                    setProdnRsceToolCategory(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolCategoryName") ) {
                final Object value = values.remove("ProdnRsceToolCategoryName");
                if( (value == null) || (!value.equals(getProdnRsceToolCategoryName())) ) {
                    setProdnRsceToolCategoryName(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolControlProfile") ) {
                final Object value = values.remove("ProdnRsceToolControlProfile");
                if( (value == null) || (!value.equals(getProdnRsceToolControlProfile())) ) {
                    setProdnRsceToolControlProfile(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolPlant") ) {
                final Object value = values.remove("ProdnRsceToolPlant");
                if( (value == null) || (!value.equals(getProdnRsceToolPlant())) ) {
                    setProdnRsceToolPlant(((String) value));
                }
            }
            if( values.containsKey("OrderOperationInternalID") ) {
                final Object value = values.remove("OrderOperationInternalID");
                if( (value == null) || (!value.equals(getOrderOperationInternalID())) ) {
                    setOrderOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderOperation") ) {
                final Object value = values.remove("ManufacturingOrderOperation");
                if( (value == null) || (!value.equals(getManufacturingOrderOperation())) ) {
                    setManufacturingOrderOperation(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderCategory") ) {
                final Object value = values.remove("ManufacturingOrderCategory");
                if( (value == null) || (!value.equals(getManufacturingOrderCategory())) ) {
                    setManufacturingOrderCategory(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderType") ) {
                final Object value = values.remove("ManufacturingOrderType");
                if( (value == null) || (!value.equals(getManufacturingOrderType())) ) {
                    setManufacturingOrderType(((String) value));
                }
            }
            if( values.containsKey("ProductionPlant") ) {
                final Object value = values.remove("ProductionPlant");
                if( (value == null) || (!value.equals(getProductionPlant())) ) {
                    setProductionPlant(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsType") ) {
                final Object value = values.remove("BillOfOperationsType");
                if( (value == null) || (!value.equals(getBillOfOperationsType())) ) {
                    setBillOfOperationsType(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsGroup") ) {
                final Object value = values.remove("BillOfOperationsGroup");
                if( (value == null) || (!value.equals(getBillOfOperationsGroup())) ) {
                    setBillOfOperationsGroup(((String) value));
                }
            }
            if( values.containsKey("EarliestSchedldUsageStartDate") ) {
                final Object value = values.remove("EarliestSchedldUsageStartDate");
                if( (value == null) || (!value.equals(getEarliestSchedldUsageStartDate())) ) {
                    setEarliestSchedldUsageStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EarliestSchedldUsageStartTime") ) {
                final Object value = values.remove("EarliestSchedldUsageStartTime");
                if( (value == null) || (!value.equals(getEarliestSchedldUsageStartTime())) ) {
                    setEarliestSchedldUsageStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("EarliestSchedldUsageEndDate") ) {
                final Object value = values.remove("EarliestSchedldUsageEndDate");
                if( (value == null) || (!value.equals(getEarliestSchedldUsageEndDate())) ) {
                    setEarliestSchedldUsageEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EarliestSchedldUsageEndTime") ) {
                final Object value = values.remove("EarliestSchedldUsageEndTime");
                if( (value == null) || (!value.equals(getEarliestSchedldUsageEndTime())) ) {
                    setEarliestSchedldUsageEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LatestSchedldUsageStartDate") ) {
                final Object value = values.remove("LatestSchedldUsageStartDate");
                if( (value == null) || (!value.equals(getLatestSchedldUsageStartDate())) ) {
                    setLatestSchedldUsageStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LatestSchedldUsageStartTime") ) {
                final Object value = values.remove("LatestSchedldUsageStartTime");
                if( (value == null) || (!value.equals(getLatestSchedldUsageStartTime())) ) {
                    setLatestSchedldUsageStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LatestSchedldUsageEndDate") ) {
                final Object value = values.remove("LatestSchedldUsageEndDate");
                if( (value == null) || (!value.equals(getLatestSchedldUsageEndDate())) ) {
                    setLatestSchedldUsageEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LatestSchedldUsageEndTime") ) {
                final Object value = values.remove("LatestSchedldUsageEndTime");
                if( (value == null) || (!value.equals(getLatestSchedldUsageEndTime())) ) {
                    setLatestSchedldUsageEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ActualUsageStartDate") ) {
                final Object value = values.remove("ActualUsageStartDate");
                if( (value == null) || (!value.equals(getActualUsageStartDate())) ) {
                    setActualUsageStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ActualUsageStartTime") ) {
                final Object value = values.remove("ActualUsageStartTime");
                if( (value == null) || (!value.equals(getActualUsageStartTime())) ) {
                    setActualUsageStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ActualUsageEndDate") ) {
                final Object value = values.remove("ActualUsageEndDate");
                if( (value == null) || (!value.equals(getActualUsageEndDate())) ) {
                    setActualUsageEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ActualUsageEndTime") ) {
                final Object value = values.remove("ActualUsageEndTime");
                if( (value == null) || (!value.equals(getActualUsageEndTime())) ) {
                    setActualUsageEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ProdnRsceToolUsageDurnUnit") ) {
                final Object value = values.remove("ProdnRsceToolUsageDurnUnit");
                if( (value == null) || (!value.equals(getProdnRsceToolUsageDurnUnit())) ) {
                    setProdnRsceToolUsageDurnUnit(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolUsageDuration") ) {
                final Object value = values.remove("ProdnRsceToolUsageDuration");
                if( (value == null) || (!value.equals(getProdnRsceToolUsageDuration())) ) {
                    setProdnRsceToolUsageDuration(((Double) value));
                }
            }
            if( values.containsKey("PRTUsageDurationUnitISOCode") ) {
                final Object value = values.remove("PRTUsageDurationUnitISOCode");
                if( (value == null) || (!value.equals(getPRTUsageDurationUnitISOCode())) ) {
                    setPRTUsageDurationUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("PRTUsageDurationUnitSAPCode") ) {
                final Object value = values.remove("PRTUsageDurationUnitSAPCode");
                if( (value == null) || (!value.equals(getPRTUsageDurationUnitSAPCode())) ) {
                    setPRTUsageDurationUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolTotQtyCalcFormula") ) {
                final Object value = values.remove("ProdnRsceToolTotQtyCalcFormula");
                if( (value == null) || (!value.equals(getProdnRsceToolTotQtyCalcFormula())) ) {
                    setProdnRsceToolTotQtyCalcFormula(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolUsageQtyCalcFmla") ) {
                final Object value = values.remove("ProdnRsceToolUsageQtyCalcFmla");
                if( (value == null) || (!value.equals(getProdnRsceToolUsageQtyCalcFmla())) ) {
                    setProdnRsceToolUsageQtyCalcFmla(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolStdWorkQtyUnit") ) {
                final Object value = values.remove("ProdnRsceToolStdWorkQtyUnit");
                if( (value == null) || (!value.equals(getProdnRsceToolStdWorkQtyUnit())) ) {
                    setProdnRsceToolStdWorkQtyUnit(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolStandardWorkQty") ) {
                final Object value = values.remove("ProdnRsceToolStandardWorkQty");
                if( (value == null) || (!value.equals(getProdnRsceToolStandardWorkQty())) ) {
                    setProdnRsceToolStandardWorkQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("PRTStdWorkQtyUnitISOCode") ) {
                final Object value = values.remove("PRTStdWorkQtyUnitISOCode");
                if( (value == null) || (!value.equals(getPRTStdWorkQtyUnitISOCode())) ) {
                    setPRTStdWorkQtyUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("PRTStdWorkQtyUnitSAPCode") ) {
                final Object value = values.remove("PRTStdWorkQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getPRTStdWorkQtyUnitSAPCode())) ) {
                    setPRTStdWorkQtyUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("PlannedProdnRsceToolQtyUnit") ) {
                final Object value = values.remove("PlannedProdnRsceToolQtyUnit");
                if( (value == null) || (!value.equals(getPlannedProdnRsceToolQtyUnit())) ) {
                    setPlannedProdnRsceToolQtyUnit(((String) value));
                }
            }
            if( values.containsKey("PlannedTotalProdnRsceToolQty") ) {
                final Object value = values.remove("PlannedTotalProdnRsceToolQty");
                if( (value == null) || (!value.equals(getPlannedTotalProdnRsceToolQty())) ) {
                    setPlannedTotalProdnRsceToolQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlannedPRTQtyUnitISOCode") ) {
                final Object value = values.remove("PlannedPRTQtyUnitISOCode");
                if( (value == null) || (!value.equals(getPlannedPRTQtyUnitISOCode())) ) {
                    setPlannedPRTQtyUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("PlannedPRTQtyUnitSAPCode") ) {
                final Object value = values.remove("PlannedPRTQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getPlannedPRTQtyUnitSAPCode())) ) {
                    setPlannedPRTQtyUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("ConfirmedProdnRsceToolQtyUnit") ) {
                final Object value = values.remove("ConfirmedProdnRsceToolQtyUnit");
                if( (value == null) || (!value.equals(getConfirmedProdnRsceToolQtyUnit())) ) {
                    setConfirmedProdnRsceToolQtyUnit(((String) value));
                }
            }
            if( values.containsKey("ConfirmedProdnRsceToolQty") ) {
                final Object value = values.remove("ConfirmedProdnRsceToolQty");
                if( (value == null) || (!value.equals(getConfirmedProdnRsceToolQty())) ) {
                    setConfirmedProdnRsceToolQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConfirmedPRTQtyUnitISOCode") ) {
                final Object value = values.remove("ConfirmedPRTQtyUnitISOCode");
                if( (value == null) || (!value.equals(getConfirmedPRTQtyUnitISOCode())) ) {
                    setConfirmedPRTQtyUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("ConfirmedPRTQtyUnitSAPCode") ) {
                final Object value = values.remove("ConfirmedPRTQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getConfirmedPRTQtyUnitSAPCode())) ) {
                    setConfirmedPRTQtyUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolUsageQuantityUnit") ) {
                final Object value = values.remove("ProdnRsceToolUsageQuantityUnit");
                if( (value == null) || (!value.equals(getProdnRsceToolUsageQuantityUnit())) ) {
                    setProdnRsceToolUsageQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolUsageQuantity") ) {
                final Object value = values.remove("ProdnRsceToolUsageQuantity");
                if( (value == null) || (!value.equals(getProdnRsceToolUsageQuantity())) ) {
                    setProdnRsceToolUsageQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PRTUsageQtyUnitISOCode") ) {
                final Object value = values.remove("PRTUsageQtyUnitISOCode");
                if( (value == null) || (!value.equals(getPRTUsageQtyUnitISOCode())) ) {
                    setPRTUsageQtyUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("PRTUsageQtyUnitSAPCode") ) {
                final Object value = values.remove("PRTUsageQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getPRTUsageQtyUnitSAPCode())) ) {
                    setPRTUsageQtyUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("PlndProdnRsceToolUsageQtyUnit") ) {
                final Object value = values.remove("PlndProdnRsceToolUsageQtyUnit");
                if( (value == null) || (!value.equals(getPlndProdnRsceToolUsageQtyUnit())) ) {
                    setPlndProdnRsceToolUsageQtyUnit(((String) value));
                }
            }
            if( values.containsKey("PlannedProdnRsceToolUsageQty") ) {
                final Object value = values.remove("PlannedProdnRsceToolUsageQty");
                if( (value == null) || (!value.equals(getPlannedProdnRsceToolUsageQty())) ) {
                    setPlannedProdnRsceToolUsageQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlannedPRTUsageQtyUnitISOCode") ) {
                final Object value = values.remove("PlannedPRTUsageQtyUnitISOCode");
                if( (value == null) || (!value.equals(getPlannedPRTUsageQtyUnitISOCode())) ) {
                    setPlannedPRTUsageQtyUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("PlannedPRTUsageQtyUnitSAPCode") ) {
                final Object value = values.remove("PlannedPRTUsageQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getPlannedPRTUsageQtyUnitSAPCode())) ) {
                    setPlannedPRTUsageQtyUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("ConfdProdnRsceToolUsageQtyUnit") ) {
                final Object value = values.remove("ConfdProdnRsceToolUsageQtyUnit");
                if( (value == null) || (!value.equals(getConfdProdnRsceToolUsageQtyUnit())) ) {
                    setConfdProdnRsceToolUsageQtyUnit(((String) value));
                }
            }
            if( values.containsKey("ConfirmedProdnRsceToolUsageQty") ) {
                final Object value = values.remove("ConfirmedProdnRsceToolUsageQty");
                if( (value == null) || (!value.equals(getConfirmedProdnRsceToolUsageQty())) ) {
                    setConfirmedProdnRsceToolUsageQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConfdPRTUsageQtyUnitISOCode") ) {
                final Object value = values.remove("ConfdPRTUsageQtyUnitISOCode");
                if( (value == null) || (!value.equals(getConfdPRTUsageQtyUnitISOCode())) ) {
                    setConfdPRTUsageQtyUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("ConfdPRTUsageQtyUnitSAPCode") ) {
                final Object value = values.remove("ConfdPRTUsageQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getConfdPRTUsageQtyUnitSAPCode())) ) {
                    setConfdPRTUsageQtyUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolBaseUnit") ) {
                final Object value = values.remove("ProdnRsceToolBaseUnit");
                if( (value == null) || (!value.equals(getProdnRsceToolBaseUnit())) ) {
                    setProdnRsceToolBaseUnit(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolBaseUnitISOCode") ) {
                final Object value = values.remove("ProdnRsceToolBaseUnitISOCode");
                if( (value == null) || (!value.equals(getProdnRsceToolBaseUnitISOCode())) ) {
                    setProdnRsceToolBaseUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("ProdnRsceToolBaseUnitSAPCode") ) {
                final Object value = values.remove("ProdnRsceToolBaseUnitSAPCode");
                if( (value == null) || (!value.equals(getProdnRsceToolBaseUnitSAPCode())) ) {
                    setProdnRsceToolBaseUnitSAPCode(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProcessOrderProdnRsceTools_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ProcessOrderProdnRsceTools_2Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProcessOrderProdnRsceTools_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProcessOrderProdnRsceTools_2Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderV2Service.DEFAULT_SERVICE_PATH);
    }

}
