/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.selectable.ProcessOrder_2Selectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2 ProcessOrder_2} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class ProcessOrder_2ByKeyFluentHelper
    extends
    FluentHelperByKey<ProcessOrder_2ByKeyFluentHelper, ProcessOrder_2, ProcessOrder_2Selectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2 ProcessOrder_2} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProcessOrder_2}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProcessOrder_2}
     * @param manufacturingOrder
     *            Process Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     */
    public ProcessOrder_2ByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String manufacturingOrder )
    {
        super(servicePath, entityCollection);
        this.key.put("ManufacturingOrder", manufacturingOrder);
    }

    @Override
    @Nonnull
    protected Class<ProcessOrder_2> getEntityClass()
    {
        return ProcessOrder_2.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
