/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2 ProcessOrder_2} entity and
 * save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class ProcessOrder_2UpdateFluentHelper
    extends
    FluentHelperUpdate<ProcessOrder_2UpdateFluentHelper, ProcessOrder_2>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2 ProcessOrder_2} entity
     * object that will be updated in the S/4HANA system.
     *
     */
    private final ProcessOrder_2 entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2 ProcessOrder_2} entity
     * on the OData endpoint. To perform execution, call the {@link #executeRequest executeRequest} method on the fluent
     * helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The ProcessOrder_2 to take the updated values from.
     */
    public ProcessOrder_2UpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final ProcessOrder_2 entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected ProcessOrder_2 getEntity()
    {
        return entity;
    }

}
