/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>SchedldProcOrdOpMessage</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SchedldProcOrdOpMessage extends VdmComplex<SchedldProcOrdOpMessage>
{

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *
     * @return Order
     */
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @param orderInternalBillOfOperations
     *
     */
    @SerializedName( "OrderInternalBillOfOperations" )
    @JsonProperty( "OrderInternalBillOfOperations" )
    @Nullable
    @ODataField( odataName = "OrderInternalBillOfOperations" )
    private String orderInternalBillOfOperations;
    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>OrderIntBillOfOperationsItem</b>
     * </p>
     *
     * @param orderIntBillOfOperationsItem
     *
     */
    @SerializedName( "OrderIntBillOfOperationsItem" )
    @JsonProperty( "OrderIntBillOfOperationsItem" )
    @Nullable
    @ODataField( odataName = "OrderIntBillOfOperationsItem" )
    private String orderIntBillOfOperationsItem;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @param manufacturingOrderOperation
     *
     * @return Activity
     */
    @SerializedName( "ManufacturingOrderOperation" )
    @JsonProperty( "ManufacturingOrderOperation" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderOperation" )
    private String manufacturingOrderOperation;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>Message</b>
     * </p>
     *
     * @param message
     *
     */
    @SerializedName( "Message" )
    @JsonProperty( "Message" )
    @Nullable
    @ODataField( odataName = "Message" )
    private String message;

    @Nonnull
    @Override
    public Class<SchedldProcOrdOpMessage> getType()
    {
        return SchedldProcOrdOpMessage.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ManufacturingOrder", getManufacturingOrder());
        values.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        values.put("OrderIntBillOfOperationsItem", getOrderIntBillOfOperationsItem());
        values.put("ManufacturingOrderOperation", getManufacturingOrderOperation());
        values.put("Message", getMessage());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
            if( values.containsKey("OrderInternalBillOfOperations") ) {
                final Object value = values.remove("OrderInternalBillOfOperations");
                if( (value == null) || (!value.equals(getOrderInternalBillOfOperations())) ) {
                    setOrderInternalBillOfOperations(((String) value));
                }
            }
            if( values.containsKey("OrderIntBillOfOperationsItem") ) {
                final Object value = values.remove("OrderIntBillOfOperationsItem");
                if( (value == null) || (!value.equals(getOrderIntBillOfOperationsItem())) ) {
                    setOrderIntBillOfOperationsItem(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderOperation") ) {
                final Object value = values.remove("ManufacturingOrderOperation");
                if( (value == null) || (!value.equals(getManufacturingOrderOperation())) ) {
                    setManufacturingOrderOperation(((String) value));
                }
            }
            if( values.containsKey("Message") ) {
                final Object value = values.remove("Message");
                if( (value == null) || (!value.equals(getMessage())) ) {
                    setMessage(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Order
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @param orderInternalBillOfOperations
     *            The orderInternalBillOfOperations to set.
     */
    public void setOrderInternalBillOfOperations( @Nullable final String orderInternalBillOfOperations )
    {
        rememberChangedField("OrderInternalBillOfOperations", this.orderInternalBillOfOperations);
        this.orderInternalBillOfOperations = orderInternalBillOfOperations;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>OrderIntBillOfOperationsItem</b>
     * </p>
     *
     * @param orderIntBillOfOperationsItem
     *            The orderIntBillOfOperationsItem to set.
     */
    public void setOrderIntBillOfOperationsItem( @Nullable final String orderIntBillOfOperationsItem )
    {
        rememberChangedField("OrderIntBillOfOperationsItem", this.orderIntBillOfOperationsItem);
        this.orderIntBillOfOperationsItem = orderIntBillOfOperationsItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @param manufacturingOrderOperation
     *            Activity
     */
    public void setManufacturingOrderOperation( @Nullable final String manufacturingOrderOperation )
    {
        rememberChangedField("ManufacturingOrderOperation", this.manufacturingOrderOperation);
        this.manufacturingOrderOperation = manufacturingOrderOperation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>Message</b>
     * </p>
     *
     * @param message
     *            The message to set.
     */
    public void setMessage( @Nullable final String message )
    {
        rememberChangedField("Message", this.message);
        this.message = message;
    }

}
