/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ProcessOrderV2ServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderV2Service ProcessOrderV2Service}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultProcessOrderV2ServiceBatch
    extends
    BatchFluentHelperBasic<ProcessOrderV2ServiceBatch, ProcessOrderV2ServiceBatchChangeSet>
    implements
    ProcessOrderV2ServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderV2Service service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultProcessOrderV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProcessOrderV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderV2Service service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderV2Service.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultProcessOrderV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProcessOrderV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderV2Service service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultProcessOrderV2ServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProcessOrderV2ServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultProcessOrderV2ServiceBatchChangeSet(this, service);
    }

}
