/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderComponent_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2;

/**
 * Implementation of the {@link ProcessOrderV2ServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderV2Service ProcessOrderV2Service}.
 *
 */
public class DefaultProcessOrderV2ServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProcessOrderV2ServiceBatch, ProcessOrderV2ServiceBatchChangeSet>
    implements
    ProcessOrderV2ServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderV2Service service;

    @SuppressWarnings( "deprecation" )
    DefaultProcessOrderV2ServiceBatchChangeSet(
        @Nonnull final DefaultProcessOrderV2ServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderV2Service service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProcessOrderV2ServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProcessOrderV2ServiceBatchChangeSet updateProcessOrderComponent_2(
        @Nonnull final ProcessOrderComponent_2 processOrderComponent_2 )
    {
        return addRequestUpdate(service::updateProcessOrderComponent_2, processOrderComponent_2);
    }

    @Nonnull
    @Override
    public ProcessOrderV2ServiceBatchChangeSet createProcessOrder_2( @Nonnull final ProcessOrder_2 processOrder_2 )
    {
        return addRequestCreate(service::createProcessOrder_2, processOrder_2);
    }

    @Nonnull
    @Override
    public ProcessOrderV2ServiceBatchChangeSet updateProcessOrder_2( @Nonnull final ProcessOrder_2 processOrder_2 )
    {
        return addRequestUpdate(service::updateProcessOrder_2, processOrder_2);
    }

}
