/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderComponent_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderV2Service ProcessOrderV2Service}.
 *
 */
public interface ProcessOrderV2ServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ProcessOrderV2ServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ProcessOrderV2ServiceBatch>
{

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderComponent_2
     * ProcessOrderComponent_2} entity and save it to the S/4HANA system.
     *
     * @param processOrderComponent_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderComponent_2
     *            ProcessOrderComponent_2} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProcessOrderV2ServiceBatchChangeSet
        updateProcessOrderComponent_2( @Nonnull final ProcessOrderComponent_2 processOrderComponent_2 );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2
     * ProcessOrder_2} entity and save it to the S/4HANA system.
     *
     * @param processOrder_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2
     *            ProcessOrder_2} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProcessOrderV2ServiceBatchChangeSet createProcessOrder_2( @Nonnull final ProcessOrder_2 processOrder_2 );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2
     * ProcessOrder_2} entity and save it to the S/4HANA system.
     *
     * @param processOrder_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2
     *            ProcessOrder_2} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProcessOrderV2ServiceBatchChangeSet updateProcessOrder_2( @Nonnull final ProcessOrder_2 processOrder_2 );

}
