/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.selectable.ProcessOrderOperation_2Selectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2
 * ProcessOrderOperation_2} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class ProcessOrderOperation_2Link<ObjectT extends VdmObject<?>>
    extends
    EntityLink<ProcessOrderOperation_2Link<ObjectT>, ProcessOrderOperation_2, ObjectT>
    implements
    ProcessOrderOperation_2Selectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public ProcessOrderOperation_2Link( final String fieldName )
    {
        super(fieldName);
    }

    private ProcessOrderOperation_2Link(
        final EntityLink<ProcessOrderOperation_2Link<ObjectT>, ProcessOrderOperation_2, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected ProcessOrderOperation_2Link<ObjectT> translateLinkType(
        final EntityLink<ProcessOrderOperation_2Link<ObjectT>, ProcessOrderOperation_2, ObjectT> link )
    {
        return new ProcessOrderOperation_2Link<ObjectT>(link);
    }

}
