/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2
 * ProcessOrderOperation_2}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.field.ProcessOrderOperation_2Field
 * ProcessOrderOperation_2Field} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.link.ProcessOrderOperation_2Link
 * ProcessOrderOperation_2Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#ORDER_INTERNAL_BILL_OF_OPERATIONS
 * ORDER_INTERNAL_BILL_OF_OPERATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#ORDER_INT_BILL_OF_OPERATIONS_ITEM
 * ORDER_INT_BILL_OF_OPERATIONS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#MANUFACTURING_ORDER_SEQUENCE
 * MANUFACTURING_ORDER_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#MFG_ORDER_SEQUENCE_TEXT
 * MFG_ORDER_SEQUENCE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#MANUFACTURING_ORDER_OPERATION
 * MANUFACTURING_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#MANUFACTURING_ORDER_SUB_OPERATION
 * MANUFACTURING_ORDER_SUB_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#MANUFACTURING_ORDER_CATEGORY
 * MANUFACTURING_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#MANUFACTURING_ORDER_TYPE
 * MANUFACTURING_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#MFG_ORDER_OPERATION_TEXT
 * MFG_ORDER_OPERATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#ORDER_OPERATION_LONG_TEXT
 * ORDER_OPERATION_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#MFG_ORDER_OPERATION_IS_PHASE
 * MFG_ORDER_OPERATION_IS_PHASE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#MFG_ORDER_PHASE_SUPERIOR_OPERATION
 * MFG_ORDER_PHASE_SUPERIOR_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_IS_CREATED
 * OPERATION_IS_CREATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_IS_RELEASED
 * OPERATION_IS_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_IS_PRINTED
 * OPERATION_IS_PRINTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_IS_CONFIRMED
 * OPERATION_IS_CONFIRMED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_IS_PARTIALLY_CONFIRMED
 * OPERATION_IS_PARTIALLY_CONFIRMED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_IS_DELETED
 * OPERATION_IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_IS_TECHLY_COMPLETED
 * OPERATION_IS_TECHLY_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_IS_CLOSED
 * OPERATION_IS_CLOSED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_IS_SCHEDULED
 * OPERATION_IS_SCHEDULED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_IS_PARTIALLY_DELIVERED
 * OPERATION_IS_PARTIALLY_DELIVERED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_IS_DELIVERED
 * OPERATION_IS_DELIVERED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#PRODUCTION_PLANT
 * PRODUCTION_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#WORK_CENTER_INTERNAL_ID
 * WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#WORK_CENTER_TYPE_CODE
 * WORK_CENTER_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_CONTROL_PROFILE
 * OPERATION_CONTROL_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OP_ERLST_SCHEDLD_EXEC_STRT_DTE
 * OP_ERLST_SCHEDLD_EXEC_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OP_ERLST_SCHEDLD_EXEC_STRT_TME
 * OP_ERLST_SCHEDLD_EXEC_STRT_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OP_ERLST_SCHEDLD_EXEC_END_DTE
 * OP_ERLST_SCHEDLD_EXEC_END_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OP_ERLST_SCHEDLD_EXEC_END_TME
 * OP_ERLST_SCHEDLD_EXEC_END_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OP_ACTUAL_EXECUTION_START_DATE
 * OP_ACTUAL_EXECUTION_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OP_ACTUAL_EXECUTION_START_TIME
 * OP_ACTUAL_EXECUTION_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OP_ACTUAL_EXECUTION_END_DATE
 * OP_ACTUAL_EXECUTION_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OP_ACTUAL_EXECUTION_END_TIME
 * OP_ACTUAL_EXECUTION_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#ERLST_SCHEDLD_EXEC_DURN_IN_WORKDAYS
 * ERLST_SCHEDLD_EXEC_DURN_IN_WORKDAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OP_ACTUAL_EXECUTION_DAYS
 * OP_ACTUAL_EXECUTION_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_UNIT
 * OPERATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_UNIT_ISO_CODE
 * OPERATION_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OPERATION_UNIT_SAP_CODE
 * OPERATION_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OP_PLANNED_TOTAL_QUANTITY
 * OP_PLANNED_TOTAL_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#OP_TOTAL_CONFIRMED_YIELD_QTY
 * OP_TOTAL_CONFIRMED_YIELD_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * </ul>
 *
 */
public interface ProcessOrderOperation_2Selectable extends EntitySelectable<ProcessOrderOperation_2>
{

}
