/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.field.ProdAllocCharcMetaDataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.link.ProdAllocCharcMetaDataOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.selectable.ProdAllocCharcMetaDataSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Product Allocation Object Meta Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProdAllocCharcMetaDataType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProdAllocCharcMetaData extends VdmEntity<ProdAllocCharcMetaData>
{

    /**
     * Selector for all available fields of ProdAllocCharcMetaData.
     *
     */
    public final static ProdAllocCharcMetaDataSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicsMetaDataUUID</b>
     * </p>
     *
     * @return Characteristic Meta Data UUID
     */
    @Key
    @SerializedName( "CharacteristicsMetaDataUUID" )
    @JsonProperty( "CharacteristicsMetaDataUUID" )
    @Nullable
    @ODataField( odataName = "CharacteristicsMetaDataUUID" )
    private UUID characteristicsMetaDataUUID;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicsMetaDataUUID</b> field to query operations.
     *
     */
    public final static ProdAllocCharcMetaDataField<UUID> CHARACTERISTICS_META_DATA_UUID =
        new ProdAllocCharcMetaDataField<UUID>("CharacteristicsMetaDataUUID");
    /**
     * Constraints: Not nullable, Maximum length: 83
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicsMetaDataUUID_Text</b>
     * </p>
     *
     * @return Catalog Path Description (83 long for API)
     */
    @SerializedName( "CharacteristicsMetaDataUUID_Text" )
    @JsonProperty( "CharacteristicsMetaDataUUID_Text" )
    @Nullable
    @ODataField( odataName = "CharacteristicsMetaDataUUID_Text" )
    private String characteristicsMetaDataUUID_Text;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicsMetaDataUUID_Text</b> field to query operations.
     *
     */
    public final static ProdAllocCharcMetaDataField<String> CHARACTERISTICS_META_DATA_UUID_TEXT =
        new ProdAllocCharcMetaDataField<String>("CharacteristicsMetaDataUUID_Text");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObjectUUID</b>
     * </p>
     *
     * @return Product Allocation Object UUID
     */
    @SerializedName( "ProductAllocationObjectUUID" )
    @JsonProperty( "ProductAllocationObjectUUID" )
    @Nullable
    @ODataField( odataName = "ProductAllocationObjectUUID" )
    private UUID productAllocationObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationObjectUUID</b> field to query operations.
     *
     */
    public final static ProdAllocCharcMetaDataField<UUID> PRODUCT_ALLOCATION_OBJECT_UUID =
        new ProdAllocCharcMetaDataField<UUID>("ProductAllocationObjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObject</b>
     * </p>
     *
     * @return Product Allocation Object
     */
    @SerializedName( "ProductAllocationObject" )
    @JsonProperty( "ProductAllocationObject" )
    @Nullable
    @ODataField( odataName = "ProductAllocationObject" )
    private String productAllocationObject;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationObject</b> field to query operations.
     *
     */
    public final static ProdAllocCharcMetaDataField<String> PRODUCT_ALLOCATION_OBJECT =
        new ProdAllocCharcMetaDataField<String>("ProductAllocationObject");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocOrdinalNumberValue</b>
     * </p>
     *
     * @return Product Allocation Ordinal Number Value
     */
    @SerializedName( "ProdAllocOrdinalNumberValue" )
    @JsonProperty( "ProdAllocOrdinalNumberValue" )
    @Nullable
    @ODataField( odataName = "ProdAllocOrdinalNumberValue" )
    private Short prodAllocOrdinalNumberValue;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocOrdinalNumberValue</b> field to query operations.
     *
     */
    public final static ProdAllocCharcMetaDataField<Short> PROD_ALLOC_ORDINAL_NUMBER_VALUE =
        new ProdAllocCharcMetaDataField<Short>("ProdAllocOrdinalNumberValue");
    /**
     * Navigation property <b>to_ProdAllocationObjectTP</b> for <b>ProdAllocCharcMetaData</b> to single
     * <b>ProdAllocationObject</b>.
     *
     */
    @SerializedName( "to_ProdAllocationObjectTP" )
    @JsonProperty( "to_ProdAllocationObjectTP" )
    @ODataField( odataName = "to_ProdAllocationObjectTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProdAllocationObject toProdAllocationObjectTP;
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocationObjectTP</b> navigation property to query
     * operations.
     *
     */
    public final static ProdAllocCharcMetaDataOneToOneLink<ProdAllocationObject> TO_PROD_ALLOCATION_OBJECT_TP =
        new ProdAllocCharcMetaDataOneToOneLink<ProdAllocationObject>("to_ProdAllocationObjectTP");

    @Nonnull
    @Override
    public Class<ProdAllocCharcMetaData> getType()
    {
        return ProdAllocCharcMetaData.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicsMetaDataUUID</b>
     * </p>
     *
     * @param characteristicsMetaDataUUID
     *            Characteristic Meta Data UUID
     */
    public void setCharacteristicsMetaDataUUID( @Nullable final UUID characteristicsMetaDataUUID )
    {
        rememberChangedField("CharacteristicsMetaDataUUID", this.characteristicsMetaDataUUID);
        this.characteristicsMetaDataUUID = characteristicsMetaDataUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 83
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicsMetaDataUUID_Text</b>
     * </p>
     *
     * @param characteristicsMetaDataUUID_Text
     *            Catalog Path Description (83 long for API)
     */
    public void setCharacteristicsMetaDataUUID_Text( @Nullable final String characteristicsMetaDataUUID_Text )
    {
        rememberChangedField("CharacteristicsMetaDataUUID_Text", this.characteristicsMetaDataUUID_Text);
        this.characteristicsMetaDataUUID_Text = characteristicsMetaDataUUID_Text;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObjectUUID</b>
     * </p>
     *
     * @param productAllocationObjectUUID
     *            Product Allocation Object UUID
     */
    public void setProductAllocationObjectUUID( @Nullable final UUID productAllocationObjectUUID )
    {
        rememberChangedField("ProductAllocationObjectUUID", this.productAllocationObjectUUID);
        this.productAllocationObjectUUID = productAllocationObjectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObject</b>
     * </p>
     *
     * @param productAllocationObject
     *            Product Allocation Object
     */
    public void setProductAllocationObject( @Nullable final String productAllocationObject )
    {
        rememberChangedField("ProductAllocationObject", this.productAllocationObject);
        this.productAllocationObject = productAllocationObject;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocOrdinalNumberValue</b>
     * </p>
     *
     * @param prodAllocOrdinalNumberValue
     *            Product Allocation Ordinal Number Value
     */
    public void setProdAllocOrdinalNumberValue( @Nullable final Short prodAllocOrdinalNumberValue )
    {
        rememberChangedField("ProdAllocOrdinalNumberValue", this.prodAllocOrdinalNumberValue);
        this.prodAllocOrdinalNumberValue = prodAllocOrdinalNumberValue;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProdAllocCharcMetaData";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CharacteristicsMetaDataUUID", getCharacteristicsMetaDataUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CharacteristicsMetaDataUUID", getCharacteristicsMetaDataUUID());
        values.put("CharacteristicsMetaDataUUID_Text", getCharacteristicsMetaDataUUID_Text());
        values.put("ProductAllocationObjectUUID", getProductAllocationObjectUUID());
        values.put("ProductAllocationObject", getProductAllocationObject());
        values.put("ProdAllocOrdinalNumberValue", getProdAllocOrdinalNumberValue());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CharacteristicsMetaDataUUID") ) {
                final Object value = values.remove("CharacteristicsMetaDataUUID");
                if( (value == null) || (!value.equals(getCharacteristicsMetaDataUUID())) ) {
                    setCharacteristicsMetaDataUUID(((UUID) value));
                }
            }
            if( values.containsKey("CharacteristicsMetaDataUUID_Text") ) {
                final Object value = values.remove("CharacteristicsMetaDataUUID_Text");
                if( (value == null) || (!value.equals(getCharacteristicsMetaDataUUID_Text())) ) {
                    setCharacteristicsMetaDataUUID_Text(((String) value));
                }
            }
            if( values.containsKey("ProductAllocationObjectUUID") ) {
                final Object value = values.remove("ProductAllocationObjectUUID");
                if( (value == null) || (!value.equals(getProductAllocationObjectUUID())) ) {
                    setProductAllocationObjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProductAllocationObject") ) {
                final Object value = values.remove("ProductAllocationObject");
                if( (value == null) || (!value.equals(getProductAllocationObject())) ) {
                    setProductAllocationObject(((String) value));
                }
            }
            if( values.containsKey("ProdAllocOrdinalNumberValue") ) {
                final Object value = values.remove("ProdAllocOrdinalNumberValue");
                if( (value == null) || (!value.equals(getProdAllocOrdinalNumberValue())) ) {
                    setProdAllocOrdinalNumberValue(((Short) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProdAllocationObjectTP") ) {
                final Object value = (values).remove("to_ProdAllocationObjectTP");
                if( value instanceof Map ) {
                    if( toProdAllocationObjectTP == null ) {
                        toProdAllocationObjectTP = new ProdAllocationObject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProdAllocationObjectTP.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProdAllocCharcMetaDataField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProdAllocCharcMetaDataField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProdAllocCharcMetaDataField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProdAllocCharcMetaDataField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationObjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProdAllocationObjectTP != null ) {
            (values).put("to_ProdAllocationObjectTP", toProdAllocationObjectTP);
        }
        return values;
    }

    /**
     * Fetches the <b>ProdAllocationObject</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ProdAllocationObjectTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProdAllocationObject</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProdAllocationObject fetchProdAllocationObjectTP()
    {
        return fetchFieldAsSingle("to_ProdAllocationObjectTP", ProdAllocationObject.class);
    }

    /**
     * Retrieval of associated <b>ProdAllocationObject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProdAllocationObjectTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocationObjectTP</b> of a queried <b>ProdAllocCharcMetaData</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProdAllocationObject</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProdAllocationObject getProdAllocationObjectTPOrFetch()
    {
        if( toProdAllocationObjectTP == null ) {
            toProdAllocationObjectTP = fetchProdAllocationObjectTP();
        }
        return toProdAllocationObjectTP;
    }

    /**
     * Retrieval of associated <b>ProdAllocationObject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProdAllocationObjectTP</b>.
     * <p>
     * If the navigation property for an entity <b>ProdAllocCharcMetaData</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProdAllocationObjectTP</b> is already loaded, the result
     *         will contain the <b>ProdAllocationObject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProdAllocationObject> getProdAllocationObjectTPIfPresent()
    {
        return Option.of(toProdAllocationObjectTP);
    }

    /**
     * Overwrites the associated <b>ProdAllocationObject</b> entity for the loaded navigation property
     * <b>to_ProdAllocationObjectTP</b>.
     *
     * @param value
     *            New <b>ProdAllocationObject</b> entity.
     */
    public void setProdAllocationObjectTP( final ProdAllocationObject value )
    {
        toProdAllocationObjectTP = value;
    }

    /**
     * Helper class to allow for fluent creation of ProdAllocCharcMetaData instances.
     *
     */
    public final static class ProdAllocCharcMetaDataBuilder
    {

        private ProdAllocationObject toProdAllocationObjectTP;

        private ProdAllocCharcMetaData.ProdAllocCharcMetaDataBuilder toProdAllocationObjectTP(
            final ProdAllocationObject value )
        {
            toProdAllocationObjectTP = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProdAllocationObjectTP</b> for <b>ProdAllocCharcMetaData</b> to single
         * <b>ProdAllocationObject</b>.
         *
         * @param value
         *            The ProdAllocationObject to build this ProdAllocCharcMetaData with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdAllocCharcMetaData.ProdAllocCharcMetaDataBuilder prodAllocationObjectTP(
            final ProdAllocationObject value )
        {
            return toProdAllocationObjectTP(value);
        }

    }

}
