/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.field.ProdAllocCharcValCombnField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.link.ProdAllocCharcValCombnLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.link.ProdAllocCharcValCombnOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.selectable.ProdAllocCharcValCombnSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Product Allocation Characteristic Value Combination
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProdAllocCharcValCombnType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProdAllocCharcValCombn extends VdmEntity<ProdAllocCharcValCombn>
{

    /**
     * Selector for all available fields of ProdAllocCharcValCombn.
     *
     */
    public final static ProdAllocCharcValCombnSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DeleteActvCharcValCombination_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "DeleteActvCharcValCombination_ac" )
    @JsonProperty( "DeleteActvCharcValCombination_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DeleteActvCharcValCombination_ac" )
    private Boolean deleteActvCharcValCombination_ac;
    /**
     * Use with available fluent helpers to apply the <b>DeleteActvCharcValCombination_ac</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Boolean> DELETE_ACTV_CHARC_VAL_COMBINATION_AC =
        new ProdAllocCharcValCombnField<Boolean>("DeleteActvCharcValCombination_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SetLifecycleStatusToActive_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "SetLifecycleStatusToActive_ac" )
    @JsonProperty( "SetLifecycleStatusToActive_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SetLifecycleStatusToActive_ac" )
    private Boolean setLifecycleStatusToActive_ac;
    /**
     * Use with available fluent helpers to apply the <b>SetLifecycleStatusToActive_ac</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Boolean> SET_LIFECYCLE_STATUS_TO_ACTIVE_AC =
        new ProdAllocCharcValCombnField<Boolean>("SetLifecycleStatusToActive_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SetLifecycleStatusToInactive_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "SetLifecycleStatusToInactive_ac" )
    @JsonProperty( "SetLifecycleStatusToInactive_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SetLifecycleStatusToInactive_ac" )
    private Boolean setLifecycleStatusToInactive_ac;
    /**
     * Use with available fluent helpers to apply the <b>SetLifecycleStatusToInactive_ac</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Boolean> SET_LIFECYCLE_STATUS_TO_INACTIVE_AC =
        new ProdAllocCharcValCombnField<Boolean>("SetLifecycleStatusToInactive_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc01_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProdAllocCharc01_fc" )
    @JsonProperty( "ProdAllocCharc01_fc" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc01_fc" )
    private Short prodAllocCharc01_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc01_fc</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Short> PROD_ALLOC_CHARC01_FC =
        new ProdAllocCharcValCombnField<Short>("ProdAllocCharc01_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc02_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProdAllocCharc02_fc" )
    @JsonProperty( "ProdAllocCharc02_fc" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc02_fc" )
    private Short prodAllocCharc02_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc02_fc</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Short> PROD_ALLOC_CHARC02_FC =
        new ProdAllocCharcValCombnField<Short>("ProdAllocCharc02_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc03_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProdAllocCharc03_fc" )
    @JsonProperty( "ProdAllocCharc03_fc" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc03_fc" )
    private Short prodAllocCharc03_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc03_fc</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Short> PROD_ALLOC_CHARC03_FC =
        new ProdAllocCharcValCombnField<Short>("ProdAllocCharc03_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc04_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProdAllocCharc04_fc" )
    @JsonProperty( "ProdAllocCharc04_fc" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc04_fc" )
    private Short prodAllocCharc04_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc04_fc</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Short> PROD_ALLOC_CHARC04_FC =
        new ProdAllocCharcValCombnField<Short>("ProdAllocCharc04_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc05_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProdAllocCharc05_fc" )
    @JsonProperty( "ProdAllocCharc05_fc" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc05_fc" )
    private Short prodAllocCharc05_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc05_fc</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Short> PROD_ALLOC_CHARC05_FC =
        new ProdAllocCharcValCombnField<Short>("ProdAllocCharc05_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc06_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProdAllocCharc06_fc" )
    @JsonProperty( "ProdAllocCharc06_fc" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc06_fc" )
    private Short prodAllocCharc06_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc06_fc</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Short> PROD_ALLOC_CHARC06_FC =
        new ProdAllocCharcValCombnField<Short>("ProdAllocCharc06_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc07_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProdAllocCharc07_fc" )
    @JsonProperty( "ProdAllocCharc07_fc" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc07_fc" )
    private Short prodAllocCharc07_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc07_fc</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Short> PROD_ALLOC_CHARC07_FC =
        new ProdAllocCharcValCombnField<Short>("ProdAllocCharc07_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc08_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProdAllocCharc08_fc" )
    @JsonProperty( "ProdAllocCharc08_fc" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc08_fc" )
    private Short prodAllocCharc08_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc08_fc</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Short> PROD_ALLOC_CHARC08_FC =
        new ProdAllocCharcValCombnField<Short>("ProdAllocCharc08_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc09_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProdAllocCharc09_fc" )
    @JsonProperty( "ProdAllocCharc09_fc" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc09_fc" )
    private Short prodAllocCharc09_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc09_fc</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Short> PROD_ALLOC_CHARC09_FC =
        new ProdAllocCharcValCombnField<Short>("ProdAllocCharc09_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc10_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProdAllocCharc10_fc" )
    @JsonProperty( "ProdAllocCharc10_fc" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc10_fc" )
    private Short prodAllocCharc10_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc10_fc</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Short> PROD_ALLOC_CHARC10_FC =
        new ProdAllocCharcValCombnField<Short>("ProdAllocCharc10_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Boolean> UPDATE_MC =
        new ProdAllocCharcValCombnField<Boolean>("Update_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ProdAllocObjTimeSeriesTP_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ProdAllocObjTimeSeriesTP_oc" )
    @JsonProperty( "to_ProdAllocObjTimeSeriesTP_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ProdAllocObjTimeSeriesTP_oc" )
    private Boolean prodAllocObjTimeSeriesTP_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocObjTimeSeriesTP_oc</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<Boolean> PROD_ALLOC_OBJ_TIME_SERIES_TP_OC =
        new ProdAllocCharcValCombnField<Boolean>("to_ProdAllocObjTimeSeriesTP_oc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueCombinationUUID</b>
     * </p>
     *
     * @return Characteristic Value Combination UUID
     */
    @Key
    @SerializedName( "CharcValueCombinationUUID" )
    @JsonProperty( "CharcValueCombinationUUID" )
    @Nullable
    @ODataField( odataName = "CharcValueCombinationUUID" )
    private UUID charcValueCombinationUUID;
    /**
     * Use with available fluent helpers to apply the <b>CharcValueCombinationUUID</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<UUID> CHARC_VALUE_COMBINATION_UUID =
        new ProdAllocCharcValCombnField<UUID>("CharcValueCombinationUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObjectUUID</b>
     * </p>
     *
     * @return Product Allocation Object UUID
     */
    @SerializedName( "ProductAllocationObjectUUID" )
    @JsonProperty( "ProductAllocationObjectUUID" )
    @Nullable
    @ODataField( odataName = "ProductAllocationObjectUUID" )
    private UUID productAllocationObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationObjectUUID</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<UUID> PRODUCT_ALLOCATION_OBJECT_UUID =
        new ProdAllocCharcValCombnField<UUID>("ProductAllocationObjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObject</b>
     * </p>
     *
     * @return Product Allocation Object
     */
    @SerializedName( "ProductAllocationObject" )
    @JsonProperty( "ProductAllocationObject" )
    @Nullable
    @ODataField( odataName = "ProductAllocationObject" )
    private String productAllocationObject;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationObject</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> PRODUCT_ALLOCATION_OBJECT =
        new ProdAllocCharcValCombnField<String>("ProductAllocationObject");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc01</b>
     * </p>
     *
     * @return Product Allocation Characteristic 1
     */
    @SerializedName( "ProdAllocCharc01" )
    @JsonProperty( "ProdAllocCharc01" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc01" )
    private String prodAllocCharc01;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc01</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> PROD_ALLOC_CHARC01 =
        new ProdAllocCharcValCombnField<String>("ProdAllocCharc01");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc02</b>
     * </p>
     *
     * @return Product Allocation Characteristic 2
     */
    @SerializedName( "ProdAllocCharc02" )
    @JsonProperty( "ProdAllocCharc02" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc02" )
    private String prodAllocCharc02;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc02</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> PROD_ALLOC_CHARC02 =
        new ProdAllocCharcValCombnField<String>("ProdAllocCharc02");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc03</b>
     * </p>
     *
     * @return Product Allocation Characteristic 3
     */
    @SerializedName( "ProdAllocCharc03" )
    @JsonProperty( "ProdAllocCharc03" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc03" )
    private String prodAllocCharc03;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc03</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> PROD_ALLOC_CHARC03 =
        new ProdAllocCharcValCombnField<String>("ProdAllocCharc03");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc04</b>
     * </p>
     *
     * @return Product Allocation Characteristic 4
     */
    @SerializedName( "ProdAllocCharc04" )
    @JsonProperty( "ProdAllocCharc04" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc04" )
    private String prodAllocCharc04;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc04</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> PROD_ALLOC_CHARC04 =
        new ProdAllocCharcValCombnField<String>("ProdAllocCharc04");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc05</b>
     * </p>
     *
     * @return Product Allocation Characteristic 5
     */
    @SerializedName( "ProdAllocCharc05" )
    @JsonProperty( "ProdAllocCharc05" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc05" )
    private String prodAllocCharc05;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc05</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> PROD_ALLOC_CHARC05 =
        new ProdAllocCharcValCombnField<String>("ProdAllocCharc05");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc06</b>
     * </p>
     *
     * @return Product Allocation Characteristic 6
     */
    @SerializedName( "ProdAllocCharc06" )
    @JsonProperty( "ProdAllocCharc06" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc06" )
    private String prodAllocCharc06;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc06</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> PROD_ALLOC_CHARC06 =
        new ProdAllocCharcValCombnField<String>("ProdAllocCharc06");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc07</b>
     * </p>
     *
     * @return Product Allocation Characteristic 7
     */
    @SerializedName( "ProdAllocCharc07" )
    @JsonProperty( "ProdAllocCharc07" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc07" )
    private String prodAllocCharc07;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc07</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> PROD_ALLOC_CHARC07 =
        new ProdAllocCharcValCombnField<String>("ProdAllocCharc07");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc08</b>
     * </p>
     *
     * @return Product Allocation Characteristic 8
     */
    @SerializedName( "ProdAllocCharc08" )
    @JsonProperty( "ProdAllocCharc08" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc08" )
    private String prodAllocCharc08;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc08</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> PROD_ALLOC_CHARC08 =
        new ProdAllocCharcValCombnField<String>("ProdAllocCharc08");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc09</b>
     * </p>
     *
     * @return Product Allocation Characteristic 9
     */
    @SerializedName( "ProdAllocCharc09" )
    @JsonProperty( "ProdAllocCharc09" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc09" )
    private String prodAllocCharc09;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc09</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> PROD_ALLOC_CHARC09 =
        new ProdAllocCharcValCombnField<String>("ProdAllocCharc09");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc10</b>
     * </p>
     *
     * @return Product Allocation Characteristic 10
     */
    @SerializedName( "ProdAllocCharc10" )
    @JsonProperty( "ProdAllocCharc10" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharc10" )
    private String prodAllocCharc10;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharc10</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> PROD_ALLOC_CHARC10 =
        new ProdAllocCharcValCombnField<String>("ProdAllocCharc10");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharcValueCombnCmnt</b>
     * </p>
     *
     * @return Product Allocation Characteristic Value Combination Comment
     */
    @SerializedName( "ProdAllocCharcValueCombnCmnt" )
    @JsonProperty( "ProdAllocCharcValueCombnCmnt" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharcValueCombnCmnt" )
    private String prodAllocCharcValueCombnCmnt;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharcValueCombnCmnt</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> PROD_ALLOC_CHARC_VALUE_COMBN_CMNT =
        new ProdAllocCharcValCombnField<String>("ProdAllocCharcValueCombnCmnt");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharcConstraintStatus</b>
     * </p>
     *
     * @return Product Allocation Characteristic Constraint Status
     */
    @SerializedName( "ProdAllocCharcConstraintStatus" )
    @JsonProperty( "ProdAllocCharcConstraintStatus" )
    @Nullable
    @ODataField( odataName = "ProdAllocCharcConstraintStatus" )
    private String prodAllocCharcConstraintStatus;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCharcConstraintStatus</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> PROD_ALLOC_CHARC_CONSTRAINT_STATUS =
        new ProdAllocCharcValCombnField<String>("ProdAllocCharcConstraintStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocationActivationStatus</b>
     * </p>
     *
     * @return Product Allocation Activation Status
     */
    @SerializedName( "ProdAllocationActivationStatus" )
    @JsonProperty( "ProdAllocationActivationStatus" )
    @Nullable
    @ODataField( odataName = "ProdAllocationActivationStatus" )
    private String prodAllocationActivationStatus;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocationActivationStatus</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> PROD_ALLOCATION_ACTIVATION_STATUS =
        new ProdAllocCharcValCombnField<String>("ProdAllocationActivationStatus");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CharcValAuthznGroup</b>
     * </p>
     *
     * @return Characteristic Value Authorization Group
     */
    @SerializedName( "CharcValAuthznGroup" )
    @JsonProperty( "CharcValAuthznGroup" )
    @Nullable
    @ODataField( odataName = "CharcValAuthznGroup" )
    private String charcValAuthznGroup;
    /**
     * Use with available fluent helpers to apply the <b>CharcValAuthznGroup</b> field to query operations.
     *
     */
    public final static ProdAllocCharcValCombnField<String> CHARC_VAL_AUTHZN_GROUP =
        new ProdAllocCharcValCombnField<String>("CharcValAuthznGroup");
    /**
     * Navigation property <b>to_ProdAllocationObjectTP</b> for <b>ProdAllocCharcValCombn</b> to single
     * <b>ProdAllocationObject</b>.
     *
     */
    @SerializedName( "to_ProdAllocationObjectTP" )
    @JsonProperty( "to_ProdAllocationObjectTP" )
    @ODataField( odataName = "to_ProdAllocationObjectTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProdAllocationObject toProdAllocationObjectTP;
    /**
     * Navigation property <b>to_ProdAllocObjTimeSeriesTP</b> for <b>ProdAllocCharcValCombn</b> to multiple
     * <b>ProdAllocObjTimeSeries</b>.
     *
     */
    @SerializedName( "to_ProdAllocObjTimeSeriesTP" )
    @JsonProperty( "to_ProdAllocObjTimeSeriesTP" )
    @ODataField( odataName = "to_ProdAllocObjTimeSeriesTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProdAllocObjTimeSeries> toProdAllocObjTimeSeriesTP;
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocationObjectTP</b> navigation property to query
     * operations.
     *
     */
    public final static ProdAllocCharcValCombnOneToOneLink<ProdAllocationObject> TO_PROD_ALLOCATION_OBJECT_TP =
        new ProdAllocCharcValCombnOneToOneLink<ProdAllocationObject>("to_ProdAllocationObjectTP");
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocObjTimeSeriesTP</b> navigation property to query
     * operations.
     *
     */
    public final static ProdAllocCharcValCombnLink<ProdAllocObjTimeSeries> TO_PROD_ALLOC_OBJ_TIME_SERIES_TP =
        new ProdAllocCharcValCombnLink<ProdAllocObjTimeSeries>("to_ProdAllocObjTimeSeriesTP");

    @Nonnull
    @Override
    public Class<ProdAllocCharcValCombn> getType()
    {
        return ProdAllocCharcValCombn.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DeleteActvCharcValCombination_ac</b>
     * </p>
     *
     * @param deleteActvCharcValCombination_ac
     *            Dyn. Action Control
     */
    public void setDeleteActvCharcValCombination_ac( @Nullable final Boolean deleteActvCharcValCombination_ac )
    {
        rememberChangedField("DeleteActvCharcValCombination_ac", this.deleteActvCharcValCombination_ac);
        this.deleteActvCharcValCombination_ac = deleteActvCharcValCombination_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SetLifecycleStatusToActive_ac</b>
     * </p>
     *
     * @param setLifecycleStatusToActive_ac
     *            Dyn. Action Control
     */
    public void setSetLifecycleStatusToActive_ac( @Nullable final Boolean setLifecycleStatusToActive_ac )
    {
        rememberChangedField("SetLifecycleStatusToActive_ac", this.setLifecycleStatusToActive_ac);
        this.setLifecycleStatusToActive_ac = setLifecycleStatusToActive_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SetLifecycleStatusToInactive_ac</b>
     * </p>
     *
     * @param setLifecycleStatusToInactive_ac
     *            Dyn. Action Control
     */
    public void setSetLifecycleStatusToInactive_ac( @Nullable final Boolean setLifecycleStatusToInactive_ac )
    {
        rememberChangedField("SetLifecycleStatusToInactive_ac", this.setLifecycleStatusToInactive_ac);
        this.setLifecycleStatusToInactive_ac = setLifecycleStatusToInactive_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc01_fc</b>
     * </p>
     *
     * @param prodAllocCharc01_fc
     *            Dyn. Field Control
     */
    public void setProdAllocCharc01_fc( @Nullable final Short prodAllocCharc01_fc )
    {
        rememberChangedField("ProdAllocCharc01_fc", this.prodAllocCharc01_fc);
        this.prodAllocCharc01_fc = prodAllocCharc01_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc02_fc</b>
     * </p>
     *
     * @param prodAllocCharc02_fc
     *            Dyn. Field Control
     */
    public void setProdAllocCharc02_fc( @Nullable final Short prodAllocCharc02_fc )
    {
        rememberChangedField("ProdAllocCharc02_fc", this.prodAllocCharc02_fc);
        this.prodAllocCharc02_fc = prodAllocCharc02_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc03_fc</b>
     * </p>
     *
     * @param prodAllocCharc03_fc
     *            Dyn. Field Control
     */
    public void setProdAllocCharc03_fc( @Nullable final Short prodAllocCharc03_fc )
    {
        rememberChangedField("ProdAllocCharc03_fc", this.prodAllocCharc03_fc);
        this.prodAllocCharc03_fc = prodAllocCharc03_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc04_fc</b>
     * </p>
     *
     * @param prodAllocCharc04_fc
     *            Dyn. Field Control
     */
    public void setProdAllocCharc04_fc( @Nullable final Short prodAllocCharc04_fc )
    {
        rememberChangedField("ProdAllocCharc04_fc", this.prodAllocCharc04_fc);
        this.prodAllocCharc04_fc = prodAllocCharc04_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc05_fc</b>
     * </p>
     *
     * @param prodAllocCharc05_fc
     *            Dyn. Field Control
     */
    public void setProdAllocCharc05_fc( @Nullable final Short prodAllocCharc05_fc )
    {
        rememberChangedField("ProdAllocCharc05_fc", this.prodAllocCharc05_fc);
        this.prodAllocCharc05_fc = prodAllocCharc05_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc06_fc</b>
     * </p>
     *
     * @param prodAllocCharc06_fc
     *            Dyn. Field Control
     */
    public void setProdAllocCharc06_fc( @Nullable final Short prodAllocCharc06_fc )
    {
        rememberChangedField("ProdAllocCharc06_fc", this.prodAllocCharc06_fc);
        this.prodAllocCharc06_fc = prodAllocCharc06_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc07_fc</b>
     * </p>
     *
     * @param prodAllocCharc07_fc
     *            Dyn. Field Control
     */
    public void setProdAllocCharc07_fc( @Nullable final Short prodAllocCharc07_fc )
    {
        rememberChangedField("ProdAllocCharc07_fc", this.prodAllocCharc07_fc);
        this.prodAllocCharc07_fc = prodAllocCharc07_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc08_fc</b>
     * </p>
     *
     * @param prodAllocCharc08_fc
     *            Dyn. Field Control
     */
    public void setProdAllocCharc08_fc( @Nullable final Short prodAllocCharc08_fc )
    {
        rememberChangedField("ProdAllocCharc08_fc", this.prodAllocCharc08_fc);
        this.prodAllocCharc08_fc = prodAllocCharc08_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc09_fc</b>
     * </p>
     *
     * @param prodAllocCharc09_fc
     *            Dyn. Field Control
     */
    public void setProdAllocCharc09_fc( @Nullable final Short prodAllocCharc09_fc )
    {
        rememberChangedField("ProdAllocCharc09_fc", this.prodAllocCharc09_fc);
        this.prodAllocCharc09_fc = prodAllocCharc09_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc10_fc</b>
     * </p>
     *
     * @param prodAllocCharc10_fc
     *            Dyn. Field Control
     */
    public void setProdAllocCharc10_fc( @Nullable final Short prodAllocCharc10_fc )
    {
        rememberChangedField("ProdAllocCharc10_fc", this.prodAllocCharc10_fc);
        this.prodAllocCharc10_fc = prodAllocCharc10_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ProdAllocObjTimeSeriesTP_oc</b>
     * </p>
     *
     * @param prodAllocObjTimeSeriesTP_oc
     *            Dynamic CbA-Control
     */
    public void setProdAllocObjTimeSeriesTP_oc( @Nullable final Boolean prodAllocObjTimeSeriesTP_oc )
    {
        rememberChangedField("to_ProdAllocObjTimeSeriesTP_oc", this.prodAllocObjTimeSeriesTP_oc);
        this.prodAllocObjTimeSeriesTP_oc = prodAllocObjTimeSeriesTP_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueCombinationUUID</b>
     * </p>
     *
     * @param charcValueCombinationUUID
     *            Characteristic Value Combination UUID
     */
    public void setCharcValueCombinationUUID( @Nullable final UUID charcValueCombinationUUID )
    {
        rememberChangedField("CharcValueCombinationUUID", this.charcValueCombinationUUID);
        this.charcValueCombinationUUID = charcValueCombinationUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObjectUUID</b>
     * </p>
     *
     * @param productAllocationObjectUUID
     *            Product Allocation Object UUID
     */
    public void setProductAllocationObjectUUID( @Nullable final UUID productAllocationObjectUUID )
    {
        rememberChangedField("ProductAllocationObjectUUID", this.productAllocationObjectUUID);
        this.productAllocationObjectUUID = productAllocationObjectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObject</b>
     * </p>
     *
     * @param productAllocationObject
     *            Product Allocation Object
     */
    public void setProductAllocationObject( @Nullable final String productAllocationObject )
    {
        rememberChangedField("ProductAllocationObject", this.productAllocationObject);
        this.productAllocationObject = productAllocationObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc01</b>
     * </p>
     *
     * @param prodAllocCharc01
     *            Product Allocation Characteristic 1
     */
    public void setProdAllocCharc01( @Nullable final String prodAllocCharc01 )
    {
        rememberChangedField("ProdAllocCharc01", this.prodAllocCharc01);
        this.prodAllocCharc01 = prodAllocCharc01;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc02</b>
     * </p>
     *
     * @param prodAllocCharc02
     *            Product Allocation Characteristic 2
     */
    public void setProdAllocCharc02( @Nullable final String prodAllocCharc02 )
    {
        rememberChangedField("ProdAllocCharc02", this.prodAllocCharc02);
        this.prodAllocCharc02 = prodAllocCharc02;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc03</b>
     * </p>
     *
     * @param prodAllocCharc03
     *            Product Allocation Characteristic 3
     */
    public void setProdAllocCharc03( @Nullable final String prodAllocCharc03 )
    {
        rememberChangedField("ProdAllocCharc03", this.prodAllocCharc03);
        this.prodAllocCharc03 = prodAllocCharc03;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc04</b>
     * </p>
     *
     * @param prodAllocCharc04
     *            Product Allocation Characteristic 4
     */
    public void setProdAllocCharc04( @Nullable final String prodAllocCharc04 )
    {
        rememberChangedField("ProdAllocCharc04", this.prodAllocCharc04);
        this.prodAllocCharc04 = prodAllocCharc04;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc05</b>
     * </p>
     *
     * @param prodAllocCharc05
     *            Product Allocation Characteristic 5
     */
    public void setProdAllocCharc05( @Nullable final String prodAllocCharc05 )
    {
        rememberChangedField("ProdAllocCharc05", this.prodAllocCharc05);
        this.prodAllocCharc05 = prodAllocCharc05;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc06</b>
     * </p>
     *
     * @param prodAllocCharc06
     *            Product Allocation Characteristic 6
     */
    public void setProdAllocCharc06( @Nullable final String prodAllocCharc06 )
    {
        rememberChangedField("ProdAllocCharc06", this.prodAllocCharc06);
        this.prodAllocCharc06 = prodAllocCharc06;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc07</b>
     * </p>
     *
     * @param prodAllocCharc07
     *            Product Allocation Characteristic 7
     */
    public void setProdAllocCharc07( @Nullable final String prodAllocCharc07 )
    {
        rememberChangedField("ProdAllocCharc07", this.prodAllocCharc07);
        this.prodAllocCharc07 = prodAllocCharc07;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc08</b>
     * </p>
     *
     * @param prodAllocCharc08
     *            Product Allocation Characteristic 8
     */
    public void setProdAllocCharc08( @Nullable final String prodAllocCharc08 )
    {
        rememberChangedField("ProdAllocCharc08", this.prodAllocCharc08);
        this.prodAllocCharc08 = prodAllocCharc08;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc09</b>
     * </p>
     *
     * @param prodAllocCharc09
     *            Product Allocation Characteristic 9
     */
    public void setProdAllocCharc09( @Nullable final String prodAllocCharc09 )
    {
        rememberChangedField("ProdAllocCharc09", this.prodAllocCharc09);
        this.prodAllocCharc09 = prodAllocCharc09;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharc10</b>
     * </p>
     *
     * @param prodAllocCharc10
     *            Product Allocation Characteristic 10
     */
    public void setProdAllocCharc10( @Nullable final String prodAllocCharc10 )
    {
        rememberChangedField("ProdAllocCharc10", this.prodAllocCharc10);
        this.prodAllocCharc10 = prodAllocCharc10;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharcValueCombnCmnt</b>
     * </p>
     *
     * @param prodAllocCharcValueCombnCmnt
     *            Product Allocation Characteristic Value Combination Comment
     */
    public void setProdAllocCharcValueCombnCmnt( @Nullable final String prodAllocCharcValueCombnCmnt )
    {
        rememberChangedField("ProdAllocCharcValueCombnCmnt", this.prodAllocCharcValueCombnCmnt);
        this.prodAllocCharcValueCombnCmnt = prodAllocCharcValueCombnCmnt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCharcConstraintStatus</b>
     * </p>
     *
     * @param prodAllocCharcConstraintStatus
     *            Product Allocation Characteristic Constraint Status
     */
    public void setProdAllocCharcConstraintStatus( @Nullable final String prodAllocCharcConstraintStatus )
    {
        rememberChangedField("ProdAllocCharcConstraintStatus", this.prodAllocCharcConstraintStatus);
        this.prodAllocCharcConstraintStatus = prodAllocCharcConstraintStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocationActivationStatus</b>
     * </p>
     *
     * @param prodAllocationActivationStatus
     *            Product Allocation Activation Status
     */
    public void setProdAllocationActivationStatus( @Nullable final String prodAllocationActivationStatus )
    {
        rememberChangedField("ProdAllocationActivationStatus", this.prodAllocationActivationStatus);
        this.prodAllocationActivationStatus = prodAllocationActivationStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CharcValAuthznGroup</b>
     * </p>
     *
     * @param charcValAuthznGroup
     *            Characteristic Value Authorization Group
     */
    public void setCharcValAuthznGroup( @Nullable final String charcValAuthznGroup )
    {
        rememberChangedField("CharcValAuthznGroup", this.charcValAuthznGroup);
        this.charcValAuthznGroup = charcValAuthznGroup;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProdAllocCharcValCombn";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CharcValueCombinationUUID", getCharcValueCombinationUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DeleteActvCharcValCombination_ac", getDeleteActvCharcValCombination_ac());
        values.put("SetLifecycleStatusToActive_ac", getSetLifecycleStatusToActive_ac());
        values.put("SetLifecycleStatusToInactive_ac", getSetLifecycleStatusToInactive_ac());
        values.put("ProdAllocCharc01_fc", getProdAllocCharc01_fc());
        values.put("ProdAllocCharc02_fc", getProdAllocCharc02_fc());
        values.put("ProdAllocCharc03_fc", getProdAllocCharc03_fc());
        values.put("ProdAllocCharc04_fc", getProdAllocCharc04_fc());
        values.put("ProdAllocCharc05_fc", getProdAllocCharc05_fc());
        values.put("ProdAllocCharc06_fc", getProdAllocCharc06_fc());
        values.put("ProdAllocCharc07_fc", getProdAllocCharc07_fc());
        values.put("ProdAllocCharc08_fc", getProdAllocCharc08_fc());
        values.put("ProdAllocCharc09_fc", getProdAllocCharc09_fc());
        values.put("ProdAllocCharc10_fc", getProdAllocCharc10_fc());
        values.put("Update_mc", getUpdate_mc());
        values.put("to_ProdAllocObjTimeSeriesTP_oc", getProdAllocObjTimeSeriesTP_oc());
        values.put("CharcValueCombinationUUID", getCharcValueCombinationUUID());
        values.put("ProductAllocationObjectUUID", getProductAllocationObjectUUID());
        values.put("ProductAllocationObject", getProductAllocationObject());
        values.put("ProdAllocCharc01", getProdAllocCharc01());
        values.put("ProdAllocCharc02", getProdAllocCharc02());
        values.put("ProdAllocCharc03", getProdAllocCharc03());
        values.put("ProdAllocCharc04", getProdAllocCharc04());
        values.put("ProdAllocCharc05", getProdAllocCharc05());
        values.put("ProdAllocCharc06", getProdAllocCharc06());
        values.put("ProdAllocCharc07", getProdAllocCharc07());
        values.put("ProdAllocCharc08", getProdAllocCharc08());
        values.put("ProdAllocCharc09", getProdAllocCharc09());
        values.put("ProdAllocCharc10", getProdAllocCharc10());
        values.put("ProdAllocCharcValueCombnCmnt", getProdAllocCharcValueCombnCmnt());
        values.put("ProdAllocCharcConstraintStatus", getProdAllocCharcConstraintStatus());
        values.put("ProdAllocationActivationStatus", getProdAllocationActivationStatus());
        values.put("CharcValAuthznGroup", getCharcValAuthznGroup());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DeleteActvCharcValCombination_ac") ) {
                final Object value = values.remove("DeleteActvCharcValCombination_ac");
                if( (value == null) || (!value.equals(getDeleteActvCharcValCombination_ac())) ) {
                    setDeleteActvCharcValCombination_ac(((Boolean) value));
                }
            }
            if( values.containsKey("SetLifecycleStatusToActive_ac") ) {
                final Object value = values.remove("SetLifecycleStatusToActive_ac");
                if( (value == null) || (!value.equals(getSetLifecycleStatusToActive_ac())) ) {
                    setSetLifecycleStatusToActive_ac(((Boolean) value));
                }
            }
            if( values.containsKey("SetLifecycleStatusToInactive_ac") ) {
                final Object value = values.remove("SetLifecycleStatusToInactive_ac");
                if( (value == null) || (!value.equals(getSetLifecycleStatusToInactive_ac())) ) {
                    setSetLifecycleStatusToInactive_ac(((Boolean) value));
                }
            }
            if( values.containsKey("ProdAllocCharc01_fc") ) {
                final Object value = values.remove("ProdAllocCharc01_fc");
                if( (value == null) || (!value.equals(getProdAllocCharc01_fc())) ) {
                    setProdAllocCharc01_fc(((Short) value));
                }
            }
            if( values.containsKey("ProdAllocCharc02_fc") ) {
                final Object value = values.remove("ProdAllocCharc02_fc");
                if( (value == null) || (!value.equals(getProdAllocCharc02_fc())) ) {
                    setProdAllocCharc02_fc(((Short) value));
                }
            }
            if( values.containsKey("ProdAllocCharc03_fc") ) {
                final Object value = values.remove("ProdAllocCharc03_fc");
                if( (value == null) || (!value.equals(getProdAllocCharc03_fc())) ) {
                    setProdAllocCharc03_fc(((Short) value));
                }
            }
            if( values.containsKey("ProdAllocCharc04_fc") ) {
                final Object value = values.remove("ProdAllocCharc04_fc");
                if( (value == null) || (!value.equals(getProdAllocCharc04_fc())) ) {
                    setProdAllocCharc04_fc(((Short) value));
                }
            }
            if( values.containsKey("ProdAllocCharc05_fc") ) {
                final Object value = values.remove("ProdAllocCharc05_fc");
                if( (value == null) || (!value.equals(getProdAllocCharc05_fc())) ) {
                    setProdAllocCharc05_fc(((Short) value));
                }
            }
            if( values.containsKey("ProdAllocCharc06_fc") ) {
                final Object value = values.remove("ProdAllocCharc06_fc");
                if( (value == null) || (!value.equals(getProdAllocCharc06_fc())) ) {
                    setProdAllocCharc06_fc(((Short) value));
                }
            }
            if( values.containsKey("ProdAllocCharc07_fc") ) {
                final Object value = values.remove("ProdAllocCharc07_fc");
                if( (value == null) || (!value.equals(getProdAllocCharc07_fc())) ) {
                    setProdAllocCharc07_fc(((Short) value));
                }
            }
            if( values.containsKey("ProdAllocCharc08_fc") ) {
                final Object value = values.remove("ProdAllocCharc08_fc");
                if( (value == null) || (!value.equals(getProdAllocCharc08_fc())) ) {
                    setProdAllocCharc08_fc(((Short) value));
                }
            }
            if( values.containsKey("ProdAllocCharc09_fc") ) {
                final Object value = values.remove("ProdAllocCharc09_fc");
                if( (value == null) || (!value.equals(getProdAllocCharc09_fc())) ) {
                    setProdAllocCharc09_fc(((Short) value));
                }
            }
            if( values.containsKey("ProdAllocCharc10_fc") ) {
                final Object value = values.remove("ProdAllocCharc10_fc");
                if( (value == null) || (!value.equals(getProdAllocCharc10_fc())) ) {
                    setProdAllocCharc10_fc(((Short) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ProdAllocObjTimeSeriesTP_oc") ) {
                final Object value = values.remove("to_ProdAllocObjTimeSeriesTP_oc");
                if( (value == null) || (!value.equals(getProdAllocObjTimeSeriesTP_oc())) ) {
                    setProdAllocObjTimeSeriesTP_oc(((Boolean) value));
                }
            }
            if( values.containsKey("CharcValueCombinationUUID") ) {
                final Object value = values.remove("CharcValueCombinationUUID");
                if( (value == null) || (!value.equals(getCharcValueCombinationUUID())) ) {
                    setCharcValueCombinationUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProductAllocationObjectUUID") ) {
                final Object value = values.remove("ProductAllocationObjectUUID");
                if( (value == null) || (!value.equals(getProductAllocationObjectUUID())) ) {
                    setProductAllocationObjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProductAllocationObject") ) {
                final Object value = values.remove("ProductAllocationObject");
                if( (value == null) || (!value.equals(getProductAllocationObject())) ) {
                    setProductAllocationObject(((String) value));
                }
            }
            if( values.containsKey("ProdAllocCharc01") ) {
                final Object value = values.remove("ProdAllocCharc01");
                if( (value == null) || (!value.equals(getProdAllocCharc01())) ) {
                    setProdAllocCharc01(((String) value));
                }
            }
            if( values.containsKey("ProdAllocCharc02") ) {
                final Object value = values.remove("ProdAllocCharc02");
                if( (value == null) || (!value.equals(getProdAllocCharc02())) ) {
                    setProdAllocCharc02(((String) value));
                }
            }
            if( values.containsKey("ProdAllocCharc03") ) {
                final Object value = values.remove("ProdAllocCharc03");
                if( (value == null) || (!value.equals(getProdAllocCharc03())) ) {
                    setProdAllocCharc03(((String) value));
                }
            }
            if( values.containsKey("ProdAllocCharc04") ) {
                final Object value = values.remove("ProdAllocCharc04");
                if( (value == null) || (!value.equals(getProdAllocCharc04())) ) {
                    setProdAllocCharc04(((String) value));
                }
            }
            if( values.containsKey("ProdAllocCharc05") ) {
                final Object value = values.remove("ProdAllocCharc05");
                if( (value == null) || (!value.equals(getProdAllocCharc05())) ) {
                    setProdAllocCharc05(((String) value));
                }
            }
            if( values.containsKey("ProdAllocCharc06") ) {
                final Object value = values.remove("ProdAllocCharc06");
                if( (value == null) || (!value.equals(getProdAllocCharc06())) ) {
                    setProdAllocCharc06(((String) value));
                }
            }
            if( values.containsKey("ProdAllocCharc07") ) {
                final Object value = values.remove("ProdAllocCharc07");
                if( (value == null) || (!value.equals(getProdAllocCharc07())) ) {
                    setProdAllocCharc07(((String) value));
                }
            }
            if( values.containsKey("ProdAllocCharc08") ) {
                final Object value = values.remove("ProdAllocCharc08");
                if( (value == null) || (!value.equals(getProdAllocCharc08())) ) {
                    setProdAllocCharc08(((String) value));
                }
            }
            if( values.containsKey("ProdAllocCharc09") ) {
                final Object value = values.remove("ProdAllocCharc09");
                if( (value == null) || (!value.equals(getProdAllocCharc09())) ) {
                    setProdAllocCharc09(((String) value));
                }
            }
            if( values.containsKey("ProdAllocCharc10") ) {
                final Object value = values.remove("ProdAllocCharc10");
                if( (value == null) || (!value.equals(getProdAllocCharc10())) ) {
                    setProdAllocCharc10(((String) value));
                }
            }
            if( values.containsKey("ProdAllocCharcValueCombnCmnt") ) {
                final Object value = values.remove("ProdAllocCharcValueCombnCmnt");
                if( (value == null) || (!value.equals(getProdAllocCharcValueCombnCmnt())) ) {
                    setProdAllocCharcValueCombnCmnt(((String) value));
                }
            }
            if( values.containsKey("ProdAllocCharcConstraintStatus") ) {
                final Object value = values.remove("ProdAllocCharcConstraintStatus");
                if( (value == null) || (!value.equals(getProdAllocCharcConstraintStatus())) ) {
                    setProdAllocCharcConstraintStatus(((String) value));
                }
            }
            if( values.containsKey("ProdAllocationActivationStatus") ) {
                final Object value = values.remove("ProdAllocationActivationStatus");
                if( (value == null) || (!value.equals(getProdAllocationActivationStatus())) ) {
                    setProdAllocationActivationStatus(((String) value));
                }
            }
            if( values.containsKey("CharcValAuthznGroup") ) {
                final Object value = values.remove("CharcValAuthznGroup");
                if( (value == null) || (!value.equals(getCharcValAuthznGroup())) ) {
                    setCharcValAuthznGroup(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProdAllocationObjectTP") ) {
                final Object value = (values).remove("to_ProdAllocationObjectTP");
                if( value instanceof Map ) {
                    if( toProdAllocationObjectTP == null ) {
                        toProdAllocationObjectTP = new ProdAllocationObject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProdAllocationObjectTP.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ProdAllocObjTimeSeriesTP") ) {
                final Object value = (values).remove("to_ProdAllocObjTimeSeriesTP");
                if( value instanceof Iterable ) {
                    if( toProdAllocObjTimeSeriesTP == null ) {
                        toProdAllocObjTimeSeriesTP = Lists.newArrayList();
                    } else {
                        toProdAllocObjTimeSeriesTP = Lists.newArrayList(toProdAllocObjTimeSeriesTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProdAllocObjTimeSeries entity;
                        if( toProdAllocObjTimeSeriesTP.size() > i ) {
                            entity = toProdAllocObjTimeSeriesTP.get(i);
                        } else {
                            entity = new ProdAllocObjTimeSeries();
                            toProdAllocObjTimeSeriesTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProdAllocCharcValCombnField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProdAllocCharcValCombnField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProdAllocCharcValCombnField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProdAllocCharcValCombnField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationObjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProdAllocationObjectTP != null ) {
            (values).put("to_ProdAllocationObjectTP", toProdAllocationObjectTP);
        }
        if( toProdAllocObjTimeSeriesTP != null ) {
            (values).put("to_ProdAllocObjTimeSeriesTP", toProdAllocObjTimeSeriesTP);
        }
        return values;
    }

    /**
     * Fetches the <b>ProdAllocationObject</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ProdAllocationObjectTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProdAllocationObject</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProdAllocationObject fetchProdAllocationObjectTP()
    {
        return fetchFieldAsSingle("to_ProdAllocationObjectTP", ProdAllocationObject.class);
    }

    /**
     * Retrieval of associated <b>ProdAllocationObject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProdAllocationObjectTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocationObjectTP</b> of a queried <b>ProdAllocCharcValCombn</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProdAllocationObject</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProdAllocationObject getProdAllocationObjectTPOrFetch()
    {
        if( toProdAllocationObjectTP == null ) {
            toProdAllocationObjectTP = fetchProdAllocationObjectTP();
        }
        return toProdAllocationObjectTP;
    }

    /**
     * Retrieval of associated <b>ProdAllocationObject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProdAllocationObjectTP</b>.
     * <p>
     * If the navigation property for an entity <b>ProdAllocCharcValCombn</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProdAllocationObjectTP</b> is already loaded, the result
     *         will contain the <b>ProdAllocationObject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProdAllocationObject> getProdAllocationObjectTPIfPresent()
    {
        return Option.of(toProdAllocationObjectTP);
    }

    /**
     * Overwrites the associated <b>ProdAllocationObject</b> entity for the loaded navigation property
     * <b>to_ProdAllocationObjectTP</b>.
     *
     * @param value
     *            New <b>ProdAllocationObject</b> entity.
     */
    public void setProdAllocationObjectTP( final ProdAllocationObject value )
    {
        toProdAllocationObjectTP = value;
    }

    /**
     * Fetches the <b>ProdAllocObjTimeSeries</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProdAllocObjTimeSeriesTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProdAllocObjTimeSeries</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProdAllocObjTimeSeries> fetchProdAllocObjTimeSeriesTP()
    {
        return fetchFieldAsList("to_ProdAllocObjTimeSeriesTP", ProdAllocObjTimeSeries.class);
    }

    /**
     * Retrieval of associated <b>ProdAllocObjTimeSeries</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProdAllocObjTimeSeriesTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocObjTimeSeriesTP</b> of a queried <b>ProdAllocCharcValCombn</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProdAllocObjTimeSeries</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProdAllocObjTimeSeries> getProdAllocObjTimeSeriesTPOrFetch()
    {
        if( toProdAllocObjTimeSeriesTP == null ) {
            toProdAllocObjTimeSeriesTP = fetchProdAllocObjTimeSeriesTP();
        }
        return toProdAllocObjTimeSeriesTP;
    }

    /**
     * Retrieval of associated <b>ProdAllocObjTimeSeries</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProdAllocObjTimeSeriesTP</b>.
     * <p>
     * If the navigation property for an entity <b>ProdAllocCharcValCombn</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProdAllocObjTimeSeriesTP</b> is already loaded, the
     *         result will contain the <b>ProdAllocObjTimeSeries</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProdAllocObjTimeSeries>> getProdAllocObjTimeSeriesTPIfPresent()
    {
        return Option.of(toProdAllocObjTimeSeriesTP);
    }

    /**
     * Overwrites the list of associated <b>ProdAllocObjTimeSeries</b> entities for the loaded navigation property
     * <b>to_ProdAllocObjTimeSeriesTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocObjTimeSeriesTP</b> of a queried <b>ProdAllocCharcValCombn</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProdAllocObjTimeSeries</b> entities.
     */
    public void setProdAllocObjTimeSeriesTP( @Nonnull final List<ProdAllocObjTimeSeries> value )
    {
        if( toProdAllocObjTimeSeriesTP == null ) {
            toProdAllocObjTimeSeriesTP = Lists.newArrayList();
        }
        toProdAllocObjTimeSeriesTP.clear();
        toProdAllocObjTimeSeriesTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProdAllocObjTimeSeries</b> entities. This corresponds to the OData
     * navigation property <b>to_ProdAllocObjTimeSeriesTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocObjTimeSeriesTP</b> of a queried <b>ProdAllocCharcValCombn</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProdAllocObjTimeSeries</b> entities.
     */
    public void addProdAllocObjTimeSeriesTP( ProdAllocObjTimeSeries... entity )
    {
        if( toProdAllocObjTimeSeriesTP == null ) {
            toProdAllocObjTimeSeriesTP = Lists.newArrayList();
        }
        toProdAllocObjTimeSeriesTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProdAllocCharcValCombn instances.
     *
     */
    public final static class ProdAllocCharcValCombnBuilder
    {

        private ProdAllocationObject toProdAllocationObjectTP;
        private List<ProdAllocObjTimeSeries> toProdAllocObjTimeSeriesTP = Lists.newArrayList();

        private ProdAllocCharcValCombn.ProdAllocCharcValCombnBuilder toProdAllocationObjectTP(
            final ProdAllocationObject value )
        {
            toProdAllocationObjectTP = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProdAllocationObjectTP</b> for <b>ProdAllocCharcValCombn</b> to single
         * <b>ProdAllocationObject</b>.
         *
         * @param value
         *            The ProdAllocationObject to build this ProdAllocCharcValCombn with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdAllocCharcValCombn.ProdAllocCharcValCombnBuilder prodAllocationObjectTP(
            final ProdAllocationObject value )
        {
            return toProdAllocationObjectTP(value);
        }

        private ProdAllocCharcValCombn.ProdAllocCharcValCombnBuilder toProdAllocObjTimeSeriesTP(
            final List<ProdAllocObjTimeSeries> value )
        {
            toProdAllocObjTimeSeriesTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProdAllocObjTimeSeriesTP</b> for <b>ProdAllocCharcValCombn</b> to multiple
         * <b>ProdAllocObjTimeSeries</b>.
         *
         * @param value
         *            The ProdAllocObjTimeSeriess to build this ProdAllocCharcValCombn with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdAllocCharcValCombn.ProdAllocCharcValCombnBuilder prodAllocObjTimeSeriesTP(
            ProdAllocObjTimeSeries... value )
        {
            return toProdAllocObjTimeSeriesTP(Lists.newArrayList(value));
        }

    }

}
