/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.selectable.ProdAllocCharcValCombnSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
 * ProdAllocCharcValCombn} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class ProdAllocCharcValCombnByKeyFluentHelper
    extends
    FluentHelperByKey<ProdAllocCharcValCombnByKeyFluentHelper, ProdAllocCharcValCombn, ProdAllocCharcValCombnSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     * ProdAllocCharcValCombn} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProdAllocCharcValCombn}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProdAllocCharcValCombn}
     * @param charcValueCombinationUUID
     *            Characteristic Value Combination UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public ProdAllocCharcValCombnByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID charcValueCombinationUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("CharcValueCombinationUUID", charcValueCombinationUUID);
    }

    @Override
    @Nonnull
    protected Class<ProdAllocCharcValCombn> getEntityClass()
    {
        return ProdAllocCharcValCombn.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
