/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.field.ProdAllocObjTimeSeriesField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.link.ProdAllocObjTimeSeriesOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.selectable.ProdAllocObjTimeSeriesSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Product Allocation Object Time Series
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProdAllocObjTimeSeriesType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProdAllocObjTimeSeries extends VdmEntity<ProdAllocObjTimeSeries>
{

    /**
     * Selector for all available fields of ProdAllocObjTimeSeries.
     *
     */
    public final static ProdAllocObjTimeSeriesSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DeleteActiveTimeSeries_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "DeleteActiveTimeSeries_ac" )
    @JsonProperty( "DeleteActiveTimeSeries_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DeleteActiveTimeSeries_ac" )
    private Boolean deleteActiveTimeSeries_ac;
    /**
     * Use with available fluent helpers to apply the <b>DeleteActiveTimeSeries_ac</b> field to query operations.
     *
     */
    public final static ProdAllocObjTimeSeriesField<Boolean> DELETE_ACTIVE_TIME_SERIES_AC =
        new ProdAllocObjTimeSeriesField<Boolean>("DeleteActiveTimeSeries_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ProdAllocObjTimeSeriesField<Boolean> UPDATE_MC =
        new ProdAllocObjTimeSeriesField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocationTimeSeriesUUID</b>
     * </p>
     *
     * @return Product Allocation Time SeriesUUID
     */
    @Key
    @SerializedName( "ProdAllocationTimeSeriesUUID" )
    @JsonProperty( "ProdAllocationTimeSeriesUUID" )
    @Nullable
    @ODataField( odataName = "ProdAllocationTimeSeriesUUID" )
    private UUID prodAllocationTimeSeriesUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocationTimeSeriesUUID</b> field to query operations.
     *
     */
    public final static ProdAllocObjTimeSeriesField<UUID> PROD_ALLOCATION_TIME_SERIES_UUID =
        new ProdAllocObjTimeSeriesField<UUID>("ProdAllocationTimeSeriesUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObjectUUID</b>
     * </p>
     *
     * @return Product Allocation Object UUID
     */
    @SerializedName( "ProductAllocationObjectUUID" )
    @JsonProperty( "ProductAllocationObjectUUID" )
    @Nullable
    @ODataField( odataName = "ProductAllocationObjectUUID" )
    private UUID productAllocationObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationObjectUUID</b> field to query operations.
     *
     */
    public final static ProdAllocObjTimeSeriesField<UUID> PRODUCT_ALLOCATION_OBJECT_UUID =
        new ProdAllocObjTimeSeriesField<UUID>("ProductAllocationObjectUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueCombinationUUID</b>
     * </p>
     *
     * @return Characteristic Value Combination UUID
     */
    @SerializedName( "CharcValueCombinationUUID" )
    @JsonProperty( "CharcValueCombinationUUID" )
    @Nullable
    @ODataField( odataName = "CharcValueCombinationUUID" )
    private UUID charcValueCombinationUUID;
    /**
     * Use with available fluent helpers to apply the <b>CharcValueCombinationUUID</b> field to query operations.
     *
     */
    public final static ProdAllocObjTimeSeriesField<UUID> CHARC_VALUE_COMBINATION_UUID =
        new ProdAllocObjTimeSeriesField<UUID>("CharcValueCombinationUUID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocPerdStartUTCDateTime</b>
     * </p>
     *
     * @return Product Allocation Period Start UTC Date Time
     */
    @SerializedName( "ProdAllocPerdStartUTCDateTime" )
    @JsonProperty( "ProdAllocPerdStartUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ProdAllocPerdStartUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime prodAllocPerdStartUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocPerdStartUTCDateTime</b> field to query operations.
     *
     */
    public final static ProdAllocObjTimeSeriesField<ZonedDateTime> PROD_ALLOC_PERD_START_UTC_DATE_TIME =
        new ProdAllocObjTimeSeriesField<ZonedDateTime>("ProdAllocPerdStartUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocPeriodStartTimeZone</b>
     * </p>
     *
     * @return Product Allocation Period Start Time Zone
     */
    @SerializedName( "ProdAllocPeriodStartTimeZone" )
    @JsonProperty( "ProdAllocPeriodStartTimeZone" )
    @Nullable
    @ODataField( odataName = "ProdAllocPeriodStartTimeZone" )
    private String prodAllocPeriodStartTimeZone;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocPeriodStartTimeZone</b> field to query operations.
     *
     */
    public final static ProdAllocObjTimeSeriesField<String> PROD_ALLOC_PERIOD_START_TIME_ZONE =
        new ProdAllocObjTimeSeriesField<String>("ProdAllocPeriodStartTimeZone");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocPeriodEndUTCDateTime</b>
     * </p>
     *
     * @return Product Allocation Period End UTC Date Time
     */
    @SerializedName( "ProdAllocPeriodEndUTCDateTime" )
    @JsonProperty( "ProdAllocPeriodEndUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ProdAllocPeriodEndUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime prodAllocPeriodEndUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocPeriodEndUTCDateTime</b> field to query operations.
     *
     */
    public final static ProdAllocObjTimeSeriesField<ZonedDateTime> PROD_ALLOC_PERIOD_END_UTC_DATE_TIME =
        new ProdAllocObjTimeSeriesField<ZonedDateTime>("ProdAllocPeriodEndUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocPeriodEndTimeZone</b>
     * </p>
     *
     * @return Product Allocation Period End Time Zone
     */
    @SerializedName( "ProdAllocPeriodEndTimeZone" )
    @JsonProperty( "ProdAllocPeriodEndTimeZone" )
    @Nullable
    @ODataField( odataName = "ProdAllocPeriodEndTimeZone" )
    private String prodAllocPeriodEndTimeZone;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocPeriodEndTimeZone</b> field to query operations.
     *
     */
    public final static ProdAllocObjTimeSeriesField<String> PROD_ALLOC_PERIOD_END_TIME_ZONE =
        new ProdAllocObjTimeSeriesField<String>("ProdAllocPeriodEndTimeZone");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationQuantity</b>
     * </p>
     *
     * @return Product Allocation Quantity
     */
    @SerializedName( "ProductAllocationQuantity" )
    @JsonProperty( "ProductAllocationQuantity" )
    @Nullable
    @ODataField( odataName = "ProductAllocationQuantity" )
    private BigDecimal productAllocationQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationQuantity</b> field to query operations.
     *
     */
    public final static ProdAllocObjTimeSeriesField<BigDecimal> PRODUCT_ALLOCATION_QUANTITY =
        new ProdAllocObjTimeSeriesField<BigDecimal>("ProductAllocationQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationQuantityUnit</b>
     * </p>
     *
     * @return Product Allocation Quantity Unit
     */
    @SerializedName( "ProductAllocationQuantityUnit" )
    @JsonProperty( "ProductAllocationQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ProductAllocationQuantityUnit" )
    private String productAllocationQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationQuantityUnit</b> field to query operations.
     *
     */
    public final static ProdAllocObjTimeSeriesField<String> PRODUCT_ALLOCATION_QUANTITY_UNIT =
        new ProdAllocObjTimeSeriesField<String>("ProductAllocationQuantityUnit");
    /**
     * Navigation property <b>to_ProdAllocCharcValCombnTP</b> for <b>ProdAllocObjTimeSeries</b> to single
     * <b>ProdAllocCharcValCombn</b>.
     *
     */
    @SerializedName( "to_ProdAllocCharcValCombnTP" )
    @JsonProperty( "to_ProdAllocCharcValCombnTP" )
    @ODataField( odataName = "to_ProdAllocCharcValCombnTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProdAllocCharcValCombn toProdAllocCharcValCombnTP;
    /**
     * Navigation property <b>to_ProdAllocationObjectTP</b> for <b>ProdAllocObjTimeSeries</b> to single
     * <b>ProdAllocationObject</b>.
     *
     */
    @SerializedName( "to_ProdAllocationObjectTP" )
    @JsonProperty( "to_ProdAllocationObjectTP" )
    @ODataField( odataName = "to_ProdAllocationObjectTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProdAllocationObject toProdAllocationObjectTP;
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocCharcValCombnTP</b> navigation property to query
     * operations.
     *
     */
    public final static ProdAllocObjTimeSeriesOneToOneLink<ProdAllocCharcValCombn> TO_PROD_ALLOC_CHARC_VAL_COMBN_TP =
        new ProdAllocObjTimeSeriesOneToOneLink<ProdAllocCharcValCombn>("to_ProdAllocCharcValCombnTP");
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocationObjectTP</b> navigation property to query
     * operations.
     *
     */
    public final static ProdAllocObjTimeSeriesOneToOneLink<ProdAllocationObject> TO_PROD_ALLOCATION_OBJECT_TP =
        new ProdAllocObjTimeSeriesOneToOneLink<ProdAllocationObject>("to_ProdAllocationObjectTP");

    @Nonnull
    @Override
    public Class<ProdAllocObjTimeSeries> getType()
    {
        return ProdAllocObjTimeSeries.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DeleteActiveTimeSeries_ac</b>
     * </p>
     *
     * @param deleteActiveTimeSeries_ac
     *            Dyn. Action Control
     */
    public void setDeleteActiveTimeSeries_ac( @Nullable final Boolean deleteActiveTimeSeries_ac )
    {
        rememberChangedField("DeleteActiveTimeSeries_ac", this.deleteActiveTimeSeries_ac);
        this.deleteActiveTimeSeries_ac = deleteActiveTimeSeries_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocationTimeSeriesUUID</b>
     * </p>
     *
     * @param prodAllocationTimeSeriesUUID
     *            Product Allocation Time SeriesUUID
     */
    public void setProdAllocationTimeSeriesUUID( @Nullable final UUID prodAllocationTimeSeriesUUID )
    {
        rememberChangedField("ProdAllocationTimeSeriesUUID", this.prodAllocationTimeSeriesUUID);
        this.prodAllocationTimeSeriesUUID = prodAllocationTimeSeriesUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObjectUUID</b>
     * </p>
     *
     * @param productAllocationObjectUUID
     *            Product Allocation Object UUID
     */
    public void setProductAllocationObjectUUID( @Nullable final UUID productAllocationObjectUUID )
    {
        rememberChangedField("ProductAllocationObjectUUID", this.productAllocationObjectUUID);
        this.productAllocationObjectUUID = productAllocationObjectUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueCombinationUUID</b>
     * </p>
     *
     * @param charcValueCombinationUUID
     *            Characteristic Value Combination UUID
     */
    public void setCharcValueCombinationUUID( @Nullable final UUID charcValueCombinationUUID )
    {
        rememberChangedField("CharcValueCombinationUUID", this.charcValueCombinationUUID);
        this.charcValueCombinationUUID = charcValueCombinationUUID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocPerdStartUTCDateTime</b>
     * </p>
     *
     * @param prodAllocPerdStartUTCDateTime
     *            Product Allocation Period Start UTC Date Time
     */
    public void setProdAllocPerdStartUTCDateTime( @Nullable final ZonedDateTime prodAllocPerdStartUTCDateTime )
    {
        rememberChangedField("ProdAllocPerdStartUTCDateTime", this.prodAllocPerdStartUTCDateTime);
        this.prodAllocPerdStartUTCDateTime = prodAllocPerdStartUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocPeriodStartTimeZone</b>
     * </p>
     *
     * @param prodAllocPeriodStartTimeZone
     *            Product Allocation Period Start Time Zone
     */
    public void setProdAllocPeriodStartTimeZone( @Nullable final String prodAllocPeriodStartTimeZone )
    {
        rememberChangedField("ProdAllocPeriodStartTimeZone", this.prodAllocPeriodStartTimeZone);
        this.prodAllocPeriodStartTimeZone = prodAllocPeriodStartTimeZone;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocPeriodEndUTCDateTime</b>
     * </p>
     *
     * @param prodAllocPeriodEndUTCDateTime
     *            Product Allocation Period End UTC Date Time
     */
    public void setProdAllocPeriodEndUTCDateTime( @Nullable final ZonedDateTime prodAllocPeriodEndUTCDateTime )
    {
        rememberChangedField("ProdAllocPeriodEndUTCDateTime", this.prodAllocPeriodEndUTCDateTime);
        this.prodAllocPeriodEndUTCDateTime = prodAllocPeriodEndUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocPeriodEndTimeZone</b>
     * </p>
     *
     * @param prodAllocPeriodEndTimeZone
     *            Product Allocation Period End Time Zone
     */
    public void setProdAllocPeriodEndTimeZone( @Nullable final String prodAllocPeriodEndTimeZone )
    {
        rememberChangedField("ProdAllocPeriodEndTimeZone", this.prodAllocPeriodEndTimeZone);
        this.prodAllocPeriodEndTimeZone = prodAllocPeriodEndTimeZone;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationQuantity</b>
     * </p>
     *
     * @param productAllocationQuantity
     *            Product Allocation Quantity
     */
    public void setProductAllocationQuantity( @Nullable final BigDecimal productAllocationQuantity )
    {
        rememberChangedField("ProductAllocationQuantity", this.productAllocationQuantity);
        this.productAllocationQuantity = productAllocationQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationQuantityUnit</b>
     * </p>
     *
     * @param productAllocationQuantityUnit
     *            Product Allocation Quantity Unit
     */
    public void setProductAllocationQuantityUnit( @Nullable final String productAllocationQuantityUnit )
    {
        rememberChangedField("ProductAllocationQuantityUnit", this.productAllocationQuantityUnit);
        this.productAllocationQuantityUnit = productAllocationQuantityUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProdAllocObjTimeSeries";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProdAllocationTimeSeriesUUID", getProdAllocationTimeSeriesUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DeleteActiveTimeSeries_ac", getDeleteActiveTimeSeries_ac());
        values.put("Update_mc", getUpdate_mc());
        values.put("ProdAllocationTimeSeriesUUID", getProdAllocationTimeSeriesUUID());
        values.put("ProductAllocationObjectUUID", getProductAllocationObjectUUID());
        values.put("CharcValueCombinationUUID", getCharcValueCombinationUUID());
        values.put("ProdAllocPerdStartUTCDateTime", getProdAllocPerdStartUTCDateTime());
        values.put("ProdAllocPeriodStartTimeZone", getProdAllocPeriodStartTimeZone());
        values.put("ProdAllocPeriodEndUTCDateTime", getProdAllocPeriodEndUTCDateTime());
        values.put("ProdAllocPeriodEndTimeZone", getProdAllocPeriodEndTimeZone());
        values.put("ProductAllocationQuantity", getProductAllocationQuantity());
        values.put("ProductAllocationQuantityUnit", getProductAllocationQuantityUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DeleteActiveTimeSeries_ac") ) {
                final Object value = values.remove("DeleteActiveTimeSeries_ac");
                if( (value == null) || (!value.equals(getDeleteActiveTimeSeries_ac())) ) {
                    setDeleteActiveTimeSeries_ac(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ProdAllocationTimeSeriesUUID") ) {
                final Object value = values.remove("ProdAllocationTimeSeriesUUID");
                if( (value == null) || (!value.equals(getProdAllocationTimeSeriesUUID())) ) {
                    setProdAllocationTimeSeriesUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProductAllocationObjectUUID") ) {
                final Object value = values.remove("ProductAllocationObjectUUID");
                if( (value == null) || (!value.equals(getProductAllocationObjectUUID())) ) {
                    setProductAllocationObjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("CharcValueCombinationUUID") ) {
                final Object value = values.remove("CharcValueCombinationUUID");
                if( (value == null) || (!value.equals(getCharcValueCombinationUUID())) ) {
                    setCharcValueCombinationUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProdAllocPerdStartUTCDateTime") ) {
                final Object value = values.remove("ProdAllocPerdStartUTCDateTime");
                if( (value == null) || (!value.equals(getProdAllocPerdStartUTCDateTime())) ) {
                    setProdAllocPerdStartUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ProdAllocPeriodStartTimeZone") ) {
                final Object value = values.remove("ProdAllocPeriodStartTimeZone");
                if( (value == null) || (!value.equals(getProdAllocPeriodStartTimeZone())) ) {
                    setProdAllocPeriodStartTimeZone(((String) value));
                }
            }
            if( values.containsKey("ProdAllocPeriodEndUTCDateTime") ) {
                final Object value = values.remove("ProdAllocPeriodEndUTCDateTime");
                if( (value == null) || (!value.equals(getProdAllocPeriodEndUTCDateTime())) ) {
                    setProdAllocPeriodEndUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ProdAllocPeriodEndTimeZone") ) {
                final Object value = values.remove("ProdAllocPeriodEndTimeZone");
                if( (value == null) || (!value.equals(getProdAllocPeriodEndTimeZone())) ) {
                    setProdAllocPeriodEndTimeZone(((String) value));
                }
            }
            if( values.containsKey("ProductAllocationQuantity") ) {
                final Object value = values.remove("ProductAllocationQuantity");
                if( (value == null) || (!value.equals(getProductAllocationQuantity())) ) {
                    setProductAllocationQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductAllocationQuantityUnit") ) {
                final Object value = values.remove("ProductAllocationQuantityUnit");
                if( (value == null) || (!value.equals(getProductAllocationQuantityUnit())) ) {
                    setProductAllocationQuantityUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProdAllocCharcValCombnTP") ) {
                final Object value = (values).remove("to_ProdAllocCharcValCombnTP");
                if( value instanceof Map ) {
                    if( toProdAllocCharcValCombnTP == null ) {
                        toProdAllocCharcValCombnTP = new ProdAllocCharcValCombn();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProdAllocCharcValCombnTP.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ProdAllocationObjectTP") ) {
                final Object value = (values).remove("to_ProdAllocationObjectTP");
                if( value instanceof Map ) {
                    if( toProdAllocationObjectTP == null ) {
                        toProdAllocationObjectTP = new ProdAllocationObject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProdAllocationObjectTP.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProdAllocObjTimeSeriesField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProdAllocObjTimeSeriesField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProdAllocObjTimeSeriesField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProdAllocObjTimeSeriesField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationObjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProdAllocCharcValCombnTP != null ) {
            (values).put("to_ProdAllocCharcValCombnTP", toProdAllocCharcValCombnTP);
        }
        if( toProdAllocationObjectTP != null ) {
            (values).put("to_ProdAllocationObjectTP", toProdAllocationObjectTP);
        }
        return values;
    }

    /**
     * Fetches the <b>ProdAllocCharcValCombn</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProdAllocCharcValCombnTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProdAllocCharcValCombn</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProdAllocCharcValCombn fetchProdAllocCharcValCombnTP()
    {
        return fetchFieldAsSingle("to_ProdAllocCharcValCombnTP", ProdAllocCharcValCombn.class);
    }

    /**
     * Retrieval of associated <b>ProdAllocCharcValCombn</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ProdAllocCharcValCombnTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocCharcValCombnTP</b> of a queried <b>ProdAllocObjTimeSeries</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProdAllocCharcValCombn</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProdAllocCharcValCombn getProdAllocCharcValCombnTPOrFetch()
    {
        if( toProdAllocCharcValCombnTP == null ) {
            toProdAllocCharcValCombnTP = fetchProdAllocCharcValCombnTP();
        }
        return toProdAllocCharcValCombnTP;
    }

    /**
     * Retrieval of associated <b>ProdAllocCharcValCombn</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ProdAllocCharcValCombnTP</b>.
     * <p>
     * If the navigation property for an entity <b>ProdAllocObjTimeSeries</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProdAllocCharcValCombnTP</b> is already loaded, the
     *         result will contain the <b>ProdAllocCharcValCombn</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProdAllocCharcValCombn> getProdAllocCharcValCombnTPIfPresent()
    {
        return Option.of(toProdAllocCharcValCombnTP);
    }

    /**
     * Overwrites the associated <b>ProdAllocCharcValCombn</b> entity for the loaded navigation property
     * <b>to_ProdAllocCharcValCombnTP</b>.
     *
     * @param value
     *            New <b>ProdAllocCharcValCombn</b> entity.
     */
    public void setProdAllocCharcValCombnTP( final ProdAllocCharcValCombn value )
    {
        toProdAllocCharcValCombnTP = value;
    }

    /**
     * Fetches the <b>ProdAllocationObject</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ProdAllocationObjectTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProdAllocationObject</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProdAllocationObject fetchProdAllocationObjectTP()
    {
        return fetchFieldAsSingle("to_ProdAllocationObjectTP", ProdAllocationObject.class);
    }

    /**
     * Retrieval of associated <b>ProdAllocationObject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProdAllocationObjectTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocationObjectTP</b> of a queried <b>ProdAllocObjTimeSeries</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProdAllocationObject</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProdAllocationObject getProdAllocationObjectTPOrFetch()
    {
        if( toProdAllocationObjectTP == null ) {
            toProdAllocationObjectTP = fetchProdAllocationObjectTP();
        }
        return toProdAllocationObjectTP;
    }

    /**
     * Retrieval of associated <b>ProdAllocationObject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProdAllocationObjectTP</b>.
     * <p>
     * If the navigation property for an entity <b>ProdAllocObjTimeSeries</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProdAllocationObjectTP</b> is already loaded, the result
     *         will contain the <b>ProdAllocationObject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProdAllocationObject> getProdAllocationObjectTPIfPresent()
    {
        return Option.of(toProdAllocationObjectTP);
    }

    /**
     * Overwrites the associated <b>ProdAllocationObject</b> entity for the loaded navigation property
     * <b>to_ProdAllocationObjectTP</b>.
     *
     * @param value
     *            New <b>ProdAllocationObject</b> entity.
     */
    public void setProdAllocationObjectTP( final ProdAllocationObject value )
    {
        toProdAllocationObjectTP = value;
    }

    /**
     * Helper class to allow for fluent creation of ProdAllocObjTimeSeries instances.
     *
     */
    public final static class ProdAllocObjTimeSeriesBuilder
    {

        private ProdAllocCharcValCombn toProdAllocCharcValCombnTP;
        private ProdAllocationObject toProdAllocationObjectTP;

        private ProdAllocObjTimeSeries.ProdAllocObjTimeSeriesBuilder toProdAllocCharcValCombnTP(
            final ProdAllocCharcValCombn value )
        {
            toProdAllocCharcValCombnTP = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProdAllocCharcValCombnTP</b> for <b>ProdAllocObjTimeSeries</b> to single
         * <b>ProdAllocCharcValCombn</b>.
         *
         * @param value
         *            The ProdAllocCharcValCombn to build this ProdAllocObjTimeSeries with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdAllocObjTimeSeries.ProdAllocObjTimeSeriesBuilder prodAllocCharcValCombnTP(
            final ProdAllocCharcValCombn value )
        {
            return toProdAllocCharcValCombnTP(value);
        }

        private ProdAllocObjTimeSeries.ProdAllocObjTimeSeriesBuilder toProdAllocationObjectTP(
            final ProdAllocationObject value )
        {
            toProdAllocationObjectTP = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProdAllocationObjectTP</b> for <b>ProdAllocObjTimeSeries</b> to single
         * <b>ProdAllocationObject</b>.
         *
         * @param value
         *            The ProdAllocationObject to build this ProdAllocObjTimeSeries with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdAllocObjTimeSeries.ProdAllocObjTimeSeriesBuilder prodAllocationObjectTP(
            final ProdAllocationObject value )
        {
            return toProdAllocationObjectTP(value);
        }

    }

}
