/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.field.ProdAllocationObjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.link.ProdAllocationObjectLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.selectable.ProdAllocationObjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Product Allocation Object
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProdAllocationObjectType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProdAllocationObject extends VdmEntity<ProdAllocationObject>
{

    /**
     * Selector for all available fields of ProdAllocationObject.
     *
     */
    public final static ProdAllocationObjectSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ProdAllocCharcValCombnTP_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ProdAllocCharcValCombnTP_oc" )
    @JsonProperty( "to_ProdAllocCharcValCombnTP_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ProdAllocCharcValCombnTP_oc" )
    private Boolean prodAllocCharcValCombnTP_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocCharcValCombnTP_oc</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectField<Boolean> PROD_ALLOC_CHARC_VAL_COMBN_TP_OC =
        new ProdAllocationObjectField<Boolean>("to_ProdAllocCharcValCombnTP_oc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObjectUUID</b>
     * </p>
     *
     * @return Product Allocation Object UUID
     */
    @Key
    @SerializedName( "ProductAllocationObjectUUID" )
    @JsonProperty( "ProductAllocationObjectUUID" )
    @Nullable
    @ODataField( odataName = "ProductAllocationObjectUUID" )
    private UUID productAllocationObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationObjectUUID</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectField<UUID> PRODUCT_ALLOCATION_OBJECT_UUID =
        new ProdAllocationObjectField<UUID>("ProductAllocationObjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObject_Text</b>
     * </p>
     *
     * @return Product Allocation Object Description
     */
    @SerializedName( "ProductAllocationObject_Text" )
    @JsonProperty( "ProductAllocationObject_Text" )
    @Nullable
    @ODataField( odataName = "ProductAllocationObject_Text" )
    private String productAllocationObject_Text;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationObject_Text</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectField<String> PRODUCT_ALLOCATION_OBJECT_TEXT =
        new ProdAllocationObjectField<String>("ProductAllocationObject_Text");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObject</b>
     * </p>
     *
     * @return Product Allocation Object
     */
    @SerializedName( "ProductAllocationObject" )
    @JsonProperty( "ProductAllocationObject" )
    @Nullable
    @ODataField( odataName = "ProductAllocationObject" )
    private String productAllocationObject;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationObject</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectField<String> PRODUCT_ALLOCATION_OBJECT =
        new ProdAllocationObjectField<String>("ProductAllocationObject");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationPeriodType</b>
     * </p>
     *
     * @return Product Allocation Period Type
     */
    @SerializedName( "ProductAllocationPeriodType" )
    @JsonProperty( "ProductAllocationPeriodType" )
    @Nullable
    @ODataField( odataName = "ProductAllocationPeriodType" )
    private String productAllocationPeriodType;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationPeriodType</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectField<String> PRODUCT_ALLOCATION_PERIOD_TYPE =
        new ProdAllocationObjectField<String>("ProductAllocationPeriodType");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocationPeriodTimeZone</b>
     * </p>
     *
     * @return Product Allocation Period Time Zone
     */
    @SerializedName( "ProdAllocationPeriodTimeZone" )
    @JsonProperty( "ProdAllocationPeriodTimeZone" )
    @Nullable
    @ODataField( odataName = "ProdAllocationPeriodTimeZone" )
    private String prodAllocationPeriodTimeZone;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocationPeriodTimeZone</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectField<String> PROD_ALLOCATION_PERIOD_TIME_ZONE =
        new ProdAllocationObjectField<String>("ProdAllocationPeriodTimeZone");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @return Factory calendar key
     */
    @SerializedName( "FactoryCalendar" )
    @JsonProperty( "FactoryCalendar" )
    @Nullable
    @ODataField( odataName = "FactoryCalendar" )
    private String factoryCalendar;
    /**
     * Use with available fluent helpers to apply the <b>FactoryCalendar</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectField<String> FACTORY_CALENDAR =
        new ProdAllocationObjectField<String>("FactoryCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCheckDateTimeType</b>
     * </p>
     *
     * @return Product Allocation Check Date Time Type
     */
    @SerializedName( "ProdAllocCheckDateTimeType" )
    @JsonProperty( "ProdAllocCheckDateTimeType" )
    @Nullable
    @ODataField( odataName = "ProdAllocCheckDateTimeType" )
    private String prodAllocCheckDateTimeType;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocCheckDateTimeType</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectField<String> PROD_ALLOC_CHECK_DATE_TIME_TYPE =
        new ProdAllocationObjectField<String>("ProdAllocCheckDateTimeType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationQuantityUnit</b>
     * </p>
     *
     * @return Product Allocation Quantity Unit
     */
    @SerializedName( "ProductAllocationQuantityUnit" )
    @JsonProperty( "ProductAllocationQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ProductAllocationQuantityUnit" )
    private String productAllocationQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationQuantityUnit</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectField<String> PRODUCT_ALLOCATION_QUANTITY_UNIT =
        new ProdAllocationObjectField<String>("ProductAllocationQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CollectiveAllocationType</b>
     * </p>
     *
     * @return Collective Allocation Type
     */
    @SerializedName( "CollectiveAllocationType" )
    @JsonProperty( "CollectiveAllocationType" )
    @Nullable
    @ODataField( odataName = "CollectiveAllocationType" )
    private String collectiveAllocationType;
    /**
     * Use with available fluent helpers to apply the <b>CollectiveAllocationType</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectField<String> COLLECTIVE_ALLOCATION_TYPE =
        new ProdAllocationObjectField<String>("CollectiveAllocationType");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Creation Date Time
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectField<ZonedDateTime> CREATION_DATE_TIME =
        new ProdAllocationObjectField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created by User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectField<String> CREATED_BY_USER =
        new ProdAllocationObjectField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Date Time
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ProdAllocationObjectField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed by User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectField<String> LAST_CHANGED_BY_USER =
        new ProdAllocationObjectField<String>("LastChangedByUser");
    /**
     * Navigation property <b>to_ProdAllocationObjectTTP</b> for <b>ProdAllocationObject</b> to multiple
     * <b>ProdAllocationObjectT</b>.
     *
     */
    @SerializedName( "to_ProdAllocationObjectTTP" )
    @JsonProperty( "to_ProdAllocationObjectTTP" )
    @ODataField( odataName = "to_ProdAllocationObjectTTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProdAllocationObjectT> toProdAllocationObjectTTP;
    /**
     * Navigation property <b>to_ProdAllocCharcMetaDataTP</b> for <b>ProdAllocationObject</b> to multiple
     * <b>ProdAllocCharcMetaData</b>.
     *
     */
    @SerializedName( "to_ProdAllocCharcMetaDataTP" )
    @JsonProperty( "to_ProdAllocCharcMetaDataTP" )
    @ODataField( odataName = "to_ProdAllocCharcMetaDataTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProdAllocCharcMetaData> toProdAllocCharcMetaDataTP;
    /**
     * Navigation property <b>to_ProdAllocCharcValCombnTP</b> for <b>ProdAllocationObject</b> to multiple
     * <b>ProdAllocCharcValCombn</b>.
     *
     */
    @SerializedName( "to_ProdAllocCharcValCombnTP" )
    @JsonProperty( "to_ProdAllocCharcValCombnTP" )
    @ODataField( odataName = "to_ProdAllocCharcValCombnTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProdAllocCharcValCombn> toProdAllocCharcValCombnTP;
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocationObjectTTP</b> navigation property to query
     * operations.
     *
     */
    public final static ProdAllocationObjectLink<ProdAllocationObjectT> TO_PROD_ALLOCATION_OBJECT_TTP =
        new ProdAllocationObjectLink<ProdAllocationObjectT>("to_ProdAllocationObjectTTP");
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocCharcMetaDataTP</b> navigation property to query
     * operations.
     *
     */
    public final static ProdAllocationObjectLink<ProdAllocCharcMetaData> TO_PROD_ALLOC_CHARC_META_DATA_TP =
        new ProdAllocationObjectLink<ProdAllocCharcMetaData>("to_ProdAllocCharcMetaDataTP");
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocCharcValCombnTP</b> navigation property to query
     * operations.
     *
     */
    public final static ProdAllocationObjectLink<ProdAllocCharcValCombn> TO_PROD_ALLOC_CHARC_VAL_COMBN_TP =
        new ProdAllocationObjectLink<ProdAllocCharcValCombn>("to_ProdAllocCharcValCombnTP");

    @Nonnull
    @Override
    public Class<ProdAllocationObject> getType()
    {
        return ProdAllocationObject.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ProdAllocCharcValCombnTP_oc</b>
     * </p>
     *
     * @param prodAllocCharcValCombnTP_oc
     *            Dynamic CbA-Control
     */
    public void setProdAllocCharcValCombnTP_oc( @Nullable final Boolean prodAllocCharcValCombnTP_oc )
    {
        rememberChangedField("to_ProdAllocCharcValCombnTP_oc", this.prodAllocCharcValCombnTP_oc);
        this.prodAllocCharcValCombnTP_oc = prodAllocCharcValCombnTP_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObjectUUID</b>
     * </p>
     *
     * @param productAllocationObjectUUID
     *            Product Allocation Object UUID
     */
    public void setProductAllocationObjectUUID( @Nullable final UUID productAllocationObjectUUID )
    {
        rememberChangedField("ProductAllocationObjectUUID", this.productAllocationObjectUUID);
        this.productAllocationObjectUUID = productAllocationObjectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObject_Text</b>
     * </p>
     *
     * @param productAllocationObject_Text
     *            Product Allocation Object Description
     */
    public void setProductAllocationObject_Text( @Nullable final String productAllocationObject_Text )
    {
        rememberChangedField("ProductAllocationObject_Text", this.productAllocationObject_Text);
        this.productAllocationObject_Text = productAllocationObject_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObject</b>
     * </p>
     *
     * @param productAllocationObject
     *            Product Allocation Object
     */
    public void setProductAllocationObject( @Nullable final String productAllocationObject )
    {
        rememberChangedField("ProductAllocationObject", this.productAllocationObject);
        this.productAllocationObject = productAllocationObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationPeriodType</b>
     * </p>
     *
     * @param productAllocationPeriodType
     *            Product Allocation Period Type
     */
    public void setProductAllocationPeriodType( @Nullable final String productAllocationPeriodType )
    {
        rememberChangedField("ProductAllocationPeriodType", this.productAllocationPeriodType);
        this.productAllocationPeriodType = productAllocationPeriodType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocationPeriodTimeZone</b>
     * </p>
     *
     * @param prodAllocationPeriodTimeZone
     *            Product Allocation Period Time Zone
     */
    public void setProdAllocationPeriodTimeZone( @Nullable final String prodAllocationPeriodTimeZone )
    {
        rememberChangedField("ProdAllocationPeriodTimeZone", this.prodAllocationPeriodTimeZone);
        this.prodAllocationPeriodTimeZone = prodAllocationPeriodTimeZone;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @param factoryCalendar
     *            Factory calendar key
     */
    public void setFactoryCalendar( @Nullable final String factoryCalendar )
    {
        rememberChangedField("FactoryCalendar", this.factoryCalendar);
        this.factoryCalendar = factoryCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocCheckDateTimeType</b>
     * </p>
     *
     * @param prodAllocCheckDateTimeType
     *            Product Allocation Check Date Time Type
     */
    public void setProdAllocCheckDateTimeType( @Nullable final String prodAllocCheckDateTimeType )
    {
        rememberChangedField("ProdAllocCheckDateTimeType", this.prodAllocCheckDateTimeType);
        this.prodAllocCheckDateTimeType = prodAllocCheckDateTimeType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationQuantityUnit</b>
     * </p>
     *
     * @param productAllocationQuantityUnit
     *            Product Allocation Quantity Unit
     */
    public void setProductAllocationQuantityUnit( @Nullable final String productAllocationQuantityUnit )
    {
        rememberChangedField("ProductAllocationQuantityUnit", this.productAllocationQuantityUnit);
        this.productAllocationQuantityUnit = productAllocationQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CollectiveAllocationType</b>
     * </p>
     *
     * @param collectiveAllocationType
     *            Collective Allocation Type
     */
    public void setCollectiveAllocationType( @Nullable final String collectiveAllocationType )
    {
        rememberChangedField("CollectiveAllocationType", this.collectiveAllocationType);
        this.collectiveAllocationType = collectiveAllocationType;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Creation Date Time
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created by User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Date Time
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed by User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProdAllocationObject";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProductAllocationObjectUUID", getProductAllocationObjectUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("to_ProdAllocCharcValCombnTP_oc", getProdAllocCharcValCombnTP_oc());
        values.put("ProductAllocationObjectUUID", getProductAllocationObjectUUID());
        values.put("ProductAllocationObject_Text", getProductAllocationObject_Text());
        values.put("ProductAllocationObject", getProductAllocationObject());
        values.put("ProductAllocationPeriodType", getProductAllocationPeriodType());
        values.put("ProdAllocationPeriodTimeZone", getProdAllocationPeriodTimeZone());
        values.put("FactoryCalendar", getFactoryCalendar());
        values.put("ProdAllocCheckDateTimeType", getProdAllocCheckDateTimeType());
        values.put("ProductAllocationQuantityUnit", getProductAllocationQuantityUnit());
        values.put("CollectiveAllocationType", getCollectiveAllocationType());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("to_ProdAllocCharcValCombnTP_oc") ) {
                final Object value = values.remove("to_ProdAllocCharcValCombnTP_oc");
                if( (value == null) || (!value.equals(getProdAllocCharcValCombnTP_oc())) ) {
                    setProdAllocCharcValCombnTP_oc(((Boolean) value));
                }
            }
            if( values.containsKey("ProductAllocationObjectUUID") ) {
                final Object value = values.remove("ProductAllocationObjectUUID");
                if( (value == null) || (!value.equals(getProductAllocationObjectUUID())) ) {
                    setProductAllocationObjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProductAllocationObject_Text") ) {
                final Object value = values.remove("ProductAllocationObject_Text");
                if( (value == null) || (!value.equals(getProductAllocationObject_Text())) ) {
                    setProductAllocationObject_Text(((String) value));
                }
            }
            if( values.containsKey("ProductAllocationObject") ) {
                final Object value = values.remove("ProductAllocationObject");
                if( (value == null) || (!value.equals(getProductAllocationObject())) ) {
                    setProductAllocationObject(((String) value));
                }
            }
            if( values.containsKey("ProductAllocationPeriodType") ) {
                final Object value = values.remove("ProductAllocationPeriodType");
                if( (value == null) || (!value.equals(getProductAllocationPeriodType())) ) {
                    setProductAllocationPeriodType(((String) value));
                }
            }
            if( values.containsKey("ProdAllocationPeriodTimeZone") ) {
                final Object value = values.remove("ProdAllocationPeriodTimeZone");
                if( (value == null) || (!value.equals(getProdAllocationPeriodTimeZone())) ) {
                    setProdAllocationPeriodTimeZone(((String) value));
                }
            }
            if( values.containsKey("FactoryCalendar") ) {
                final Object value = values.remove("FactoryCalendar");
                if( (value == null) || (!value.equals(getFactoryCalendar())) ) {
                    setFactoryCalendar(((String) value));
                }
            }
            if( values.containsKey("ProdAllocCheckDateTimeType") ) {
                final Object value = values.remove("ProdAllocCheckDateTimeType");
                if( (value == null) || (!value.equals(getProdAllocCheckDateTimeType())) ) {
                    setProdAllocCheckDateTimeType(((String) value));
                }
            }
            if( values.containsKey("ProductAllocationQuantityUnit") ) {
                final Object value = values.remove("ProductAllocationQuantityUnit");
                if( (value == null) || (!value.equals(getProductAllocationQuantityUnit())) ) {
                    setProductAllocationQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("CollectiveAllocationType") ) {
                final Object value = values.remove("CollectiveAllocationType");
                if( (value == null) || (!value.equals(getCollectiveAllocationType())) ) {
                    setCollectiveAllocationType(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProdAllocationObjectTTP") ) {
                final Object value = (values).remove("to_ProdAllocationObjectTTP");
                if( value instanceof Iterable ) {
                    if( toProdAllocationObjectTTP == null ) {
                        toProdAllocationObjectTTP = Lists.newArrayList();
                    } else {
                        toProdAllocationObjectTTP = Lists.newArrayList(toProdAllocationObjectTTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProdAllocationObjectT entity;
                        if( toProdAllocationObjectTTP.size() > i ) {
                            entity = toProdAllocationObjectTTP.get(i);
                        } else {
                            entity = new ProdAllocationObjectT();
                            toProdAllocationObjectTTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProdAllocCharcMetaDataTP") ) {
                final Object value = (values).remove("to_ProdAllocCharcMetaDataTP");
                if( value instanceof Iterable ) {
                    if( toProdAllocCharcMetaDataTP == null ) {
                        toProdAllocCharcMetaDataTP = Lists.newArrayList();
                    } else {
                        toProdAllocCharcMetaDataTP = Lists.newArrayList(toProdAllocCharcMetaDataTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProdAllocCharcMetaData entity;
                        if( toProdAllocCharcMetaDataTP.size() > i ) {
                            entity = toProdAllocCharcMetaDataTP.get(i);
                        } else {
                            entity = new ProdAllocCharcMetaData();
                            toProdAllocCharcMetaDataTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProdAllocCharcValCombnTP") ) {
                final Object value = (values).remove("to_ProdAllocCharcValCombnTP");
                if( value instanceof Iterable ) {
                    if( toProdAllocCharcValCombnTP == null ) {
                        toProdAllocCharcValCombnTP = Lists.newArrayList();
                    } else {
                        toProdAllocCharcValCombnTP = Lists.newArrayList(toProdAllocCharcValCombnTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProdAllocCharcValCombn entity;
                        if( toProdAllocCharcValCombnTP.size() > i ) {
                            entity = toProdAllocCharcValCombnTP.get(i);
                        } else {
                            entity = new ProdAllocCharcValCombn();
                            toProdAllocCharcValCombnTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProdAllocationObjectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProdAllocationObjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProdAllocationObjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProdAllocationObjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationObjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProdAllocationObjectTTP != null ) {
            (values).put("to_ProdAllocationObjectTTP", toProdAllocationObjectTTP);
        }
        if( toProdAllocCharcMetaDataTP != null ) {
            (values).put("to_ProdAllocCharcMetaDataTP", toProdAllocCharcMetaDataTP);
        }
        if( toProdAllocCharcValCombnTP != null ) {
            (values).put("to_ProdAllocCharcValCombnTP", toProdAllocCharcValCombnTP);
        }
        return values;
    }

    /**
     * Fetches the <b>ProdAllocationObjectT</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProdAllocationObjectTTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProdAllocationObjectT</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProdAllocationObjectT> fetchProdAllocationObjectTTP()
    {
        return fetchFieldAsList("to_ProdAllocationObjectTTP", ProdAllocationObjectT.class);
    }

    /**
     * Retrieval of associated <b>ProdAllocationObjectT</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProdAllocationObjectTTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocationObjectTTP</b> of a queried <b>ProdAllocationObject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProdAllocationObjectT</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProdAllocationObjectT> getProdAllocationObjectTTPOrFetch()
    {
        if( toProdAllocationObjectTTP == null ) {
            toProdAllocationObjectTTP = fetchProdAllocationObjectTTP();
        }
        return toProdAllocationObjectTTP;
    }

    /**
     * Retrieval of associated <b>ProdAllocationObjectT</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProdAllocationObjectTTP</b>.
     * <p>
     * If the navigation property for an entity <b>ProdAllocationObject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProdAllocationObjectTTP</b> is already loaded, the
     *         result will contain the <b>ProdAllocationObjectT</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProdAllocationObjectT>> getProdAllocationObjectTTPIfPresent()
    {
        return Option.of(toProdAllocationObjectTTP);
    }

    /**
     * Overwrites the list of associated <b>ProdAllocationObjectT</b> entities for the loaded navigation property
     * <b>to_ProdAllocationObjectTTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocationObjectTTP</b> of a queried <b>ProdAllocationObject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProdAllocationObjectT</b> entities.
     */
    public void setProdAllocationObjectTTP( @Nonnull final List<ProdAllocationObjectT> value )
    {
        if( toProdAllocationObjectTTP == null ) {
            toProdAllocationObjectTTP = Lists.newArrayList();
        }
        toProdAllocationObjectTTP.clear();
        toProdAllocationObjectTTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProdAllocationObjectT</b> entities. This corresponds to the OData
     * navigation property <b>to_ProdAllocationObjectTTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocationObjectTTP</b> of a queried <b>ProdAllocationObject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProdAllocationObjectT</b> entities.
     */
    public void addProdAllocationObjectTTP( ProdAllocationObjectT... entity )
    {
        if( toProdAllocationObjectTTP == null ) {
            toProdAllocationObjectTTP = Lists.newArrayList();
        }
        toProdAllocationObjectTTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProdAllocCharcMetaData</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProdAllocCharcMetaDataTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProdAllocCharcMetaData</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProdAllocCharcMetaData> fetchProdAllocCharcMetaDataTP()
    {
        return fetchFieldAsList("to_ProdAllocCharcMetaDataTP", ProdAllocCharcMetaData.class);
    }

    /**
     * Retrieval of associated <b>ProdAllocCharcMetaData</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProdAllocCharcMetaDataTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocCharcMetaDataTP</b> of a queried <b>ProdAllocationObject</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProdAllocCharcMetaData</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProdAllocCharcMetaData> getProdAllocCharcMetaDataTPOrFetch()
    {
        if( toProdAllocCharcMetaDataTP == null ) {
            toProdAllocCharcMetaDataTP = fetchProdAllocCharcMetaDataTP();
        }
        return toProdAllocCharcMetaDataTP;
    }

    /**
     * Retrieval of associated <b>ProdAllocCharcMetaData</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProdAllocCharcMetaDataTP</b>.
     * <p>
     * If the navigation property for an entity <b>ProdAllocationObject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProdAllocCharcMetaDataTP</b> is already loaded, the
     *         result will contain the <b>ProdAllocCharcMetaData</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProdAllocCharcMetaData>> getProdAllocCharcMetaDataTPIfPresent()
    {
        return Option.of(toProdAllocCharcMetaDataTP);
    }

    /**
     * Overwrites the list of associated <b>ProdAllocCharcMetaData</b> entities for the loaded navigation property
     * <b>to_ProdAllocCharcMetaDataTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocCharcMetaDataTP</b> of a queried <b>ProdAllocationObject</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProdAllocCharcMetaData</b> entities.
     */
    public void setProdAllocCharcMetaDataTP( @Nonnull final List<ProdAllocCharcMetaData> value )
    {
        if( toProdAllocCharcMetaDataTP == null ) {
            toProdAllocCharcMetaDataTP = Lists.newArrayList();
        }
        toProdAllocCharcMetaDataTP.clear();
        toProdAllocCharcMetaDataTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProdAllocCharcMetaData</b> entities. This corresponds to the OData
     * navigation property <b>to_ProdAllocCharcMetaDataTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocCharcMetaDataTP</b> of a queried <b>ProdAllocationObject</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProdAllocCharcMetaData</b> entities.
     */
    public void addProdAllocCharcMetaDataTP( ProdAllocCharcMetaData... entity )
    {
        if( toProdAllocCharcMetaDataTP == null ) {
            toProdAllocCharcMetaDataTP = Lists.newArrayList();
        }
        toProdAllocCharcMetaDataTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProdAllocCharcValCombn</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProdAllocCharcValCombnTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProdAllocCharcValCombn</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProdAllocCharcValCombn> fetchProdAllocCharcValCombnTP()
    {
        return fetchFieldAsList("to_ProdAllocCharcValCombnTP", ProdAllocCharcValCombn.class);
    }

    /**
     * Retrieval of associated <b>ProdAllocCharcValCombn</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProdAllocCharcValCombnTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocCharcValCombnTP</b> of a queried <b>ProdAllocationObject</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProdAllocCharcValCombn</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProdAllocCharcValCombn> getProdAllocCharcValCombnTPOrFetch()
    {
        if( toProdAllocCharcValCombnTP == null ) {
            toProdAllocCharcValCombnTP = fetchProdAllocCharcValCombnTP();
        }
        return toProdAllocCharcValCombnTP;
    }

    /**
     * Retrieval of associated <b>ProdAllocCharcValCombn</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProdAllocCharcValCombnTP</b>.
     * <p>
     * If the navigation property for an entity <b>ProdAllocationObject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProdAllocCharcValCombnTP</b> is already loaded, the
     *         result will contain the <b>ProdAllocCharcValCombn</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProdAllocCharcValCombn>> getProdAllocCharcValCombnTPIfPresent()
    {
        return Option.of(toProdAllocCharcValCombnTP);
    }

    /**
     * Overwrites the list of associated <b>ProdAllocCharcValCombn</b> entities for the loaded navigation property
     * <b>to_ProdAllocCharcValCombnTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocCharcValCombnTP</b> of a queried <b>ProdAllocationObject</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProdAllocCharcValCombn</b> entities.
     */
    public void setProdAllocCharcValCombnTP( @Nonnull final List<ProdAllocCharcValCombn> value )
    {
        if( toProdAllocCharcValCombnTP == null ) {
            toProdAllocCharcValCombnTP = Lists.newArrayList();
        }
        toProdAllocCharcValCombnTP.clear();
        toProdAllocCharcValCombnTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProdAllocCharcValCombn</b> entities. This corresponds to the OData
     * navigation property <b>to_ProdAllocCharcValCombnTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocCharcValCombnTP</b> of a queried <b>ProdAllocationObject</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProdAllocCharcValCombn</b> entities.
     */
    public void addProdAllocCharcValCombnTP( ProdAllocCharcValCombn... entity )
    {
        if( toProdAllocCharcValCombnTP == null ) {
            toProdAllocCharcValCombnTP = Lists.newArrayList();
        }
        toProdAllocCharcValCombnTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProdAllocationObject instances.
     *
     */
    public final static class ProdAllocationObjectBuilder
    {

        private List<ProdAllocationObjectT> toProdAllocationObjectTTP = Lists.newArrayList();
        private List<ProdAllocCharcMetaData> toProdAllocCharcMetaDataTP = Lists.newArrayList();
        private List<ProdAllocCharcValCombn> toProdAllocCharcValCombnTP = Lists.newArrayList();

        private ProdAllocationObject.ProdAllocationObjectBuilder toProdAllocationObjectTTP(
            final List<ProdAllocationObjectT> value )
        {
            toProdAllocationObjectTTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProdAllocationObjectTTP</b> for <b>ProdAllocationObject</b> to multiple
         * <b>ProdAllocationObjectT</b>.
         *
         * @param value
         *            The ProdAllocationObjectTs to build this ProdAllocationObject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdAllocationObject.ProdAllocationObjectBuilder prodAllocationObjectTTP(
            ProdAllocationObjectT... value )
        {
            return toProdAllocationObjectTTP(Lists.newArrayList(value));
        }

        private ProdAllocationObject.ProdAllocationObjectBuilder toProdAllocCharcMetaDataTP(
            final List<ProdAllocCharcMetaData> value )
        {
            toProdAllocCharcMetaDataTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProdAllocCharcMetaDataTP</b> for <b>ProdAllocationObject</b> to multiple
         * <b>ProdAllocCharcMetaData</b>.
         *
         * @param value
         *            The ProdAllocCharcMetaDatas to build this ProdAllocationObject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdAllocationObject.ProdAllocationObjectBuilder prodAllocCharcMetaDataTP(
            ProdAllocCharcMetaData... value )
        {
            return toProdAllocCharcMetaDataTP(Lists.newArrayList(value));
        }

        private ProdAllocationObject.ProdAllocationObjectBuilder toProdAllocCharcValCombnTP(
            final List<ProdAllocCharcValCombn> value )
        {
            toProdAllocCharcValCombnTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProdAllocCharcValCombnTP</b> for <b>ProdAllocationObject</b> to multiple
         * <b>ProdAllocCharcValCombn</b>.
         *
         * @param value
         *            The ProdAllocCharcValCombns to build this ProdAllocationObject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdAllocationObject.ProdAllocationObjectBuilder prodAllocCharcValCombnTP(
            ProdAllocCharcValCombn... value )
        {
            return toProdAllocCharcValCombnTP(Lists.newArrayList(value));
        }

    }

}
