/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.selectable.ProdAllocationObjectSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject
 * ProdAllocationObject} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class ProdAllocationObjectByKeyFluentHelper
    extends
    FluentHelperByKey<ProdAllocationObjectByKeyFluentHelper, ProdAllocationObject, ProdAllocationObjectSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject
     * ProdAllocationObject} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProdAllocationObject}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProdAllocationObject}
     * @param productAllocationObjectUUID
     *            Product Allocation Object UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public ProdAllocationObjectByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID productAllocationObjectUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("ProductAllocationObjectUUID", productAllocationObjectUUID);
    }

    @Override
    @Nonnull
    protected Class<ProdAllocationObject> getEntityClass()
    {
        return ProdAllocationObject.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
