/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.field.ProdAllocationObjectTField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.link.ProdAllocationObjectTOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.selectable.ProdAllocationObjectTSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Product Allocation Object Description
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProdAllocationObjectTType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProdAllocationObjectT extends VdmEntity<ProdAllocationObjectT>
{

    /**
     * Selector for all available fields of ProdAllocationObjectT.
     *
     */
    public final static ProdAllocationObjectTSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObjectUUID</b>
     * </p>
     *
     * @return Product Allocation Object UUID
     */
    @Key
    @SerializedName( "ProductAllocationObjectUUID" )
    @JsonProperty( "ProductAllocationObjectUUID" )
    @Nullable
    @ODataField( odataName = "ProductAllocationObjectUUID" )
    private UUID productAllocationObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationObjectUUID</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectTField<UUID> PRODUCT_ALLOCATION_OBJECT_UUID =
        new ProdAllocationObjectTField<UUID>("ProductAllocationObjectUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectTField<String> LANGUAGE =
        new ProdAllocationObjectTField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocObjectDescription</b>
     * </p>
     *
     * @return Product Allocation Object Description
     */
    @SerializedName( "ProdAllocObjectDescription" )
    @JsonProperty( "ProdAllocObjectDescription" )
    @Nullable
    @ODataField( odataName = "ProdAllocObjectDescription" )
    private String prodAllocObjectDescription;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocObjectDescription</b> field to query operations.
     *
     */
    public final static ProdAllocationObjectTField<String> PROD_ALLOC_OBJECT_DESCRIPTION =
        new ProdAllocationObjectTField<String>("ProdAllocObjectDescription");
    /**
     * Navigation property <b>to_ProdAllocationObjectTP</b> for <b>ProdAllocationObjectT</b> to single
     * <b>ProdAllocationObject</b>.
     *
     */
    @SerializedName( "to_ProdAllocationObjectTP" )
    @JsonProperty( "to_ProdAllocationObjectTP" )
    @ODataField( odataName = "to_ProdAllocationObjectTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProdAllocationObject toProdAllocationObjectTP;
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocationObjectTP</b> navigation property to query
     * operations.
     *
     */
    public final static ProdAllocationObjectTOneToOneLink<ProdAllocationObject> TO_PROD_ALLOCATION_OBJECT_TP =
        new ProdAllocationObjectTOneToOneLink<ProdAllocationObject>("to_ProdAllocationObjectTP");

    @Nonnull
    @Override
    public Class<ProdAllocationObjectT> getType()
    {
        return ProdAllocationObjectT.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationObjectUUID</b>
     * </p>
     *
     * @param productAllocationObjectUUID
     *            Product Allocation Object UUID
     */
    public void setProductAllocationObjectUUID( @Nullable final UUID productAllocationObjectUUID )
    {
        rememberChangedField("ProductAllocationObjectUUID", this.productAllocationObjectUUID);
        this.productAllocationObjectUUID = productAllocationObjectUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocObjectDescription</b>
     * </p>
     *
     * @param prodAllocObjectDescription
     *            Product Allocation Object Description
     */
    public void setProdAllocObjectDescription( @Nullable final String prodAllocObjectDescription )
    {
        rememberChangedField("ProdAllocObjectDescription", this.prodAllocObjectDescription);
        this.prodAllocObjectDescription = prodAllocObjectDescription;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProdAllocationObjectT";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProductAllocationObjectUUID", getProductAllocationObjectUUID());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProductAllocationObjectUUID", getProductAllocationObjectUUID());
        values.put("Language", getLanguage());
        values.put("ProdAllocObjectDescription", getProdAllocObjectDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProductAllocationObjectUUID") ) {
                final Object value = values.remove("ProductAllocationObjectUUID");
                if( (value == null) || (!value.equals(getProductAllocationObjectUUID())) ) {
                    setProductAllocationObjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ProdAllocObjectDescription") ) {
                final Object value = values.remove("ProdAllocObjectDescription");
                if( (value == null) || (!value.equals(getProdAllocObjectDescription())) ) {
                    setProdAllocObjectDescription(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProdAllocationObjectTP") ) {
                final Object value = (values).remove("to_ProdAllocationObjectTP");
                if( value instanceof Map ) {
                    if( toProdAllocationObjectTP == null ) {
                        toProdAllocationObjectTP = new ProdAllocationObject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProdAllocationObjectTP.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProdAllocationObjectTField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProdAllocationObjectTField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProdAllocationObjectTField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProdAllocationObjectTField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationObjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProdAllocationObjectTP != null ) {
            (values).put("to_ProdAllocationObjectTP", toProdAllocationObjectTP);
        }
        return values;
    }

    /**
     * Fetches the <b>ProdAllocationObject</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ProdAllocationObjectTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProdAllocationObject</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProdAllocationObject fetchProdAllocationObjectTP()
    {
        return fetchFieldAsSingle("to_ProdAllocationObjectTP", ProdAllocationObject.class);
    }

    /**
     * Retrieval of associated <b>ProdAllocationObject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProdAllocationObjectTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocationObjectTP</b> of a queried <b>ProdAllocationObjectT</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProdAllocationObject</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProdAllocationObject getProdAllocationObjectTPOrFetch()
    {
        if( toProdAllocationObjectTP == null ) {
            toProdAllocationObjectTP = fetchProdAllocationObjectTP();
        }
        return toProdAllocationObjectTP;
    }

    /**
     * Retrieval of associated <b>ProdAllocationObject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProdAllocationObjectTP</b>.
     * <p>
     * If the navigation property for an entity <b>ProdAllocationObjectT</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProdAllocationObjectTP</b> is already loaded, the result
     *         will contain the <b>ProdAllocationObject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProdAllocationObject> getProdAllocationObjectTPIfPresent()
    {
        return Option.of(toProdAllocationObjectTP);
    }

    /**
     * Overwrites the associated <b>ProdAllocationObject</b> entity for the loaded navigation property
     * <b>to_ProdAllocationObjectTP</b>.
     *
     * @param value
     *            New <b>ProdAllocationObject</b> entity.
     */
    public void setProdAllocationObjectTP( final ProdAllocationObject value )
    {
        toProdAllocationObjectTP = value;
    }

    /**
     * Helper class to allow for fluent creation of ProdAllocationObjectT instances.
     *
     */
    public final static class ProdAllocationObjectTBuilder
    {

        private ProdAllocationObject toProdAllocationObjectTP;

        private ProdAllocationObjectT.ProdAllocationObjectTBuilder toProdAllocationObjectTP(
            final ProdAllocationObject value )
        {
            toProdAllocationObjectTP = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProdAllocationObjectTP</b> for <b>ProdAllocationObjectT</b> to single
         * <b>ProdAllocationObject</b>.
         *
         * @param value
         *            The ProdAllocationObject to build this ProdAllocationObjectT with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdAllocationObjectT.ProdAllocationObjectTBuilder prodAllocationObjectTP(
            final ProdAllocationObject value )
        {
            return toProdAllocationObjectTP(value);
        }

    }

}
