/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ProductAllocationObjectServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationObjectService
 * ProductAllocationObjectService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultProductAllocationObjectServiceBatch
    extends
    BatchFluentHelperBasic<ProductAllocationObjectServiceBatch, ProductAllocationObjectServiceBatchChangeSet>
    implements
    ProductAllocationObjectServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationObjectService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultProductAllocationObjectServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductAllocationObjectServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationObjectService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationObjectService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultProductAllocationObjectServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductAllocationObjectServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationObjectService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultProductAllocationObjectServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductAllocationObjectServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultProductAllocationObjectServiceBatchChangeSet(this, service);
    }

}
