/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject;

/**
 * Implementation of the {@link ProductAllocationObjectServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationObjectService
 * ProductAllocationObjectService}.
 *
 */
public class DefaultProductAllocationObjectServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProductAllocationObjectServiceBatch, ProductAllocationObjectServiceBatchChangeSet>
    implements
    ProductAllocationObjectServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationObjectService service;

    @SuppressWarnings( "deprecation" )
    DefaultProductAllocationObjectServiceBatchChangeSet(
        @Nonnull final DefaultProductAllocationObjectServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationObjectService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProductAllocationObjectServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductAllocationObjectServiceBatchChangeSet createProdAllocationObject(
        @Nonnull final ProdAllocationObject prodAllocationObject )
    {
        return addRequestCreate(service::createProdAllocationObject, prodAllocationObject);
    }

    @Nonnull
    @Override
    public ProductAllocationObjectServiceBatchChangeSet createProdAllocCharcValCombn(
        @Nonnull final ProdAllocCharcValCombn prodAllocCharcValCombn )
    {
        return addRequestCreate(service::createProdAllocCharcValCombn, prodAllocCharcValCombn);
    }

    @Nonnull
    @Override
    public ProductAllocationObjectServiceBatchChangeSet updateProdAllocCharcValCombn(
        @Nonnull final ProdAllocCharcValCombn prodAllocCharcValCombn )
    {
        return addRequestUpdate(service::updateProdAllocCharcValCombn, prodAllocCharcValCombn);
    }

    @Nonnull
    @Override
    public ProductAllocationObjectServiceBatchChangeSet updateProdAllocObjTimeSeries(
        @Nonnull final ProdAllocObjTimeSeries prodAllocObjTimeSeries )
    {
        return addRequestUpdate(service::updateProdAllocObjTimeSeries, prodAllocObjTimeSeries);
    }

}
