/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationObjectService
 * ProductAllocationObjectService}.
 *
 */
public interface ProductAllocationObjectServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ProductAllocationObjectServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ProductAllocationObjectServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject
     * ProdAllocationObject} entity and save it to the S/4HANA system.
     *
     * @param prodAllocationObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject
     *            ProdAllocationObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductAllocationObjectServiceBatchChangeSet
        createProdAllocationObject( @Nonnull final ProdAllocationObject prodAllocationObject );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     * ProdAllocCharcValCombn} entity and save it to the S/4HANA system.
     *
     * @param prodAllocCharcValCombn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     *            ProdAllocCharcValCombn} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductAllocationObjectServiceBatchChangeSet
        createProdAllocCharcValCombn( @Nonnull final ProdAllocCharcValCombn prodAllocCharcValCombn );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     * ProdAllocCharcValCombn} entity and save it to the S/4HANA system.
     *
     * @param prodAllocCharcValCombn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
     *            ProdAllocCharcValCombn} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductAllocationObjectServiceBatchChangeSet
        updateProdAllocCharcValCombn( @Nonnull final ProdAllocCharcValCombn prodAllocCharcValCombn );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries
     * ProdAllocObjTimeSeries} entity and save it to the S/4HANA system.
     *
     * @param prodAllocObjTimeSeries
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries
     *            ProdAllocObjTimeSeries} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductAllocationObjectServiceBatchChangeSet
        updateProdAllocObjTimeSeries( @Nonnull final ProdAllocObjTimeSeries prodAllocObjTimeSeries );

}
