/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaData;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaData
 * ProdAllocCharcMetaData}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.field.ProdAllocCharcMetaDataField
 * ProdAllocCharcMetaDataField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.link.ProdAllocCharcMetaDataLink
 * ProdAllocCharcMetaDataLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaData#CHARACTERISTICS_META_DATA_UUID
 * CHARACTERISTICS_META_DATA_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaData#CHARACTERISTICS_META_DATA_UUID_TEXT
 * CHARACTERISTICS_META_DATA_UUID_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaData#PRODUCT_ALLOCATION_OBJECT_UUID
 * PRODUCT_ALLOCATION_OBJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaData#PRODUCT_ALLOCATION_OBJECT
 * PRODUCT_ALLOCATION_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaData#PROD_ALLOC_ORDINAL_NUMBER_VALUE
 * PROD_ALLOC_ORDINAL_NUMBER_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaData#TO_PROD_ALLOCATION_OBJECT_TP
 * TO_PROD_ALLOCATION_OBJECT_TP}</li>
 * </ul>
 *
 */
public interface ProdAllocCharcMetaDataSelectable extends EntitySelectable<ProdAllocCharcMetaData>
{

}
