/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn
 * ProdAllocCharcValCombn}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.field.ProdAllocCharcValCombnField
 * ProdAllocCharcValCombnField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.link.ProdAllocCharcValCombnLink
 * ProdAllocCharcValCombnLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#DELETE_ACTV_CHARC_VAL_COMBINATION_AC
 * DELETE_ACTV_CHARC_VAL_COMBINATION_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#SET_LIFECYCLE_STATUS_TO_ACTIVE_AC
 * SET_LIFECYCLE_STATUS_TO_ACTIVE_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#SET_LIFECYCLE_STATUS_TO_INACTIVE_AC
 * SET_LIFECYCLE_STATUS_TO_INACTIVE_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC01_FC
 * PROD_ALLOC_CHARC01_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC02_FC
 * PROD_ALLOC_CHARC02_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC03_FC
 * PROD_ALLOC_CHARC03_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC04_FC
 * PROD_ALLOC_CHARC04_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC05_FC
 * PROD_ALLOC_CHARC05_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC06_FC
 * PROD_ALLOC_CHARC06_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC07_FC
 * PROD_ALLOC_CHARC07_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC08_FC
 * PROD_ALLOC_CHARC08_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC09_FC
 * PROD_ALLOC_CHARC09_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC10_FC
 * PROD_ALLOC_CHARC10_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_OBJ_TIME_SERIES_TP_OC
 * PROD_ALLOC_OBJ_TIME_SERIES_TP_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#CHARC_VALUE_COMBINATION_UUID
 * CHARC_VALUE_COMBINATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PRODUCT_ALLOCATION_OBJECT_UUID
 * PRODUCT_ALLOCATION_OBJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PRODUCT_ALLOCATION_OBJECT
 * PRODUCT_ALLOCATION_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC01
 * PROD_ALLOC_CHARC01}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC02
 * PROD_ALLOC_CHARC02}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC03
 * PROD_ALLOC_CHARC03}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC04
 * PROD_ALLOC_CHARC04}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC05
 * PROD_ALLOC_CHARC05}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC06
 * PROD_ALLOC_CHARC06}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC07
 * PROD_ALLOC_CHARC07}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC08
 * PROD_ALLOC_CHARC08}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC09
 * PROD_ALLOC_CHARC09}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC10
 * PROD_ALLOC_CHARC10}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC_VALUE_COMBN_CMNT
 * PROD_ALLOC_CHARC_VALUE_COMBN_CMNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOC_CHARC_CONSTRAINT_STATUS
 * PROD_ALLOC_CHARC_CONSTRAINT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#PROD_ALLOCATION_ACTIVATION_STATUS
 * PROD_ALLOCATION_ACTIVATION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#CHARC_VAL_AUTHZN_GROUP
 * CHARC_VAL_AUTHZN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#TO_PROD_ALLOCATION_OBJECT_TP
 * TO_PROD_ALLOCATION_OBJECT_TP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn#TO_PROD_ALLOC_OBJ_TIME_SERIES_TP
 * TO_PROD_ALLOC_OBJ_TIME_SERIES_TP}</li>
 * </ul>
 *
 */
public interface ProdAllocCharcValCombnSelectable extends EntitySelectable<ProdAllocCharcValCombn>
{

}
