/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries
 * ProdAllocObjTimeSeries}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.field.ProdAllocObjTimeSeriesField
 * ProdAllocObjTimeSeriesField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.link.ProdAllocObjTimeSeriesLink
 * ProdAllocObjTimeSeriesLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries#DELETE_ACTIVE_TIME_SERIES_AC
 * DELETE_ACTIVE_TIME_SERIES_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries#PROD_ALLOCATION_TIME_SERIES_UUID
 * PROD_ALLOCATION_TIME_SERIES_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries#PRODUCT_ALLOCATION_OBJECT_UUID
 * PRODUCT_ALLOCATION_OBJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries#CHARC_VALUE_COMBINATION_UUID
 * CHARC_VALUE_COMBINATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries#PROD_ALLOC_PERD_START_UTC_DATE_TIME
 * PROD_ALLOC_PERD_START_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries#PROD_ALLOC_PERIOD_START_TIME_ZONE
 * PROD_ALLOC_PERIOD_START_TIME_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries#PROD_ALLOC_PERIOD_END_UTC_DATE_TIME
 * PROD_ALLOC_PERIOD_END_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries#PROD_ALLOC_PERIOD_END_TIME_ZONE
 * PROD_ALLOC_PERIOD_END_TIME_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries#PRODUCT_ALLOCATION_QUANTITY
 * PRODUCT_ALLOCATION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries#PRODUCT_ALLOCATION_QUANTITY_UNIT
 * PRODUCT_ALLOCATION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries#TO_PROD_ALLOC_CHARC_VAL_COMBN_TP
 * TO_PROD_ALLOC_CHARC_VAL_COMBN_TP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries#TO_PROD_ALLOCATION_OBJECT_TP
 * TO_PROD_ALLOCATION_OBJECT_TP}</li>
 * </ul>
 *
 */
public interface ProdAllocObjTimeSeriesSelectable extends EntitySelectable<ProdAllocObjTimeSeries>
{

}
