/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject
 * ProdAllocationObject}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.field.ProdAllocationObjectField
 * ProdAllocationObjectField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.link.ProdAllocationObjectLink
 * ProdAllocationObjectLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#PROD_ALLOC_CHARC_VAL_COMBN_TP_OC
 * PROD_ALLOC_CHARC_VAL_COMBN_TP_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#PRODUCT_ALLOCATION_OBJECT_UUID
 * PRODUCT_ALLOCATION_OBJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#PRODUCT_ALLOCATION_OBJECT_TEXT
 * PRODUCT_ALLOCATION_OBJECT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#PRODUCT_ALLOCATION_OBJECT
 * PRODUCT_ALLOCATION_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#PRODUCT_ALLOCATION_PERIOD_TYPE
 * PRODUCT_ALLOCATION_PERIOD_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#PROD_ALLOCATION_PERIOD_TIME_ZONE
 * PROD_ALLOCATION_PERIOD_TIME_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#FACTORY_CALENDAR
 * FACTORY_CALENDAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#PROD_ALLOC_CHECK_DATE_TIME_TYPE
 * PROD_ALLOC_CHECK_DATE_TIME_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#PRODUCT_ALLOCATION_QUANTITY_UNIT
 * PRODUCT_ALLOCATION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#COLLECTIVE_ALLOCATION_TYPE
 * COLLECTIVE_ALLOCATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#TO_PROD_ALLOCATION_OBJECT_TTP
 * TO_PROD_ALLOCATION_OBJECT_TTP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#TO_PROD_ALLOC_CHARC_META_DATA_TP
 * TO_PROD_ALLOC_CHARC_META_DATA_TP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject#TO_PROD_ALLOC_CHARC_VAL_COMBN_TP
 * TO_PROD_ALLOC_CHARC_VAL_COMBN_TP}</li>
 * </ul>
 *
 */
public interface ProdAllocationObjectSelectable extends EntitySelectable<ProdAllocationObject>
{

}
