/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectT;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectT
 * ProdAllocationObjectT}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.field.ProdAllocationObjectTField
 * ProdAllocationObjectTField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.link.ProdAllocationObjectTLink
 * ProdAllocationObjectTLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectT#PRODUCT_ALLOCATION_OBJECT_UUID
 * PRODUCT_ALLOCATION_OBJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectT#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectT#PROD_ALLOC_OBJECT_DESCRIPTION
 * PROD_ALLOC_OBJECT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectT#TO_PROD_ALLOCATION_OBJECT_TP
 * TO_PROD_ALLOCATION_OBJECT_TP}</li>
 * </ul>
 *
 */
public interface ProdAllocationObjectTSelectable extends EntitySelectable<ProdAllocationObjectT>
{

}
