/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.field.ProdAllocSequenceTField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.link.ProdAllocSequenceTOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.selectable.ProdAllocSequenceTSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Product Allocation Sequence Description
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProdAllocSequenceTType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProdAllocSequenceT extends VdmEntity<ProdAllocSequenceT>
{

    /**
     * Selector for all available fields of ProdAllocSequenceT.
     *
     */
    public final static ProdAllocSequenceTSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationSequenceUUID</b>
     * </p>
     *
     * @return Product Allocation Sequence UUID
     */
    @Key
    @SerializedName( "ProductAllocationSequenceUUID" )
    @JsonProperty( "ProductAllocationSequenceUUID" )
    @Nullable
    @ODataField( odataName = "ProductAllocationSequenceUUID" )
    private UUID productAllocationSequenceUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationSequenceUUID</b> field to query operations.
     *
     */
    public final static ProdAllocSequenceTField<UUID> PRODUCT_ALLOCATION_SEQUENCE_UUID =
        new ProdAllocSequenceTField<UUID>("ProductAllocationSequenceUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ProdAllocSequenceTField<String> LANGUAGE = new ProdAllocSequenceTField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationSequenceDesc</b>
     * </p>
     *
     * @return Product Allocation Sequence Description
     */
    @SerializedName( "ProductAllocationSequenceDesc" )
    @JsonProperty( "ProductAllocationSequenceDesc" )
    @Nullable
    @ODataField( odataName = "ProductAllocationSequenceDesc" )
    private String productAllocationSequenceDesc;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationSequenceDesc</b> field to query operations.
     *
     */
    public final static ProdAllocSequenceTField<String> PRODUCT_ALLOCATION_SEQUENCE_DESC =
        new ProdAllocSequenceTField<String>("ProductAllocationSequenceDesc");
    /**
     * Navigation property <b>to_ProdAllocationSequenceTP</b> for <b>ProdAllocSequenceT</b> to single
     * <b>ProdAllocationSequence</b>.
     *
     */
    @SerializedName( "to_ProdAllocationSequenceTP" )
    @JsonProperty( "to_ProdAllocationSequenceTP" )
    @ODataField( odataName = "to_ProdAllocationSequenceTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProdAllocationSequence toProdAllocationSequenceTP;
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocationSequenceTP</b> navigation property to query
     * operations.
     *
     */
    public final static ProdAllocSequenceTOneToOneLink<ProdAllocationSequence> TO_PROD_ALLOCATION_SEQUENCE_TP =
        new ProdAllocSequenceTOneToOneLink<ProdAllocationSequence>("to_ProdAllocationSequenceTP");

    @Nonnull
    @Override
    public Class<ProdAllocSequenceT> getType()
    {
        return ProdAllocSequenceT.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationSequenceUUID</b>
     * </p>
     *
     * @param productAllocationSequenceUUID
     *            Product Allocation Sequence UUID
     */
    public void setProductAllocationSequenceUUID( @Nullable final UUID productAllocationSequenceUUID )
    {
        rememberChangedField("ProductAllocationSequenceUUID", this.productAllocationSequenceUUID);
        this.productAllocationSequenceUUID = productAllocationSequenceUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationSequenceDesc</b>
     * </p>
     *
     * @param productAllocationSequenceDesc
     *            Product Allocation Sequence Description
     */
    public void setProductAllocationSequenceDesc( @Nullable final String productAllocationSequenceDesc )
    {
        rememberChangedField("ProductAllocationSequenceDesc", this.productAllocationSequenceDesc);
        this.productAllocationSequenceDesc = productAllocationSequenceDesc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProdAllocSequenceT";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProductAllocationSequenceUUID", getProductAllocationSequenceUUID());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProductAllocationSequenceUUID", getProductAllocationSequenceUUID());
        values.put("Language", getLanguage());
        values.put("ProductAllocationSequenceDesc", getProductAllocationSequenceDesc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProductAllocationSequenceUUID") ) {
                final Object value = values.remove("ProductAllocationSequenceUUID");
                if( (value == null) || (!value.equals(getProductAllocationSequenceUUID())) ) {
                    setProductAllocationSequenceUUID(((UUID) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ProductAllocationSequenceDesc") ) {
                final Object value = values.remove("ProductAllocationSequenceDesc");
                if( (value == null) || (!value.equals(getProductAllocationSequenceDesc())) ) {
                    setProductAllocationSequenceDesc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProdAllocationSequenceTP") ) {
                final Object value = (values).remove("to_ProdAllocationSequenceTP");
                if( value instanceof Map ) {
                    if( toProdAllocationSequenceTP == null ) {
                        toProdAllocationSequenceTP = new ProdAllocationSequence();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProdAllocationSequenceTP.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProdAllocSequenceTField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProdAllocSequenceTField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProdAllocSequenceTField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProdAllocSequenceTField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationSequenceService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProdAllocationSequenceTP != null ) {
            (values).put("to_ProdAllocationSequenceTP", toProdAllocationSequenceTP);
        }
        return values;
    }

    /**
     * Fetches the <b>ProdAllocationSequence</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProdAllocationSequenceTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProdAllocationSequence</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProdAllocationSequence fetchProdAllocationSequenceTP()
    {
        return fetchFieldAsSingle("to_ProdAllocationSequenceTP", ProdAllocationSequence.class);
    }

    /**
     * Retrieval of associated <b>ProdAllocationSequence</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ProdAllocationSequenceTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocationSequenceTP</b> of a queried <b>ProdAllocSequenceT</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProdAllocationSequence</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProdAllocationSequence getProdAllocationSequenceTPOrFetch()
    {
        if( toProdAllocationSequenceTP == null ) {
            toProdAllocationSequenceTP = fetchProdAllocationSequenceTP();
        }
        return toProdAllocationSequenceTP;
    }

    /**
     * Retrieval of associated <b>ProdAllocationSequence</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ProdAllocationSequenceTP</b>.
     * <p>
     * If the navigation property for an entity <b>ProdAllocSequenceT</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProdAllocationSequenceTP</b> is already loaded, the
     *         result will contain the <b>ProdAllocationSequence</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProdAllocationSequence> getProdAllocationSequenceTPIfPresent()
    {
        return Option.of(toProdAllocationSequenceTP);
    }

    /**
     * Overwrites the associated <b>ProdAllocationSequence</b> entity for the loaded navigation property
     * <b>to_ProdAllocationSequenceTP</b>.
     *
     * @param value
     *            New <b>ProdAllocationSequence</b> entity.
     */
    public void setProdAllocationSequenceTP( final ProdAllocationSequence value )
    {
        toProdAllocationSequenceTP = value;
    }

    /**
     * Helper class to allow for fluent creation of ProdAllocSequenceT instances.
     *
     */
    public final static class ProdAllocSequenceTBuilder
    {

        private ProdAllocationSequence toProdAllocationSequenceTP;

        private ProdAllocSequenceT.ProdAllocSequenceTBuilder toProdAllocationSequenceTP(
            final ProdAllocationSequence value )
        {
            toProdAllocationSequenceTP = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProdAllocationSequenceTP</b> for <b>ProdAllocSequenceT</b> to single
         * <b>ProdAllocationSequence</b>.
         *
         * @param value
         *            The ProdAllocationSequence to build this ProdAllocSequenceT with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdAllocSequenceT.ProdAllocSequenceTBuilder prodAllocationSequenceTP(
            final ProdAllocationSequence value )
        {
            return toProdAllocationSequenceTP(value);
        }

    }

}
