/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.field.ProdAllocSqncAssgmtField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.link.ProdAllocSqncAssgmtOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.selectable.ProdAllocSqncAssgmtSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Product Allocation Sequence Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProdAllocSqncAssgmtType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProdAllocSqncAssgmt extends VdmEntity<ProdAllocSqncAssgmt>
{

    /**
     * Selector for all available fields of ProdAllocSqncAssgmt.
     *
     */
    public final static ProdAllocSqncAssgmtSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DeleteSequenceAssignment_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "DeleteSequenceAssignment_ac" )
    @JsonProperty( "DeleteSequenceAssignment_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DeleteSequenceAssignment_ac" )
    private Boolean deleteSequenceAssignment_ac;
    /**
     * Use with available fluent helpers to apply the <b>DeleteSequenceAssignment_ac</b> field to query operations.
     *
     */
    public final static ProdAllocSqncAssgmtField<Boolean> DELETE_SEQUENCE_ASSIGNMENT_AC =
        new ProdAllocSqncAssgmtField<Boolean>("DeleteSequenceAssignment_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Material_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "Material_fc" )
    @JsonProperty( "Material_fc" )
    @Nullable
    @ODataField( odataName = "Material_fc" )
    private Short material_fc;
    /**
     * Use with available fluent helpers to apply the <b>Material_fc</b> field to query operations.
     *
     */
    public final static ProdAllocSqncAssgmtField<Short> MATERIAL_FC =
        new ProdAllocSqncAssgmtField<Short>("Material_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Plant_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "Plant_fc" )
    @JsonProperty( "Plant_fc" )
    @Nullable
    @ODataField( odataName = "Plant_fc" )
    private Short plant_fc;
    /**
     * Use with available fluent helpers to apply the <b>Plant_fc</b> field to query operations.
     *
     */
    public final static ProdAllocSqncAssgmtField<Short> PLANT_FC = new ProdAllocSqncAssgmtField<Short>("Plant_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ProdAllocSqncAssgmtField<Boolean> UPDATE_MC =
        new ProdAllocSqncAssgmtField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocSqncAssignmentUUID</b>
     * </p>
     *
     * @return Product Allocation Sequence Assignment UUID
     */
    @Key
    @SerializedName( "ProdAllocSqncAssignmentUUID" )
    @JsonProperty( "ProdAllocSqncAssignmentUUID" )
    @Nullable
    @ODataField( odataName = "ProdAllocSqncAssignmentUUID" )
    private UUID prodAllocSqncAssignmentUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocSqncAssignmentUUID</b> field to query operations.
     *
     */
    public final static ProdAllocSqncAssgmtField<UUID> PROD_ALLOC_SQNC_ASSIGNMENT_UUID =
        new ProdAllocSqncAssgmtField<UUID>("ProdAllocSqncAssignmentUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationSequenceUUID</b>
     * </p>
     *
     * @return Product Allocation Sequence UUID
     */
    @SerializedName( "ProductAllocationSequenceUUID" )
    @JsonProperty( "ProductAllocationSequenceUUID" )
    @Nullable
    @ODataField( odataName = "ProductAllocationSequenceUUID" )
    private UUID productAllocationSequenceUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationSequenceUUID</b> field to query operations.
     *
     */
    public final static ProdAllocSqncAssgmtField<UUID> PRODUCT_ALLOCATION_SEQUENCE_UUID =
        new ProdAllocSqncAssgmtField<UUID>("ProductAllocationSequenceUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationSequence</b>
     * </p>
     *
     * @return Product Allocation Sequence
     */
    @SerializedName( "ProductAllocationSequence" )
    @JsonProperty( "ProductAllocationSequence" )
    @Nullable
    @ODataField( odataName = "ProductAllocationSequence" )
    private String productAllocationSequence;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationSequence</b> field to query operations.
     *
     */
    public final static ProdAllocSqncAssgmtField<String> PRODUCT_ALLOCATION_SEQUENCE =
        new ProdAllocSqncAssgmtField<String>("ProductAllocationSequence");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ProdAllocSqncAssgmtField<String> MATERIAL = new ProdAllocSqncAssgmtField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProdAllocSqncAssgmtField<String> PLANT = new ProdAllocSqncAssgmtField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartUTCDateTime</b>
     * </p>
     *
     * @return Validity Start UTC Date Time
     */
    @SerializedName( "ValidityStartUTCDateTime" )
    @JsonProperty( "ValidityStartUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime validityStartUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartUTCDateTime</b> field to query operations.
     *
     */
    public final static ProdAllocSqncAssgmtField<ZonedDateTime> VALIDITY_START_UTC_DATE_TIME =
        new ProdAllocSqncAssgmtField<ZonedDateTime>("ValidityStartUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartTimeZone</b>
     * </p>
     *
     * @return Validity Start Time Zone
     */
    @SerializedName( "ValidityStartTimeZone" )
    @JsonProperty( "ValidityStartTimeZone" )
    @Nullable
    @ODataField( odataName = "ValidityStartTimeZone" )
    private String validityStartTimeZone;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartTimeZone</b> field to query operations.
     *
     */
    public final static ProdAllocSqncAssgmtField<String> VALIDITY_START_TIME_ZONE =
        new ProdAllocSqncAssgmtField<String>("ValidityStartTimeZone");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndUTCDateTime</b>
     * </p>
     *
     * @return Validity End UTC Date Time
     */
    @SerializedName( "ValidityEndUTCDateTime" )
    @JsonProperty( "ValidityEndUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime validityEndUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndUTCDateTime</b> field to query operations.
     *
     */
    public final static ProdAllocSqncAssgmtField<ZonedDateTime> VALIDITY_END_UTC_DATE_TIME =
        new ProdAllocSqncAssgmtField<ZonedDateTime>("ValidityEndUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndTimeZone</b>
     * </p>
     *
     * @return Validity End Time Zone
     */
    @SerializedName( "ValidityEndTimeZone" )
    @JsonProperty( "ValidityEndTimeZone" )
    @Nullable
    @ODataField( odataName = "ValidityEndTimeZone" )
    private String validityEndTimeZone;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndTimeZone</b> field to query operations.
     *
     */
    public final static ProdAllocSqncAssgmtField<String> VALIDITY_END_TIME_ZONE =
        new ProdAllocSqncAssgmtField<String>("ValidityEndTimeZone");
    /**
     * Navigation property <b>to_ProdAllocationSequenceTP</b> for <b>ProdAllocSqncAssgmt</b> to single
     * <b>ProdAllocationSequence</b>.
     *
     */
    @SerializedName( "to_ProdAllocationSequenceTP" )
    @JsonProperty( "to_ProdAllocationSequenceTP" )
    @ODataField( odataName = "to_ProdAllocationSequenceTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProdAllocationSequence toProdAllocationSequenceTP;
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocationSequenceTP</b> navigation property to query
     * operations.
     *
     */
    public final static ProdAllocSqncAssgmtOneToOneLink<ProdAllocationSequence> TO_PROD_ALLOCATION_SEQUENCE_TP =
        new ProdAllocSqncAssgmtOneToOneLink<ProdAllocationSequence>("to_ProdAllocationSequenceTP");

    @Nonnull
    @Override
    public Class<ProdAllocSqncAssgmt> getType()
    {
        return ProdAllocSqncAssgmt.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DeleteSequenceAssignment_ac</b>
     * </p>
     *
     * @param deleteSequenceAssignment_ac
     *            Dyn. Action Control
     */
    public void setDeleteSequenceAssignment_ac( @Nullable final Boolean deleteSequenceAssignment_ac )
    {
        rememberChangedField("DeleteSequenceAssignment_ac", this.deleteSequenceAssignment_ac);
        this.deleteSequenceAssignment_ac = deleteSequenceAssignment_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Material_fc</b>
     * </p>
     *
     * @param material_fc
     *            Dyn. Field Control
     */
    public void setMaterial_fc( @Nullable final Short material_fc )
    {
        rememberChangedField("Material_fc", this.material_fc);
        this.material_fc = material_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Plant_fc</b>
     * </p>
     *
     * @param plant_fc
     *            Dyn. Field Control
     */
    public void setPlant_fc( @Nullable final Short plant_fc )
    {
        rememberChangedField("Plant_fc", this.plant_fc);
        this.plant_fc = plant_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocSqncAssignmentUUID</b>
     * </p>
     *
     * @param prodAllocSqncAssignmentUUID
     *            Product Allocation Sequence Assignment UUID
     */
    public void setProdAllocSqncAssignmentUUID( @Nullable final UUID prodAllocSqncAssignmentUUID )
    {
        rememberChangedField("ProdAllocSqncAssignmentUUID", this.prodAllocSqncAssignmentUUID);
        this.prodAllocSqncAssignmentUUID = prodAllocSqncAssignmentUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationSequenceUUID</b>
     * </p>
     *
     * @param productAllocationSequenceUUID
     *            Product Allocation Sequence UUID
     */
    public void setProductAllocationSequenceUUID( @Nullable final UUID productAllocationSequenceUUID )
    {
        rememberChangedField("ProductAllocationSequenceUUID", this.productAllocationSequenceUUID);
        this.productAllocationSequenceUUID = productAllocationSequenceUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationSequence</b>
     * </p>
     *
     * @param productAllocationSequence
     *            Product Allocation Sequence
     */
    public void setProductAllocationSequence( @Nullable final String productAllocationSequence )
    {
        rememberChangedField("ProductAllocationSequence", this.productAllocationSequence);
        this.productAllocationSequence = productAllocationSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartUTCDateTime</b>
     * </p>
     *
     * @param validityStartUTCDateTime
     *            Validity Start UTC Date Time
     */
    public void setValidityStartUTCDateTime( @Nullable final ZonedDateTime validityStartUTCDateTime )
    {
        rememberChangedField("ValidityStartUTCDateTime", this.validityStartUTCDateTime);
        this.validityStartUTCDateTime = validityStartUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartTimeZone</b>
     * </p>
     *
     * @param validityStartTimeZone
     *            Validity Start Time Zone
     */
    public void setValidityStartTimeZone( @Nullable final String validityStartTimeZone )
    {
        rememberChangedField("ValidityStartTimeZone", this.validityStartTimeZone);
        this.validityStartTimeZone = validityStartTimeZone;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndUTCDateTime</b>
     * </p>
     *
     * @param validityEndUTCDateTime
     *            Validity End UTC Date Time
     */
    public void setValidityEndUTCDateTime( @Nullable final ZonedDateTime validityEndUTCDateTime )
    {
        rememberChangedField("ValidityEndUTCDateTime", this.validityEndUTCDateTime);
        this.validityEndUTCDateTime = validityEndUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndTimeZone</b>
     * </p>
     *
     * @param validityEndTimeZone
     *            Validity End Time Zone
     */
    public void setValidityEndTimeZone( @Nullable final String validityEndTimeZone )
    {
        rememberChangedField("ValidityEndTimeZone", this.validityEndTimeZone);
        this.validityEndTimeZone = validityEndTimeZone;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProdAllocSqncAssgmt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProdAllocSqncAssignmentUUID", getProdAllocSqncAssignmentUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DeleteSequenceAssignment_ac", getDeleteSequenceAssignment_ac());
        values.put("Material_fc", getMaterial_fc());
        values.put("Plant_fc", getPlant_fc());
        values.put("Update_mc", getUpdate_mc());
        values.put("ProdAllocSqncAssignmentUUID", getProdAllocSqncAssignmentUUID());
        values.put("ProductAllocationSequenceUUID", getProductAllocationSequenceUUID());
        values.put("ProductAllocationSequence", getProductAllocationSequence());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("ValidityStartUTCDateTime", getValidityStartUTCDateTime());
        values.put("ValidityStartTimeZone", getValidityStartTimeZone());
        values.put("ValidityEndUTCDateTime", getValidityEndUTCDateTime());
        values.put("ValidityEndTimeZone", getValidityEndTimeZone());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DeleteSequenceAssignment_ac") ) {
                final Object value = values.remove("DeleteSequenceAssignment_ac");
                if( (value == null) || (!value.equals(getDeleteSequenceAssignment_ac())) ) {
                    setDeleteSequenceAssignment_ac(((Boolean) value));
                }
            }
            if( values.containsKey("Material_fc") ) {
                final Object value = values.remove("Material_fc");
                if( (value == null) || (!value.equals(getMaterial_fc())) ) {
                    setMaterial_fc(((Short) value));
                }
            }
            if( values.containsKey("Plant_fc") ) {
                final Object value = values.remove("Plant_fc");
                if( (value == null) || (!value.equals(getPlant_fc())) ) {
                    setPlant_fc(((Short) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ProdAllocSqncAssignmentUUID") ) {
                final Object value = values.remove("ProdAllocSqncAssignmentUUID");
                if( (value == null) || (!value.equals(getProdAllocSqncAssignmentUUID())) ) {
                    setProdAllocSqncAssignmentUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProductAllocationSequenceUUID") ) {
                final Object value = values.remove("ProductAllocationSequenceUUID");
                if( (value == null) || (!value.equals(getProductAllocationSequenceUUID())) ) {
                    setProductAllocationSequenceUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProductAllocationSequence") ) {
                final Object value = values.remove("ProductAllocationSequence");
                if( (value == null) || (!value.equals(getProductAllocationSequence())) ) {
                    setProductAllocationSequence(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ValidityStartUTCDateTime") ) {
                final Object value = values.remove("ValidityStartUTCDateTime");
                if( (value == null) || (!value.equals(getValidityStartUTCDateTime())) ) {
                    setValidityStartUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartTimeZone") ) {
                final Object value = values.remove("ValidityStartTimeZone");
                if( (value == null) || (!value.equals(getValidityStartTimeZone())) ) {
                    setValidityStartTimeZone(((String) value));
                }
            }
            if( values.containsKey("ValidityEndUTCDateTime") ) {
                final Object value = values.remove("ValidityEndUTCDateTime");
                if( (value == null) || (!value.equals(getValidityEndUTCDateTime())) ) {
                    setValidityEndUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndTimeZone") ) {
                final Object value = values.remove("ValidityEndTimeZone");
                if( (value == null) || (!value.equals(getValidityEndTimeZone())) ) {
                    setValidityEndTimeZone(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProdAllocationSequenceTP") ) {
                final Object value = (values).remove("to_ProdAllocationSequenceTP");
                if( value instanceof Map ) {
                    if( toProdAllocationSequenceTP == null ) {
                        toProdAllocationSequenceTP = new ProdAllocationSequence();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProdAllocationSequenceTP.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProdAllocSqncAssgmtField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProdAllocSqncAssgmtField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProdAllocSqncAssgmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProdAllocSqncAssgmtField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationSequenceService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProdAllocationSequenceTP != null ) {
            (values).put("to_ProdAllocationSequenceTP", toProdAllocationSequenceTP);
        }
        return values;
    }

    /**
     * Fetches the <b>ProdAllocationSequence</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProdAllocationSequenceTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProdAllocationSequence</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProdAllocationSequence fetchProdAllocationSequenceTP()
    {
        return fetchFieldAsSingle("to_ProdAllocationSequenceTP", ProdAllocationSequence.class);
    }

    /**
     * Retrieval of associated <b>ProdAllocationSequence</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ProdAllocationSequenceTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocationSequenceTP</b> of a queried <b>ProdAllocSqncAssgmt</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProdAllocationSequence</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProdAllocationSequence getProdAllocationSequenceTPOrFetch()
    {
        if( toProdAllocationSequenceTP == null ) {
            toProdAllocationSequenceTP = fetchProdAllocationSequenceTP();
        }
        return toProdAllocationSequenceTP;
    }

    /**
     * Retrieval of associated <b>ProdAllocationSequence</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ProdAllocationSequenceTP</b>.
     * <p>
     * If the navigation property for an entity <b>ProdAllocSqncAssgmt</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProdAllocationSequenceTP</b> is already loaded, the
     *         result will contain the <b>ProdAllocationSequence</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProdAllocationSequence> getProdAllocationSequenceTPIfPresent()
    {
        return Option.of(toProdAllocationSequenceTP);
    }

    /**
     * Overwrites the associated <b>ProdAllocationSequence</b> entity for the loaded navigation property
     * <b>to_ProdAllocationSequenceTP</b>.
     *
     * @param value
     *            New <b>ProdAllocationSequence</b> entity.
     */
    public void setProdAllocationSequenceTP( final ProdAllocationSequence value )
    {
        toProdAllocationSequenceTP = value;
    }

    /**
     * Helper class to allow for fluent creation of ProdAllocSqncAssgmt instances.
     *
     */
    public final static class ProdAllocSqncAssgmtBuilder
    {

        private ProdAllocationSequence toProdAllocationSequenceTP;

        private ProdAllocSqncAssgmt.ProdAllocSqncAssgmtBuilder toProdAllocationSequenceTP(
            final ProdAllocationSequence value )
        {
            toProdAllocationSequenceTP = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProdAllocationSequenceTP</b> for <b>ProdAllocSqncAssgmt</b> to single
         * <b>ProdAllocationSequence</b>.
         *
         * @param value
         *            The ProdAllocationSequence to build this ProdAllocSqncAssgmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdAllocSqncAssgmt.ProdAllocSqncAssgmtBuilder prodAllocationSequenceTP(
            final ProdAllocationSequence value )
        {
            return toProdAllocationSequenceTP(value);
        }

    }

}
