/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.selectable.ProdAllocSqncAssgmtSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt
 * ProdAllocSqncAssgmt} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class ProdAllocSqncAssgmtByKeyFluentHelper
    extends
    FluentHelperByKey<ProdAllocSqncAssgmtByKeyFluentHelper, ProdAllocSqncAssgmt, ProdAllocSqncAssgmtSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt
     * ProdAllocSqncAssgmt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProdAllocSqncAssgmt}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProdAllocSqncAssgmt}
     * @param prodAllocSqncAssignmentUUID
     *            Product Allocation Sequence Assignment UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public ProdAllocSqncAssgmtByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID prodAllocSqncAssignmentUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("ProdAllocSqncAssignmentUUID", prodAllocSqncAssignmentUUID);
    }

    @Override
    @Nonnull
    protected Class<ProdAllocSqncAssgmt> getEntityClass()
    {
        return ProdAllocSqncAssgmt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
