/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.field.ProdAllocationSequenceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.link.ProdAllocationSequenceLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.selectable.ProdAllocationSequenceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Product Allocation Sequence
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProdAllocationSequenceType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProdAllocationSequence extends VdmEntity<ProdAllocationSequence>
{

    /**
     * Selector for all available fields of ProdAllocationSequence.
     *
     */
    public final static ProdAllocationSequenceSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ProdAllocSqncAssgmtTP_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ProdAllocSqncAssgmtTP_oc" )
    @JsonProperty( "to_ProdAllocSqncAssgmtTP_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ProdAllocSqncAssgmtTP_oc" )
    private Boolean prodAllocSqncAssgmtTP_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocSqncAssgmtTP_oc</b> field to query operations.
     *
     */
    public final static ProdAllocationSequenceField<Boolean> PROD_ALLOC_SQNC_ASSGMT_TP_OC =
        new ProdAllocationSequenceField<Boolean>("to_ProdAllocSqncAssgmtTP_oc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationSequenceUUID</b>
     * </p>
     *
     * @return Product Allocation Sequence UUID
     */
    @Key
    @SerializedName( "ProductAllocationSequenceUUID" )
    @JsonProperty( "ProductAllocationSequenceUUID" )
    @Nullable
    @ODataField( odataName = "ProductAllocationSequenceUUID" )
    private UUID productAllocationSequenceUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationSequenceUUID</b> field to query operations.
     *
     */
    public final static ProdAllocationSequenceField<UUID> PRODUCT_ALLOCATION_SEQUENCE_UUID =
        new ProdAllocationSequenceField<UUID>("ProductAllocationSequenceUUID");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationSequence_Text</b>
     * </p>
     *
     * @return Product Allocation Sequence Description
     */
    @SerializedName( "ProductAllocationSequence_Text" )
    @JsonProperty( "ProductAllocationSequence_Text" )
    @Nullable
    @ODataField( odataName = "ProductAllocationSequence_Text" )
    private String productAllocationSequence_Text;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationSequence_Text</b> field to query operations.
     *
     */
    public final static ProdAllocationSequenceField<String> PRODUCT_ALLOCATION_SEQUENCE_TEXT =
        new ProdAllocationSequenceField<String>("ProductAllocationSequence_Text");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationSequence</b>
     * </p>
     *
     * @return Product Allocation Sequence
     */
    @SerializedName( "ProductAllocationSequence" )
    @JsonProperty( "ProductAllocationSequence" )
    @Nullable
    @ODataField( odataName = "ProductAllocationSequence" )
    private String productAllocationSequence;
    /**
     * Use with available fluent helpers to apply the <b>ProductAllocationSequence</b> field to query operations.
     *
     */
    public final static ProdAllocationSequenceField<String> PRODUCT_ALLOCATION_SEQUENCE =
        new ProdAllocationSequenceField<String>("ProductAllocationSequence");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocSqncConsumptionUnit</b>
     * </p>
     *
     * @return Product Allocation Sequence Consumption Unit
     */
    @SerializedName( "ProdAllocSqncConsumptionUnit" )
    @JsonProperty( "ProdAllocSqncConsumptionUnit" )
    @Nullable
    @ODataField( odataName = "ProdAllocSqncConsumptionUnit" )
    private String prodAllocSqncConsumptionUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProdAllocSqncConsumptionUnit</b> field to query operations.
     *
     */
    public final static ProdAllocationSequenceField<String> PROD_ALLOC_SQNC_CONSUMPTION_UNIT =
        new ProdAllocationSequenceField<String>("ProdAllocSqncConsumptionUnit");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Creation Date Time
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ProdAllocationSequenceField<ZonedDateTime> CREATION_DATE_TIME =
        new ProdAllocationSequenceField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created by User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ProdAllocationSequenceField<String> CREATED_BY_USER =
        new ProdAllocationSequenceField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Date Time
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProdAllocationSequenceField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ProdAllocationSequenceField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed by User
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ProdAllocationSequenceField<String> LAST_CHANGED_BY_USER =
        new ProdAllocationSequenceField<String>("LastChangedByUser");
    /**
     * Navigation property <b>to_ProdAllocSequenceTTP</b> for <b>ProdAllocationSequence</b> to multiple
     * <b>ProdAllocSequenceT</b>.
     *
     */
    @SerializedName( "to_ProdAllocSequenceTTP" )
    @JsonProperty( "to_ProdAllocSequenceTTP" )
    @ODataField( odataName = "to_ProdAllocSequenceTTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProdAllocSequenceT> toProdAllocSequenceTTP;
    /**
     * Navigation property <b>to_ProdAllocSqncAssgmtTP</b> for <b>ProdAllocationSequence</b> to multiple
     * <b>ProdAllocSqncAssgmt</b>.
     *
     */
    @SerializedName( "to_ProdAllocSqncAssgmtTP" )
    @JsonProperty( "to_ProdAllocSqncAssgmtTP" )
    @ODataField( odataName = "to_ProdAllocSqncAssgmtTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProdAllocSqncAssgmt> toProdAllocSqncAssgmtTP;
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocSequenceTTP</b> navigation property to query
     * operations.
     *
     */
    public final static ProdAllocationSequenceLink<ProdAllocSequenceT> TO_PROD_ALLOC_SEQUENCE_TTP =
        new ProdAllocationSequenceLink<ProdAllocSequenceT>("to_ProdAllocSequenceTTP");
    /**
     * Use with available fluent helpers to apply the <b>to_ProdAllocSqncAssgmtTP</b> navigation property to query
     * operations.
     *
     */
    public final static ProdAllocationSequenceLink<ProdAllocSqncAssgmt> TO_PROD_ALLOC_SQNC_ASSGMT_TP =
        new ProdAllocationSequenceLink<ProdAllocSqncAssgmt>("to_ProdAllocSqncAssgmtTP");

    @Nonnull
    @Override
    public Class<ProdAllocationSequence> getType()
    {
        return ProdAllocationSequence.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ProdAllocSqncAssgmtTP_oc</b>
     * </p>
     *
     * @param prodAllocSqncAssgmtTP_oc
     *            Dynamic CbA-Control
     */
    public void setProdAllocSqncAssgmtTP_oc( @Nullable final Boolean prodAllocSqncAssgmtTP_oc )
    {
        rememberChangedField("to_ProdAllocSqncAssgmtTP_oc", this.prodAllocSqncAssgmtTP_oc);
        this.prodAllocSqncAssgmtTP_oc = prodAllocSqncAssgmtTP_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationSequenceUUID</b>
     * </p>
     *
     * @param productAllocationSequenceUUID
     *            Product Allocation Sequence UUID
     */
    public void setProductAllocationSequenceUUID( @Nullable final UUID productAllocationSequenceUUID )
    {
        rememberChangedField("ProductAllocationSequenceUUID", this.productAllocationSequenceUUID);
        this.productAllocationSequenceUUID = productAllocationSequenceUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationSequence_Text</b>
     * </p>
     *
     * @param productAllocationSequence_Text
     *            Product Allocation Sequence Description
     */
    public void setProductAllocationSequence_Text( @Nullable final String productAllocationSequence_Text )
    {
        rememberChangedField("ProductAllocationSequence_Text", this.productAllocationSequence_Text);
        this.productAllocationSequence_Text = productAllocationSequence_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductAllocationSequence</b>
     * </p>
     *
     * @param productAllocationSequence
     *            Product Allocation Sequence
     */
    public void setProductAllocationSequence( @Nullable final String productAllocationSequence )
    {
        rememberChangedField("ProductAllocationSequence", this.productAllocationSequence);
        this.productAllocationSequence = productAllocationSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdAllocSqncConsumptionUnit</b>
     * </p>
     *
     * @param prodAllocSqncConsumptionUnit
     *            Product Allocation Sequence Consumption Unit
     */
    public void setProdAllocSqncConsumptionUnit( @Nullable final String prodAllocSqncConsumptionUnit )
    {
        rememberChangedField("ProdAllocSqncConsumptionUnit", this.prodAllocSqncConsumptionUnit);
        this.prodAllocSqncConsumptionUnit = prodAllocSqncConsumptionUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Creation Date Time
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created by User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Date Time
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed by User
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProdAllocationSequence";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProductAllocationSequenceUUID", getProductAllocationSequenceUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("to_ProdAllocSqncAssgmtTP_oc", getProdAllocSqncAssgmtTP_oc());
        values.put("ProductAllocationSequenceUUID", getProductAllocationSequenceUUID());
        values.put("ProductAllocationSequence_Text", getProductAllocationSequence_Text());
        values.put("ProductAllocationSequence", getProductAllocationSequence());
        values.put("ProdAllocSqncConsumptionUnit", getProdAllocSqncConsumptionUnit());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("to_ProdAllocSqncAssgmtTP_oc") ) {
                final Object value = values.remove("to_ProdAllocSqncAssgmtTP_oc");
                if( (value == null) || (!value.equals(getProdAllocSqncAssgmtTP_oc())) ) {
                    setProdAllocSqncAssgmtTP_oc(((Boolean) value));
                }
            }
            if( values.containsKey("ProductAllocationSequenceUUID") ) {
                final Object value = values.remove("ProductAllocationSequenceUUID");
                if( (value == null) || (!value.equals(getProductAllocationSequenceUUID())) ) {
                    setProductAllocationSequenceUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProductAllocationSequence_Text") ) {
                final Object value = values.remove("ProductAllocationSequence_Text");
                if( (value == null) || (!value.equals(getProductAllocationSequence_Text())) ) {
                    setProductAllocationSequence_Text(((String) value));
                }
            }
            if( values.containsKey("ProductAllocationSequence") ) {
                final Object value = values.remove("ProductAllocationSequence");
                if( (value == null) || (!value.equals(getProductAllocationSequence())) ) {
                    setProductAllocationSequence(((String) value));
                }
            }
            if( values.containsKey("ProdAllocSqncConsumptionUnit") ) {
                final Object value = values.remove("ProdAllocSqncConsumptionUnit");
                if( (value == null) || (!value.equals(getProdAllocSqncConsumptionUnit())) ) {
                    setProdAllocSqncConsumptionUnit(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProdAllocSequenceTTP") ) {
                final Object value = (values).remove("to_ProdAllocSequenceTTP");
                if( value instanceof Iterable ) {
                    if( toProdAllocSequenceTTP == null ) {
                        toProdAllocSequenceTTP = Lists.newArrayList();
                    } else {
                        toProdAllocSequenceTTP = Lists.newArrayList(toProdAllocSequenceTTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProdAllocSequenceT entity;
                        if( toProdAllocSequenceTTP.size() > i ) {
                            entity = toProdAllocSequenceTTP.get(i);
                        } else {
                            entity = new ProdAllocSequenceT();
                            toProdAllocSequenceTTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProdAllocSqncAssgmtTP") ) {
                final Object value = (values).remove("to_ProdAllocSqncAssgmtTP");
                if( value instanceof Iterable ) {
                    if( toProdAllocSqncAssgmtTP == null ) {
                        toProdAllocSqncAssgmtTP = Lists.newArrayList();
                    } else {
                        toProdAllocSqncAssgmtTP = Lists.newArrayList(toProdAllocSqncAssgmtTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProdAllocSqncAssgmt entity;
                        if( toProdAllocSqncAssgmtTP.size() > i ) {
                            entity = toProdAllocSqncAssgmtTP.get(i);
                        } else {
                            entity = new ProdAllocSqncAssgmt();
                            toProdAllocSqncAssgmtTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProdAllocationSequenceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProdAllocationSequenceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProdAllocationSequenceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProdAllocationSequenceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationSequenceService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProdAllocSequenceTTP != null ) {
            (values).put("to_ProdAllocSequenceTTP", toProdAllocSequenceTTP);
        }
        if( toProdAllocSqncAssgmtTP != null ) {
            (values).put("to_ProdAllocSqncAssgmtTP", toProdAllocSqncAssgmtTP);
        }
        return values;
    }

    /**
     * Fetches the <b>ProdAllocSequenceT</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ProdAllocSequenceTTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProdAllocSequenceT</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProdAllocSequenceT> fetchProdAllocSequenceTTP()
    {
        return fetchFieldAsList("to_ProdAllocSequenceTTP", ProdAllocSequenceT.class);
    }

    /**
     * Retrieval of associated <b>ProdAllocSequenceT</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProdAllocSequenceTTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocSequenceTTP</b> of a queried <b>ProdAllocationSequence</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProdAllocSequenceT</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProdAllocSequenceT> getProdAllocSequenceTTPOrFetch()
    {
        if( toProdAllocSequenceTTP == null ) {
            toProdAllocSequenceTTP = fetchProdAllocSequenceTTP();
        }
        return toProdAllocSequenceTTP;
    }

    /**
     * Retrieval of associated <b>ProdAllocSequenceT</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProdAllocSequenceTTP</b>.
     * <p>
     * If the navigation property for an entity <b>ProdAllocationSequence</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProdAllocSequenceTTP</b> is already loaded, the result
     *         will contain the <b>ProdAllocSequenceT</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProdAllocSequenceT>> getProdAllocSequenceTTPIfPresent()
    {
        return Option.of(toProdAllocSequenceTTP);
    }

    /**
     * Overwrites the list of associated <b>ProdAllocSequenceT</b> entities for the loaded navigation property
     * <b>to_ProdAllocSequenceTTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocSequenceTTP</b> of a queried <b>ProdAllocationSequence</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProdAllocSequenceT</b> entities.
     */
    public void setProdAllocSequenceTTP( @Nonnull final List<ProdAllocSequenceT> value )
    {
        if( toProdAllocSequenceTTP == null ) {
            toProdAllocSequenceTTP = Lists.newArrayList();
        }
        toProdAllocSequenceTTP.clear();
        toProdAllocSequenceTTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProdAllocSequenceT</b> entities. This corresponds to the OData
     * navigation property <b>to_ProdAllocSequenceTTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocSequenceTTP</b> of a queried <b>ProdAllocationSequence</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProdAllocSequenceT</b> entities.
     */
    public void addProdAllocSequenceTTP( ProdAllocSequenceT... entity )
    {
        if( toProdAllocSequenceTTP == null ) {
            toProdAllocSequenceTTP = Lists.newArrayList();
        }
        toProdAllocSequenceTTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProdAllocSqncAssgmt</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProdAllocSqncAssgmtTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProdAllocSqncAssgmt</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProdAllocSqncAssgmt> fetchProdAllocSqncAssgmtTP()
    {
        return fetchFieldAsList("to_ProdAllocSqncAssgmtTP", ProdAllocSqncAssgmt.class);
    }

    /**
     * Retrieval of associated <b>ProdAllocSqncAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProdAllocSqncAssgmtTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocSqncAssgmtTP</b> of a queried <b>ProdAllocationSequence</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProdAllocSqncAssgmt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProdAllocSqncAssgmt> getProdAllocSqncAssgmtTPOrFetch()
    {
        if( toProdAllocSqncAssgmtTP == null ) {
            toProdAllocSqncAssgmtTP = fetchProdAllocSqncAssgmtTP();
        }
        return toProdAllocSqncAssgmtTP;
    }

    /**
     * Retrieval of associated <b>ProdAllocSqncAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProdAllocSqncAssgmtTP</b>.
     * <p>
     * If the navigation property for an entity <b>ProdAllocationSequence</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProdAllocSqncAssgmtTP</b> is already loaded, the result
     *         will contain the <b>ProdAllocSqncAssgmt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProdAllocSqncAssgmt>> getProdAllocSqncAssgmtTPIfPresent()
    {
        return Option.of(toProdAllocSqncAssgmtTP);
    }

    /**
     * Overwrites the list of associated <b>ProdAllocSqncAssgmt</b> entities for the loaded navigation property
     * <b>to_ProdAllocSqncAssgmtTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocSqncAssgmtTP</b> of a queried <b>ProdAllocationSequence</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProdAllocSqncAssgmt</b> entities.
     */
    public void setProdAllocSqncAssgmtTP( @Nonnull final List<ProdAllocSqncAssgmt> value )
    {
        if( toProdAllocSqncAssgmtTP == null ) {
            toProdAllocSqncAssgmtTP = Lists.newArrayList();
        }
        toProdAllocSqncAssgmtTP.clear();
        toProdAllocSqncAssgmtTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProdAllocSqncAssgmt</b> entities. This corresponds to the OData
     * navigation property <b>to_ProdAllocSqncAssgmtTP</b>.
     * <p>
     * If the navigation property <b>to_ProdAllocSqncAssgmtTP</b> of a queried <b>ProdAllocationSequence</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProdAllocSqncAssgmt</b> entities.
     */
    public void addProdAllocSqncAssgmtTP( ProdAllocSqncAssgmt... entity )
    {
        if( toProdAllocSqncAssgmtTP == null ) {
            toProdAllocSqncAssgmtTP = Lists.newArrayList();
        }
        toProdAllocSqncAssgmtTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProdAllocationSequence instances.
     *
     */
    public final static class ProdAllocationSequenceBuilder
    {

        private List<ProdAllocSequenceT> toProdAllocSequenceTTP = Lists.newArrayList();
        private List<ProdAllocSqncAssgmt> toProdAllocSqncAssgmtTP = Lists.newArrayList();

        private ProdAllocationSequence.ProdAllocationSequenceBuilder toProdAllocSequenceTTP(
            final List<ProdAllocSequenceT> value )
        {
            toProdAllocSequenceTTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProdAllocSequenceTTP</b> for <b>ProdAllocationSequence</b> to multiple
         * <b>ProdAllocSequenceT</b>.
         *
         * @param value
         *            The ProdAllocSequenceTs to build this ProdAllocationSequence with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdAllocationSequence.ProdAllocationSequenceBuilder prodAllocSequenceTTP( ProdAllocSequenceT... value )
        {
            return toProdAllocSequenceTTP(Lists.newArrayList(value));
        }

        private ProdAllocationSequence.ProdAllocationSequenceBuilder toProdAllocSqncAssgmtTP(
            final List<ProdAllocSqncAssgmt> value )
        {
            toProdAllocSqncAssgmtTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProdAllocSqncAssgmtTP</b> for <b>ProdAllocationSequence</b> to multiple
         * <b>ProdAllocSqncAssgmt</b>.
         *
         * @param value
         *            The ProdAllocSqncAssgmts to build this ProdAllocationSequence with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdAllocationSequence.ProdAllocationSequenceBuilder prodAllocSqncAssgmtTP(
            ProdAllocSqncAssgmt... value )
        {
            return toProdAllocSqncAssgmtTP(Lists.newArrayList(value));
        }

    }

}
