/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ProductAllocationSequenceServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationSequenceService
 * ProductAllocationSequenceService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultProductAllocationSequenceServiceBatch
    extends
    BatchFluentHelperBasic<ProductAllocationSequenceServiceBatch, ProductAllocationSequenceServiceBatchChangeSet>
    implements
    ProductAllocationSequenceServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationSequenceService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultProductAllocationSequenceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductAllocationSequenceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationSequenceService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationSequenceService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultProductAllocationSequenceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductAllocationSequenceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationSequenceService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultProductAllocationSequenceServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductAllocationSequenceServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultProductAllocationSequenceServiceBatchChangeSet(this, service);
    }

}
