/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence;

/**
 * Implementation of the {@link ProductAllocationSequenceServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationSequenceService
 * ProductAllocationSequenceService}.
 *
 */
public class DefaultProductAllocationSequenceServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProductAllocationSequenceServiceBatch, ProductAllocationSequenceServiceBatchChangeSet>
    implements
    ProductAllocationSequenceServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationSequenceService service;

    @SuppressWarnings( "deprecation" )
    DefaultProductAllocationSequenceServiceBatchChangeSet(
        @Nonnull final DefaultProductAllocationSequenceServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationSequenceService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProductAllocationSequenceServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductAllocationSequenceServiceBatchChangeSet createProdAllocationSequence(
        @Nonnull final ProdAllocationSequence prodAllocationSequence )
    {
        return addRequestCreate(service::createProdAllocationSequence, prodAllocationSequence);
    }

    @Nonnull
    @Override
    public ProductAllocationSequenceServiceBatchChangeSet updateProdAllocSqncAssgmt(
        @Nonnull final ProdAllocSqncAssgmt prodAllocSqncAssgmt )
    {
        return addRequestUpdate(service::updateProdAllocSqncAssgmt, prodAllocSqncAssgmt);
    }

}
