/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductAllocationSequenceService
 * ProductAllocationSequenceService}.
 *
 */
public interface ProductAllocationSequenceServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ProductAllocationSequenceServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ProductAllocationSequenceServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence
     * ProdAllocationSequence} entity and save it to the S/4HANA system.
     *
     * @param prodAllocationSequence
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence
     *            ProdAllocationSequence} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductAllocationSequenceServiceBatchChangeSet
        createProdAllocationSequence( @Nonnull final ProdAllocationSequence prodAllocationSequence );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt
     * ProdAllocSqncAssgmt} entity and save it to the S/4HANA system.
     *
     * @param prodAllocSqncAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt
     *            ProdAllocSqncAssgmt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProductAllocationSequenceServiceBatchChangeSet
        updateProdAllocSqncAssgmt( @Nonnull final ProdAllocSqncAssgmt prodAllocSqncAssgmt );

}
