/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSequenceT;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSequenceT
 * ProdAllocSequenceT}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.field.ProdAllocSequenceTField
 * ProdAllocSequenceTField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.link.ProdAllocSequenceTLink
 * ProdAllocSequenceTLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSequenceT#PRODUCT_ALLOCATION_SEQUENCE_UUID
 * PRODUCT_ALLOCATION_SEQUENCE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSequenceT#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSequenceT#PRODUCT_ALLOCATION_SEQUENCE_DESC
 * PRODUCT_ALLOCATION_SEQUENCE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSequenceT#TO_PROD_ALLOCATION_SEQUENCE_TP
 * TO_PROD_ALLOCATION_SEQUENCE_TP}</li>
 * </ul>
 *
 */
public interface ProdAllocSequenceTSelectable extends EntitySelectable<ProdAllocSequenceT>
{

}
