/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt
 * ProdAllocSqncAssgmt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.field.ProdAllocSqncAssgmtField
 * ProdAllocSqncAssgmtField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.link.ProdAllocSqncAssgmtLink
 * ProdAllocSqncAssgmtLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt#DELETE_SEQUENCE_ASSIGNMENT_AC
 * DELETE_SEQUENCE_ASSIGNMENT_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt#MATERIAL_FC
 * MATERIAL_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt#PLANT_FC
 * PLANT_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt#PROD_ALLOC_SQNC_ASSIGNMENT_UUID
 * PROD_ALLOC_SQNC_ASSIGNMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt#PRODUCT_ALLOCATION_SEQUENCE_UUID
 * PRODUCT_ALLOCATION_SEQUENCE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt#PRODUCT_ALLOCATION_SEQUENCE
 * PRODUCT_ALLOCATION_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt#VALIDITY_START_UTC_DATE_TIME
 * VALIDITY_START_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt#VALIDITY_START_TIME_ZONE
 * VALIDITY_START_TIME_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt#VALIDITY_END_UTC_DATE_TIME
 * VALIDITY_END_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt#VALIDITY_END_TIME_ZONE
 * VALIDITY_END_TIME_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt#TO_PROD_ALLOCATION_SEQUENCE_TP
 * TO_PROD_ALLOCATION_SEQUENCE_TP}</li>
 * </ul>
 *
 */
public interface ProdAllocSqncAssgmtSelectable extends EntitySelectable<ProdAllocSqncAssgmt>
{

}
