/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence
 * ProdAllocationSequence}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.field.ProdAllocationSequenceField
 * ProdAllocationSequenceField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.link.ProdAllocationSequenceLink
 * ProdAllocationSequenceLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence#PROD_ALLOC_SQNC_ASSGMT_TP_OC
 * PROD_ALLOC_SQNC_ASSGMT_TP_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence#PRODUCT_ALLOCATION_SEQUENCE_UUID
 * PRODUCT_ALLOCATION_SEQUENCE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence#PRODUCT_ALLOCATION_SEQUENCE_TEXT
 * PRODUCT_ALLOCATION_SEQUENCE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence#PRODUCT_ALLOCATION_SEQUENCE
 * PRODUCT_ALLOCATION_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence#PROD_ALLOC_SQNC_CONSUMPTION_UNIT
 * PROD_ALLOC_SQNC_CONSUMPTION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence#TO_PROD_ALLOC_SEQUENCE_TTP
 * TO_PROD_ALLOC_SEQUENCE_TTP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence#TO_PROD_ALLOC_SQNC_ASSGMT_TP
 * TO_PROD_ALLOC_SQNC_ASSGMT_TP}</li>
 * </ul>
 *
 */
public interface ProdAllocationSequenceSelectable extends EntitySelectable<ProdAllocationSequence>
{

}
