/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.field.ProductGroupTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.link.ProductGroupTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.selectable.ProductGroupTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Product Group Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductGroupTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductGroupText extends VdmEntity<ProductGroupText>
{

    /**
     * Selector for all available fields of ProductGroupText.
     *
     */
    public final static ProductGroupTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Product Group
     */
    @Key
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static ProductGroupTextField<String> MATERIAL_GROUP =
        new ProductGroupTextField<String>("MaterialGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ProductGroupTextField<String> LANGUAGE = new ProductGroupTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupName</b>
     * </p>
     *
     * @return Product Group Description
     */
    @SerializedName( "MaterialGroupName" )
    @JsonProperty( "MaterialGroupName" )
    @Nullable
    @ODataField( odataName = "MaterialGroupName" )
    private String materialGroupName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroupName</b> field to query operations.
     *
     */
    public final static ProductGroupTextField<String> MATERIAL_GROUP_NAME =
        new ProductGroupTextField<String>("MaterialGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupText</b>
     * </p>
     *
     * @return Description of the Material Group
     */
    @SerializedName( "MaterialGroupText" )
    @JsonProperty( "MaterialGroupText" )
    @Nullable
    @ODataField( odataName = "MaterialGroupText" )
    private String materialGroupText;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroupText</b> field to query operations.
     *
     */
    public final static ProductGroupTextField<String> MATERIAL_GROUP_TEXT =
        new ProductGroupTextField<String>("MaterialGroupText");
    /**
     * Navigation property <b>to_MaterialGroup</b> for <b>ProductGroupText</b> to single <b>ProductGroup</b>.
     *
     */
    @SerializedName( "to_MaterialGroup" )
    @JsonProperty( "to_MaterialGroup" )
    @ODataField( odataName = "to_MaterialGroup" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProductGroup toMaterialGroup;
    /**
     * Use with available fluent helpers to apply the <b>to_MaterialGroup</b> navigation property to query operations.
     *
     */
    public final static ProductGroupTextOneToOneLink<ProductGroup> TO_MATERIAL_GROUP =
        new ProductGroupTextOneToOneLink<ProductGroup>("to_MaterialGroup");

    @Nonnull
    @Override
    public Class<ProductGroupText> getType()
    {
        return ProductGroupText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Product Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupName</b>
     * </p>
     *
     * @param materialGroupName
     *            Product Group Description
     */
    public void setMaterialGroupName( @Nullable final String materialGroupName )
    {
        rememberChangedField("MaterialGroupName", this.materialGroupName);
        this.materialGroupName = materialGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupText</b>
     * </p>
     *
     * @param materialGroupText
     *            Description of the Material Group
     */
    public void setMaterialGroupText( @Nullable final String materialGroupText )
    {
        rememberChangedField("MaterialGroupText", this.materialGroupText);
        this.materialGroupText = materialGroupText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductGroupText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaterialGroup", getMaterialGroup());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaterialGroup", getMaterialGroup());
        values.put("Language", getLanguage());
        values.put("MaterialGroupName", getMaterialGroupName());
        values.put("MaterialGroupText", getMaterialGroupText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("MaterialGroupName") ) {
                final Object value = values.remove("MaterialGroupName");
                if( (value == null) || (!value.equals(getMaterialGroupName())) ) {
                    setMaterialGroupName(((String) value));
                }
            }
            if( values.containsKey("MaterialGroupText") ) {
                final Object value = values.remove("MaterialGroupText");
                if( (value == null) || (!value.equals(getMaterialGroupText())) ) {
                    setMaterialGroupText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaterialGroup") ) {
                final Object value = (values).remove("to_MaterialGroup");
                if( value instanceof Map ) {
                    if( toMaterialGroup == null ) {
                        toMaterialGroup = new ProductGroup();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaterialGroup.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductGroupTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductGroupTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductGroupTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductGroupTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductGroupService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaterialGroup != null ) {
            (values).put("to_MaterialGroup", toMaterialGroup);
        }
        return values;
    }

    /**
     * Fetches the <b>ProductGroup</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_MaterialGroup</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProductGroup</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProductGroup fetchMaterialGroup()
    {
        return fetchFieldAsSingle("to_MaterialGroup", ProductGroup.class);
    }

    /**
     * Retrieval of associated <b>ProductGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaterialGroup</b>.
     * <p>
     * If the navigation property <b>to_MaterialGroup</b> of a queried <b>ProductGroupText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductGroup</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProductGroup getMaterialGroupOrFetch()
    {
        if( toMaterialGroup == null ) {
            toMaterialGroup = fetchMaterialGroup();
        }
        return toMaterialGroup;
    }

    /**
     * Retrieval of associated <b>ProductGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaterialGroup</b>.
     * <p>
     * If the navigation property for an entity <b>ProductGroupText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaterialGroup</b> is already loaded, the result will
     *         contain the <b>ProductGroup</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProductGroup> getMaterialGroupIfPresent()
    {
        return Option.of(toMaterialGroup);
    }

    /**
     * Overwrites the associated <b>ProductGroup</b> entity for the loaded navigation property <b>to_MaterialGroup</b>.
     *
     * @param value
     *            New <b>ProductGroup</b> entity.
     */
    public void setMaterialGroup( final ProductGroup value )
    {
        toMaterialGroup = value;
    }

    /**
     * Helper class to allow for fluent creation of ProductGroupText instances.
     *
     */
    public final static class ProductGroupTextBuilder
    {

        private ProductGroup toMaterialGroup;
        private String materialGroup = null;

        private ProductGroupText.ProductGroupTextBuilder toMaterialGroup( final ProductGroup value )
        {
            toMaterialGroup = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaterialGroup</b> for <b>ProductGroupText</b> to single <b>ProductGroup</b>.
         *
         * @param value
         *            The ProductGroup to build this ProductGroupText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductGroupText.ProductGroupTextBuilder materialGroup( final ProductGroup value )
        {
            return toMaterialGroup(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 9
         * <p>
         * Original property name from the Odata EDM: <b>MaterialGroup</b>
         * </p>
         *
         * @param value
         *            The materialGroup to build this ProductGroupText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductGroupText.ProductGroupTextBuilder materialGroup( final String value )
        {
            materialGroup = value;
            return this;
        }

    }

}
