/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ProductGroupServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductGroupService ProductGroupService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultProductGroupServiceBatch
    extends
    BatchFluentHelperBasic<ProductGroupServiceBatch, ProductGroupServiceBatchChangeSet>
    implements
    ProductGroupServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductGroupService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultProductGroupServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductGroupServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductGroupService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductGroupService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultProductGroupServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProductGroupServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductGroupService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultProductGroupServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProductGroupServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultProductGroupServiceBatchChangeSet(this, service);
    }

}
