/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link ProductGroupServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductGroupService ProductGroupService}.
 *
 */
public class DefaultProductGroupServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProductGroupServiceBatch, ProductGroupServiceBatchChangeSet>
    implements
    ProductGroupServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductGroupService service;

    @SuppressWarnings( "deprecation" )
    DefaultProductGroupServiceBatchChangeSet(
        @Nonnull final DefaultProductGroupServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductGroupService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProductGroupServiceBatchChangeSet getThis()
    {
        return this;
    }

}
