/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.ProductGroup;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.ProductGroup ProductGroup}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.field.ProductGroupField
 * ProductGroupField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.link.ProductGroupLink
 * ProductGroupLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.ProductGroup#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.ProductGroup#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.ProductGroup#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface ProductGroupSelectable extends EntitySelectable<ProductGroup>
{

}
