/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.field.ProductionOrderComponentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.selectable.ProductionOrderComponentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * API Production Order Components
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductionOrderComponentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductionOrderComponent extends VdmEntity<ProductionOrderComponent>
{

    /**
     * Selector for all available fields of ProductionOrderComponent.
     *
     */
    public final static ProductionOrderComponentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @return Number of reservation/dependent requirements
     */
    @Key
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Use with available fluent helpers to apply the <b>Reservation</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> RESERVATION =
        new ProductionOrderComponentField<String>("Reservation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @return Reservation Item
     */
    @Key
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItem</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> RESERVATION_ITEM =
        new ProductionOrderComponentField<String>("ReservationItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     * </p>
     *
     * @return BOM item number
     */
    @SerializedName( "BillOfMaterialItemNumber" )
    @JsonProperty( "BillOfMaterialItemNumber" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemNumber" )
    private String billOfMaterialItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemNumber</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> BILL_OF_MATERIAL_ITEM_NUMBER =
        new ProductionOrderComponentField<String>("BillOfMaterialItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @return BOM Item Text (Line 1)
     */
    @SerializedName( "BOMItemDescription" )
    @JsonProperty( "BOMItemDescription" )
    @Nullable
    @ODataField( odataName = "BOMItemDescription" )
    private String bOMItemDescription;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemDescription</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> BOM_ITEM_DESCRIPTION =
        new ProductionOrderComponentField<String>("BOMItemDescription");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> MATERIAL =
        new ProductionOrderComponentField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> PLANT =
        new ProductionOrderComponentField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @return Production Plant
     */
    @SerializedName( "ProductionPlant" )
    @JsonProperty( "ProductionPlant" )
    @Nullable
    @ODataField( odataName = "ProductionPlant" )
    private String productionPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPlant</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> PRODUCTION_PLANT =
        new ProductionOrderComponentField<String>("ProductionPlant");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompRequirementDate</b>
     * </p>
     *
     * @return Material Component Requirement Date
     */
    @SerializedName( "MatlCompRequirementDate" )
    @JsonProperty( "MatlCompRequirementDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MatlCompRequirementDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime matlCompRequirementDate;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompRequirementDate</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<LocalDateTime> MATL_COMP_REQUIREMENT_DATE =
        new ProductionOrderComponentField<LocalDateTime>("MatlCompRequirementDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> BASE_UNIT =
        new ProductionOrderComponentField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequiredQuantity</b>
     * </p>
     *
     * @return Requirement Quantity
     */
    @SerializedName( "RequiredQuantity" )
    @JsonProperty( "RequiredQuantity" )
    @Nullable
    @ODataField( odataName = "RequiredQuantity" )
    private BigDecimal requiredQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequiredQuantity</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<BigDecimal> REQUIRED_QUANTITY =
        new ProductionOrderComponentField<BigDecimal>("RequiredQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawnQuantity</b>
     * </p>
     *
     * @return Withdrawn Quantity
     */
    @SerializedName( "WithdrawnQuantity" )
    @JsonProperty( "WithdrawnQuantity" )
    @Nullable
    @ODataField( odataName = "WithdrawnQuantity" )
    private BigDecimal withdrawnQuantity;
    /**
     * Use with available fluent helpers to apply the <b>WithdrawnQuantity</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<BigDecimal> WITHDRAWN_QUANTITY =
        new ProductionOrderComponentField<BigDecimal>("WithdrawnQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMItem</b>
     * </p>
     *
     * @return Bill of Material Item
     */
    @SerializedName( "BOMItem" )
    @JsonProperty( "BOMItem" )
    @Nullable
    @ODataField( odataName = "BOMItem" )
    private String bOMItem;
    /**
     * Use with available fluent helpers to apply the <b>BOMItem</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> BOM_ITEM =
        new ProductionOrderComponentField<String>("BOMItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> STORAGE_LOCATION =
        new ProductionOrderComponentField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyArea</b>
     * </p>
     *
     * @return Production Supply Area
     */
    @SerializedName( "SupplyArea" )
    @JsonProperty( "SupplyArea" )
    @Nullable
    @ODataField( odataName = "SupplyArea" )
    private String supplyArea;
    /**
     * Use with available fluent helpers to apply the <b>SupplyArea</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> SUPPLY_AREA =
        new ProductionOrderComponentField<String>("SupplyArea");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     * </p>
     *
     * @return Sequence
     */
    @SerializedName( "ManufacturingOrderSequence" )
    @JsonProperty( "ManufacturingOrderSequence" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderSequence" )
    private String manufacturingOrderSequence;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderSequence</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> MANUFACTURING_ORDER_SEQUENCE =
        new ProductionOrderComponentField<String>("ManufacturingOrderSequence");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Manufacturing Order ID
     */
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> MANUFACTURING_ORDER =
        new ProductionOrderComponentField<String>("ManufacturingOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @return Manufacturing Order Operation
     */
    @SerializedName( "ManufacturingOrderOperation" )
    @JsonProperty( "ManufacturingOrderOperation" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderOperation" )
    private String manufacturingOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderOperation</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> MANUFACTURING_ORDER_OPERATION =
        new ProductionOrderComponentField<String>("ManufacturingOrderOperation");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @return Manufacturing Order Category
     */
    @SerializedName( "ManufacturingOrderCategory" )
    @JsonProperty( "ManufacturingOrderCategory" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderCategory" )
    private String manufacturingOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderCategory</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> MANUFACTURING_ORDER_CATEGORY =
        new ProductionOrderComponentField<String>("ManufacturingOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @return Manufacturing Order Type
     */
    @SerializedName( "ManufacturingOrderType" )
    @JsonProperty( "ManufacturingOrderType" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderType" )
    private String manufacturingOrderType;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderType</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> MANUFACTURING_ORDER_TYPE =
        new ProductionOrderComponentField<String>("ManufacturingOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @return Order Internal ID
     */
    @SerializedName( "OrderInternalBillOfOperations" )
    @JsonProperty( "OrderInternalBillOfOperations" )
    @Nullable
    @ODataField( odataName = "OrderInternalBillOfOperations" )
    private String orderInternalBillOfOperations;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalBillOfOperations</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> ORDER_INTERNAL_BILL_OF_OPERATIONS =
        new ProductionOrderComponentField<String>("OrderInternalBillOfOperations");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemText2</b>
     * </p>
     *
     * @return BOM Item Text (Line 2)
     */
    @SerializedName( "BOMItemText2" )
    @JsonProperty( "BOMItemText2" )
    @Nullable
    @ODataField( odataName = "BOMItemText2" )
    private String bOMItemText2;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemText2</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> BOM_ITEM_TEXT2 =
        new ProductionOrderComponentField<String>("BOMItemText2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemCategory</b>
     * </p>
     *
     * @return Bill of Material Item Category
     */
    @SerializedName( "BOMItemCategory" )
    @JsonProperty( "BOMItemCategory" )
    @Nullable
    @ODataField( odataName = "BOMItemCategory" )
    private String bOMItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemCategory</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> BOM_ITEM_CATEGORY =
        new ProductionOrderComponentField<String>("BOMItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @return Bill of Material Category Code
     */
    @SerializedName( "BillOfMaterialCategory" )
    @JsonProperty( "BillOfMaterialCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialCategory" )
    private String billOfMaterialCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialCategory</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> BILL_OF_MATERIAL_CATEGORY =
        new ProductionOrderComponentField<String>("BillOfMaterialCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SortField</b>
     * </p>
     *
     * @return Sort String
     */
    @SerializedName( "SortField" )
    @JsonProperty( "SortField" )
    @Nullable
    @ODataField( odataName = "SortField" )
    private String sortField;
    /**
     * Use with available fluent helpers to apply the <b>SortField</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> SORT_FIELD =
        new ProductionOrderComponentField<String>("SortField");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @return Goods Recipient
     */
    @SerializedName( "GoodsRecipientName" )
    @JsonProperty( "GoodsRecipientName" )
    @Nullable
    @ODataField( odataName = "GoodsRecipientName" )
    private String goodsRecipientName;
    /**
     * Use with available fluent helpers to apply the <b>GoodsRecipientName</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> GOODS_RECIPIENT_NAME =
        new ProductionOrderComponentField<String>("GoodsRecipientName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @SerializedName( "UnloadingPointName" )
    @JsonProperty( "UnloadingPointName" )
    @Nullable
    @ODataField( odataName = "UnloadingPointName" )
    private String unloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingPointName</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> UNLOADING_POINT_NAME =
        new ProductionOrderComponentField<String>("UnloadingPointName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> BATCH =
        new ProductionOrderComponentField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BatchSplitType</b>
     * </p>
     *
     * @return Batch key
     */
    @SerializedName( "BatchSplitType" )
    @JsonProperty( "BatchSplitType" )
    @Nullable
    @ODataField( odataName = "BatchSplitType" )
    private String batchSplitType;
    /**
     * Use with available fluent helpers to apply the <b>BatchSplitType</b> field to query operations.
     *
     */
    public final static ProductionOrderComponentField<String> BATCH_SPLIT_TYPE =
        new ProductionOrderComponentField<String>("BatchSplitType");

    @Nonnull
    @Override
    public Class<ProductionOrderComponent> getType()
    {
        return ProductionOrderComponent.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Number of reservation/dependent requirements
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Reservation Item
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNumber
     *            BOM item number
     */
    public void setBillOfMaterialItemNumber( @Nullable final String billOfMaterialItemNumber )
    {
        rememberChangedField("BillOfMaterialItemNumber", this.billOfMaterialItemNumber);
        this.billOfMaterialItemNumber = billOfMaterialItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @param bOMItemDescription
     *            BOM Item Text (Line 1)
     */
    public void setBOMItemDescription( @Nullable final String bOMItemDescription )
    {
        rememberChangedField("BOMItemDescription", this.bOMItemDescription);
        this.bOMItemDescription = bOMItemDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @param productionPlant
     *            Production Plant
     */
    public void setProductionPlant( @Nullable final String productionPlant )
    {
        rememberChangedField("ProductionPlant", this.productionPlant);
        this.productionPlant = productionPlant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompRequirementDate</b>
     * </p>
     *
     * @param matlCompRequirementDate
     *            Material Component Requirement Date
     */
    public void setMatlCompRequirementDate( @Nullable final LocalDateTime matlCompRequirementDate )
    {
        rememberChangedField("MatlCompRequirementDate", this.matlCompRequirementDate);
        this.matlCompRequirementDate = matlCompRequirementDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequiredQuantity</b>
     * </p>
     *
     * @param requiredQuantity
     *            Requirement Quantity
     */
    public void setRequiredQuantity( @Nullable final BigDecimal requiredQuantity )
    {
        rememberChangedField("RequiredQuantity", this.requiredQuantity);
        this.requiredQuantity = requiredQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawnQuantity</b>
     * </p>
     *
     * @param withdrawnQuantity
     *            Withdrawn Quantity
     */
    public void setWithdrawnQuantity( @Nullable final BigDecimal withdrawnQuantity )
    {
        rememberChangedField("WithdrawnQuantity", this.withdrawnQuantity);
        this.withdrawnQuantity = withdrawnQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMItem</b>
     * </p>
     *
     * @param bOMItem
     *            Bill of Material Item
     */
    public void setBOMItem( @Nullable final String bOMItem )
    {
        rememberChangedField("BOMItem", this.bOMItem);
        this.bOMItem = bOMItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyArea</b>
     * </p>
     *
     * @param supplyArea
     *            Production Supply Area
     */
    public void setSupplyArea( @Nullable final String supplyArea )
    {
        rememberChangedField("SupplyArea", this.supplyArea);
        this.supplyArea = supplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     * </p>
     *
     * @param manufacturingOrderSequence
     *            Sequence
     */
    public void setManufacturingOrderSequence( @Nullable final String manufacturingOrderSequence )
    {
        rememberChangedField("ManufacturingOrderSequence", this.manufacturingOrderSequence);
        this.manufacturingOrderSequence = manufacturingOrderSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Manufacturing Order ID
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @param manufacturingOrderOperation
     *            Manufacturing Order Operation
     */
    public void setManufacturingOrderOperation( @Nullable final String manufacturingOrderOperation )
    {
        rememberChangedField("ManufacturingOrderOperation", this.manufacturingOrderOperation);
        this.manufacturingOrderOperation = manufacturingOrderOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @param manufacturingOrderCategory
     *            Manufacturing Order Category
     */
    public void setManufacturingOrderCategory( @Nullable final String manufacturingOrderCategory )
    {
        rememberChangedField("ManufacturingOrderCategory", this.manufacturingOrderCategory);
        this.manufacturingOrderCategory = manufacturingOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @param manufacturingOrderType
     *            Manufacturing Order Type
     */
    public void setManufacturingOrderType( @Nullable final String manufacturingOrderType )
    {
        rememberChangedField("ManufacturingOrderType", this.manufacturingOrderType);
        this.manufacturingOrderType = manufacturingOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     */
    public void setOrderInternalBillOfOperations( @Nullable final String orderInternalBillOfOperations )
    {
        rememberChangedField("OrderInternalBillOfOperations", this.orderInternalBillOfOperations);
        this.orderInternalBillOfOperations = orderInternalBillOfOperations;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemText2</b>
     * </p>
     *
     * @param bOMItemText2
     *            BOM Item Text (Line 2)
     */
    public void setBOMItemText2( @Nullable final String bOMItemText2 )
    {
        rememberChangedField("BOMItemText2", this.bOMItemText2);
        this.bOMItemText2 = bOMItemText2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemCategory</b>
     * </p>
     *
     * @param bOMItemCategory
     *            Bill of Material Item Category
     */
    public void setBOMItemCategory( @Nullable final String bOMItemCategory )
    {
        rememberChangedField("BOMItemCategory", this.bOMItemCategory);
        this.bOMItemCategory = bOMItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *            Bill of Material Category Code
     */
    public void setBillOfMaterialCategory( @Nullable final String billOfMaterialCategory )
    {
        rememberChangedField("BillOfMaterialCategory", this.billOfMaterialCategory);
        this.billOfMaterialCategory = billOfMaterialCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SortField</b>
     * </p>
     *
     * @param sortField
     *            Sort String
     */
    public void setSortField( @Nullable final String sortField )
    {
        rememberChangedField("SortField", this.sortField);
        this.sortField = sortField;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @param goodsRecipientName
     *            Goods Recipient
     */
    public void setGoodsRecipientName( @Nullable final String goodsRecipientName )
    {
        rememberChangedField("GoodsRecipientName", this.goodsRecipientName);
        this.goodsRecipientName = goodsRecipientName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @param unloadingPointName
     *            Unloading Point
     */
    public void setUnloadingPointName( @Nullable final String unloadingPointName )
    {
        rememberChangedField("UnloadingPointName", this.unloadingPointName);
        this.unloadingPointName = unloadingPointName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BatchSplitType</b>
     * </p>
     *
     * @param batchSplitType
     *            Batch key
     */
    public void setBatchSplitType( @Nullable final String batchSplitType )
    {
        rememberChangedField("BatchSplitType", this.batchSplitType);
        this.batchSplitType = batchSplitType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductionOrderComponent";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Reservation", getReservation());
        result.put("ReservationItem", getReservationItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Reservation", getReservation());
        values.put("ReservationItem", getReservationItem());
        values.put("BillOfMaterialItemNumber", getBillOfMaterialItemNumber());
        values.put("BOMItemDescription", getBOMItemDescription());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("ProductionPlant", getProductionPlant());
        values.put("MatlCompRequirementDate", getMatlCompRequirementDate());
        values.put("BaseUnit", getBaseUnit());
        values.put("RequiredQuantity", getRequiredQuantity());
        values.put("WithdrawnQuantity", getWithdrawnQuantity());
        values.put("BOMItem", getBOMItem());
        values.put("StorageLocation", getStorageLocation());
        values.put("SupplyArea", getSupplyArea());
        values.put("ManufacturingOrderSequence", getManufacturingOrderSequence());
        values.put("ManufacturingOrder", getManufacturingOrder());
        values.put("ManufacturingOrderOperation", getManufacturingOrderOperation());
        values.put("ManufacturingOrderCategory", getManufacturingOrderCategory());
        values.put("ManufacturingOrderType", getManufacturingOrderType());
        values.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        values.put("BOMItemText2", getBOMItemText2());
        values.put("BOMItemCategory", getBOMItemCategory());
        values.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        values.put("SortField", getSortField());
        values.put("GoodsRecipientName", getGoodsRecipientName());
        values.put("UnloadingPointName", getUnloadingPointName());
        values.put("Batch", getBatch());
        values.put("BatchSplitType", getBatchSplitType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemNumber") ) {
                final Object value = values.remove("BillOfMaterialItemNumber");
                if( (value == null) || (!value.equals(getBillOfMaterialItemNumber())) ) {
                    setBillOfMaterialItemNumber(((String) value));
                }
            }
            if( values.containsKey("BOMItemDescription") ) {
                final Object value = values.remove("BOMItemDescription");
                if( (value == null) || (!value.equals(getBOMItemDescription())) ) {
                    setBOMItemDescription(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ProductionPlant") ) {
                final Object value = values.remove("ProductionPlant");
                if( (value == null) || (!value.equals(getProductionPlant())) ) {
                    setProductionPlant(((String) value));
                }
            }
            if( values.containsKey("MatlCompRequirementDate") ) {
                final Object value = values.remove("MatlCompRequirementDate");
                if( (value == null) || (!value.equals(getMatlCompRequirementDate())) ) {
                    setMatlCompRequirementDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("RequiredQuantity") ) {
                final Object value = values.remove("RequiredQuantity");
                if( (value == null) || (!value.equals(getRequiredQuantity())) ) {
                    setRequiredQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("WithdrawnQuantity") ) {
                final Object value = values.remove("WithdrawnQuantity");
                if( (value == null) || (!value.equals(getWithdrawnQuantity())) ) {
                    setWithdrawnQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BOMItem") ) {
                final Object value = values.remove("BOMItem");
                if( (value == null) || (!value.equals(getBOMItem())) ) {
                    setBOMItem(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("SupplyArea") ) {
                final Object value = values.remove("SupplyArea");
                if( (value == null) || (!value.equals(getSupplyArea())) ) {
                    setSupplyArea(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderSequence") ) {
                final Object value = values.remove("ManufacturingOrderSequence");
                if( (value == null) || (!value.equals(getManufacturingOrderSequence())) ) {
                    setManufacturingOrderSequence(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderOperation") ) {
                final Object value = values.remove("ManufacturingOrderOperation");
                if( (value == null) || (!value.equals(getManufacturingOrderOperation())) ) {
                    setManufacturingOrderOperation(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderCategory") ) {
                final Object value = values.remove("ManufacturingOrderCategory");
                if( (value == null) || (!value.equals(getManufacturingOrderCategory())) ) {
                    setManufacturingOrderCategory(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderType") ) {
                final Object value = values.remove("ManufacturingOrderType");
                if( (value == null) || (!value.equals(getManufacturingOrderType())) ) {
                    setManufacturingOrderType(((String) value));
                }
            }
            if( values.containsKey("OrderInternalBillOfOperations") ) {
                final Object value = values.remove("OrderInternalBillOfOperations");
                if( (value == null) || (!value.equals(getOrderInternalBillOfOperations())) ) {
                    setOrderInternalBillOfOperations(((String) value));
                }
            }
            if( values.containsKey("BOMItemText2") ) {
                final Object value = values.remove("BOMItemText2");
                if( (value == null) || (!value.equals(getBOMItemText2())) ) {
                    setBOMItemText2(((String) value));
                }
            }
            if( values.containsKey("BOMItemCategory") ) {
                final Object value = values.remove("BOMItemCategory");
                if( (value == null) || (!value.equals(getBOMItemCategory())) ) {
                    setBOMItemCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialCategory") ) {
                final Object value = values.remove("BillOfMaterialCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialCategory())) ) {
                    setBillOfMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("SortField") ) {
                final Object value = values.remove("SortField");
                if( (value == null) || (!value.equals(getSortField())) ) {
                    setSortField(((String) value));
                }
            }
            if( values.containsKey("GoodsRecipientName") ) {
                final Object value = values.remove("GoodsRecipientName");
                if( (value == null) || (!value.equals(getGoodsRecipientName())) ) {
                    setGoodsRecipientName(((String) value));
                }
            }
            if( values.containsKey("UnloadingPointName") ) {
                final Object value = values.remove("UnloadingPointName");
                if( (value == null) || (!value.equals(getUnloadingPointName())) ) {
                    setUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("BatchSplitType") ) {
                final Object value = values.remove("BatchSplitType");
                if( (value == null) || (!value.equals(getBatchSplitType())) ) {
                    setBatchSplitType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductionOrderComponentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductionOrderComponentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductionOrderComponentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductionOrderComponentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProductionOrderService.DEFAULT_SERVICE_PATH);
    }

}
