/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.selectable.ProductionOrderOperationSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation
 * ProductionOrderOperation} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ProductionOrderOperationByKeyFluentHelper
    extends
    FluentHelperByKey<ProductionOrderOperationByKeyFluentHelper, ProductionOrderOperation, ProductionOrderOperationSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation
     * ProductionOrderOperation} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param orderIntBillOfOperationsItem
     *            Internal Identifier of an Operation or Activity
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProductionOrderOperation}
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProductionOrderOperation}
     */
    public ProductionOrderOperationByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String orderInternalBillOfOperations,
        final String orderIntBillOfOperationsItem )
    {
        super(servicePath, entityCollection);
        this.key.put("OrderInternalBillOfOperations", orderInternalBillOfOperations);
        this.key.put("OrderIntBillOfOperationsItem", orderIntBillOfOperationsItem);
    }

    @Override
    @Nonnull
    protected Class<ProductionOrderOperation> getEntityClass()
    {
        return ProductionOrderOperation.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
